{-# LANGUAGE MagicHash, UnboxedTuples #-}
import GHC.Prim
import GHC.Exts

test :: (Int, Int, Int, Int) -> (FloatX4# -> FloatX4# -> FloatX4#) -> IO ()
test t@(i0, i1, i2, i3) shuffle = do
  let a = packFloatX4# (# 0.0#, 1.1#, 2.2#, 3.3# #)
      b = packFloatX4# (# 4.4#, 5.5#, 6.6#, 7.7# #)
      c = shuffle a b
      (# x0, x1, x2, x3 #) = unpackFloatX4# c
      ok = if map ([0.0, 1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7] !!) [i0, i1, i2, i3] == [F# x0, F# x1, F# x2, F# x3]
           then ""
           else "...WRONG"
  putStrLn $ show t ++ ": " ++ show (F# x0, F# x1, F# x2, F# x3) ++ ok
{-# NOINLINE test #-}

testFlipped :: (Int, Int, Int, Int) -> (FloatX4# -> FloatX4# -> FloatX4#) -> IO ()
testFlipped t@(i0, i1, i2, i3) shuffle = do
  let a = packFloatX4# (# 0.0#, 1.1#, 2.2#, 3.3# #)
      b = packFloatX4# (# 4.4#, 5.5#, 6.6#, 7.7# #)
      c = shuffle a b
      (# x0, x1, x2, x3 #) = unpackFloatX4# c
      ok = if map ([4.4, 5.5, 6.6, 7.7, 0.0, 1.1, 2.2, 3.3] !!) [i0, i1, i2, i3] == [F# x0, F# x1, F# x2, F# x3]
           then ""
           else "...WRONG"
  putStrLn $ show t ++ ": " ++ show (F# x0, F# x1, F# x2, F# x3) ++ ok
{-# NOINLINE testFlipped #-}

main :: IO ()
main = do
  test (0, 0, 0, 0) $ \a b -> shuffleFloatX4# a b (# 0#, 0#, 0#, 0# #)
  test (0, 0, 1, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 0#, 1#, 1# #)
  test (0, 1, 0, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 1#, 0#, 1# #)
  test (0, 1, 2, 3) $ \a b -> shuffleFloatX4# a b (# 0#, 1#, 2#, 3# #)
  test (0, 1, 3, 2) $ \a b -> shuffleFloatX4# a b (# 0#, 1#, 3#, 2# #)
  test (0, 1, 4, 5) $ \a b -> shuffleFloatX4# a b (# 0#, 1#, 4#, 5# #)
  test (0, 1, 5, 4) $ \a b -> shuffleFloatX4# a b (# 0#, 1#, 5#, 4# #)
  test (0, 2, 0, 6) $ \a b -> shuffleFloatX4# a b (# 0#, 2#, 0#, 6# #)
  test (0, 2, 1, 3) $ \a b -> shuffleFloatX4# a b (# 0#, 2#, 1#, 3# #)
  test (0, 2, 1, 7) $ \a b -> shuffleFloatX4# a b (# 0#, 2#, 1#, 7# #)
  test (0, 2, 3, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 2#, 3#, 1# #)
  test (0, 2, 4, 6) $ \a b -> shuffleFloatX4# a b (# 0#, 2#, 4#, 6# #)
  test (0, 2, 6, 4) $ \a b -> shuffleFloatX4# a b (# 0#, 2#, 6#, 4# #)
  test (0, 2, 7, 6) $ \a b -> shuffleFloatX4# a b (# 0#, 2#, 7#, 6# #)
  test (0, 3, 0, 5) $ \a b -> shuffleFloatX4# a b (# 0#, 3#, 0#, 5# #)
  test (0, 3, 1, 2) $ \a b -> shuffleFloatX4# a b (# 0#, 3#, 1#, 2# #)
  test (0, 3, 1, 5) $ \a b -> shuffleFloatX4# a b (# 0#, 3#, 1#, 5# #)
  test (0, 3, 2, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 3#, 2#, 1# #)
  test (0, 4, 0, 4) $ \a b -> shuffleFloatX4# a b (# 0#, 4#, 0#, 4# #)
  test (0, 4, 1, 5) $ \a b -> shuffleFloatX4# a b (# 0#, 4#, 1#, 5# #)
  test (0, 4, 1, 6) $ \a b -> shuffleFloatX4# a b (# 0#, 4#, 1#, 6# #)
  test (0, 4, 2, 6) $ \a b -> shuffleFloatX4# a b (# 0#, 4#, 2#, 6# #)
  test (0, 4, 5, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 4#, 5#, 1# #)
  test (0, 4, 5, 3) $ \a b -> shuffleFloatX4# a b (# 0#, 4#, 5#, 3# #)
  test (0, 4, 6, 2) $ \a b -> shuffleFloatX4# a b (# 0#, 4#, 6#, 2# #)
  test (0, 4, 7, 5) $ \a b -> shuffleFloatX4# a b (# 0#, 4#, 7#, 5# #)
  test (0, 5, 1, 4) $ \a b -> shuffleFloatX4# a b (# 0#, 5#, 1#, 4# #)
  test (0, 5, 4, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 5#, 4#, 1# #)
  test (0, 5, 5, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 5#, 5#, 1# #)
  test (0, 5, 6, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 5#, 6#, 1# #)
  test (0, 5, 6, 3) $ \a b -> shuffleFloatX4# a b (# 0#, 5#, 6#, 3# #)
  test (0, 5, 6, 7) $ \a b -> shuffleFloatX4# a b (# 0#, 5#, 6#, 7# #)
  test (0, 5, 7, 6) $ \a b -> shuffleFloatX4# a b (# 0#, 5#, 7#, 6# #)
  test (0, 6, 2, 4) $ \a b -> shuffleFloatX4# a b (# 0#, 6#, 2#, 4# #)
  test (0, 6, 3, 6) $ \a b -> shuffleFloatX4# a b (# 0#, 6#, 3#, 6# #)
  test (0, 6, 4, 2) $ \a b -> shuffleFloatX4# a b (# 0#, 6#, 4#, 2# #)
  test (0, 6, 4, 3) $ \a b -> shuffleFloatX4# a b (# 0#, 6#, 4#, 3# #)
  test (0, 6, 5, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 6#, 5#, 1# #)
  test (0, 6, 5, 7) $ \a b -> shuffleFloatX4# a b (# 0#, 6#, 5#, 7# #)
  test (0, 6, 6, 5) $ \a b -> shuffleFloatX4# a b (# 0#, 6#, 6#, 5# #)
  test (0, 6, 7, 5) $ \a b -> shuffleFloatX4# a b (# 0#, 6#, 7#, 5# #)
  test (0, 7, 3, 1) $ \a b -> shuffleFloatX4# a b (# 0#, 7#, 3#, 1# #)
  test (0, 7, 5, 6) $ \a b -> shuffleFloatX4# a b (# 0#, 7#, 5#, 6# #)
  test (0, 7, 6, 5) $ \a b -> shuffleFloatX4# a b (# 0#, 7#, 6#, 5# #)
  test (0, 7, 6, 6) $ \a b -> shuffleFloatX4# a b (# 0#, 7#, 6#, 6# #)
  test (0, 7, 7, 7) $ \a b -> shuffleFloatX4# a b (# 0#, 7#, 7#, 7# #)
  test (1, 0, 2, 2) $ \a b -> shuffleFloatX4# a b (# 1#, 0#, 2#, 2# #)
  test (1, 0, 2, 3) $ \a b -> shuffleFloatX4# a b (# 1#, 0#, 2#, 3# #)
  test (1, 0, 2, 6) $ \a b -> shuffleFloatX4# a b (# 1#, 0#, 2#, 6# #)
  test (1, 0, 3, 2) $ \a b -> shuffleFloatX4# a b (# 1#, 0#, 3#, 2# #)
  test (1, 0, 4, 5) $ \a b -> shuffleFloatX4# a b (# 1#, 0#, 4#, 5# #)
  test (1, 0, 5, 4) $ \a b -> shuffleFloatX4# a b (# 1#, 0#, 5#, 4# #)
  test (1, 1, 1, 1) $ \a b -> shuffleFloatX4# a b (# 1#, 1#, 1#, 1# #)
  test (1, 1, 7, 3) $ \a b -> shuffleFloatX4# a b (# 1#, 1#, 7#, 3# #)
  test (1, 2, 0, 3) $ \a b -> shuffleFloatX4# a b (# 1#, 2#, 0#, 3# #)
  test (1, 2, 3, 0) $ \a b -> shuffleFloatX4# a b (# 1#, 2#, 3#, 0# #)
  test (1, 2, 3, 4) $ \a b -> shuffleFloatX4# a b (# 1#, 2#, 3#, 4# #)
  test (1, 2, 4, 3) $ \a b -> shuffleFloatX4# a b (# 1#, 2#, 4#, 3# #)
  test (1, 3, 0, 2) $ \a b -> shuffleFloatX4# a b (# 1#, 3#, 0#, 2# #)
  test (1, 3, 2, 0) $ \a b -> shuffleFloatX4# a b (# 1#, 3#, 2#, 0# #)
  test (1, 3, 2, 4) $ \a b -> shuffleFloatX4# a b (# 1#, 3#, 2#, 4# #)
  test (1, 3, 3, 1) $ \a b -> shuffleFloatX4# a b (# 1#, 3#, 3#, 1# #)
  test (1, 3, 4, 2) $ \a b -> shuffleFloatX4# a b (# 1#, 3#, 4#, 2# #)
  test (1, 3, 4, 4) $ \a b -> shuffleFloatX4# a b (# 1#, 3#, 4#, 4# #)
  test (1, 3, 5, 7) $ \a b -> shuffleFloatX4# a b (# 1#, 3#, 5#, 7# #)
  test (1, 3, 6, 6) $ \a b -> shuffleFloatX4# a b (# 1#, 3#, 6#, 6# #)
  test (1, 3, 7, 5) $ \a b -> shuffleFloatX4# a b (# 1#, 3#, 7#, 5# #)
  test (1, 4, 0, 5) $ \a b -> shuffleFloatX4# a b (# 1#, 4#, 0#, 5# #)
  test (1, 4, 2, 1) $ \a b -> shuffleFloatX4# a b (# 1#, 4#, 2#, 1# #)
  test (1, 4, 2, 3) $ \a b -> shuffleFloatX4# a b (# 1#, 4#, 2#, 3# #)
  test (1, 4, 3, 2) $ \a b -> shuffleFloatX4# a b (# 1#, 4#, 3#, 2# #)
  test (1, 4, 3, 5) $ \a b -> shuffleFloatX4# a b (# 1#, 4#, 3#, 5# #)
  test (1, 4, 5, 0) $ \a b -> shuffleFloatX4# a b (# 1#, 4#, 5#, 0# #)
  test (1, 4, 7, 4) $ \a b -> shuffleFloatX4# a b (# 1#, 4#, 7#, 4# #)
  test (1, 5, 0, 4) $ \a b -> shuffleFloatX4# a b (# 1#, 5#, 0#, 4# #)
  test (1, 5, 1, 1) $ \a b -> shuffleFloatX4# a b (# 1#, 5#, 1#, 1# #)
  test (1, 5, 3, 1) $ \a b -> shuffleFloatX4# a b (# 1#, 5#, 3#, 1# #)
  test (1, 5, 3, 7) $ \a b -> shuffleFloatX4# a b (# 1#, 5#, 3#, 7# #)
  test (1, 5, 4, 0) $ \a b -> shuffleFloatX4# a b (# 1#, 5#, 4#, 0# #)
  test (1, 5, 6, 4) $ \a b -> shuffleFloatX4# a b (# 1#, 5#, 6#, 4# #)
  test (1, 5, 7, 3) $ \a b -> shuffleFloatX4# a b (# 1#, 5#, 7#, 3# #)
  test (1, 6, 0, 2) $ \a b -> shuffleFloatX4# a b (# 1#, 6#, 0#, 2# #)
  test (1, 6, 5, 0) $ \a b -> shuffleFloatX4# a b (# 1#, 6#, 5#, 0# #)
  test (1, 7, 0, 0) $ \a b -> shuffleFloatX4# a b (# 1#, 7#, 0#, 0# #)
  test (1, 7, 0, 2) $ \a b -> shuffleFloatX4# a b (# 1#, 7#, 0#, 2# #)
  test (1, 7, 2, 6) $ \a b -> shuffleFloatX4# a b (# 1#, 7#, 2#, 6# #)
  test (1, 7, 3, 5) $ \a b -> shuffleFloatX4# a b (# 1#, 7#, 3#, 5# #)
  test (1, 7, 5, 3) $ \a b -> shuffleFloatX4# a b (# 1#, 7#, 5#, 3# #)
  test (1, 7, 7, 7) $ \a b -> shuffleFloatX4# a b (# 1#, 7#, 7#, 7# #)
  test (2, 0, 1, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 0#, 1#, 3# #)
  test (2, 0, 3, 1) $ \a b -> shuffleFloatX4# a b (# 2#, 0#, 3#, 1# #)
  test (2, 0, 4, 6) $ \a b -> shuffleFloatX4# a b (# 2#, 0#, 4#, 6# #)
  test (2, 0, 6, 4) $ \a b -> shuffleFloatX4# a b (# 2#, 0#, 6#, 4# #)
  test (2, 1, 0, 1) $ \a b -> shuffleFloatX4# a b (# 2#, 1#, 0#, 1# #)
  test (2, 1, 0, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 1#, 0#, 3# #)
  test (2, 1, 2, 2) $ \a b -> shuffleFloatX4# a b (# 2#, 1#, 2#, 2# #)
  test (2, 1, 3, 0) $ \a b -> shuffleFloatX4# a b (# 2#, 1#, 3#, 0# #)
  test (2, 1, 3, 4) $ \a b -> shuffleFloatX4# a b (# 2#, 1#, 3#, 4# #)
  test (2, 1, 4, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 1#, 4#, 3# #)
  test (2, 1, 5, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 1#, 5#, 3# #)
  test (2, 2, 2, 2) $ \a b -> shuffleFloatX4# a b (# 2#, 2#, 2#, 2# #)
  test (2, 2, 3, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 2#, 3#, 3# #)
  test (2, 2, 3, 7) $ \a b -> shuffleFloatX4# a b (# 2#, 2#, 3#, 7# #)
  test (2, 2, 5, 0) $ \a b -> shuffleFloatX4# a b (# 2#, 2#, 5#, 0# #)
  test (2, 3, 0, 1) $ \a b -> shuffleFloatX4# a b (# 2#, 3#, 0#, 1# #)
  test (2, 3, 1, 0) $ \a b -> shuffleFloatX4# a b (# 2#, 3#, 1#, 0# #)
  test (2, 3, 1, 4) $ \a b -> shuffleFloatX4# a b (# 2#, 3#, 1#, 4# #)
  test (2, 3, 2, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 3#, 2#, 3# #)
  test (2, 3, 4, 1) $ \a b -> shuffleFloatX4# a b (# 2#, 3#, 4#, 1# #)
  test (2, 3, 6, 7) $ \a b -> shuffleFloatX4# a b (# 2#, 3#, 6#, 7# #)
  test (2, 3, 7, 0) $ \a b -> shuffleFloatX4# a b (# 2#, 3#, 7#, 0# #)
  test (2, 3, 7, 6) $ \a b -> shuffleFloatX4# a b (# 2#, 3#, 7#, 6# #)
  test (2, 4, 0, 6) $ \a b -> shuffleFloatX4# a b (# 2#, 4#, 0#, 6# #)
  test (2, 4, 1, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 4#, 1#, 3# #)
  test (2, 4, 3, 1) $ \a b -> shuffleFloatX4# a b (# 2#, 4#, 3#, 1# #)
  test (2, 4, 3, 6) $ \a b -> shuffleFloatX4# a b (# 2#, 4#, 3#, 6# #)
  test (2, 4, 5, 2) $ \a b -> shuffleFloatX4# a b (# 2#, 4#, 5#, 2# #)
  test (2, 4, 6, 0) $ \a b -> shuffleFloatX4# a b (# 2#, 4#, 6#, 0# #)
  test (2, 4, 7, 1) $ \a b -> shuffleFloatX4# a b (# 2#, 4#, 7#, 1# #)
  test (2, 5, 6, 0) $ \a b -> shuffleFloatX4# a b (# 2#, 5#, 6#, 0# #)
  test (2, 6, 0, 4) $ \a b -> shuffleFloatX4# a b (# 2#, 6#, 0#, 4# #)
  test (2, 6, 3, 7) $ \a b -> shuffleFloatX4# a b (# 2#, 6#, 3#, 7# #)
  test (2, 6, 4, 0) $ \a b -> shuffleFloatX4# a b (# 2#, 6#, 4#, 0# #)
  test (2, 6, 5, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 6#, 5#, 3# #)
  test (2, 6, 7, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 6#, 7#, 3# #)
  test (2, 7, 3, 6) $ \a b -> shuffleFloatX4# a b (# 2#, 7#, 3#, 6# #)
  test (2, 7, 6, 3) $ \a b -> shuffleFloatX4# a b (# 2#, 7#, 6#, 3# #)
  test (3, 0, 1, 2) $ \a b -> shuffleFloatX4# a b (# 3#, 0#, 1#, 2# #)
  test (3, 0, 2, 1) $ \a b -> shuffleFloatX4# a b (# 3#, 0#, 2#, 1# #)
  test (3, 0, 2, 4) $ \a b -> shuffleFloatX4# a b (# 3#, 0#, 2#, 4# #)
  test (3, 0, 4, 4) $ \a b -> shuffleFloatX4# a b (# 3#, 0#, 4#, 4# #)
  test (3, 1, 0, 2) $ \a b -> shuffleFloatX4# a b (# 3#, 1#, 0#, 2# #)
  test (3, 1, 0, 4) $ \a b -> shuffleFloatX4# a b (# 3#, 1#, 0#, 4# #)
  test (3, 1, 2, 0) $ \a b -> shuffleFloatX4# a b (# 3#, 1#, 2#, 0# #)
  test (3, 1, 2, 4) $ \a b -> shuffleFloatX4# a b (# 3#, 1#, 2#, 4# #)
  test (3, 1, 4, 2) $ \a b -> shuffleFloatX4# a b (# 3#, 1#, 4#, 2# #)
  test (3, 1, 5, 7) $ \a b -> shuffleFloatX4# a b (# 3#, 1#, 5#, 7# #)
  test (3, 1, 7, 5) $ \a b -> shuffleFloatX4# a b (# 3#, 1#, 7#, 5# #)
  test (3, 2, 0, 1) $ \a b -> shuffleFloatX4# a b (# 3#, 2#, 0#, 1# #)
  test (3, 2, 1, 0) $ \a b -> shuffleFloatX4# a b (# 3#, 2#, 1#, 0# #)
  test (3, 2, 1, 4) $ \a b -> shuffleFloatX4# a b (# 3#, 2#, 1#, 4# #)
  test (3, 2, 2, 5) $ \a b -> shuffleFloatX4# a b (# 3#, 2#, 2#, 5# #)
  test (3, 2, 3, 5) $ \a b -> shuffleFloatX4# a b (# 3#, 2#, 3#, 5# #)
  test (3, 2, 4, 1) $ \a b -> shuffleFloatX4# a b (# 3#, 2#, 4#, 1# #)
  test (3, 2, 6, 7) $ \a b -> shuffleFloatX4# a b (# 3#, 2#, 6#, 7# #)
  test (3, 2, 7, 6) $ \a b -> shuffleFloatX4# a b (# 3#, 2#, 7#, 6# #)
  test (3, 3, 2, 0) $ \a b -> shuffleFloatX4# a b (# 3#, 3#, 2#, 0# #)
  test (3, 3, 3, 3) $ \a b -> shuffleFloatX4# a b (# 3#, 3#, 3#, 3# #)
  test (3, 3, 6, 7) $ \a b -> shuffleFloatX4# a b (# 3#, 3#, 6#, 7# #)
  test (3, 4, 1, 2) $ \a b -> shuffleFloatX4# a b (# 3#, 4#, 1#, 2# #)
  test (3, 4, 2, 1) $ \a b -> shuffleFloatX4# a b (# 3#, 4#, 2#, 1# #)
  test (3, 5, 1, 3) $ \a b -> shuffleFloatX4# a b (# 3#, 5#, 1#, 3# #)
  test (3, 5, 1, 7) $ \a b -> shuffleFloatX4# a b (# 3#, 5#, 1#, 7# #)
  test (3, 5, 2, 7) $ \a b -> shuffleFloatX4# a b (# 3#, 5#, 2#, 7# #)
  test (3, 5, 6, 1) $ \a b -> shuffleFloatX4# a b (# 3#, 5#, 6#, 1# #)
  test (3, 5, 7, 1) $ \a b -> shuffleFloatX4# a b (# 3#, 5#, 7#, 1# #)
  test (3, 6, 2, 7) $ \a b -> shuffleFloatX4# a b (# 3#, 6#, 2#, 7# #)
  test (3, 6, 7, 2) $ \a b -> shuffleFloatX4# a b (# 3#, 6#, 7#, 2# #)
  test (3, 7, 1, 5) $ \a b -> shuffleFloatX4# a b (# 3#, 7#, 1#, 5# #)
  test (3, 7, 2, 6) $ \a b -> shuffleFloatX4# a b (# 3#, 7#, 2#, 6# #)
  test (3, 7, 4, 1) $ \a b -> shuffleFloatX4# a b (# 3#, 7#, 4#, 1# #)
  test (3, 7, 4, 2) $ \a b -> shuffleFloatX4# a b (# 3#, 7#, 4#, 2# #)
  test (3, 7, 5, 1) $ \a b -> shuffleFloatX4# a b (# 3#, 7#, 5#, 1# #)
  test (3, 7, 6, 2) $ \a b -> shuffleFloatX4# a b (# 3#, 7#, 6#, 2# #)
  test (4, 0, 0, 3) $ \a b -> shuffleFloatX4# a b (# 4#, 0#, 0#, 3# #)
  test (4, 0, 1, 5) $ \a b -> shuffleFloatX4# a b (# 4#, 0#, 1#, 5# #)
  test (4, 0, 2, 5) $ \a b -> shuffleFloatX4# a b (# 4#, 0#, 2#, 5# #)
  test (4, 0, 2, 6) $ \a b -> shuffleFloatX4# a b (# 4#, 0#, 2#, 6# #)
  test (4, 0, 5, 1) $ \a b -> shuffleFloatX4# a b (# 4#, 0#, 5#, 1# #)
  test (4, 0, 5, 7) $ \a b -> shuffleFloatX4# a b (# 4#, 0#, 5#, 7# #)
  test (4, 0, 6, 2) $ \a b -> shuffleFloatX4# a b (# 4#, 0#, 6#, 2# #)
  test (4, 1, 0, 1) $ \a b -> shuffleFloatX4# a b (# 4#, 1#, 0#, 1# #)
  test (4, 1, 0, 5) $ \a b -> shuffleFloatX4# a b (# 4#, 1#, 0#, 5# #)
  test (4, 1, 2, 3) $ \a b -> shuffleFloatX4# a b (# 4#, 1#, 2#, 3# #)
  test (4, 1, 2, 7) $ \a b -> shuffleFloatX4# a b (# 4#, 1#, 2#, 7# #)
  test (4, 1, 3, 2) $ \a b -> shuffleFloatX4# a b (# 4#, 1#, 3#, 2# #)
  test (4, 1, 5, 0) $ \a b -> shuffleFloatX4# a b (# 4#, 1#, 5#, 0# #)
  test (4, 1, 6, 3) $ \a b -> shuffleFloatX4# a b (# 4#, 1#, 6#, 3# #)
  test (4, 1, 6, 7) $ \a b -> shuffleFloatX4# a b (# 4#, 1#, 6#, 7# #)
  test (4, 2, 0, 6) $ \a b -> shuffleFloatX4# a b (# 4#, 2#, 0#, 6# #)
  test (4, 2, 1, 3) $ \a b -> shuffleFloatX4# a b (# 4#, 2#, 1#, 3# #)
  test (4, 2, 3, 1) $ \a b -> shuffleFloatX4# a b (# 4#, 2#, 3#, 1# #)
  test (4, 2, 6, 0) $ \a b -> shuffleFloatX4# a b (# 4#, 2#, 6#, 0# #)
  test (4, 3, 1, 2) $ \a b -> shuffleFloatX4# a b (# 4#, 3#, 1#, 2# #)
  test (4, 3, 2, 1) $ \a b -> shuffleFloatX4# a b (# 4#, 3#, 2#, 1# #)
  test (4, 4, 2, 2) $ \a b -> shuffleFloatX4# a b (# 4#, 4#, 2#, 2# #)
  test (4, 4, 3, 3) $ \a b -> shuffleFloatX4# a b (# 4#, 4#, 3#, 3# #)
  test (4, 4, 4, 4) $ \a b -> shuffleFloatX4# a b (# 4#, 4#, 4#, 4# #)
  test (4, 4, 5, 5) $ \a b -> shuffleFloatX4# a b (# 4#, 4#, 5#, 5# #)
  test (4, 5, 0, 1) $ \a b -> shuffleFloatX4# a b (# 4#, 5#, 0#, 1# #)
  test (4, 5, 1, 0) $ \a b -> shuffleFloatX4# a b (# 4#, 5#, 1#, 0# #)
  test (4, 5, 4, 5) $ \a b -> shuffleFloatX4# a b (# 4#, 5#, 4#, 5# #)
  test (4, 5, 6, 3) $ \a b -> shuffleFloatX4# a b (# 4#, 5#, 6#, 3# #)
  test (4, 5, 6, 7) $ \a b -> shuffleFloatX4# a b (# 4#, 5#, 6#, 7# #)
  test (4, 5, 7, 2) $ \a b -> shuffleFloatX4# a b (# 4#, 5#, 7#, 2# #)
  test (4, 5, 7, 6) $ \a b -> shuffleFloatX4# a b (# 4#, 5#, 7#, 6# #)
  test (4, 6, 0, 2) $ \a b -> shuffleFloatX4# a b (# 4#, 6#, 0#, 2# #)
  test (4, 6, 2, 0) $ \a b -> shuffleFloatX4# a b (# 4#, 6#, 2#, 0# #)
  test (4, 6, 4, 3) $ \a b -> shuffleFloatX4# a b (# 4#, 6#, 4#, 3# #)
  test (4, 6, 5, 0) $ \a b -> shuffleFloatX4# a b (# 4#, 6#, 5#, 0# #)
  test (4, 6, 5, 7) $ \a b -> shuffleFloatX4# a b (# 4#, 6#, 5#, 7# #)
  test (4, 6, 7, 5) $ \a b -> shuffleFloatX4# a b (# 4#, 6#, 7#, 5# #)
  test (4, 7, 5, 6) $ \a b -> shuffleFloatX4# a b (# 4#, 7#, 5#, 6# #)
  test (4, 7, 6, 5) $ \a b -> shuffleFloatX4# a b (# 4#, 7#, 6#, 5# #)
  test (4, 7, 7, 4) $ \a b -> shuffleFloatX4# a b (# 4#, 7#, 7#, 4# #)
  test (4, 7, 7, 7) $ \a b -> shuffleFloatX4# a b (# 4#, 7#, 7#, 7# #)
  test (5, 0, 1, 4) $ \a b -> shuffleFloatX4# a b (# 5#, 0#, 1#, 4# #)
  test (5, 0, 4, 1) $ \a b -> shuffleFloatX4# a b (# 5#, 0#, 4#, 1# #)
  test (5, 0, 4, 3) $ \a b -> shuffleFloatX4# a b (# 5#, 0#, 4#, 3# #)
  test (5, 0, 6, 7) $ \a b -> shuffleFloatX4# a b (# 5#, 0#, 6#, 7# #)
  test (5, 0, 7, 6) $ \a b -> shuffleFloatX4# a b (# 5#, 0#, 7#, 6# #)
  test (5, 1, 0, 4) $ \a b -> shuffleFloatX4# a b (# 5#, 1#, 0#, 4# #)
  test (5, 1, 3, 7) $ \a b -> shuffleFloatX4# a b (# 5#, 1#, 3#, 7# #)
  test (5, 1, 4, 0) $ \a b -> shuffleFloatX4# a b (# 5#, 1#, 4#, 0# #)
  test (5, 1, 7, 3) $ \a b -> shuffleFloatX4# a b (# 5#, 1#, 7#, 3# #)
  test (5, 2, 0, 2) $ \a b -> shuffleFloatX4# a b (# 5#, 2#, 0#, 2# #)
  test (5, 2, 3, 3) $ \a b -> shuffleFloatX4# a b (# 5#, 2#, 3#, 3# #)
  test (5, 2, 6, 3) $ \a b -> shuffleFloatX4# a b (# 5#, 2#, 6#, 3# #)
  test (5, 2, 7, 5) $ \a b -> shuffleFloatX4# a b (# 5#, 2#, 7#, 5# #)
  test (5, 3, 1, 7) $ \a b -> shuffleFloatX4# a b (# 5#, 3#, 1#, 7# #)
  test (5, 3, 7, 1) $ \a b -> shuffleFloatX4# a b (# 5#, 3#, 7#, 1# #)
  test (5, 4, 0, 1) $ \a b -> shuffleFloatX4# a b (# 5#, 4#, 0#, 1# #)
  test (5, 4, 1, 0) $ \a b -> shuffleFloatX4# a b (# 5#, 4#, 1#, 0# #)
  test (5, 4, 2, 5) $ \a b -> shuffleFloatX4# a b (# 5#, 4#, 2#, 5# #)
  test (5, 4, 6, 7) $ \a b -> shuffleFloatX4# a b (# 5#, 4#, 6#, 7# #)
  test (5, 4, 7, 6) $ \a b -> shuffleFloatX4# a b (# 5#, 4#, 7#, 6# #)
  test (5, 5, 5, 5) $ \a b -> shuffleFloatX4# a b (# 5#, 5#, 5#, 5# #)
  test (5, 6, 0, 7) $ \a b -> shuffleFloatX4# a b (# 5#, 6#, 0#, 7# #)
  test (5, 6, 1, 2) $ \a b -> shuffleFloatX4# a b (# 5#, 6#, 1#, 2# #)
  test (5, 6, 4, 7) $ \a b -> shuffleFloatX4# a b (# 5#, 6#, 4#, 7# #)
  test (5, 6, 6, 3) $ \a b -> shuffleFloatX4# a b (# 5#, 6#, 6#, 3# #)
  test (5, 6, 7, 0) $ \a b -> shuffleFloatX4# a b (# 5#, 6#, 7#, 0# #)
  test (5, 6, 7, 4) $ \a b -> shuffleFloatX4# a b (# 5#, 6#, 7#, 4# #)
  test (5, 7, 0, 6) $ \a b -> shuffleFloatX4# a b (# 5#, 7#, 0#, 6# #)
  test (5, 7, 1, 3) $ \a b -> shuffleFloatX4# a b (# 5#, 7#, 1#, 3# #)
  test (5, 7, 2, 1) $ \a b -> shuffleFloatX4# a b (# 5#, 7#, 2#, 1# #)
  test (5, 7, 3, 1) $ \a b -> shuffleFloatX4# a b (# 5#, 7#, 3#, 1# #)
  test (5, 7, 4, 6) $ \a b -> shuffleFloatX4# a b (# 5#, 7#, 4#, 6# #)
  test (5, 7, 6, 0) $ \a b -> shuffleFloatX4# a b (# 5#, 7#, 6#, 0# #)
  test (5, 7, 6, 4) $ \a b -> shuffleFloatX4# a b (# 5#, 7#, 6#, 4# #)
  test (5, 7, 6, 5) $ \a b -> shuffleFloatX4# a b (# 5#, 7#, 6#, 5# #)
  test (6, 0, 2, 4) $ \a b -> shuffleFloatX4# a b (# 6#, 0#, 2#, 4# #)
  test (6, 0, 4, 2) $ \a b -> shuffleFloatX4# a b (# 6#, 0#, 4#, 2# #)
  test (6, 0, 5, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 0#, 5#, 7# #)
  test (6, 0, 6, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 0#, 6#, 7# #)
  test (6, 0, 7, 5) $ \a b -> shuffleFloatX4# a b (# 6#, 0#, 7#, 5# #)
  test (6, 0, 7, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 0#, 7#, 7# #)
  test (6, 1, 0, 1) $ \a b -> shuffleFloatX4# a b (# 6#, 1#, 0#, 1# #)
  test (6, 1, 6, 4) $ \a b -> shuffleFloatX4# a b (# 6#, 1#, 6#, 4# #)
  test (6, 2, 0, 4) $ \a b -> shuffleFloatX4# a b (# 6#, 2#, 0#, 4# #)
  test (6, 2, 3, 2) $ \a b -> shuffleFloatX4# a b (# 6#, 2#, 3#, 2# #)
  test (6, 2, 3, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 2#, 3#, 7# #)
  test (6, 2, 4, 0) $ \a b -> shuffleFloatX4# a b (# 6#, 2#, 4#, 0# #)
  test (6, 2, 7, 3) $ \a b -> shuffleFloatX4# a b (# 6#, 2#, 7#, 3# #)
  test (6, 3, 1, 3) $ \a b -> shuffleFloatX4# a b (# 6#, 3#, 1#, 3# #)
  test (6, 3, 2, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 3#, 2#, 7# #)
  test (6, 3, 3, 2) $ \a b -> shuffleFloatX4# a b (# 6#, 3#, 3#, 2# #)
  test (6, 3, 4, 4) $ \a b -> shuffleFloatX4# a b (# 6#, 3#, 4#, 4# #)
  test (6, 3, 7, 2) $ \a b -> shuffleFloatX4# a b (# 6#, 3#, 7#, 2# #)
  test (6, 4, 0, 2) $ \a b -> shuffleFloatX4# a b (# 6#, 4#, 0#, 2# #)
  test (6, 4, 2, 0) $ \a b -> shuffleFloatX4# a b (# 6#, 4#, 2#, 0# #)
  test (6, 4, 2, 6) $ \a b -> shuffleFloatX4# a b (# 6#, 4#, 2#, 6# #)
  test (6, 4, 5, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 4#, 5#, 7# #)
  test (6, 4, 7, 5) $ \a b -> shuffleFloatX4# a b (# 6#, 4#, 7#, 5# #)
  test (6, 5, 0, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 5#, 0#, 7# #)
  test (6, 5, 4, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 5#, 4#, 7# #)
  test (6, 5, 7, 0) $ \a b -> shuffleFloatX4# a b (# 6#, 5#, 7#, 0# #)
  test (6, 5, 7, 4) $ \a b -> shuffleFloatX4# a b (# 6#, 5#, 7#, 4# #)
  test (6, 6, 5, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 6#, 5#, 7# #)
  test (6, 6, 6, 6) $ \a b -> shuffleFloatX4# a b (# 6#, 6#, 6#, 6# #)
  test (6, 6, 7, 2) $ \a b -> shuffleFloatX4# a b (# 6#, 6#, 7#, 2# #)
  test (6, 6, 7, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 6#, 7#, 7# #)
  test (6, 7, 0, 5) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 0#, 5# #)
  test (6, 7, 2, 3) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 2#, 3# #)
  test (6, 7, 3, 0) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 3#, 0# #)
  test (6, 7, 3, 2) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 3#, 2# #)
  test (6, 7, 4, 5) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 4#, 5# #)
  test (6, 7, 5, 0) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 5#, 0# #)
  test (6, 7, 5, 3) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 5#, 3# #)
  test (6, 7, 5, 4) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 5#, 4# #)
  test (6, 7, 6, 7) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 6#, 7# #)
  test (6, 7, 7, 1) $ \a b -> shuffleFloatX4# a b (# 6#, 7#, 7#, 1# #)
  test (7, 0, 1, 1) $ \a b -> shuffleFloatX4# a b (# 7#, 0#, 1#, 1# #)
  test (7, 0, 5, 6) $ \a b -> shuffleFloatX4# a b (# 7#, 0#, 5#, 6# #)
  test (7, 0, 6, 5) $ \a b -> shuffleFloatX4# a b (# 7#, 0#, 6#, 5# #)
  test (7, 1, 1, 0) $ \a b -> shuffleFloatX4# a b (# 7#, 1#, 1#, 0# #)
  test (7, 1, 2, 0) $ \a b -> shuffleFloatX4# a b (# 7#, 1#, 2#, 0# #)
  test (7, 1, 2, 4) $ \a b -> shuffleFloatX4# a b (# 7#, 1#, 2#, 4# #)
  test (7, 1, 3, 5) $ \a b -> shuffleFloatX4# a b (# 7#, 1#, 3#, 5# #)
  test (7, 1, 5, 3) $ \a b -> shuffleFloatX4# a b (# 7#, 1#, 5#, 3# #)
  test (7, 2, 3, 6) $ \a b -> shuffleFloatX4# a b (# 7#, 2#, 3#, 6# #)
  test (7, 2, 6, 3) $ \a b -> shuffleFloatX4# a b (# 7#, 2#, 6#, 3# #)
  test (7, 3, 0, 3) $ \a b -> shuffleFloatX4# a b (# 7#, 3#, 0#, 3# #)
  test (7, 3, 1, 5) $ \a b -> shuffleFloatX4# a b (# 7#, 3#, 1#, 5# #)
  test (7, 3, 2, 6) $ \a b -> shuffleFloatX4# a b (# 7#, 3#, 2#, 6# #)
  test (7, 3, 5, 1) $ \a b -> shuffleFloatX4# a b (# 7#, 3#, 5#, 1# #)
  test (7, 3, 6, 2) $ \a b -> shuffleFloatX4# a b (# 7#, 3#, 6#, 2# #)
  test (7, 3, 7, 6) $ \a b -> shuffleFloatX4# a b (# 7#, 3#, 7#, 6# #)
  test (7, 4, 1, 1) $ \a b -> shuffleFloatX4# a b (# 7#, 4#, 1#, 1# #)
  test (7, 4, 5, 6) $ \a b -> shuffleFloatX4# a b (# 7#, 4#, 5#, 6# #)
  test (7, 4, 6, 5) $ \a b -> shuffleFloatX4# a b (# 7#, 4#, 6#, 5# #)
  test (7, 5, 0, 6) $ \a b -> shuffleFloatX4# a b (# 7#, 5#, 0#, 6# #)
  test (7, 5, 1, 3) $ \a b -> shuffleFloatX4# a b (# 7#, 5#, 1#, 3# #)
  test (7, 5, 2, 1) $ \a b -> shuffleFloatX4# a b (# 7#, 5#, 2#, 1# #)
  test (7, 5, 3, 1) $ \a b -> shuffleFloatX4# a b (# 7#, 5#, 3#, 1# #)
  test (7, 5, 4, 6) $ \a b -> shuffleFloatX4# a b (# 7#, 5#, 4#, 6# #)
  test (7, 5, 6, 0) $ \a b -> shuffleFloatX4# a b (# 7#, 5#, 6#, 0# #)
  test (7, 5, 6, 4) $ \a b -> shuffleFloatX4# a b (# 7#, 5#, 6#, 4# #)
  test (7, 6, 0, 5) $ \a b -> shuffleFloatX4# a b (# 7#, 6#, 0#, 5# #)
  test (7, 6, 1, 2) $ \a b -> shuffleFloatX4# a b (# 7#, 6#, 1#, 2# #)
  test (7, 6, 2, 3) $ \a b -> shuffleFloatX4# a b (# 7#, 6#, 2#, 3# #)
  test (7, 6, 3, 2) $ \a b -> shuffleFloatX4# a b (# 7#, 6#, 3#, 2# #)
  test (7, 6, 4, 5) $ \a b -> shuffleFloatX4# a b (# 7#, 6#, 4#, 5# #)
  test (7, 6, 5, 0) $ \a b -> shuffleFloatX4# a b (# 7#, 6#, 5#, 0# #)
  test (7, 6, 5, 4) $ \a b -> shuffleFloatX4# a b (# 7#, 6#, 5#, 4# #)
  test (7, 6, 6, 4) $ \a b -> shuffleFloatX4# a b (# 7#, 6#, 6#, 4# #)
  test (7, 7, 6, 7) $ \a b -> shuffleFloatX4# a b (# 7#, 7#, 6#, 7# #)
  test (7, 7, 7, 7) $ \a b -> shuffleFloatX4# a b (# 7#, 7#, 7#, 7# #)
  testFlipped (0, 0, 0, 0) $ \a b -> shuffleFloatX4# b a (# 0#, 0#, 0#, 0# #)
  testFlipped (0, 0, 1, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 0#, 1#, 1# #)
  testFlipped (0, 1, 0, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 1#, 0#, 1# #)
  testFlipped (0, 1, 2, 3) $ \a b -> shuffleFloatX4# b a (# 0#, 1#, 2#, 3# #)
  testFlipped (0, 1, 3, 2) $ \a b -> shuffleFloatX4# b a (# 0#, 1#, 3#, 2# #)
  testFlipped (0, 1, 4, 5) $ \a b -> shuffleFloatX4# b a (# 0#, 1#, 4#, 5# #)
  testFlipped (0, 1, 5, 4) $ \a b -> shuffleFloatX4# b a (# 0#, 1#, 5#, 4# #)
  testFlipped (0, 2, 0, 6) $ \a b -> shuffleFloatX4# b a (# 0#, 2#, 0#, 6# #)
  testFlipped (0, 2, 1, 3) $ \a b -> shuffleFloatX4# b a (# 0#, 2#, 1#, 3# #)
  testFlipped (0, 2, 1, 7) $ \a b -> shuffleFloatX4# b a (# 0#, 2#, 1#, 7# #)
  testFlipped (0, 2, 3, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 2#, 3#, 1# #)
  testFlipped (0, 2, 4, 6) $ \a b -> shuffleFloatX4# b a (# 0#, 2#, 4#, 6# #)
  testFlipped (0, 2, 6, 4) $ \a b -> shuffleFloatX4# b a (# 0#, 2#, 6#, 4# #)
  testFlipped (0, 2, 7, 6) $ \a b -> shuffleFloatX4# b a (# 0#, 2#, 7#, 6# #)
  testFlipped (0, 3, 0, 5) $ \a b -> shuffleFloatX4# b a (# 0#, 3#, 0#, 5# #)
  testFlipped (0, 3, 1, 2) $ \a b -> shuffleFloatX4# b a (# 0#, 3#, 1#, 2# #)
  testFlipped (0, 3, 1, 5) $ \a b -> shuffleFloatX4# b a (# 0#, 3#, 1#, 5# #)
  testFlipped (0, 3, 2, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 3#, 2#, 1# #)
  testFlipped (0, 4, 0, 4) $ \a b -> shuffleFloatX4# b a (# 0#, 4#, 0#, 4# #)
  testFlipped (0, 4, 1, 5) $ \a b -> shuffleFloatX4# b a (# 0#, 4#, 1#, 5# #)
  testFlipped (0, 4, 1, 6) $ \a b -> shuffleFloatX4# b a (# 0#, 4#, 1#, 6# #)
  testFlipped (0, 4, 2, 6) $ \a b -> shuffleFloatX4# b a (# 0#, 4#, 2#, 6# #)
  testFlipped (0, 4, 5, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 4#, 5#, 1# #)
  testFlipped (0, 4, 5, 3) $ \a b -> shuffleFloatX4# b a (# 0#, 4#, 5#, 3# #)
  testFlipped (0, 4, 6, 2) $ \a b -> shuffleFloatX4# b a (# 0#, 4#, 6#, 2# #)
  testFlipped (0, 4, 7, 5) $ \a b -> shuffleFloatX4# b a (# 0#, 4#, 7#, 5# #)
  testFlipped (0, 5, 1, 4) $ \a b -> shuffleFloatX4# b a (# 0#, 5#, 1#, 4# #)
  testFlipped (0, 5, 4, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 5#, 4#, 1# #)
  testFlipped (0, 5, 5, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 5#, 5#, 1# #)
  testFlipped (0, 5, 6, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 5#, 6#, 1# #)
  testFlipped (0, 5, 6, 3) $ \a b -> shuffleFloatX4# b a (# 0#, 5#, 6#, 3# #)
  testFlipped (0, 5, 6, 7) $ \a b -> shuffleFloatX4# b a (# 0#, 5#, 6#, 7# #)
  testFlipped (0, 5, 7, 6) $ \a b -> shuffleFloatX4# b a (# 0#, 5#, 7#, 6# #)
  testFlipped (0, 6, 2, 4) $ \a b -> shuffleFloatX4# b a (# 0#, 6#, 2#, 4# #)
  testFlipped (0, 6, 3, 6) $ \a b -> shuffleFloatX4# b a (# 0#, 6#, 3#, 6# #)
  testFlipped (0, 6, 4, 2) $ \a b -> shuffleFloatX4# b a (# 0#, 6#, 4#, 2# #)
  testFlipped (0, 6, 4, 3) $ \a b -> shuffleFloatX4# b a (# 0#, 6#, 4#, 3# #)
  testFlipped (0, 6, 5, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 6#, 5#, 1# #)
  testFlipped (0, 6, 5, 7) $ \a b -> shuffleFloatX4# b a (# 0#, 6#, 5#, 7# #)
  testFlipped (0, 6, 6, 5) $ \a b -> shuffleFloatX4# b a (# 0#, 6#, 6#, 5# #)
  testFlipped (0, 6, 7, 5) $ \a b -> shuffleFloatX4# b a (# 0#, 6#, 7#, 5# #)
  testFlipped (0, 7, 3, 1) $ \a b -> shuffleFloatX4# b a (# 0#, 7#, 3#, 1# #)
  testFlipped (0, 7, 5, 6) $ \a b -> shuffleFloatX4# b a (# 0#, 7#, 5#, 6# #)
  testFlipped (0, 7, 6, 5) $ \a b -> shuffleFloatX4# b a (# 0#, 7#, 6#, 5# #)
  testFlipped (0, 7, 6, 6) $ \a b -> shuffleFloatX4# b a (# 0#, 7#, 6#, 6# #)
  testFlipped (0, 7, 7, 7) $ \a b -> shuffleFloatX4# b a (# 0#, 7#, 7#, 7# #)
  testFlipped (1, 0, 2, 2) $ \a b -> shuffleFloatX4# b a (# 1#, 0#, 2#, 2# #)
  testFlipped (1, 0, 2, 3) $ \a b -> shuffleFloatX4# b a (# 1#, 0#, 2#, 3# #)
  testFlipped (1, 0, 2, 6) $ \a b -> shuffleFloatX4# b a (# 1#, 0#, 2#, 6# #)
  testFlipped (1, 0, 3, 2) $ \a b -> shuffleFloatX4# b a (# 1#, 0#, 3#, 2# #)
  testFlipped (1, 0, 4, 5) $ \a b -> shuffleFloatX4# b a (# 1#, 0#, 4#, 5# #)
  testFlipped (1, 0, 5, 4) $ \a b -> shuffleFloatX4# b a (# 1#, 0#, 5#, 4# #)
  testFlipped (1, 1, 1, 1) $ \a b -> shuffleFloatX4# b a (# 1#, 1#, 1#, 1# #)
  testFlipped (1, 1, 7, 3) $ \a b -> shuffleFloatX4# b a (# 1#, 1#, 7#, 3# #)
  testFlipped (1, 2, 0, 3) $ \a b -> shuffleFloatX4# b a (# 1#, 2#, 0#, 3# #)
  testFlipped (1, 2, 3, 0) $ \a b -> shuffleFloatX4# b a (# 1#, 2#, 3#, 0# #)
  testFlipped (1, 2, 3, 4) $ \a b -> shuffleFloatX4# b a (# 1#, 2#, 3#, 4# #)
  testFlipped (1, 2, 4, 3) $ \a b -> shuffleFloatX4# b a (# 1#, 2#, 4#, 3# #)
  testFlipped (1, 3, 0, 2) $ \a b -> shuffleFloatX4# b a (# 1#, 3#, 0#, 2# #)
  testFlipped (1, 3, 2, 0) $ \a b -> shuffleFloatX4# b a (# 1#, 3#, 2#, 0# #)
  testFlipped (1, 3, 2, 4) $ \a b -> shuffleFloatX4# b a (# 1#, 3#, 2#, 4# #)
  testFlipped (1, 3, 3, 1) $ \a b -> shuffleFloatX4# b a (# 1#, 3#, 3#, 1# #)
  testFlipped (1, 3, 4, 2) $ \a b -> shuffleFloatX4# b a (# 1#, 3#, 4#, 2# #)
  testFlipped (1, 3, 4, 4) $ \a b -> shuffleFloatX4# b a (# 1#, 3#, 4#, 4# #)
  testFlipped (1, 3, 5, 7) $ \a b -> shuffleFloatX4# b a (# 1#, 3#, 5#, 7# #)
  testFlipped (1, 3, 6, 6) $ \a b -> shuffleFloatX4# b a (# 1#, 3#, 6#, 6# #)
  testFlipped (1, 3, 7, 5) $ \a b -> shuffleFloatX4# b a (# 1#, 3#, 7#, 5# #)
  testFlipped (1, 4, 0, 5) $ \a b -> shuffleFloatX4# b a (# 1#, 4#, 0#, 5# #)
  testFlipped (1, 4, 2, 1) $ \a b -> shuffleFloatX4# b a (# 1#, 4#, 2#, 1# #)
  testFlipped (1, 4, 2, 3) $ \a b -> shuffleFloatX4# b a (# 1#, 4#, 2#, 3# #)
  testFlipped (1, 4, 3, 2) $ \a b -> shuffleFloatX4# b a (# 1#, 4#, 3#, 2# #)
  testFlipped (1, 4, 3, 5) $ \a b -> shuffleFloatX4# b a (# 1#, 4#, 3#, 5# #)
  testFlipped (1, 4, 5, 0) $ \a b -> shuffleFloatX4# b a (# 1#, 4#, 5#, 0# #)
  testFlipped (1, 4, 7, 4) $ \a b -> shuffleFloatX4# b a (# 1#, 4#, 7#, 4# #)
  testFlipped (1, 5, 0, 4) $ \a b -> shuffleFloatX4# b a (# 1#, 5#, 0#, 4# #)
  testFlipped (1, 5, 1, 1) $ \a b -> shuffleFloatX4# b a (# 1#, 5#, 1#, 1# #)
  testFlipped (1, 5, 3, 1) $ \a b -> shuffleFloatX4# b a (# 1#, 5#, 3#, 1# #)
  testFlipped (1, 5, 3, 7) $ \a b -> shuffleFloatX4# b a (# 1#, 5#, 3#, 7# #)
  testFlipped (1, 5, 4, 0) $ \a b -> shuffleFloatX4# b a (# 1#, 5#, 4#, 0# #)
  testFlipped (1, 5, 6, 4) $ \a b -> shuffleFloatX4# b a (# 1#, 5#, 6#, 4# #)
  testFlipped (1, 5, 7, 3) $ \a b -> shuffleFloatX4# b a (# 1#, 5#, 7#, 3# #)
  testFlipped (1, 6, 0, 2) $ \a b -> shuffleFloatX4# b a (# 1#, 6#, 0#, 2# #)
  testFlipped (1, 6, 5, 0) $ \a b -> shuffleFloatX4# b a (# 1#, 6#, 5#, 0# #)
  testFlipped (1, 7, 0, 0) $ \a b -> shuffleFloatX4# b a (# 1#, 7#, 0#, 0# #)
  testFlipped (1, 7, 0, 2) $ \a b -> shuffleFloatX4# b a (# 1#, 7#, 0#, 2# #)
  testFlipped (1, 7, 2, 6) $ \a b -> shuffleFloatX4# b a (# 1#, 7#, 2#, 6# #)
  testFlipped (1, 7, 3, 5) $ \a b -> shuffleFloatX4# b a (# 1#, 7#, 3#, 5# #)
  testFlipped (1, 7, 5, 3) $ \a b -> shuffleFloatX4# b a (# 1#, 7#, 5#, 3# #)
  testFlipped (1, 7, 7, 7) $ \a b -> shuffleFloatX4# b a (# 1#, 7#, 7#, 7# #)
  testFlipped (2, 0, 1, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 0#, 1#, 3# #)
  testFlipped (2, 0, 3, 1) $ \a b -> shuffleFloatX4# b a (# 2#, 0#, 3#, 1# #)
  testFlipped (2, 0, 4, 6) $ \a b -> shuffleFloatX4# b a (# 2#, 0#, 4#, 6# #)
  testFlipped (2, 0, 6, 4) $ \a b -> shuffleFloatX4# b a (# 2#, 0#, 6#, 4# #)
  testFlipped (2, 1, 0, 1) $ \a b -> shuffleFloatX4# b a (# 2#, 1#, 0#, 1# #)
  testFlipped (2, 1, 0, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 1#, 0#, 3# #)
  testFlipped (2, 1, 2, 2) $ \a b -> shuffleFloatX4# b a (# 2#, 1#, 2#, 2# #)
  testFlipped (2, 1, 3, 0) $ \a b -> shuffleFloatX4# b a (# 2#, 1#, 3#, 0# #)
  testFlipped (2, 1, 3, 4) $ \a b -> shuffleFloatX4# b a (# 2#, 1#, 3#, 4# #)
  testFlipped (2, 1, 4, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 1#, 4#, 3# #)
  testFlipped (2, 1, 5, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 1#, 5#, 3# #)
  testFlipped (2, 2, 2, 2) $ \a b -> shuffleFloatX4# b a (# 2#, 2#, 2#, 2# #)
  testFlipped (2, 2, 3, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 2#, 3#, 3# #)
  testFlipped (2, 2, 3, 7) $ \a b -> shuffleFloatX4# b a (# 2#, 2#, 3#, 7# #)
  testFlipped (2, 2, 5, 0) $ \a b -> shuffleFloatX4# b a (# 2#, 2#, 5#, 0# #)
  testFlipped (2, 3, 0, 1) $ \a b -> shuffleFloatX4# b a (# 2#, 3#, 0#, 1# #)
  testFlipped (2, 3, 1, 0) $ \a b -> shuffleFloatX4# b a (# 2#, 3#, 1#, 0# #)
  testFlipped (2, 3, 1, 4) $ \a b -> shuffleFloatX4# b a (# 2#, 3#, 1#, 4# #)
  testFlipped (2, 3, 2, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 3#, 2#, 3# #)
  testFlipped (2, 3, 4, 1) $ \a b -> shuffleFloatX4# b a (# 2#, 3#, 4#, 1# #)
  testFlipped (2, 3, 6, 7) $ \a b -> shuffleFloatX4# b a (# 2#, 3#, 6#, 7# #)
  testFlipped (2, 3, 7, 0) $ \a b -> shuffleFloatX4# b a (# 2#, 3#, 7#, 0# #)
  testFlipped (2, 3, 7, 6) $ \a b -> shuffleFloatX4# b a (# 2#, 3#, 7#, 6# #)
  testFlipped (2, 4, 0, 6) $ \a b -> shuffleFloatX4# b a (# 2#, 4#, 0#, 6# #)
  testFlipped (2, 4, 1, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 4#, 1#, 3# #)
  testFlipped (2, 4, 3, 1) $ \a b -> shuffleFloatX4# b a (# 2#, 4#, 3#, 1# #)
  testFlipped (2, 4, 3, 6) $ \a b -> shuffleFloatX4# b a (# 2#, 4#, 3#, 6# #)
  testFlipped (2, 4, 5, 2) $ \a b -> shuffleFloatX4# b a (# 2#, 4#, 5#, 2# #)
  testFlipped (2, 4, 6, 0) $ \a b -> shuffleFloatX4# b a (# 2#, 4#, 6#, 0# #)
  testFlipped (2, 4, 7, 1) $ \a b -> shuffleFloatX4# b a (# 2#, 4#, 7#, 1# #)
  testFlipped (2, 5, 6, 0) $ \a b -> shuffleFloatX4# b a (# 2#, 5#, 6#, 0# #)
  testFlipped (2, 6, 0, 4) $ \a b -> shuffleFloatX4# b a (# 2#, 6#, 0#, 4# #)
  testFlipped (2, 6, 3, 7) $ \a b -> shuffleFloatX4# b a (# 2#, 6#, 3#, 7# #)
  testFlipped (2, 6, 4, 0) $ \a b -> shuffleFloatX4# b a (# 2#, 6#, 4#, 0# #)
  testFlipped (2, 6, 5, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 6#, 5#, 3# #)
  testFlipped (2, 6, 7, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 6#, 7#, 3# #)
  testFlipped (2, 7, 3, 6) $ \a b -> shuffleFloatX4# b a (# 2#, 7#, 3#, 6# #)
  testFlipped (2, 7, 6, 3) $ \a b -> shuffleFloatX4# b a (# 2#, 7#, 6#, 3# #)
  testFlipped (3, 0, 1, 2) $ \a b -> shuffleFloatX4# b a (# 3#, 0#, 1#, 2# #)
  testFlipped (3, 0, 2, 1) $ \a b -> shuffleFloatX4# b a (# 3#, 0#, 2#, 1# #)
  testFlipped (3, 0, 2, 4) $ \a b -> shuffleFloatX4# b a (# 3#, 0#, 2#, 4# #)
  testFlipped (3, 0, 4, 4) $ \a b -> shuffleFloatX4# b a (# 3#, 0#, 4#, 4# #)
  testFlipped (3, 1, 0, 2) $ \a b -> shuffleFloatX4# b a (# 3#, 1#, 0#, 2# #)
  testFlipped (3, 1, 0, 4) $ \a b -> shuffleFloatX4# b a (# 3#, 1#, 0#, 4# #)
  testFlipped (3, 1, 2, 0) $ \a b -> shuffleFloatX4# b a (# 3#, 1#, 2#, 0# #)
  testFlipped (3, 1, 2, 4) $ \a b -> shuffleFloatX4# b a (# 3#, 1#, 2#, 4# #)
  testFlipped (3, 1, 4, 2) $ \a b -> shuffleFloatX4# b a (# 3#, 1#, 4#, 2# #)
  testFlipped (3, 1, 5, 7) $ \a b -> shuffleFloatX4# b a (# 3#, 1#, 5#, 7# #)
  testFlipped (3, 1, 7, 5) $ \a b -> shuffleFloatX4# b a (# 3#, 1#, 7#, 5# #)
  testFlipped (3, 2, 0, 1) $ \a b -> shuffleFloatX4# b a (# 3#, 2#, 0#, 1# #)
  testFlipped (3, 2, 1, 0) $ \a b -> shuffleFloatX4# b a (# 3#, 2#, 1#, 0# #)
  testFlipped (3, 2, 1, 4) $ \a b -> shuffleFloatX4# b a (# 3#, 2#, 1#, 4# #)
  testFlipped (3, 2, 2, 5) $ \a b -> shuffleFloatX4# b a (# 3#, 2#, 2#, 5# #)
  testFlipped (3, 2, 3, 5) $ \a b -> shuffleFloatX4# b a (# 3#, 2#, 3#, 5# #)
  testFlipped (3, 2, 4, 1) $ \a b -> shuffleFloatX4# b a (# 3#, 2#, 4#, 1# #)
  testFlipped (3, 2, 6, 7) $ \a b -> shuffleFloatX4# b a (# 3#, 2#, 6#, 7# #)
  testFlipped (3, 2, 7, 6) $ \a b -> shuffleFloatX4# b a (# 3#, 2#, 7#, 6# #)
  testFlipped (3, 3, 2, 0) $ \a b -> shuffleFloatX4# b a (# 3#, 3#, 2#, 0# #)
  testFlipped (3, 3, 3, 3) $ \a b -> shuffleFloatX4# b a (# 3#, 3#, 3#, 3# #)
  testFlipped (3, 3, 6, 7) $ \a b -> shuffleFloatX4# b a (# 3#, 3#, 6#, 7# #)
  testFlipped (3, 4, 1, 2) $ \a b -> shuffleFloatX4# b a (# 3#, 4#, 1#, 2# #)
  testFlipped (3, 4, 2, 1) $ \a b -> shuffleFloatX4# b a (# 3#, 4#, 2#, 1# #)
  testFlipped (3, 5, 1, 3) $ \a b -> shuffleFloatX4# b a (# 3#, 5#, 1#, 3# #)
  testFlipped (3, 5, 1, 7) $ \a b -> shuffleFloatX4# b a (# 3#, 5#, 1#, 7# #)
  testFlipped (3, 5, 2, 7) $ \a b -> shuffleFloatX4# b a (# 3#, 5#, 2#, 7# #)
  testFlipped (3, 5, 6, 1) $ \a b -> shuffleFloatX4# b a (# 3#, 5#, 6#, 1# #)
  testFlipped (3, 5, 7, 1) $ \a b -> shuffleFloatX4# b a (# 3#, 5#, 7#, 1# #)
  testFlipped (3, 6, 2, 7) $ \a b -> shuffleFloatX4# b a (# 3#, 6#, 2#, 7# #)
  testFlipped (3, 6, 7, 2) $ \a b -> shuffleFloatX4# b a (# 3#, 6#, 7#, 2# #)
  testFlipped (3, 7, 1, 5) $ \a b -> shuffleFloatX4# b a (# 3#, 7#, 1#, 5# #)
  testFlipped (3, 7, 2, 6) $ \a b -> shuffleFloatX4# b a (# 3#, 7#, 2#, 6# #)
  testFlipped (3, 7, 4, 1) $ \a b -> shuffleFloatX4# b a (# 3#, 7#, 4#, 1# #)
  testFlipped (3, 7, 4, 2) $ \a b -> shuffleFloatX4# b a (# 3#, 7#, 4#, 2# #)
  testFlipped (3, 7, 5, 1) $ \a b -> shuffleFloatX4# b a (# 3#, 7#, 5#, 1# #)
  testFlipped (3, 7, 6, 2) $ \a b -> shuffleFloatX4# b a (# 3#, 7#, 6#, 2# #)
  testFlipped (4, 0, 0, 3) $ \a b -> shuffleFloatX4# b a (# 4#, 0#, 0#, 3# #)
  testFlipped (4, 0, 1, 5) $ \a b -> shuffleFloatX4# b a (# 4#, 0#, 1#, 5# #)
  testFlipped (4, 0, 2, 5) $ \a b -> shuffleFloatX4# b a (# 4#, 0#, 2#, 5# #)
  testFlipped (4, 0, 2, 6) $ \a b -> shuffleFloatX4# b a (# 4#, 0#, 2#, 6# #)
  testFlipped (4, 0, 5, 1) $ \a b -> shuffleFloatX4# b a (# 4#, 0#, 5#, 1# #)
  testFlipped (4, 0, 5, 7) $ \a b -> shuffleFloatX4# b a (# 4#, 0#, 5#, 7# #)
  testFlipped (4, 0, 6, 2) $ \a b -> shuffleFloatX4# b a (# 4#, 0#, 6#, 2# #)
  testFlipped (4, 1, 0, 1) $ \a b -> shuffleFloatX4# b a (# 4#, 1#, 0#, 1# #)
  testFlipped (4, 1, 0, 5) $ \a b -> shuffleFloatX4# b a (# 4#, 1#, 0#, 5# #)
  testFlipped (4, 1, 2, 3) $ \a b -> shuffleFloatX4# b a (# 4#, 1#, 2#, 3# #)
  testFlipped (4, 1, 2, 7) $ \a b -> shuffleFloatX4# b a (# 4#, 1#, 2#, 7# #)
  testFlipped (4, 1, 3, 2) $ \a b -> shuffleFloatX4# b a (# 4#, 1#, 3#, 2# #)
  testFlipped (4, 1, 5, 0) $ \a b -> shuffleFloatX4# b a (# 4#, 1#, 5#, 0# #)
  testFlipped (4, 1, 6, 3) $ \a b -> shuffleFloatX4# b a (# 4#, 1#, 6#, 3# #)
  testFlipped (4, 1, 6, 7) $ \a b -> shuffleFloatX4# b a (# 4#, 1#, 6#, 7# #)
  testFlipped (4, 2, 0, 6) $ \a b -> shuffleFloatX4# b a (# 4#, 2#, 0#, 6# #)
  testFlipped (4, 2, 1, 3) $ \a b -> shuffleFloatX4# b a (# 4#, 2#, 1#, 3# #)
  testFlipped (4, 2, 3, 1) $ \a b -> shuffleFloatX4# b a (# 4#, 2#, 3#, 1# #)
  testFlipped (4, 2, 6, 0) $ \a b -> shuffleFloatX4# b a (# 4#, 2#, 6#, 0# #)
  testFlipped (4, 3, 1, 2) $ \a b -> shuffleFloatX4# b a (# 4#, 3#, 1#, 2# #)
  testFlipped (4, 3, 2, 1) $ \a b -> shuffleFloatX4# b a (# 4#, 3#, 2#, 1# #)
  testFlipped (4, 4, 2, 2) $ \a b -> shuffleFloatX4# b a (# 4#, 4#, 2#, 2# #)
  testFlipped (4, 4, 3, 3) $ \a b -> shuffleFloatX4# b a (# 4#, 4#, 3#, 3# #)
  testFlipped (4, 4, 4, 4) $ \a b -> shuffleFloatX4# b a (# 4#, 4#, 4#, 4# #)
  testFlipped (4, 4, 5, 5) $ \a b -> shuffleFloatX4# b a (# 4#, 4#, 5#, 5# #)
  testFlipped (4, 5, 0, 1) $ \a b -> shuffleFloatX4# b a (# 4#, 5#, 0#, 1# #)
  testFlipped (4, 5, 1, 0) $ \a b -> shuffleFloatX4# b a (# 4#, 5#, 1#, 0# #)
  testFlipped (4, 5, 4, 5) $ \a b -> shuffleFloatX4# b a (# 4#, 5#, 4#, 5# #)
  testFlipped (4, 5, 6, 3) $ \a b -> shuffleFloatX4# b a (# 4#, 5#, 6#, 3# #)
  testFlipped (4, 5, 6, 7) $ \a b -> shuffleFloatX4# b a (# 4#, 5#, 6#, 7# #)
  testFlipped (4, 5, 7, 2) $ \a b -> shuffleFloatX4# b a (# 4#, 5#, 7#, 2# #)
  testFlipped (4, 5, 7, 6) $ \a b -> shuffleFloatX4# b a (# 4#, 5#, 7#, 6# #)
  testFlipped (4, 6, 0, 2) $ \a b -> shuffleFloatX4# b a (# 4#, 6#, 0#, 2# #)
  testFlipped (4, 6, 2, 0) $ \a b -> shuffleFloatX4# b a (# 4#, 6#, 2#, 0# #)
  testFlipped (4, 6, 4, 3) $ \a b -> shuffleFloatX4# b a (# 4#, 6#, 4#, 3# #)
  testFlipped (4, 6, 5, 0) $ \a b -> shuffleFloatX4# b a (# 4#, 6#, 5#, 0# #)
  testFlipped (4, 6, 5, 7) $ \a b -> shuffleFloatX4# b a (# 4#, 6#, 5#, 7# #)
  testFlipped (4, 6, 7, 5) $ \a b -> shuffleFloatX4# b a (# 4#, 6#, 7#, 5# #)
  testFlipped (4, 7, 5, 6) $ \a b -> shuffleFloatX4# b a (# 4#, 7#, 5#, 6# #)
  testFlipped (4, 7, 6, 5) $ \a b -> shuffleFloatX4# b a (# 4#, 7#, 6#, 5# #)
  testFlipped (4, 7, 7, 4) $ \a b -> shuffleFloatX4# b a (# 4#, 7#, 7#, 4# #)
  testFlipped (4, 7, 7, 7) $ \a b -> shuffleFloatX4# b a (# 4#, 7#, 7#, 7# #)
  testFlipped (5, 0, 1, 4) $ \a b -> shuffleFloatX4# b a (# 5#, 0#, 1#, 4# #)
  testFlipped (5, 0, 4, 1) $ \a b -> shuffleFloatX4# b a (# 5#, 0#, 4#, 1# #)
  testFlipped (5, 0, 4, 3) $ \a b -> shuffleFloatX4# b a (# 5#, 0#, 4#, 3# #)
  testFlipped (5, 0, 6, 7) $ \a b -> shuffleFloatX4# b a (# 5#, 0#, 6#, 7# #)
  testFlipped (5, 0, 7, 6) $ \a b -> shuffleFloatX4# b a (# 5#, 0#, 7#, 6# #)
  testFlipped (5, 1, 0, 4) $ \a b -> shuffleFloatX4# b a (# 5#, 1#, 0#, 4# #)
  testFlipped (5, 1, 3, 7) $ \a b -> shuffleFloatX4# b a (# 5#, 1#, 3#, 7# #)
  testFlipped (5, 1, 4, 0) $ \a b -> shuffleFloatX4# b a (# 5#, 1#, 4#, 0# #)
  testFlipped (5, 1, 7, 3) $ \a b -> shuffleFloatX4# b a (# 5#, 1#, 7#, 3# #)
  testFlipped (5, 2, 0, 2) $ \a b -> shuffleFloatX4# b a (# 5#, 2#, 0#, 2# #)
  testFlipped (5, 2, 3, 3) $ \a b -> shuffleFloatX4# b a (# 5#, 2#, 3#, 3# #)
  testFlipped (5, 2, 6, 3) $ \a b -> shuffleFloatX4# b a (# 5#, 2#, 6#, 3# #)
  testFlipped (5, 2, 7, 5) $ \a b -> shuffleFloatX4# b a (# 5#, 2#, 7#, 5# #)
  testFlipped (5, 3, 1, 7) $ \a b -> shuffleFloatX4# b a (# 5#, 3#, 1#, 7# #)
  testFlipped (5, 3, 7, 1) $ \a b -> shuffleFloatX4# b a (# 5#, 3#, 7#, 1# #)
  testFlipped (5, 4, 0, 1) $ \a b -> shuffleFloatX4# b a (# 5#, 4#, 0#, 1# #)
  testFlipped (5, 4, 1, 0) $ \a b -> shuffleFloatX4# b a (# 5#, 4#, 1#, 0# #)
  testFlipped (5, 4, 2, 5) $ \a b -> shuffleFloatX4# b a (# 5#, 4#, 2#, 5# #)
  testFlipped (5, 4, 6, 7) $ \a b -> shuffleFloatX4# b a (# 5#, 4#, 6#, 7# #)
  testFlipped (5, 4, 7, 6) $ \a b -> shuffleFloatX4# b a (# 5#, 4#, 7#, 6# #)
  testFlipped (5, 5, 5, 5) $ \a b -> shuffleFloatX4# b a (# 5#, 5#, 5#, 5# #)
  testFlipped (5, 6, 0, 7) $ \a b -> shuffleFloatX4# b a (# 5#, 6#, 0#, 7# #)
  testFlipped (5, 6, 1, 2) $ \a b -> shuffleFloatX4# b a (# 5#, 6#, 1#, 2# #)
  testFlipped (5, 6, 4, 7) $ \a b -> shuffleFloatX4# b a (# 5#, 6#, 4#, 7# #)
  testFlipped (5, 6, 6, 3) $ \a b -> shuffleFloatX4# b a (# 5#, 6#, 6#, 3# #)
  testFlipped (5, 6, 7, 0) $ \a b -> shuffleFloatX4# b a (# 5#, 6#, 7#, 0# #)
  testFlipped (5, 6, 7, 4) $ \a b -> shuffleFloatX4# b a (# 5#, 6#, 7#, 4# #)
  testFlipped (5, 7, 0, 6) $ \a b -> shuffleFloatX4# b a (# 5#, 7#, 0#, 6# #)
  testFlipped (5, 7, 1, 3) $ \a b -> shuffleFloatX4# b a (# 5#, 7#, 1#, 3# #)
  testFlipped (5, 7, 2, 1) $ \a b -> shuffleFloatX4# b a (# 5#, 7#, 2#, 1# #)
  testFlipped (5, 7, 3, 1) $ \a b -> shuffleFloatX4# b a (# 5#, 7#, 3#, 1# #)
  testFlipped (5, 7, 4, 6) $ \a b -> shuffleFloatX4# b a (# 5#, 7#, 4#, 6# #)
  testFlipped (5, 7, 6, 0) $ \a b -> shuffleFloatX4# b a (# 5#, 7#, 6#, 0# #)
  testFlipped (5, 7, 6, 4) $ \a b -> shuffleFloatX4# b a (# 5#, 7#, 6#, 4# #)
  testFlipped (5, 7, 6, 5) $ \a b -> shuffleFloatX4# b a (# 5#, 7#, 6#, 5# #)
  testFlipped (6, 0, 2, 4) $ \a b -> shuffleFloatX4# b a (# 6#, 0#, 2#, 4# #)
  testFlipped (6, 0, 4, 2) $ \a b -> shuffleFloatX4# b a (# 6#, 0#, 4#, 2# #)
  testFlipped (6, 0, 5, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 0#, 5#, 7# #)
  testFlipped (6, 0, 6, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 0#, 6#, 7# #)
  testFlipped (6, 0, 7, 5) $ \a b -> shuffleFloatX4# b a (# 6#, 0#, 7#, 5# #)
  testFlipped (6, 0, 7, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 0#, 7#, 7# #)
  testFlipped (6, 1, 0, 1) $ \a b -> shuffleFloatX4# b a (# 6#, 1#, 0#, 1# #)
  testFlipped (6, 1, 6, 4) $ \a b -> shuffleFloatX4# b a (# 6#, 1#, 6#, 4# #)
  testFlipped (6, 2, 0, 4) $ \a b -> shuffleFloatX4# b a (# 6#, 2#, 0#, 4# #)
  testFlipped (6, 2, 3, 2) $ \a b -> shuffleFloatX4# b a (# 6#, 2#, 3#, 2# #)
  testFlipped (6, 2, 3, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 2#, 3#, 7# #)
  testFlipped (6, 2, 4, 0) $ \a b -> shuffleFloatX4# b a (# 6#, 2#, 4#, 0# #)
  testFlipped (6, 2, 7, 3) $ \a b -> shuffleFloatX4# b a (# 6#, 2#, 7#, 3# #)
  testFlipped (6, 3, 1, 3) $ \a b -> shuffleFloatX4# b a (# 6#, 3#, 1#, 3# #)
  testFlipped (6, 3, 2, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 3#, 2#, 7# #)
  testFlipped (6, 3, 3, 2) $ \a b -> shuffleFloatX4# b a (# 6#, 3#, 3#, 2# #)
  testFlipped (6, 3, 4, 4) $ \a b -> shuffleFloatX4# b a (# 6#, 3#, 4#, 4# #)
  testFlipped (6, 3, 7, 2) $ \a b -> shuffleFloatX4# b a (# 6#, 3#, 7#, 2# #)
  testFlipped (6, 4, 0, 2) $ \a b -> shuffleFloatX4# b a (# 6#, 4#, 0#, 2# #)
  testFlipped (6, 4, 2, 0) $ \a b -> shuffleFloatX4# b a (# 6#, 4#, 2#, 0# #)
  testFlipped (6, 4, 2, 6) $ \a b -> shuffleFloatX4# b a (# 6#, 4#, 2#, 6# #)
  testFlipped (6, 4, 5, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 4#, 5#, 7# #)
  testFlipped (6, 4, 7, 5) $ \a b -> shuffleFloatX4# b a (# 6#, 4#, 7#, 5# #)
  testFlipped (6, 5, 0, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 5#, 0#, 7# #)
  testFlipped (6, 5, 4, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 5#, 4#, 7# #)
  testFlipped (6, 5, 7, 0) $ \a b -> shuffleFloatX4# b a (# 6#, 5#, 7#, 0# #)
  testFlipped (6, 5, 7, 4) $ \a b -> shuffleFloatX4# b a (# 6#, 5#, 7#, 4# #)
  testFlipped (6, 6, 5, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 6#, 5#, 7# #)
  testFlipped (6, 6, 6, 6) $ \a b -> shuffleFloatX4# b a (# 6#, 6#, 6#, 6# #)
  testFlipped (6, 6, 7, 2) $ \a b -> shuffleFloatX4# b a (# 6#, 6#, 7#, 2# #)
  testFlipped (6, 6, 7, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 6#, 7#, 7# #)
  testFlipped (6, 7, 0, 5) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 0#, 5# #)
  testFlipped (6, 7, 2, 3) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 2#, 3# #)
  testFlipped (6, 7, 3, 0) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 3#, 0# #)
  testFlipped (6, 7, 3, 2) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 3#, 2# #)
  testFlipped (6, 7, 4, 5) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 4#, 5# #)
  testFlipped (6, 7, 5, 0) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 5#, 0# #)
  testFlipped (6, 7, 5, 3) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 5#, 3# #)
  testFlipped (6, 7, 5, 4) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 5#, 4# #)
  testFlipped (6, 7, 6, 7) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 6#, 7# #)
  testFlipped (6, 7, 7, 1) $ \a b -> shuffleFloatX4# b a (# 6#, 7#, 7#, 1# #)
  testFlipped (7, 0, 1, 1) $ \a b -> shuffleFloatX4# b a (# 7#, 0#, 1#, 1# #)
  testFlipped (7, 0, 5, 6) $ \a b -> shuffleFloatX4# b a (# 7#, 0#, 5#, 6# #)
  testFlipped (7, 0, 6, 5) $ \a b -> shuffleFloatX4# b a (# 7#, 0#, 6#, 5# #)
  testFlipped (7, 1, 1, 0) $ \a b -> shuffleFloatX4# b a (# 7#, 1#, 1#, 0# #)
  testFlipped (7, 1, 2, 0) $ \a b -> shuffleFloatX4# b a (# 7#, 1#, 2#, 0# #)
  testFlipped (7, 1, 2, 4) $ \a b -> shuffleFloatX4# b a (# 7#, 1#, 2#, 4# #)
  testFlipped (7, 1, 3, 5) $ \a b -> shuffleFloatX4# b a (# 7#, 1#, 3#, 5# #)
  testFlipped (7, 1, 5, 3) $ \a b -> shuffleFloatX4# b a (# 7#, 1#, 5#, 3# #)
  testFlipped (7, 2, 3, 6) $ \a b -> shuffleFloatX4# b a (# 7#, 2#, 3#, 6# #)
  testFlipped (7, 2, 6, 3) $ \a b -> shuffleFloatX4# b a (# 7#, 2#, 6#, 3# #)
  testFlipped (7, 3, 0, 3) $ \a b -> shuffleFloatX4# b a (# 7#, 3#, 0#, 3# #)
  testFlipped (7, 3, 1, 5) $ \a b -> shuffleFloatX4# b a (# 7#, 3#, 1#, 5# #)
  testFlipped (7, 3, 2, 6) $ \a b -> shuffleFloatX4# b a (# 7#, 3#, 2#, 6# #)
  testFlipped (7, 3, 5, 1) $ \a b -> shuffleFloatX4# b a (# 7#, 3#, 5#, 1# #)
  testFlipped (7, 3, 6, 2) $ \a b -> shuffleFloatX4# b a (# 7#, 3#, 6#, 2# #)
  testFlipped (7, 3, 7, 6) $ \a b -> shuffleFloatX4# b a (# 7#, 3#, 7#, 6# #)
  testFlipped (7, 4, 1, 1) $ \a b -> shuffleFloatX4# b a (# 7#, 4#, 1#, 1# #)
  testFlipped (7, 4, 5, 6) $ \a b -> shuffleFloatX4# b a (# 7#, 4#, 5#, 6# #)
  testFlipped (7, 4, 6, 5) $ \a b -> shuffleFloatX4# b a (# 7#, 4#, 6#, 5# #)
  testFlipped (7, 5, 0, 6) $ \a b -> shuffleFloatX4# b a (# 7#, 5#, 0#, 6# #)
  testFlipped (7, 5, 1, 3) $ \a b -> shuffleFloatX4# b a (# 7#, 5#, 1#, 3# #)
  testFlipped (7, 5, 2, 1) $ \a b -> shuffleFloatX4# b a (# 7#, 5#, 2#, 1# #)
  testFlipped (7, 5, 3, 1) $ \a b -> shuffleFloatX4# b a (# 7#, 5#, 3#, 1# #)
  testFlipped (7, 5, 4, 6) $ \a b -> shuffleFloatX4# b a (# 7#, 5#, 4#, 6# #)
  testFlipped (7, 5, 6, 0) $ \a b -> shuffleFloatX4# b a (# 7#, 5#, 6#, 0# #)
  testFlipped (7, 5, 6, 4) $ \a b -> shuffleFloatX4# b a (# 7#, 5#, 6#, 4# #)
  testFlipped (7, 6, 0, 5) $ \a b -> shuffleFloatX4# b a (# 7#, 6#, 0#, 5# #)
  testFlipped (7, 6, 1, 2) $ \a b -> shuffleFloatX4# b a (# 7#, 6#, 1#, 2# #)
  testFlipped (7, 6, 2, 3) $ \a b -> shuffleFloatX4# b a (# 7#, 6#, 2#, 3# #)
  testFlipped (7, 6, 3, 2) $ \a b -> shuffleFloatX4# b a (# 7#, 6#, 3#, 2# #)
  testFlipped (7, 6, 4, 5) $ \a b -> shuffleFloatX4# b a (# 7#, 6#, 4#, 5# #)
  testFlipped (7, 6, 5, 0) $ \a b -> shuffleFloatX4# b a (# 7#, 6#, 5#, 0# #)
  testFlipped (7, 6, 5, 4) $ \a b -> shuffleFloatX4# b a (# 7#, 6#, 5#, 4# #)
  testFlipped (7, 6, 6, 4) $ \a b -> shuffleFloatX4# b a (# 7#, 6#, 6#, 4# #)
  testFlipped (7, 7, 6, 7) $ \a b -> shuffleFloatX4# b a (# 7#, 7#, 6#, 7# #)
  testFlipped (7, 7, 7, 7) $ \a b -> shuffleFloatX4# b a (# 7#, 7#, 7#, 7# #)

{- Generated by:
{- cabal:
build-depends: base, random
-}
import System.Random.Stateful
import qualified Data.List as List
import Control.Monad

main :: IO ()
main = do
  let genShuffle = replicateM 4 . uniformRM (0, 7)
      pureGen = mkStdGen 42
      randomCases = runStateGen_ pureGen $ \g -> do
        randomCases <- replicateM 100 (genShuffle g)
        blend <- replicateM 10 $ replicateM 4 (uniformRM (0, 1) g)
        let blendCases = [[4 * i + j | (i,j) <- zip is [0..]] | is <- blend]
        insertCases <- replicateM 10 $ do
          b <- uniformM g
          srcPos <- uniformRM (if b then (0,3) else (4,7)) g
          xs <- replicateM 3 $ uniformRM (if b then (4,7) else (0,3)) g
          uniformShuffleListM (srcPos : xs) g
        return $ randomCases ++ blendCases ++ insertCases
      fixedCases = [[i,i,i,i] | i <- [0..7]]
        ++ List.permutations [0,1,2,3]
        ++ List.permutations [4,5,6,7]
        ++ List.permutations [0,2,4,6]
        ++ List.permutations [1,3,5,7]
        ++ List.permutations [0,1,4,5]
        ++ List.permutations [2,3,6,7]
        ++ List.permutations [1,2,3,4]
        ++ List.permutations [0,5,6,7]
        ++ [[0,1,0,1]
           ,[2,3,2,3]
           ,[4,5,4,5]
           ,[6,7,6,7]
           ,[0,0,1,1]
           ,[2,2,3,3]
           ,[4,4,5,5]
           ,[6,6,7,7]]
      cases = List.nub $ List.sort $ fixedCases ++ randomCases
  forM_ cases $ \xs -> do
    putStrLn $ "  test (" ++ List.intercalate ", " (map show xs) ++ ") $ \\a b -> shuffleFloatX4# a b (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
  forM_ cases $ \xs -> do
    putStrLn $ "  testFlipped (" ++ List.intercalate ", " (map show xs) ++ ") $ \\a b -> shuffleFloatX4# b a (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
-}
