/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { StreamingState } from '../types.js';
import { type RetryAttemptPayload } from '@google/gemini-cli-core';
import type { LoadingPhrasesMode } from '../../config/settings.js';
export interface UseLoadingIndicatorProps {
    streamingState: StreamingState;
    shouldShowFocusHint: boolean;
    retryStatus: RetryAttemptPayload | null;
    loadingPhrasesMode?: LoadingPhrasesMode;
    customWittyPhrases?: string[];
}
export declare const useLoadingIndicator: ({ streamingState, shouldShowFocusHint, retryStatus, loadingPhrasesMode, customWittyPhrases, }: UseLoadingIndicatorProps) => {
    elapsedTime: number;
    currentLoadingPhrase: string | undefined;
};
