/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.api.resource.LoadableResourceMetadata;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.experimental.schemahistory.ResolvedSchemaHistoryItem;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.nc.info.CoreMigrationStateCalculator;
import org.flywaydb.nc.info.ExperimentalMigrationInfoImpl;
import org.flywaydb.nc.migration.CompositeMigrationTypeResolver;
import org.flywaydb.nc.migration.ExperimentalMigrationComparator;
import org.flywaydb.nc.migration.ExperimentalMigrationScannerManager;
import org.flywaydb.nc.migration.ExperimentalMigrationStateCalculator;
import org.flywaydb.nc.migration.MigrationTypeResolver;

public class VerbUtils {
    private static final Log LOG = LogFactory.getLog(VerbUtils.class);
    private static boolean databaseInfoPrinted;

    public static Collection<LoadableResourceMetadata> scanForResources(Configuration configuration, ParsingContext parsingContext) {
        ExperimentalMigrationScannerManager scannerManager = new ExperimentalMigrationScannerManager(configuration);
        Collection<LoadableResourceMetadata> resources = scannerManager.scan(configuration, parsingContext);
        return resources;
    }

    public static SchemaHistoryModel getSchemaHistoryModel(Configuration configuration, ExperimentalDatabase experimentalDatabase) {
        return experimentalDatabase.getSchemaHistoryModel(configuration.getTable());
    }

    public static ExperimentalDatabase getExperimentalDatabase(Configuration configuration) throws SQLException {
        Optional resolvedExperimentalDatabase = ExperimentalModeUtils.resolveExperimentalDatabasePlugin((Configuration)configuration);
        if (resolvedExperimentalDatabase.isEmpty()) {
            throw new FlywayException("No Native Connectors database plugin found for the designated database");
        }
        ExperimentalDatabase experimentalDatabase = (ExperimentalDatabase)resolvedExperimentalDatabase.get();
        experimentalDatabase.initialize(VerbUtils.getResolvedEnvironment(configuration), configuration);
        if (!databaseInfoPrinted) {
            LOG.info("Database: " + experimentalDatabase.redactUrl(configuration.getUrl()) + " (" + experimentalDatabase.getDatabaseMetaData().productName() + ")");
            databaseInfoPrinted = true;
        }
        return experimentalDatabase;
    }

    public static MigrationInfo[] getMigrations(SchemaHistoryModel schemaHistoryModel, LoadableResourceMetadata[] sortedMigrations, Configuration configuration) {
        ArrayList<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> migrations = new ArrayList<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>>();
        CompositeMigrationTypeResolver migrationTypeResolver = new CompositeMigrationTypeResolver();
        List<ResolvedSchemaHistoryItem> resolvedSchemaHistoryItems = VerbUtils.getResolvedSchemaHistoryItems(schemaHistoryModel, configuration, migrationTypeResolver);
        List<LoadableResourceMetadata> resolvedMigrations = VerbUtils.getResolvedMigrations(sortedMigrations, configuration);
        VerbUtils.insertResolvedSchemaHistoryItems(resolvedSchemaHistoryItems, migrations);
        VerbUtils.insertResolvedMigrations(resolvedMigrations, migrations);
        VerbUtils.insertUndoneMigrations(resolvedSchemaHistoryItems, resolvedMigrations, migrations);
        ExperimentalMigrationComparator comparator = VerbUtils.getOrderComparator(configuration);
        List<ExperimentalMigrationStateCalculator> stateCalculators = VerbUtils.getMigrationStateCalculators(configuration);
        List copy = migrations.stream().toList();
        return (MigrationInfo[])migrations.stream().map(x -> {
            MigrationState state = stateCalculators.stream().map(stateCalculator -> stateCalculator.calculateState((Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>)x, copy, configuration)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new FlywayException("No state calculator found"));
            return new ExperimentalMigrationInfoImpl((Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>)x, state);
        }).filter(x -> x.getType() != CoreMigrationType.DELETE).sorted(comparator.getComparator(configuration)).toArray(MigrationInfo[]::new);
    }

    private static List<ResolvedSchemaHistoryItem> getResolvedSchemaHistoryItems(SchemaHistoryModel schemaHistoryModel, Configuration configuration, MigrationTypeResolver migrationTypeResolver) {
        return schemaHistoryModel.getSchemaHistoryItems().stream().map(schemaHistoryItem -> ResolvedSchemaHistoryItem.builder().version(schemaHistoryItem.getVersion() == null ? null : MigrationVersion.fromVersion((String)schemaHistoryItem.getVersion())).description(schemaHistoryItem.getDescription()).type(migrationTypeResolver.resolveMigrationTypeFromName(schemaHistoryItem.getType(), configuration)).script(schemaHistoryItem.getScript()).checksum(schemaHistoryItem.getChecksum()).installedBy(schemaHistoryItem.getInstalledBy()).installedOn(schemaHistoryItem.getInstalledOn()).executionTime(schemaHistoryItem.getExecutionTime()).success(schemaHistoryItem.isSuccess()).installedRank(schemaHistoryItem.getInstalledRank()).build()).toList();
    }

    private static void insertUndoneMigrations(Collection<ResolvedSchemaHistoryItem> resolvedSchemaHistoryItems, Collection<LoadableResourceMetadata> resolvedMigrations, List<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> migrations) {
        resolvedSchemaHistoryItems.stream().filter(item -> item.getType().isUndo() && item.isSuccess()).filter(item -> VerbUtils.shouldAddUndone(item, resolvedSchemaHistoryItems)).map(undoneSchemaHistoryItem -> VerbUtils.findOriginalMigration(undoneSchemaHistoryItem, resolvedMigrations)).filter(Optional::isPresent).forEach(originalMigration -> migrations.add(Pair.of(null, (Object)((LoadableResourceMetadata)originalMigration.get()))));
    }

    private static Optional<LoadableResourceMetadata> findOriginalMigration(ResolvedSchemaHistoryItem undoneSchemaHistoryItem, Collection<LoadableResourceMetadata> resolvedMigrations) {
        return resolvedMigrations.stream().filter(LoadableResourceMetadata::isVersioned).filter(migration -> !migration.migrationType().isUndo()).filter(migration -> migration.version().equals((Object)undoneSchemaHistoryItem.getVersion())).findFirst();
    }

    private static boolean shouldAddUndone(ResolvedSchemaHistoryItem undoneSchemaHistoryItem, Collection<ResolvedSchemaHistoryItem> resolvedSchemaHistoryItems) {
        return resolvedSchemaHistoryItems.stream().filter(ResolvedSchemaHistoryItem::isVersioned).filter(item -> item.getInstalledRank() > undoneSchemaHistoryItem.getInstalledRank()).noneMatch(item -> item.getVersion().equals((Object)undoneSchemaHistoryItem.getVersion()) && !item.getType().isUndo() && item.isSuccess());
    }

    private static LoadableResourceMetadata getTypedMigration(Configuration configuration, LoadableResourceMetadata sortedMigration) {
        MigrationType migrationType = VerbUtils.getMigrationType(sortedMigration.loadableResource(), configuration);
        if (migrationType == null) {
            return null;
        }
        return new LoadableResourceMetadata(sortedMigration.version(), sortedMigration.description(), sortedMigration.prefix(), sortedMigration.loadableResource(), sortedMigration.sqlScriptMetadata(), sortedMigration.checksum(), migrationType);
    }

    private static MigrationType getMigrationType(LoadableResource resource, Configuration configuration) {
        CompositeMigrationTypeResolver resolver = new CompositeMigrationTypeResolver();
        return resolver.resolveMigrationType(resource.getFilename(), configuration);
    }

    private static ResolvedEnvironment getResolvedEnvironment(Configuration configuration) {
        String envProvisionMode;
        ProvisionerMode provisionerMode;
        String envName = configuration.getCurrentEnvironmentName();
        ResolvedEnvironment resolved = configuration.getResolvedEnvironment(envName, provisionerMode = StringUtils.hasText((String)(envProvisionMode = configuration.getModernConfig().getFlyway().getProvisionMode())) ? ProvisionerMode.fromString((String)envProvisionMode) : ProvisionerMode.Provision, null);
        if (resolved == null) {
            throw new FlywayException("Environment '" + envName + "' not found. Check that this environment exists in your configuration.");
        }
        return resolved;
    }

    private static List<ExperimentalMigrationStateCalculator> getMigrationStateCalculators(Configuration configuration) {
        List stateCalculators = configuration.getPluginRegister().getLicensedPlugins(ExperimentalMigrationStateCalculator.class, configuration);
        stateCalculators.add(new CoreMigrationStateCalculator());
        return stateCalculators;
    }

    private static ExperimentalMigrationComparator getOrderComparator(Configuration configuration) {
        return configuration.getPluginRegister().getPlugins(ExperimentalMigrationComparator.class).stream().filter(comparatorPlugin -> comparatorPlugin.getName().equals("Info")).max(Comparator.comparingInt(experimentalMigrationComparator -> experimentalMigrationComparator.getPriority(configuration))).orElseThrow(() -> new FlywayException("No Info comparator found"));
    }

    private static List<LoadableResourceMetadata> getResolvedMigrations(LoadableResourceMetadata[] sortedMigrations, Configuration configuration) {
        return Arrays.stream(sortedMigrations).map(sortedMigration -> VerbUtils.getTypedMigration(configuration, sortedMigration)).filter(Objects::nonNull).toList();
    }

    private static void insertResolvedSchemaHistoryItems(List<ResolvedSchemaHistoryItem> resolvedSchemaHistoryItems, List<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> migrations) {
        for (ResolvedSchemaHistoryItem schemaHistoryItem : resolvedSchemaHistoryItems) {
            migrations.add((Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>)Pair.of((Object)schemaHistoryItem, null));
        }
    }

    private static void insertResolvedMigrations(Iterable<LoadableResourceMetadata> resolvedMigrations, List<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> migrations) {
        resolvedMigrations.forEach(resolvedMigration -> {
            List<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> matchedMigrations = VerbUtils.findMigrationsByResourceMetadata(migrations, resolvedMigration);
            if (!matchedMigrations.isEmpty()) {
                for (Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata> migration : matchedMigrations) {
                    migrations.add(Pair.of((Object)((ResolvedSchemaHistoryItem)migration.getLeft()), (Object)resolvedMigration));
                    migrations.remove(migration);
                }
            } else {
                migrations.add(Pair.of(null, (Object)resolvedMigration));
            }
        });
    }

    private static List<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> findMigrationsByResourceMetadata(List<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> migrations, LoadableResourceMetadata resourceMetadata) {
        ArrayList<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> result = new ArrayList<Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>>();
        for (Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata> migration : migrations) {
            ResolvedSchemaHistoryItem item = (ResolvedSchemaHistoryItem)migration.getLeft();
            if (item == null) continue;
            boolean bl = item.isRepeatable() ? item.getDescription().equals(resourceMetadata.description()) && item.getChecksum().equals(resourceMetadata.checksum()) : item.getVersion().equals((Object)resourceMetadata.version());
            boolean versionMatched = bl;
            if (!versionMatched || !VerbUtils.typesCompatible(resourceMetadata, item)) continue;
            result.add(migration);
        }
        return result;
    }

    private static boolean typesCompatible(LoadableResourceMetadata resourceMetadata, ResolvedSchemaHistoryItem item) {
        return item.getType().isBaseline() == resourceMetadata.migrationType().isBaseline() && item.getType() != CoreMigrationType.BASELINE && item.getType().isUndo() == resourceMetadata.migrationType().isUndo();
    }

    public static String[] getAllSchemas(String[] schemas, String defaultSchema) {
        ArrayList<String> schemaList = new ArrayList<String>(List.of(schemas));
        schemaList.add(defaultSchema);
        return schemaList.toArray(new String[0]);
    }

    public static String toMigrationText(MigrationInfo migration, boolean isExecuteInTransaction, ExperimentalDatabase database, boolean outOfOrder) {
        String migrationText = migration.getVersion() != null ? "schema " + database.doQuote(database.getCurrentSchema()) + " to version " + database.doQuote(String.valueOf(migration.getVersion()) + (String)(StringUtils.hasLength((String)migration.getDescription()) ? " - " + migration.getDescription() : "")) + (outOfOrder ? " [out of order]" : "") + (isExecuteInTransaction ? "" : " [non-transactional]") : "schema " + database.doQuote(database.getCurrentSchema()) + " with repeatable migration " + database.doQuote(migration.getDescription()) + (isExecuteInTransaction ? "" : " [non-transactional]");
        return migrationText;
    }

    public static List<MigrationInfo> removeIgnoredMigrations(Configuration configuration, MigrationInfo[] migrations) {
        return Arrays.stream(migrations).filter(x -> Arrays.stream(configuration.getIgnoreMigrationPatterns()).noneMatch(pattern -> pattern.matchesMigration(x.isVersioned(), x.getState()))).toList();
    }

    public static FlywayTelemetryManager getFlywayTelemetryManager(Configuration configuration) {
        return (FlywayTelemetryManager)configuration.getPluginRegister().getPluginInstanceOf(FlywayTelemetryManager.class);
    }
}

