/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.derby;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.derby.DerbyDatabase;
import org.flywaydb.database.derby.DerbyTable;

public class DerbySchema
extends Schema<DerbyDatabase, DerbyTable> {
    public DerbySchema(JdbcTemplate jdbcTemplate, DerbyDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM sys.sysschemas WHERE schemaname=?", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() {
        return ((DerbyTable[])this.allTables()).length == 0;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((DerbyDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.clean();
        this.jdbcTemplate.execute("DROP SCHEMA " + ((DerbyDatabase)this.database).quote(new String[]{this.name}) + " RESTRICT", new Object[0]);
    }

    protected void doClean() throws SQLException {
        List<String> triggerNames = this.listObjectNames("TRIGGER", "");
        for (String string : this.generateDropStatements("TRIGGER", triggerNames, "")) {
            this.jdbcTemplate.execute(string, new Object[0]);
        }
        for (String string : this.generateDropStatementsForConstraints()) {
            this.jdbcTemplate.execute(string, new Object[0]);
        }
        List<String> viewNames = this.listObjectNames("TABLE", "TABLETYPE='V'");
        for (String statement : this.generateDropStatements("VIEW", viewNames, "")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (DerbyTable table : (DerbyTable[])this.allTables()) {
            table.drop();
        }
        List<String> list = this.listObjectNames("SEQUENCE", "");
        for (String statement : this.generateDropStatements("SEQUENCE", list, "RESTRICT")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> generateDropStatementsForConstraints() throws SQLException {
        List results = this.jdbcTemplate.queryForList("SELECT c.constraintname, t.tablename FROM sys.sysconstraints c INNER JOIN sys.systables t ON c.tableid = t.tableid INNER JOIN sys.sysschemas s ON c.schemaid = s.schemaid WHERE c.type = 'F' AND s.schemaname = ?", new Object[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (Map result : results) {
            String dropStatement = "ALTER TABLE " + ((DerbyDatabase)this.database).quote(new String[]{this.name, (String)result.get("TABLENAME")}) + " DROP CONSTRAINT " + ((DerbyDatabase)this.database).quote(new String[]{(String)result.get("CONSTRAINTNAME")});
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> generateDropStatements(String objectType, List<String> objectNames, String dropStatementSuffix) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + " " + ((DerbyDatabase)this.database).quote(new String[]{this.name, objectName}) + " " + dropStatementSuffix;
            statements.add(dropStatement);
        }
        return statements;
    }

    protected DerbyTable[] doAllTables() throws SQLException {
        List<String> tableNames = this.listObjectNames("TABLE", "TABLETYPE='T'");
        DerbyTable[] tables = new DerbyTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new DerbyTable(this.jdbcTemplate, (DerbyDatabase)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    private List<String> listObjectNames(String objectType, String querySuffix) throws SQLException {
        String query = "SELECT " + objectType + "name FROM sys.sys" + objectType + "s WHERE schemaid in (SELECT schemaid FROM sys.sysschemas where schemaname = ?)";
        if (StringUtils.hasLength((String)querySuffix)) {
            query = query + " AND " + querySuffix;
        }
        return this.jdbcTemplate.queryForStringList(query, new String[]{this.name});
    }

    public Table getTable(String tableName) {
        return new DerbyTable(this.jdbcTemplate, (DerbyDatabase)this.database, this, tableName);
    }
}

