/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.collect.ImmutableList;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;

class MetricRegistryConstants {
    private static final LabelKey CLIENT_ID = LabelKey.create((String)"client_id", (String)"User defined database client id");
    private static final LabelKey DATABASE = LabelKey.create((String)"database", (String)"Target database");
    private static final LabelKey INSTANCE_ID = LabelKey.create((String)"instance_id", (String)"Name of the instance");
    private static final LabelKey LIBRARY_VERSION = LabelKey.create((String)"library_version", (String)"Library version");
    static final LabelKey IS_MULTIPLEXED_KEY = LabelKey.create((String)"is_multiplexed", (String)"Multiplexed Session");
    private static final LabelKey SESSION_TYPE = LabelKey.create((String)"Type", (String)"Type of the Sessions");
    private static final LabelValue UNSET_LABEL = LabelValue.create(null);
    static final LabelValue NUM_IN_USE_SESSIONS = LabelValue.create((String)"num_in_use_sessions");
    @Deprecated
    static final LabelValue NUM_SESSIONS_BEING_PREPARED = LabelValue.create((String)"num_sessions_being_prepared");
    static final LabelValue NUM_READ_SESSIONS = LabelValue.create((String)"num_read_sessions");
    @Deprecated
    static final LabelValue NUM_WRITE_SESSIONS = LabelValue.create((String)"num_write_prepared_sessions");
    static final ImmutableList<LabelKey> SPANNER_LABEL_KEYS = ImmutableList.of((Object)CLIENT_ID, (Object)DATABASE, (Object)INSTANCE_ID, (Object)LIBRARY_VERSION);
    static final ImmutableList<LabelKey> SPANNER_LABEL_KEYS_WITH_TYPE = ImmutableList.of((Object)CLIENT_ID, (Object)DATABASE, (Object)INSTANCE_ID, (Object)LIBRARY_VERSION, (Object)SESSION_TYPE);
    static final ImmutableList<LabelValue> SPANNER_DEFAULT_LABEL_VALUES = ImmutableList.of((Object)UNSET_LABEL, (Object)UNSET_LABEL, (Object)UNSET_LABEL, (Object)UNSET_LABEL);
    static final ImmutableList<LabelKey> SPANNER_LABEL_KEYS_WITH_MULTIPLEXED_SESSIONS = ImmutableList.of((Object)CLIENT_ID, (Object)DATABASE, (Object)INSTANCE_ID, (Object)LIBRARY_VERSION, (Object)IS_MULTIPLEXED_KEY);
    static final String COUNT = "1";
    static final String INSTRUMENTATION_SCOPE = "cloud.google.com/java";
    static final String METRIC_PREFIX = "cloud.google.com/java/";
    static final String MAX_IN_USE_SESSIONS = "spanner/max_in_use_sessions";
    static final String MAX_ALLOWED_SESSIONS = "spanner/max_allowed_sessions";
    static final String GET_SESSION_TIMEOUTS = "spanner/get_session_timeouts";
    static final String NUM_ACQUIRED_SESSIONS = "spanner/num_acquired_sessions";
    static final String NUM_RELEASED_SESSIONS = "spanner/num_released_sessions";
    static final String NUM_SESSIONS_IN_POOL = "spanner/num_sessions_in_pool";
    static final String NUM_SESSIONS_IN_USE = "spanner/num_in_use_sessions";
    static final String NUM_SESSIONS_AVAILABLE = "spanner/num_available_sessions";
    static final String SESSIONS_TYPE = "session_type";
    static final String IS_MULTIPLEXED = "is_multiplexed";
    static final String MAX_IN_USE_SESSIONS_DESCRIPTION = "The maximum number of sessions in use during the last 10 minute interval.";
    static final String MAX_ALLOWED_SESSIONS_DESCRIPTION = "The maximum number of sessions allowed. Configurable by the user.";
    static final String SESSIONS_TIMEOUTS_DESCRIPTION = "The number of get sessions timeouts due to pool exhaustion";
    static final String NUM_ACQUIRED_SESSIONS_DESCRIPTION = "The number of sessions acquired from the session pool.";
    static final String NUM_RELEASED_SESSIONS_DESCRIPTION = "The number of sessions released by the user and pool maintainer.";
    static final String NUM_SESSIONS_IN_POOL_DESCRIPTION = "The number of sessions in the pool.";
    static final String SPANNER_GFE_LATENCY = "spanner/gfe_latency";
    static final String SPANNER_GFE_LATENCY_DESCRIPTION = "Latency between Google's network receiving an RPC and reading back the first byte of the response";
    static final String SPANNER_GFE_HEADER_MISSING_COUNT = "spanner/gfe_header_missing_count";
    static final String SPANNER_GFE_HEADER_MISSING_COUNT_DESCRIPTION = "Number of RPC responses received without the server-timing header, most likely means that the RPC never reached Google's network";

    MetricRegistryConstants() {
    }
}

