/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.timeplus;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.timeplus.TimeplusConfigurationExtension;
import org.flywaydb.community.database.timeplus.TimeplusConnection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class TimeplusDatabase
extends Database<TimeplusConnection> {
    private TimeplusConnection systemConnection;

    public boolean useSingleConnection() {
        return true;
    }

    public TimeplusDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public String getClusterName() {
        return ((TimeplusConfigurationExtension)this.configuration.getPluginRegister().getPlugin(TimeplusConfigurationExtension.class)).getClusterName();
    }

    public String getZookeeperPath() {
        return ((TimeplusConfigurationExtension)this.configuration.getPluginRegister().getPlugin(TimeplusConfigurationExtension.class)).getZookeeperPath();
    }

    public TimeplusConnection getSystemConnection() {
        if (this.systemConnection == null) {
            Connection connection = this.jdbcConnectionFactory.openConnection();
            try {
                this.systemConnection = this.doGetConnection(connection);
                this.systemConnection.doChangeCurrentSchemaOrSearchPathTo("system");
            }
            catch (SQLException e) {
                throw new FlywaySqlException("Unable to switch connection to read-only", e);
            }
        }
        return this.systemConnection;
    }

    protected TimeplusConnection doGetConnection(Connection connection) {
        return new TimeplusConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public boolean catalogIsSchema() {
        return true;
    }

    public void close() {
        if (this.systemConnection != null) {
            this.systemConnection.close();
        }
        super.close();
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String clusterName = this.getClusterName();
        boolean isClustered = StringUtils.hasText((String)clusterName);
        String script = "CREATE STREAM IF NOT EXISTS " + String.valueOf(table) + (String)(isClustered ? " ON CLUSTER " + clusterName : "") + "(    installed_rank int32,    version nullable(string),    description string,    type string,    script string,    checksum nullable(int32),    installed_by string,    installed_on datetime DEFAULT now(),    execution_time int32,    success bool)";
        Object engine = isClustered ? "ReplicatedMergeTree('" + this.getZookeeperPath() + "', '{replica}')" : "MergeTree";
        script = script + " ENGINE = " + (String)engine + " PRIMARY KEY (script);";
        return script + (String)(baseline ? this.getBaselineStatement(table) + ";" : "");
    }

    public Pair<String, Object> getDeleteStatement(Table table, boolean version, String filter) {
        String deleteStatement = "ALTER STREAM " + String.valueOf(table) + " DELETE WHERE " + this.quote(new String[]{"success"}) + " = " + this.getBooleanFalse() + " AND " + (version ? this.quote(new String[]{"version"}) + " = ?" : this.quote(new String[]{"description"}) + " = ?");
        return Pair.of((Object)deleteStatement, (Object)filter);
    }

    public String getUpdateStatement(Table table) {
        return "ALTER STREAM " + String.valueOf(table) + " UPDATE " + this.quote(new String[]{"description"}) + "=? , " + this.quote(new String[]{"type"}) + "=? , " + this.quote(new String[]{"checksum"}) + "=? WHERE " + this.quote(new String[]{"installed_rank"}) + "=?";
    }
}

