/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserBase;
import org.hsqldb.ParserRoutine;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public class Routine
implements SchemaObject,
RangeGroup,
Cloneable {
    public static final int NO_SQL = 1;
    public static final int CONTAINS_SQL = 2;
    public static final int READS_SQL = 3;
    public static final int MODIFIES_SQL = 4;
    public static final int LANGUAGE_JAVA = 1;
    public static final int LANGUAGE_SQL = 2;
    public static final int PARAM_STYLE_JAVA = 1;
    public static final int PARAM_STYLE_SQL = 2;
    static final Routine[] emptyArray = new Routine[0];
    RoutineSchema routineSchema;
    private HsqlNameManager.HsqlName name;
    private HsqlNameManager.HsqlName specificName;
    Type[] parameterTypes;
    int typeGroups;
    Type returnType;
    Table returnTable;
    final int routineType;
    int language = 2;
    int dataImpact = 2;
    int parameterStyle;
    boolean isDeterministic;
    boolean isNullInputOutput;
    boolean isNewSavepointLevel = true;
    int maxDynamicResults = 0;
    boolean isRecursive;
    boolean returnsTable;
    Statement statement;
    boolean isAggregate;
    boolean isIndex;
    boolean isSearch;
    private String methodName;
    Method javaMethod;
    boolean javaMethodWithConnection;
    private boolean isLibraryRoutine;
    OrderedHashMap parameterList = new OrderedHashMap();
    RangeVariable[] ranges = RangeVariable.emptyArray;
    int variableCount;
    int cursorCount;
    OrderedHashSet references;
    Table triggerTable;
    int triggerType;
    int triggerOperation;

    public Routine(int n) {
        this.routineType = n;
        this.returnType = Type.SQL_ALL_TYPES;
        this.ranges = new RangeVariable[]{new RangeVariable(this.parameterList, null, false, 3)};
    }

    public Routine(Table table, RangeVariable[] rangeVariableArray, int n, int n2, int n3) {
        this.routineType = 8;
        this.returnType = Type.SQL_ALL_TYPES;
        this.dataImpact = n;
        this.ranges = rangeVariableArray;
        this.triggerTable = table;
        this.triggerType = n2;
        this.triggerOperation = n3;
    }

    @Override
    public int getType() {
        return this.routineType;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        if (this.routineType == 8) {
            return this.triggerTable.getSchemaName();
        }
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compile(Session session, SchemaObject schemaObject) {
        ParserRoutine parserRoutine = new ParserRoutine(session, new Scanner(session, this.statement.getSQL()));
        session.sessionContext.pushRoutineTables();
        try {
            parserRoutine.read();
            ParserBase.Recorder recorder = parserRoutine.startRecording();
            Statement statement = parserRoutine.compileSQLProcedureStatementOrNull(this, null);
            String string = recorder.getSQL();
            statement.setSQL(string);
            this.setProcedure(statement);
            this.resolve(session);
        }
        finally {
            session.sessionContext.popRoutineTables();
        }
    }

    @Override
    public String getSQL() {
        return this.getDefinitionSQL(true);
    }

    public String getSQLAlter() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ALTER").append(' ').append("SPECIFIC");
        stringBuilder.append(' ').append("ROUTINE").append(' ');
        stringBuilder.append(this.specificName.getSchemaQualifiedStatementName());
        stringBuilder.append(' ').append("BODY");
        stringBuilder.append(' ').append(this.statement.getSQL());
        return stringBuilder.toString();
    }

    public String getSQLDeclaration() {
        return this.getDefinitionSQL(false);
    }

    private String getDefinitionSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE").append(' ');
        if (this.isAggregate) {
            stringBuilder.append("AGGREGATE").append(' ');
        }
        if (this.routineType == 17) {
            stringBuilder.append("PROCEDURE");
        } else {
            stringBuilder.append("FUNCTION");
        }
        stringBuilder.append(' ');
        stringBuilder.append(this.name.getSchemaQualifiedStatementName());
        stringBuilder.append('(');
        for (int i = 0; i < this.parameterList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            ColumnSchema columnSchema = (ColumnSchema)this.parameterList.get(i);
            stringBuilder.append(columnSchema.getSQL());
        }
        stringBuilder.append(')');
        stringBuilder.append(' ');
        if (this.routineType == 16) {
            stringBuilder.append("RETURNS");
            stringBuilder.append(' ');
            if (this.returnsTable) {
                stringBuilder.append("TABLE");
                stringBuilder.append(this.returnTable.getColumnListWithTypeSQL());
            } else {
                stringBuilder.append(this.returnType.getTypeDefinition());
            }
            stringBuilder.append(' ');
        }
        if (this.specificName != null) {
            stringBuilder.append("SPECIFIC");
            stringBuilder.append(' ');
            stringBuilder.append(this.specificName.getStatementName());
            stringBuilder.append(' ');
        }
        stringBuilder.append("LANGUAGE");
        stringBuilder.append(' ');
        if (this.language == 1) {
            stringBuilder.append("JAVA");
        } else {
            stringBuilder.append("SQL");
        }
        stringBuilder.append(' ');
        if (!this.isDeterministic) {
            stringBuilder.append("NOT");
            stringBuilder.append(' ');
        }
        stringBuilder.append("DETERMINISTIC");
        stringBuilder.append(' ');
        stringBuilder.append(this.getDataImpactString());
        stringBuilder.append(' ');
        if (this.routineType == 16) {
            if (this.isNullInputOutput) {
                stringBuilder.append("RETURNS").append(' ').append("NULL");
            } else {
                stringBuilder.append("CALLED");
            }
            stringBuilder.append(' ').append("ON").append(' ');
            stringBuilder.append("NULL").append(' ').append("INPUT");
            stringBuilder.append(' ');
        } else {
            if (this.isNewSavepointLevel) {
                stringBuilder.append("NEW");
            } else {
                stringBuilder.append("OLD");
            }
            stringBuilder.append(' ').append("SAVEPOINT").append(' ');
            stringBuilder.append("LEVEL").append(' ');
            if (this.maxDynamicResults != 0) {
                stringBuilder.append(' ').append("DYNAMIC").append(' ');
                stringBuilder.append("RESULT").append(' ').append("SETS");
                stringBuilder.append(' ').append(this.maxDynamicResults).append(' ');
            }
        }
        if (this.language == 1) {
            stringBuilder.append("EXTERNAL").append(' ').append("NAME");
            stringBuilder.append(' ').append('\'').append(this.methodName).append('\'');
        } else if (bl) {
            stringBuilder.append(this.statement.getSQL());
        } else {
            stringBuilder.append("SIGNAL").append(' ');
            stringBuilder.append("SQLSTATE").append(' ');
            stringBuilder.append('\'').append("45000").append('\'');
        }
        return stringBuilder.toString();
    }

    public String getSQLBodyDefinition() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.language == 1) {
            stringBuilder.append("EXTERNAL").append(' ').append("NAME");
            stringBuilder.append(' ').append('\'').append(this.methodName).append('\'');
        } else {
            stringBuilder.append(this.statement.getSQL());
        }
        return stringBuilder.toString();
    }

    public String getExternalName() {
        if (this.language == 1) {
            return this.methodName;
        }
        return null;
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public void addParameter(ColumnSchema columnSchema) {
        HsqlNameManager.HsqlName hsqlName = columnSchema.getName();
        String string = hsqlName == null ? HsqlNameManager.getAutoNoNameColumnString(this.parameterList.size()) : hsqlName.name;
        boolean bl = this.parameterList.add(string, columnSchema);
        if (!bl) {
            throw Error.error(5614);
        }
    }

    public void setLanguage(int n) {
        this.language = n;
    }

    public int getLanguage() {
        return this.language;
    }

    boolean isPSM() {
        return this.language == 2;
    }

    public void setDataImpact(int n) {
        this.dataImpact = n;
    }

    public int getDataImpact() {
        return this.dataImpact;
    }

    public String getDataImpactString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.dataImpact) {
            case 1: {
                stringBuilder.append("NO").append(' ').append("SQL");
                break;
            }
            case 2: {
                stringBuilder.append("CONTAINS").append(' ').append("SQL");
                break;
            }
            case 3: {
                stringBuilder.append("READS").append(' ').append("SQL").append(' ').append("DATA");
                break;
            }
            case 4: {
                stringBuilder.append("MODIFIES").append(' ').append("SQL").append(' ').append("DATA");
            }
        }
        return stringBuilder.toString();
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Table getTable() {
        return this.returnTable;
    }

    public void setProcedure(Statement statement) {
        this.statement = statement;
    }

    public Statement getProcedure() {
        return this.statement;
    }

    public void setSpecificName(HsqlNameManager.HsqlName hsqlName) {
        this.specificName = hsqlName;
    }

    public int getMaxDynamicResults() {
        return this.maxDynamicResults;
    }

    public void setName(HsqlNameManager.HsqlName hsqlName) {
        this.name = hsqlName;
    }

    public HsqlNameManager.HsqlName getSpecificName() {
        return this.specificName;
    }

    public void setDeterministic(boolean bl) {
        this.isDeterministic = bl;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public void setNullInputOutput(boolean bl) {
        this.isNullInputOutput = bl;
    }

    public boolean isNullInputOutput() {
        return this.isNullInputOutput;
    }

    public void setNewSavepointLevel(boolean bl) {
        this.isNewSavepointLevel = bl;
    }

    public void setMaxDynamicResults(int n) {
        this.maxDynamicResults = n;
    }

    public void setParameterStyle(int n) {
        this.parameterStyle = n;
    }

    public void setMethodURL(String string) {
        this.methodName = string;
    }

    public Method getMethod() {
        return this.javaMethod;
    }

    public void setMethod(Method method) {
        this.javaMethod = method;
    }

    public void setReturnTable(TableDerived tableDerived) {
        this.returnTable = tableDerived;
        this.returnsTable = true;
        HsqlNameManager.SimpleName[] simpleNameArray = new HsqlNameManager.SimpleName[tableDerived.getColumnCount()];
        Type[] typeArray = tableDerived.getColumnTypes();
        this.returnType = new RowType(typeArray);
    }

    public boolean returnsTable() {
        return this.returnsTable;
    }

    public void setAggregate(boolean bl) {
        this.isAggregate = bl;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public void resolve(Session session) {
        ColumnSchema columnSchema;
        int n;
        this.setLanguage(this.language);
        if (this.language == 2) {
            if (this.dataImpact == 1) {
                throw Error.error(5604, "CONTAINS SQL");
            }
            if (this.parameterStyle == 1) {
                throw Error.error(5604, "PARAMETER STYLE");
            }
        }
        if (this.language == 2 && this.parameterStyle != 0 && this.parameterStyle != 2) {
            throw Error.error(5604, "PARAMETER STYLE");
        }
        this.parameterTypes = new Type[this.parameterList.size()];
        this.typeGroups = 0;
        for (n = 0; n < this.parameterTypes.length; ++n) {
            columnSchema = (ColumnSchema)this.parameterList.get(n);
            this.parameterTypes[n] = columnSchema.dataType;
            if (n >= 4) continue;
            this.typeGroups = BitMap.setByte(this.typeGroups, (byte)columnSchema.dataType.typeComparisonGroup, n * 8);
        }
        if (this.isAggregate) {
            if (this.parameterTypes.length != 4) {
                throw Error.error(5610);
            }
            n = this.parameterTypes[1].typeCode == 16 ? 1 : 0;
            columnSchema = (ColumnSchema)this.parameterList.get(0);
            n &= columnSchema.getParameterMode() == 1 ? 1 : 0;
            columnSchema = (ColumnSchema)this.parameterList.get(1);
            n &= columnSchema.getParameterMode() == 1 ? 1 : 0;
            columnSchema = (ColumnSchema)this.parameterList.get(2);
            n &= columnSchema.getParameterMode() == 2 ? 1 : 0;
            columnSchema = (ColumnSchema)this.parameterList.get(3);
            if ((n &= columnSchema.getParameterMode() == 2 ? 1 : 0) == 0) {
                throw Error.error(5610);
            }
        }
        this.resolveReferences(session);
    }

    void resolveReferences(Session session) {
        if (this.statement != null) {
            this.statement.resolve(session);
            this.checkSQLData(session);
        }
        if (this.methodName != null && this.javaMethod == null) {
            boolean[] blArray = new boolean[1];
            this.javaMethod = Routine.getMethod(this.methodName, this, blArray, this.returnsTable);
            if (this.javaMethod == null) {
                throw Error.error(6013);
            }
            this.javaMethodWithConnection = blArray[0];
            String string = this.javaMethod.getDeclaringClass().getName();
            if (string.equals("java.lang.Math")) {
                this.isLibraryRoutine = true;
            }
        }
        this.setReferences();
    }

    private void setReferences() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            ColumnSchema columnSchema = (ColumnSchema)this.parameterList.get(i);
            OrderedHashSet orderedHashSet2 = columnSchema.getReferences();
            if (orderedHashSet2 == null) continue;
            orderedHashSet.addAll(orderedHashSet2);
        }
        if (this.statement != null) {
            orderedHashSet.addAll(this.statement.getReferences());
        }
        this.isRecursive = false;
        if (orderedHashSet.contains(this.getSpecificName())) {
            orderedHashSet.remove(this.getSpecificName());
            this.isRecursive = true;
        }
        this.references = orderedHashSet;
    }

    void checkSQLData(Session session) {
        OrderedHashSet orderedHashSet = this.statement.getReferences();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            if (hsqlName.type != 24) continue;
            Routine routine = (Routine)session.database.schemaManager.getSchemaObject(hsqlName);
            if (routine.dataImpact == 3) {
                if (this.dataImpact != 2) continue;
                throw Error.error(5608, "READS SQL DATA");
            }
            if (routine.dataImpact != 4 || this.dataImpact != 2 && this.dataImpact != 3) continue;
            throw Error.error(5608, "MODIFIES SQL DATA");
        }
        if (this.dataImpact == 2 || this.dataImpact == 3) {
            HsqlNameManager.HsqlName[] hsqlNameArray = this.statement.getTableNamesForWrite();
            for (int i = 0; i < hsqlNameArray.length; ++i) {
                if (hsqlNameArray[i].schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
                throw Error.error(5608, "MODIFIES SQL DATA");
            }
        }
        if (this.dataImpact == 2) {
            HsqlNameManager.HsqlName[] hsqlNameArray = this.statement.getTableNamesForRead();
            for (int i = 0; i < hsqlNameArray.length; ++i) {
                if (hsqlNameArray[i].schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
                throw Error.error(5608, "READS SQL DATA");
            }
        }
    }

    public boolean isTrigger() {
        return this.routineType == 8;
    }

    public boolean isProcedure() {
        return this.routineType == 17;
    }

    public boolean isFunction() {
        return this.routineType == 16;
    }

    public ColumnSchema getParameter(int n) {
        return (ColumnSchema)this.parameterList.get(n);
    }

    Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    int getParameterSignature() {
        return this.typeGroups;
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public int getParameterCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            ColumnSchema columnSchema = (ColumnSchema)this.parameterList.get(i);
            if (columnSchema.getParameterMode() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getParameterIndex(String string) {
        return this.parameterList.getIndex(string);
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.ranges;
    }

    @Override
    public void setCorrelated() {
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public int getCursorCount() {
        return this.cursorCount;
    }

    public boolean isLibraryRoutine() {
        return this.isLibraryRoutine;
    }

    public HsqlNameManager.HsqlName[] getTableNamesForRead() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForRead();
    }

    public HsqlNameManager.HsqlName[] getTableNamesForWrite() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForWrite();
    }

    public void resetAlteredRoutineSettings() {
        if (this.isPSM()) {
            this.methodName = null;
            this.javaMethod = null;
            this.javaMethodWithConnection = false;
            this.parameterStyle = 2;
            if (this.dataImpact == 1) {
                this.dataImpact = 2;
            }
        } else {
            this.statement = null;
            this.references = null;
            this.variableCount = 0;
            this.cursorCount = 0;
            this.ranges = RangeVariable.emptyArray;
        }
    }

    public void setAsAlteredRoutine(Routine routine) {
        this.language = routine.language;
        this.dataImpact = routine.dataImpact;
        this.parameterStyle = routine.parameterStyle;
        this.isDeterministic = routine.isDeterministic;
        this.isNullInputOutput = routine.isNullInputOutput;
        this.maxDynamicResults = routine.maxDynamicResults;
        this.isRecursive = routine.isRecursive;
        this.javaMethod = routine.javaMethod;
        this.isRecursive = routine.isRecursive;
        this.javaMethodWithConnection = routine.javaMethodWithConnection;
        this.methodName = routine.methodName;
        this.statement = routine.statement;
        this.references = routine.references;
        this.variableCount = routine.variableCount;
        this.cursorCount = routine.cursorCount;
        this.ranges = routine.ranges;
    }

    Object[] convertArgsToJava(Session session, Object[] objectArray) {
        int n;
        int n2 = this.javaMethodWithConnection ? 1 : 0;
        Object[] objectArray2 = new Object[this.javaMethod.getParameterTypes().length];
        Type[] typeArray = this.getParameterTypes();
        for (n = 0; n < typeArray.length; ++n) {
            Object object = objectArray[n];
            ColumnSchema columnSchema = this.getParameter(n);
            if (columnSchema.parameterMode == 1) {
                objectArray2[n + n2] = typeArray[n].convertSQLToJava(session, object);
                continue;
            }
            Object object2 = typeArray[n].convertSQLToJava(session, object);
            Class clazz = typeArray[n].getJDBCClass();
            Object object3 = Array.newInstance(clazz, 1);
            Array.set(object3, 0, object2);
            objectArray2[n + n2] = object3;
        }
        while (n + n2 < objectArray2.length) {
            objectArray2[n + n2] = new ResultSet[1];
            ++n;
        }
        return objectArray2;
    }

    void convertArgsToSQL(Session session, Object[] objectArray, Object[] objectArray2) {
        Object object;
        Object object2;
        int n;
        int n2 = this.javaMethodWithConnection ? 1 : 0;
        Type[] typeArray = this.getParameterTypes();
        for (n = 0; n < typeArray.length; ++n) {
            object2 = objectArray2[n + n2];
            object = this.getParameter(n);
            if (((ColumnSchema)object).parameterMode != 1) {
                object2 = Array.get(object2, 0);
            }
            objectArray[n] = typeArray[n].convertJavaToSQL(session, object2);
        }
        object2 = null;
        while (n + n2 < objectArray2.length) {
            object = ((ResultSet[])objectArray2[n + n2])[0];
            if (object != null) {
                if (object instanceof JDBCResultSet) {
                    Result result = ((JDBCResultSet)object).result;
                    if (object2 == null) {
                        objectArray[n] = result;
                        object2 = result;
                    } else {
                        ((Result)object2).addChainedResult(result);
                    }
                } else {
                    throw Error.error(6000, "ResultSet not native");
                }
            }
            ++n;
        }
    }

    public Result invokeJavaMethodDirect(Object[] objectArray) {
        Result result;
        try {
            Object object = this.javaMethod.invoke(null, objectArray);
            object = this.returnType.convertJavaToSQL(null, object);
            result = Result.newPSMResult(object);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(Error.error(throwable, 6000, this.getName().name));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Result invokeJavaMethod(Session session, Object[] objectArray) {
        Result result;
        HsqlNameManager.HsqlName hsqlName = session.getCurrentSchemaHsqlName();
        try {
            if (this.dataImpact == 1) {
                session.sessionContext.isReadOnly = Boolean.TRUE;
                session.setNoSQL();
            } else if (this.dataImpact == 2) {
                session.sessionContext.isReadOnly = Boolean.TRUE;
            } else if (this.dataImpact == 3) {
                session.sessionContext.isReadOnly = Boolean.TRUE;
            }
            session.setCurrentSchemaHsqlName(this.getSchemaName());
            Object object = this.javaMethod.invoke(null, objectArray);
            if (this.returnsTable()) {
                if (!(object instanceof JDBCResultSet)) throw Error.runtimeError(201, "FunctionSQLInvoked");
                result = ((JDBCResultSet)object).result;
            } else {
                object = this.returnType.convertJavaToSQL(session, object);
                result = Result.newPSMResult(object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            result = Result.newErrorResult(Error.error(invocationTargetException, 6000, this.getName().name));
        }
        catch (IllegalAccessException illegalAccessException) {
            result = Result.newErrorResult(Error.error(illegalAccessException, 6000, this.getName().name));
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(Error.error(throwable, 6000, this.getName().name));
        }
        session.setCurrentSchemaHsqlName(hsqlName);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Result invoke(Session var1_1, Object[] var2_2, Object[] var3_3, boolean var4_4) {
        if (var4_4) {
            var1_1.sessionContext.pushRoutineInvocation();
        }
        if (this.isPSM()) {
            try {
                var1_1.sessionContext.routineArguments = var2_2;
                var1_1.sessionContext.routineVariables = ValuePool.emptyObjectArray;
                if (this.variableCount > 0) {
                    var1_1.sessionContext.routineVariables = new Object[this.variableCount];
                }
                var1_1.sessionContext.routineCursors = Result.emptyArray;
                if (this.cursorCount > 0) {
                    var1_1.sessionContext.routineCursors = new Result[this.cursorCount];
                }
                var5_5 = this.statement.execute(var1_1);
                if (var3_3 == null) ** GOTO lbl30
                for (var6_6 = 0; var6_6 < var3_3.length; ++var6_6) {
                    var3_3[var6_6] = var2_2[var6_6 + 1];
                }
            }
            catch (Throwable var6_7) {
                var5_5 = Result.newErrorResult(var6_7);
            }
        } else {
            if (this.isAggregate) {
                var2_2 = this.convertArgsToJava(var1_1, var2_2);
            }
            var5_5 = this.invokeJavaMethod(var1_1, var2_2);
            if (this.isAggregate) {
                var6_8 = new Object[var2_2.length];
                this.convertArgsToSQL(var1_1, var6_8, var2_2);
                for (var7_9 = 0; var7_9 < var3_3.length; ++var7_9) {
                    var3_3[var7_9] = var6_8[var7_9 + 1];
                }
            }
        }
lbl30:
        // 6 sources

        if (var4_4) {
            var1_1.sessionContext.popRoutineInvocation();
        }
        return var5_5;
    }

    public Routine duplicate() {
        try {
            return (Routine)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Type");
        }
    }

    static Method getMethod(String string, Routine routine, boolean[] blArray, boolean bl) {
        int n = string.indexOf(58);
        if (n != -1) {
            if (!string.substring(0, n).equals("CLASSPATH")) {
                throw Error.error(6012, string);
            }
            string = string.substring(n + 1);
        }
        Method[] methodArray = Routine.getMethods(string);
        int n2 = -1;
        for (n = 0; n < methodArray.length; ++n) {
            int n3;
            int n4;
            int n5 = 0;
            blArray[0] = false;
            Method method = methodArray[n];
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length > 0 && classArray[0].equals(Connection.class)) {
                n5 = 1;
                blArray[0] = true;
            }
            int n6 = classArray.length - n5;
            if (routine.isProcedure()) {
                for (n4 = n5; n4 < classArray.length; ++n4) {
                    if (!classArray[n4].isArray() || !ResultSet.class.isAssignableFrom(classArray[n4].getComponentType())) continue;
                    n6 = n4 - n5;
                    break;
                }
            }
            if (n6 != routine.parameterTypes.length) continue;
            if (bl) {
                if (!ResultSet.class.isAssignableFrom(method.getReturnType())) {
                    continue;
                }
            } else {
                Type type = Types.getParameterSQLType(method.getReturnType());
                if (type == null || !routine.returnType.canBeAssignedFrom(type)) continue;
                if (type.isLobType() || !type.isBinaryType() && !type.isCharacterType()) {
                    n3 = routine.returnType.typeCode;
                    if (n3 == 2) {
                        n3 = 3;
                    }
                    if (type.typeCode != n3) continue;
                }
            }
            for (n4 = 0; n4 < routine.parameterTypes.length; ++n4) {
                boolean bl2;
                Type type;
                n3 = 0;
                Class<?> clazz = classArray[n4 + n5];
                if (clazz.isArray() && !byte[].class.equals(clazz)) {
                    if ((clazz = clazz.getComponentType()).isPrimitive()) {
                        method = null;
                        break;
                    }
                    n3 = 1;
                }
                if ((type = Types.getParameterSQLType(clazz)) == null) {
                    method = null;
                    break;
                }
                boolean bl3 = bl2 = routine.parameterTypes[n4].typeComparisonGroup == type.typeComparisonGroup;
                if (bl2 && routine.parameterTypes[n4].isNumberType()) {
                    int n7 = routine.parameterTypes[n4].typeCode;
                    if (n7 == 2) {
                        n7 = 3;
                    }
                    boolean bl4 = bl2 = n7 == type.typeCode;
                }
                if (n3 != 0 && routine.getParameter((int)n4).parameterMode == 1) {
                    bl2 = false;
                }
                if (bl2) continue;
                method = null;
                if (n4 + n5 <= n2) break;
                n2 = n4 + n5;
                break;
            }
            if (method == null) continue;
            for (n4 = 0; n4 < routine.parameterTypes.length; ++n4) {
                routine.getParameter(n4).setNullable(!classArray[n4 + n5].isPrimitive());
            }
            return method;
        }
        if (n2 >= 0) {
            ColumnSchema columnSchema = routine.getParameter(n2);
            throw Error.error(6021, columnSchema.getNameString());
        }
        return null;
    }

    static Method[] getMethods(String string) {
        Class<?> clazz;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw Error.error(5501, string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Method[] methodArray = null;
        if (!HsqlDatabaseProperties.supportsJavaMethod(string)) {
            throw Error.error(5501, string2);
        }
        try {
            clazz = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            try {
                clazz = Class.forName(string2);
            }
            catch (Throwable throwable2) {
                throw Error.error(throwable2, 5501, 26, new String[]{throwable2.toString(), string2});
            }
        }
        try {
            methodArray = clazz.getMethods();
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 5501, 26, new String[]{throwable.toString(), string2});
        }
        HsqlArrayList<Method> hsqlArrayList = new HsqlArrayList<Method>();
        for (n = 0; n < methodArray.length; ++n) {
            int n2 = 0;
            int n3 = Integer.MAX_VALUE;
            Method method = methodArray[n];
            int n4 = method.getModifiers();
            if (!method.getName().equals(string3) || !Modifier.isStatic(n4) || !Modifier.isPublic(n4)) continue;
            Class<?>[] classArray = methodArray[n].getParameterTypes();
            if (classArray.length > 0 && classArray[0].equals(Connection.class)) {
                n2 = 1;
            }
            for (int i = n2; i < classArray.length; ++i) {
                Type type;
                Class<?> clazz2 = classArray[i];
                if (clazz2.isArray()) {
                    if (!byte[].class.equals(clazz2)) {
                        if ((clazz2 = clazz2.getComponentType()).isPrimitive()) {
                            method = null;
                            break;
                        }
                        if (ResultSet.class.isAssignableFrom(clazz2) && n3 > i) {
                            n3 = i;
                        }
                    }
                    if (i >= n3) {
                        if (ResultSet.class.isAssignableFrom(clazz2)) continue;
                        method = null;
                        break;
                    }
                } else if (i > n3) {
                    method = null;
                    break;
                }
                if ((type = Types.getParameterSQLType(clazz2)) != null) continue;
                method = null;
                break;
            }
            if (method == null) continue;
            if (ResultSet.class.isAssignableFrom(method.getReturnType())) {
                hsqlArrayList.add(methodArray[n]);
                continue;
            }
            Type type = Types.getParameterSQLType(method.getReturnType());
            if (type == null) continue;
            hsqlArrayList.add(methodArray[n]);
        }
        methodArray = new Method[hsqlArrayList.size()];
        hsqlArrayList.toArray(methodArray);
        return methodArray;
    }

    public static Routine[] newRoutines(Session session, Method[] methodArray) {
        Routine[] routineArray = new Routine[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            routineArray[i] = Routine.newRoutine(session, method);
        }
        return routineArray;
    }

    public static Routine newRoutine(Session session, Method method) {
        Routine routine = new Routine(16);
        int n = 0;
        Class<?>[] classArray = method.getParameterTypes();
        String string = method.getDeclaringClass().getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CLASSPATH:");
        stringBuilder.append(method.getDeclaringClass().getName()).append('.');
        stringBuilder.append(method.getName());
        if (classArray.length > 0 && classArray[0].equals(Connection.class)) {
            n = 1;
        }
        String string2 = stringBuilder.toString();
        if (string.equals("java.lang.Math")) {
            routine.isLibraryRoutine = true;
        }
        for (int i = n; i < classArray.length; ++i) {
            Type type = Types.getParameterSQLType(classArray[i]);
            HsqlNameManager.HsqlName hsqlName = session.database.nameManager.newHsqlName("C" + (i - n + 1), false, 23);
            ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, !classArray[i].isPrimitive(), false, null);
            routine.addParameter(columnSchema);
        }
        routine.setLanguage(1);
        routine.setMethod(method);
        routine.setMethodURL(string2);
        routine.setDataImpact(1);
        Type type = Types.getParameterSQLType(method.getReturnType());
        routine.javaMethodWithConnection = n == 1;
        routine.setReturnType(type);
        routine.resolve(session);
        return routine;
    }

    public static void createRoutines(Session session, HsqlNameManager.HsqlName hsqlName, String string) {
        Method[] methodArray = Routine.getMethods(string);
        Routine[] routineArray = Routine.newRoutines(session, methodArray);
        HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newHsqlName(hsqlName, string, true, 16);
        for (int i = 0; i < routineArray.length; ++i) {
            if (routineArray[i].getReturnType() == Type.SQL_ALL_TYPES) continue;
            routineArray[i].setName(hsqlName2);
            session.database.schemaManager.addSchemaObject(routineArray[i]);
        }
    }
}

