/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.types;

import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class JdbcInetAddress
extends AbstractJdbcType<InetAddress> {
    public static final JdbcInetAddress INSTANCE = new JdbcInetAddress();
    private static final int DEFAULT_INET_PRECISION = 39;

    JdbcInetAddress() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(InetAddress obj) {
        return 0;
    }

    @Override
    public int getPrecision(InetAddress obj) {
        if (obj != null) {
            return obj.toString().length();
        }
        return 39;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(InetAddress obj) {
        if (obj != null) {
            return obj.getHostAddress();
        }
        return null;
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    public String getString(ByteBuffer bytes) {
        return this.compose(bytes).getHostAddress();
    }

    @Override
    public Class<InetAddress> getType() {
        return InetAddress.class;
    }

    @Override
    public int getJdbcType() {
        return 1111;
    }

    @Override
    public InetAddress compose(Object value) {
        try {
            return InetAddress.getByName((String)value);
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Object decompose(InetAddress value) {
        return value.getAddress();
    }
}

