/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbConnectionProperties;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.gds.ng.FbServiceProperties;
import org.firebirdsql.gds.ng.IServiceProperties;
import org.firebirdsql.gds.ng.WireCrypt;
import org.firebirdsql.management.ServiceManager;

public class FBServiceManager
implements ServiceManager {
    private final IServiceProperties serviceProperties = new FbServiceProperties();
    private FbDatabaseFactory dbFactory;
    private String database;
    private OutputStream logger;
    public static final int BUFFER_SIZE = 1024;

    public FBServiceManager() {
        this(GDSFactory.getDefaultGDSType());
    }

    public FBServiceManager(String gdsType) {
        this(GDSType.getType(gdsType));
    }

    public FBServiceManager(GDSType gdsType) {
        this.dbFactory = GDSFactory.getDatabaseFactoryForType(gdsType);
    }

    @Override
    public void setCharSet(String charSet) {
        this.serviceProperties.setCharSet(charSet);
    }

    @Override
    public String getCharSet() {
        return this.serviceProperties.getCharSet();
    }

    @Override
    public void setUser(String user) {
        this.serviceProperties.setUser(user);
    }

    @Override
    public String getUser() {
        return this.serviceProperties.getUser();
    }

    @Override
    public void setPassword(String password) {
        this.serviceProperties.setPassword(password);
    }

    @Override
    public String getPassword() {
        return this.serviceProperties.getPassword();
    }

    @Override
    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getHost() {
        return this.serviceProperties.getServerName();
    }

    @Override
    public void setHost(String host) {
        this.serviceProperties.setServerName(host);
    }

    @Override
    public int getPort() {
        return this.serviceProperties.getPortNumber();
    }

    @Override
    public void setPort(int port) {
        this.serviceProperties.setPortNumber(port);
    }

    @Override
    public WireCrypt getWireCrypt() {
        return this.serviceProperties.getWireCrypt();
    }

    @Override
    public void setWireCrypt(WireCrypt wireCrypt) {
        this.serviceProperties.setWireCrypt(wireCrypt);
    }

    @Override
    public String getDbCryptConfig() {
        return this.serviceProperties.getDbCryptConfig();
    }

    @Override
    public void setDbCryptConfig(String dbCryptConfig) {
        this.serviceProperties.setDbCryptConfig(dbCryptConfig);
    }

    @Override
    public synchronized OutputStream getLogger() {
        return this.logger;
    }

    @Override
    public synchronized void setLogger(OutputStream logger) {
        this.logger = logger;
    }

    public String getServiceName() {
        StringBuilder sb = new StringBuilder();
        if (this.getHost() != null) {
            sb.append(this.getHost());
            if (this.getPort() != 3050) {
                sb.append('/');
                sb.append(this.getPort());
            }
            sb.append(':');
        }
        sb.append("service_mgr");
        return sb.toString();
    }

    public FbService attachServiceManager() throws SQLException {
        FbService fbService = this.dbFactory.serviceConnect(this.serviceProperties);
        fbService.attach();
        return fbService;
    }

    protected FbDatabase attachDatabase() throws SQLException {
        if (this.database == null) {
            throw new SQLException("Property database needs to be set.");
        }
        FbConnectionProperties connectionProperties = new FbConnectionProperties();
        connectionProperties.setServerName(this.serviceProperties.getServerName());
        connectionProperties.setPortNumber(this.serviceProperties.getPortNumber());
        connectionProperties.setUser(this.serviceProperties.getUser());
        connectionProperties.setPassword(this.serviceProperties.getPassword());
        connectionProperties.setDatabaseName(this.database);
        FbDatabase fbDatabase = this.dbFactory.connect(connectionProperties);
        fbDatabase.attach();
        return fbDatabase;
    }

    public void queueService(FbService service) throws SQLException, IOException {
        OutputStream currentLogger = this.getLogger();
        ServiceRequestBuffer infoSRB = service.createServiceRequestBuffer();
        infoSRB.addArgument(63);
        int bufferSize = 1024;
        boolean processing = true;
        while (processing) {
            byte[] buffer = service.getServiceInfo(null, infoSRB, bufferSize);
            switch (buffer[0]) {
                case 63: {
                    int dataLength = VaxEncoding.iscVaxInteger2(buffer, 1);
                    if (dataLength == 0) {
                        if (buffer[3] != 1) {
                            throw new SQLException("Unexpected end of stream reached.");
                        }
                        processing = false;
                        break;
                    }
                    if (currentLogger == null) break;
                    currentLogger.write(buffer, 3, dataLength);
                    break;
                }
                case 2: {
                    bufferSize *= 2;
                    break;
                }
                case 1: {
                    processing = false;
                }
            }
        }
    }

    @Deprecated
    protected void executeServicesOperation(ServiceRequestBuffer srb) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            service.startServiceAction(srb);
            this.queueService(service);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    protected final void executeServicesOperation(FbService service, ServiceRequestBuffer srb) throws SQLException {
        try {
            service.startServiceAction(srb);
            this.queueService(service);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    protected ServiceRequestBuffer createRequestBuffer(FbService service, int operation, int options) {
        ServiceRequestBuffer srb = service.createServiceRequestBuffer();
        srb.addArgument(operation);
        if (this.getDatabase() != null) {
            srb.addArgument(106, this.getDatabase());
        }
        srb.addArgument(108, options);
        return srb;
    }

    @Override
    public GDSServerVersion getServerVersion() throws SQLException {
        try (FbService service = this.attachServiceManager();){
            GDSServerVersion gDSServerVersion = service.getServerVersion();
            return gDSServerVersion;
        }
    }
}

