/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.materializer;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.AvgAggregatorFactory;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.CountAggregatorFactory;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.IAggregatorFactory;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.MinMaxAggregatorFactory;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.SumAggregatorFactory;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Iterator;

public class ETAggregateFnFactory {
    private ETAggregateFnFactory() {
    }

    public static IAggregatorFactory makeNewAggregatorFactory(AEAggrFn aEAggrFn, int n) throws ErrorException {
        int n2 = aEAggrFn.getNumChildren();
        Iterator<AEValueExpr> iterator = aEAggrFn.getChildItr();
        IColumn[] iColumnArray = new IColumn[n2];
        for (int i = 0; i < n2; ++i) {
            iColumnArray[i] = iterator.next().getColumn();
        }
        switch (aEAggrFn.getAggrFnId()) {
            case AVG: {
                return new AvgAggregatorFactory(iColumnArray, aEAggrFn.getColumn());
            }
            case COUNT: 
            case COUNT_STAR: {
                return new CountAggregatorFactory(iColumnArray, aEAggrFn.getColumn());
            }
            case SUM: {
                return new SumAggregatorFactory(iColumnArray, aEAggrFn.getColumn());
            }
            case MIN: 
            case MAX: {
                assert (iColumnArray.length == 1);
                if (ColumnSizeCalculator.isLongData(iColumnArray[0], n)) {
                    throw SQLEngineExceptionFactory.aggregateOnLongData();
                }
                return new MinMaxAggregatorFactory(iColumnArray, aEAggrFn.getColumn(), aEAggrFn.getAggrFnId() == AEAggrFn.AggrFnId.MAX, n);
            }
        }
        throw SQLEngineExceptionFactory.featureNotImplementedException("" + (Object)((Object)aEAggrFn.getAggrFnId()));
    }
}

