/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aetree.value;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.ColumnMetadata;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.dataengine.utilities.TypeUtilities;
import com.databricks.client.dsi.exceptions.NumericOverflowException;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAEUnaryNode;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.MetadataColumnInfo;
import com.databricks.client.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.databricks.client.sqlengine.dsiext.dataengine.IColumnInfo;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public class AEGeneralAggrFn
extends AEAggrFn
implements IAEUnaryNode<AEValueExpr> {
    private static final MetadataColumnInfo INT_COLUMN = new MetadataColumnInfo(new ColumnMetadata(new TypeMetadata(-5, "SQL_BIGINT", 19, 0, 0, false)), IColumnInfo.ColumnType.COLUMN);
    private AEAggrFn.AggrFnQuantifier m_setQuantifier;
    private AEValueExpr m_operand;
    private IColumn m_metadata;
    private final ICoercionHandler m_coercionHandler;

    public AEGeneralAggrFn(AEAggrFn.AggrFnId aggrFnId, AEAggrFn.AggrFnQuantifier aggrFnQuantifier, AEValueExpr aEValueExpr, ICoercionHandler iCoercionHandler) throws ErrorException {
        super(aggrFnId);
        this.m_setQuantifier = aggrFnQuantifier;
        this.m_operand = aEValueExpr;
        this.validate();
        this.m_coercionHandler = iCoercionHandler;
        this.initializeMetadata();
        this.m_operand.setParent(this);
    }

    public AEGeneralAggrFn(AEGeneralAggrFn aEGeneralAggrFn) {
        super(aEGeneralAggrFn.getAggrFnId());
        this.m_setQuantifier = aEGeneralAggrFn.m_setQuantifier;
        this.m_operand = aEGeneralAggrFn.m_operand.copy();
        this.m_metadata = AEGeneralAggrFn.createColumnMetadata(aEGeneralAggrFn.m_metadata);
        this.m_coercionHandler = aEGeneralAggrFn.m_coercionHandler;
        this.m_operand.setParent(this);
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public Iterator<AEValueExpr> getChildItr() {
        return this.asList().iterator();
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEGeneralAggrFn)) {
            return false;
        }
        AEGeneralAggrFn aEGeneralAggrFn = (AEGeneralAggrFn)iAENode;
        return this.getAggrFnId() == aEGeneralAggrFn.getAggrFnId() && this.m_operand.isEquivalent(aEGeneralAggrFn.m_operand) && this.m_setQuantifier == aEGeneralAggrFn.m_setQuantifier;
    }

    @Override
    public IColumn getColumn() {
        return this.m_metadata;
    }

    @Override
    public AEValueExpr copy() {
        return new AEGeneralAggrFn(this);
    }

    @Override
    public String getLogString() {
        return "AEGeneralAggrFn: " + this.getAggrFnId().name() + " " + this.m_setQuantifier.name();
    }

    @Override
    public AEValueExpr getOperand() {
        return this.m_operand;
    }

    public void setOperand(AEValueExpr aEValueExpr) {
        this.m_operand.setParent(null);
        this.m_operand = aEValueExpr;
        aEValueExpr.setParent(this);
    }

    private void initializeMetadata() throws ErrorException {
        switch (this.getAggrFnId()) {
            case COUNT: {
                this.m_metadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(-5, false));
                break;
            }
            case MAX: 
            case MIN: {
                this.m_metadata = this.copyOperandMetadata();
                break;
            }
            case SUM: {
                TypeMetadata typeMetadata = this.m_operand.getColumn().getTypeMetadata();
                if (typeMetadata.isExactNumericType()) {
                    this.m_metadata = this.copyOperandMetadata();
                    break;
                }
                if (!TypeUtilities.isNumberType(typeMetadata.getType()) && typeMetadata.getType() != -7) break;
                this.m_metadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(8));
                break;
            }
            case AVG: {
                TypeMetadata typeMetadata = this.m_operand.getColumn().getTypeMetadata();
                if (typeMetadata.isExactNumericType()) {
                    ColumnMetadata columnMetadata = new ColumnMetadata(new TypeMetadata(3, "SQL_DECIMAL", 38, typeMetadata.getScale(), 0));
                    this.m_metadata = this.m_coercionHandler.coerceDivisionColumns(new MetadataColumnInfo(columnMetadata, IColumnInfo.ColumnType.COLUMN), INT_COLUMN);
                    break;
                }
                if (TypeUtilities.isNumberType(typeMetadata.getType()) || typeMetadata.getType() == -7) {
                    this.m_metadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(8));
                    break;
                }
                this.m_metadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(typeMetadata.getType()));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SET function name: " + this.getAggrFnId().name());
            }
        }
        if (this.m_metadata instanceof ColumnMetadata) {
            ((ColumnMetadata)this.m_metadata).setName(null);
        }
    }

    private void validate() throws ErrorException {
        short s = this.m_operand.getTypeMetadata().getType();
        switch (this.getAggrFnId()) {
            case COUNT: {
                return;
            }
            case SUM: 
            case AVG: {
                if (!TypeUtilities.isNumberType(s) && s != -7) {
                    throw SQLEngineExceptionFactory.invalidSetArgTypeException(this.getAggrFnId().name(), s);
                }
                return;
            }
            case MAX: 
            case MIN: {
                if (s == -4) {
                    throw SQLEngineExceptionFactory.invalidSetArgTypeException(this.getAggrFnId().name(), s);
                }
                return;
            }
        }
        throw new IllegalStateException("Unknown SET function name: " + this.getAggrFnId().name());
    }

    @Override
    public AEAggrFn.AggrFnQuantifier getSetQuantifier() {
        return this.m_setQuantifier;
    }

    private List<AEValueExpr> asList() {
        return new AbstractList<AEValueExpr>(){

            @Override
            public AEValueExpr get(int n) {
                if (0 == n) {
                    return AEGeneralAggrFn.this.m_operand;
                }
                throw new IndexOutOfBoundsException("Index: " + n);
            }

            @Override
            public int size() {
                return AEGeneralAggrFn.this.getNumChildren();
            }
        };
    }

    private ColumnMetadata copyOperandMetadata() {
        IColumn iColumn = this.m_operand.getColumn();
        TypeMetadata typeMetadata = iColumn.getTypeMetadata();
        ColumnMetadata columnMetadata = new ColumnMetadata(TypeMetadata.copyOf(typeMetadata));
        columnMetadata.setCaseSensitive(iColumn.isCaseSensitive());
        try {
            columnMetadata.setColumnLength(iColumn.getColumnLength());
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new RuntimeException(numericOverflowException);
        }
        return columnMetadata;
    }

    @Override
    public void updateColumn() throws ErrorException {
        this.initializeMetadata();
    }
}

