/*
 * Code for class I18N_HOST_LOCALE_IMP
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "i12256.h"
#include <string.h>
#include <eif_langinfo.h>
#include <iconv.h>
#include <eif_eiffel.h>
#include "eif_langinfo.h"
#include <locale.h>
#include "eif_dir.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F3253_38402
static int inline_F3253_38402 (void)
{
	#if EIF_OS == EIF_OS_SUNOS
	return (EIF_BOOLEAN)1;
#else
	return (EIF_BOOLEAN)0;
#endif
	;
}
#define INLINE_F3253_38402
#endif
#ifndef INLINE_F325_5350
static EIF_INTEGER_32 inline_F325_5350 (void)
{
	return D_T_FMT;
	;
}
#define INLINE_F325_5350
#endif
#ifndef INLINE_F325_5351
static EIF_INTEGER_32 inline_F325_5351 (void)
{
	return D_FMT;
	;
}
#define INLINE_F325_5351
#endif
#ifndef INLINE_F325_5352
static EIF_INTEGER_32 inline_F325_5352 (void)
{
	return T_FMT;
	;
}
#define INLINE_F325_5352
#endif
#ifndef INLINE_F325_5348
static EIF_INTEGER_32 inline_F325_5348 (void)
{
	return AM_STR;
	;
}
#define INLINE_F325_5348
#endif
#ifndef INLINE_F325_5349
static EIF_INTEGER_32 inline_F325_5349 (void)
{
	return PM_STR;
	;
}
#define INLINE_F325_5349
#endif
#ifndef INLINE_F325_5354
static EIF_INTEGER_32 inline_F325_5354 (void)
{
	return CRNCYSTR;
	;
}
#define INLINE_F325_5354
#endif
#ifndef INLINE_F324_5305
static EIF_POINTER inline_F324_5305 (void)
{
	#if EIF_OS == EIF_OS_OPENBSD
	return locale_charset ();
#else
	return nl_langinfo (CODESET);
#endif
	;
}
#define INLINE_F324_5305
#endif
#ifndef INLINE_F324_5303
static EIF_POINTER inline_F324_5303 (EIF_INTEGER_32 arg1)
{
	char *dname;
				wchar_t *out = NULL;
				size_t insize, outsize = 0;

				dname = nl_langinfo(arg1);
				insize = strlen(dname) + 1;
				
				{
					iconv_t cd;
					size_t nconv, avail, alloc;
					char *res, *tres, *wrptr, *inptr;
					char **l_inptr = &inptr;

					alloc = avail = insize + insize/4;
					if (!(res = malloc(alloc))) {
					  perror("malloc");
					  return NULL;
					}

					wrptr = res;   /* duplicate pointers because they */
					inptr = dname; /* get modified by iconv */
					
					/*get charset used by current locale */
					#if EIF_OS == EIF_OS_OPENBSD
						char *charset = locale_charset ();
					#else
						char *charset = nl_langinfo (CODESET);
					#endif
					
					cd = iconv_open ("UTF-8", charset);
					if (cd == (iconv_t)(-1)) {
							perror("iconv_open");
							free(res);
							return NULL;
					}

					do {
							nconv = iconv (cd, l_inptr, &insize, &wrptr, &avail); /*convertions */
							if (nconv == (size_t)(-1)) {
									if (errno == E2BIG) { /* need more room for result */
											tres = realloc(res, alloc += 20);
											avail += 20;
											if (!tres) {
													perror("realloc");
													break;
											}
											wrptr = tres + (wrptr - res);
											res = tres;
									}
									else /* something wrong with input */
											break;
							}
					} while (insize);

					if (iconv_close(cd))
							perror("iconv_close");
				   
					out = (wchar_t*) res;
					outsize = wrptr - res; /* should be == to (alloc - avail + 1) */
					/* TODO: should possibly null-terminate the result */
				}
				return out;
	;
}
#define INLINE_F324_5303
#endif
#ifndef INLINE_F325_5317
static EIF_INTEGER_32 inline_F325_5317 (void)
{
	return DAY_1;
	;
}
#define INLINE_F325_5317
#endif
#ifndef INLINE_F325_5336
static EIF_INTEGER_32 inline_F325_5336 (void)
{
	return MON_1;
	;
}
#define INLINE_F325_5336
#endif
#ifndef INLINE_F325_5310
static EIF_INTEGER_32 inline_F325_5310 (void)
{
	return ABDAY_1;
	;
}
#define INLINE_F325_5310
#endif
#ifndef INLINE_F325_5324
static EIF_INTEGER_32 inline_F325_5324 (void)
{
	return ABMON_1;
	;
}
#define INLINE_F325_5324
#endif
#ifndef INLINE_F324_5309
static EIF_INTEGER_32 inline_F324_5309 (void)
{
	return LC_ALL;
	;
}
#define INLINE_F324_5309
#endif
#ifndef INLINE_F324_5308
static EIF_POINTER inline_F324_5308 (EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	return setlocale((int) arg1, (const char *) arg2);
	;
}
#define INLINE_F324_5308
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {I18N_HOST_LOCALE_IMP}.create_locale_info */
EIF_REFERENCE F3253_38366 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	if (EIF_TEST (inline_F3253_38402())) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		tr1 = F3253_38404(Current, tr1);
		F324_5301(Current, tr1);
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		F324_5301(Current, tr1);
	}
	Result = RTLNS(eif_new_type(329, 0x00).id, 329, _OBJSIZ_35_0_0_5_0_0_0_0_);
	F330_5473(RTCW(Result));
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.fill) */
		F3253_38374(Current, Result);
		F3253_38375(Current, Result);
		F3253_38376(Current, Result);
		F3253_38377(Current, Result);
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_LOCALE_INFO.set_id) */
		(void) RTCW(Result);
		RTAR(Result, arg1);
		*(EIF_REFERENCE *)(Result + _REFACS_34_) = (EIF_REFERENCE) arg1;
		/* END INLINED CODE */
	}
	;
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.is_available */
EIF_BOOLEAN F3253_38367 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLIU(3);
	
	RTGC;
	if (EIF_TEST (inline_F3253_38402())) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		tr1 = F3253_38404(Current, tr1);
		Result = F324_5304(Current, tr1);
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		Result = F324_5304(Current, tr1);
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.available_locales */
EIF_REFERENCE F3253_38368 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(6);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc2);
	RTLR(3,tr1);
	RTLR(4,loc3);
	RTLR(5,loc1);
	RTLIU(6);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1697,3214,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1697, _OBJSIZ_2_3_0_1_0_0_0_0_);
	}
	F1698_16886(RTCW(Result));
	loc2 = RTLNS(eif_new_type(925, 0x00).id, 925, _OBJSIZ_3_0_0_1_0_2_0_0_);
	tr1 = RTMS_EX_H("/usr/share/i18n/locales/",24,2077116975);
	F926_13156(RTCW(loc2), tr1);
	{
		/* INLINED CODE (DIRECTORY.exists) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(loc2);
		tp1 = *(EIF_POINTER *)(RTCV(F926_13195(loc2))+ _PTROFF_0_1_0_1_0_0_);
		tb1 = (EIF_BOOLEAN) EIF_TEST(eif_dir_exists((EIF_FILENAME) tp1));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = RTMS_EX_H("/usr/lib/locale",15,443040613);
		{
			/* INLINED CODE (DIRECTORY.make) */
			(void) RTCW(loc2);
			F926_13157(loc2, tr1);
			/* END INLINED CODE */
		}
		;
	}
	{
		/* INLINED CODE (DIRECTORY.exists) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(loc2);
		tp1 = *(EIF_POINTER *)(RTCV(F926_13195(loc2))+ _PTROFF_0_1_0_1_0_0_);
		tb1 = (EIF_BOOLEAN) EIF_TEST(eif_dir_exists((EIF_FILENAME) tp1));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if (tb1) {
		loc3 = F926_13175(RTCW(loc2));
		{
			/* INLINED CODE (ARRAYED_LIST.start) */
			(void) RTCW(loc3);
			*(EIF_INTEGER_32 *)(loc3 + O14443[Dtype(loc3)-1723]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			/* END INLINED CODE */
		}
		;
		for (;;) {
			{
				/* INLINED CODE (LIST.after) */
				tb1 = (EIF_BOOLEAN)  0;
				(void) RTCW(loc3);
				ti4_1 = *(EIF_INTEGER_32 *)(loc3 + O14443[Dtype(loc3)-1723]);
				ti4_2 = F1724_17124(loc3);
				tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) 1L)));
				/* END INLINED CODE */
			}
			tb1 = tb1;
			if (tb1) break;
			loc1 = RTLNS(eif_new_type(3214, 0x00).id, 3214, _OBJSIZ_6_0_0_0_0_0_0_0_);
			tr1 = F1724_17108(RTCW(loc3));
			F3215_37600(RTCW(loc1), tr1);
			tr1 = *(EIF_REFERENCE *)(RTCW(loc1) + _REFACS_1_);
			if (F324_5304(Current, tr1)) {
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R13902[Dtype(RTCW(Result))-1462])(Result, loc1);
			}
			{
				/* INLINED CODE (ARRAYED_LIST.forth) */
				(void) RTCW(loc3);
				(*(EIF_INTEGER_32 *)(loc3 + O14443[Dtype(loc3)-1723]))++;
				/* END INLINED CODE */
			}
			;
		}
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.default_locale_id */
EIF_REFERENCE F3253_38369 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTGC;
	tr1 = RTMS_EX_H("",0,0);
	F324_5301(Current, tr1);
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.current_locale_id) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(3214, 0x00).id, 3214, _OBJSIZ_6_0_0_0_0_0_0_0_);
		tr2 = F3253_38372(Current);
		F3215_37600(RTCW(tr1), tr2);
		/* END INLINED CODE */
	}
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {I18N_HOST_LOCALE_IMP}.system_locale_id */
EIF_REFERENCE F3253_38370 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.default_locale_id) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = RTMS_EX_H("",0,0);
		F324_5301(Current, tr2);
		tr1 = F3253_38371(Current);
		/* END INLINED CODE */
	}
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {I18N_HOST_LOCALE_IMP}.current_locale_id */
EIF_REFERENCE F3253_38371 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	Result = RTLNS(eif_new_type(3214, 0x00).id, 3214, _OBJSIZ_6_0_0_0_0_0_0_0_);
	tr1 = F3253_38372(Current);
	F3215_37600(RTCW(Result), tr1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.locale_name */
EIF_REFERENCE F3253_38372 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_locale_name) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = *(EIF_REFERENCE *)(RTCV(RTOSCF(5307,F324_5307, (Current))));
		/* END INLINED CODE */
	}
	Result = F2078_20910(RTCV(tr1));
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.fill */
void F3253_38373 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	F3253_38374(Current, arg1);
	F3253_38375(Current, arg1);
	F3253_38376(Current, arg1);
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.fill_code_page_info) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = F3253_38398(Current);
		F326_5360(RTCW(arg1), tr1);
		F326_5361(RTCW(arg1), tr1);
		F326_5362(RTCW(arg1), tr1);
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_date_time_info */
void F3253_38374 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLIU(5);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_date_time_format) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F325_5350();
		tr2 = F324_5302(Current, ti4_1);
		tr1 = F3253_38403(Current, tr2);
		tr2 = RTMS32_EX_H("%\000\000\000",1,37);
		tr3 = RTMS32_EX_H("&\000\000\000",1,38);
		F2087_21239(RTCW(tr1), tr2, tr3);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_date_time_format) */
		(void) RTCW(arg1);
		tr3 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17279[Dtype(RTCW(tr2))-2081])(tr2);
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_3_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_long_date_format) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F325_5351();
		tr2 = F324_5302(Current, ti4_1);
		tr1 = F3253_38403(Current, tr2);
		tr2 = RTMS32_EX_H("%\000\000\000",1,37);
		tr3 = RTMS32_EX_H("&\000\000\000",1,38);
		F2087_21239(RTCW(tr1), tr2, tr3);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_long_date_format) */
		(void) RTCW(arg1);
		tr3 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17279[Dtype(RTCW(tr2))-2081])(tr2);
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_4_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_long_time_format) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F325_5352();
		tr2 = F324_5302(Current, ti4_1);
		tr1 = F3253_38403(Current, tr2);
		tr2 = RTMS32_EX_H("%\000\000\000",1,37);
		tr3 = RTMS32_EX_H("&\000\000\000",1,38);
		F2087_21239(RTCW(tr1), tr2, tr3);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_long_time_format) */
		(void) RTCW(arg1);
		tr3 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17279[Dtype(RTCW(tr2))-2081])(tr2);
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_6_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_am_suffix) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F325_5348();
		tr2 = F324_5302(Current, ti4_1);
		tr1 = F3253_38403(Current, tr2);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_am_suffix) */
		(void) RTCW(arg1);
		tr3 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17279[Dtype(RTCW(tr2))-2081])(tr2);
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_8_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_pm_suffix) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F325_5349();
		tr2 = F324_5302(Current, ti4_1);
		tr1 = F3253_38403(Current, tr2);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_pm_suffix) */
		(void) RTCW(arg1);
		tr3 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17279[Dtype(RTCW(tr2))-2081])(tr2);
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_9_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	tr1 = F3253_38383(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_day_names) */
		(void) RTCW(arg1);
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(arg1 + _REFACS_12_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	tr1 = F3253_38384(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_month_names) */
		(void) RTCW(arg1);
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(arg1 + _REFACS_13_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	tr1 = F3253_38385(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_abbreviated_day_names) */
		(void) RTCW(arg1);
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(arg1 + _REFACS_14_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	tr1 = F3253_38386(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_abbreviated_month_names) */
		(void) RTCW(arg1);
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(arg1 + _REFACS_15_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_numeric_info */
void F3253_38375 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLIU(5);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_value_decimal_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->decimal_point);
		F2085_21151(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_NUMERIC_INFO.set_value_decimal_separator) */
		(void) RTCW(arg1);
		tr3 = F2078_20910(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_16_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_value_group_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->thousands_sep);
		F2085_21151(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_NUMERIC_INFO.set_value_group_separator) */
		(void) RTCW(arg1);
		tr3 = F2078_20910(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_17_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_value_grouping) */
		tr1 = (EIF_REFERENCE)  0;
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->grouping);
		tr1 = F3253_38401(Current, tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_NUMERIC_INFO.set_value_grouping) */
		(void) RTCW(arg1);
		RTAR(arg1, tr2);
		*(EIF_REFERENCE *)(arg1 + _REFACS_21_) = (EIF_REFERENCE) tr2;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_currency_info */
void F3253_38376 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLIU(5);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_symbol) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F325_5354();
		tr2 = F324_5302(Current, ti4_1);
		tr1 = F3253_38403(Current, tr2);
		F2087_21284(RTCW(tr1), ((EIF_INTEGER_32) 1L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_symbol) */
		(void) RTCW(arg1);
		tr3 = F2078_20910(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O5334[Dtype(arg1)-328]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	ti4_1 = F3253_38391(Current);
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_symbol_location) */
		(void) RTCW(arg1);
		*(EIF_INTEGER_32 *)(arg1 + O5335[Dtype(arg1)-328]) = (EIF_INTEGER_32) ti4_1;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_decimal_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_decimal_point);
		F2085_21151(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_decimal_separator) */
		(void) RTCW(arg1);
		tr3 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17279[Dtype(RTCW(tr2))-2081])(tr2);
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O5339[Dtype(arg1)-328]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	ti4_1 = F3253_38393(Current);
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_numbers_after_decimal_separator) */
		(void) RTCW(arg1);
		*(EIF_INTEGER_32 *)(arg1 + O5340[Dtype(arg1)-328]) = (EIF_INTEGER_32) ti4_1;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_group_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_thousands_sep);
		F2085_21151(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_group_separator) */
		(void) RTCW(arg1);
		tr3 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17279[Dtype(RTCW(tr2))-2081])(tr2);
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O5341[Dtype(arg1)-328]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_positive_sign) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->positive_sign);
		F2085_21151(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_positive_sign) */
		(void) RTCW(arg1);
		tr3 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17279[Dtype(RTCW(tr2))-2081])(tr2);
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O5343[Dtype(arg1)-328]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_negative_sign) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->negative_sign);
		F2085_21151(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_negative_sign) */
		(void) RTCW(arg1);
		tr3 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17279[Dtype(RTCW(tr2))-2081])(tr2);
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O5344[Dtype(arg1)-328]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_grouping) */
		tr1 = (EIF_REFERENCE)  0;
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_grouping);
		tr1 = F3253_38401(Current, tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_grouping) */
		(void) RTCW(arg1);
		RTAR(arg1, tr2);
		*(EIF_REFERENCE *)(arg1 + O5345[Dtype(arg1)-328]) = (EIF_REFERENCE) tr2;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_int_currency_symbol) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->int_curr_symbol);
		F2085_21151(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_international_currency_symbol) */
		(void) RTCW(arg1);
		tr3 = F2078_20910(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O5346[Dtype(arg1)-328]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	ti4_1 = F3253_38400(Current);
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_international_currency_numbers_after_decimal_separator) */
		(void) RTCW(arg1);
		*(EIF_INTEGER_32 *)(arg1 + O5352[Dtype(arg1)-328]) = (EIF_INTEGER_32) ti4_1;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_code_page_info */
void F3253_38377 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	RTLD;
	
	RTLI(6);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLR(5,arg1);
	RTLIU(6);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(1058, 0x00).id, 1058, _OBJSIZ_1_0_0_1_0_0_0_0_);
		tp1 = inline_F324_5305();
		F1059_15101(RTCW(tr1), tp1);
		tr3 = *(EIF_REFERENCE *)(RTCW(tr1));
		tr2 = F3253_38403(Current, tr3);
		/* END INLINED CODE */
	}
	loc1 = tr2;
	{
		/* INLINED CODE (I18N_CODE_PAGE_INFO.set_ansi_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		(void) RTCW(arg1);
		if ((EIF_BOOLEAN)(loc1 != NULL)) {
			tr2 = F2078_20904(RTCW(loc1));
			RTAR(arg1, tr2);
			*(EIF_REFERENCE *)(arg1) = (EIF_REFERENCE) tr2;
		} else {
			*(EIF_REFERENCE *)(arg1) = (EIF_REFERENCE) NULL;
		}
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_CODE_PAGE_INFO.set_oem_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		(void) RTCW(arg1);
		if ((EIF_BOOLEAN)(loc1 != NULL)) {
			tr2 = F2078_20904(RTCW(loc1));
			RTAR(arg1, tr2);
			*(EIF_REFERENCE *)(arg1 + _REFACS_1_) = (EIF_REFERENCE) tr2;
		} else {
			*(EIF_REFERENCE *)(arg1 + _REFACS_1_) = (EIF_REFERENCE) NULL;
		}
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_CODE_PAGE_INFO.set_mac_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		(void) RTCW(arg1);
		if ((EIF_BOOLEAN)(loc1 != NULL)) {
			tr2 = F2078_20904(RTCW(loc1));
			RTAR(arg1, tr2);
			*(EIF_REFERENCE *)(arg1 + _REFACS_2_) = (EIF_REFERENCE) tr2;
		} else {
			*(EIF_REFERENCE *)(arg1 + _REFACS_2_) = (EIF_REFERENCE) NULL;
		}
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.get_long_date_format */
EIF_REFERENCE F3253_38378 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F325_5351();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F324_5303(ti4_1);
		F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F3253_38403(Current, tr2);
	tr1 = RTMS32_EX_H("%\000\000\000",1,37);
	tr2 = RTMS32_EX_H("&\000\000\000",1,38);
	F2087_21239(RTCW(Result), tr1, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_long_time_format */
EIF_REFERENCE F3253_38379 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F325_5352();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F324_5303(ti4_1);
		F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F3253_38403(Current, tr2);
	tr1 = RTMS32_EX_H("%\000\000\000",1,37);
	tr2 = RTMS32_EX_H("&\000\000\000",1,38);
	F2087_21239(RTCW(Result), tr1, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_am_suffix */
EIF_REFERENCE F3253_38380 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F325_5348();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F324_5303(ti4_1);
		F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F3253_38403(Current, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_pm_suffix */
EIF_REFERENCE F3253_38381 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F325_5349();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F324_5303(ti4_1);
		F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F3253_38403(Current, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_date_time_format */
EIF_REFERENCE F3253_38382 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F325_5350();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F324_5303(ti4_1);
		F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F3253_38403(Current, tr2);
	tr1 = RTMS32_EX_H("%\000\000\000",1,37);
	tr2 = RTMS32_EX_H("&\000\000\000",1,38);
	F2087_21239(RTCW(Result), tr1, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_day_names */
EIF_REFERENCE F3253_38383 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc3);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 7L);
	{
		static EIF_TYPE_INDEX typarr0[] = {1759,2086,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1759, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1760_17296(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), loc2);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O14562[Dtype(Result)-1759]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O14561[Dtype(Result)-1759]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F325_5317();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) (ti4_2 + (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)) % loc2));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F324_5303(ti4_2);
			F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc3 = F3253_38403(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			ti4_2 = *(EIF_INTEGER_32 *)(Result + O14562[Dtype(Result)-1759]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc3;
			RTAR(tr1,loc3);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_month_names */
EIF_REFERENCE F3253_38384 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc2);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1759,2086,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1759, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1760_17296(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 12L));
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O14562[Dtype(Result)-1759]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O14561[Dtype(Result)-1759]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F325_5336();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_2 + loc1) - ((EIF_INTEGER_32) 1L));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F324_5303(ti4_2);
			F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc2 = F3253_38403(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			ti4_2 = *(EIF_INTEGER_32 *)(Result + O14562[Dtype(Result)-1759]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc2;
			RTAR(tr1,loc2);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_abbreviated_day_names */
EIF_REFERENCE F3253_38385 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc3);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 7L);
	{
		static EIF_TYPE_INDEX typarr0[] = {1759,2086,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1759, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1760_17296(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), loc2);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O14562[Dtype(Result)-1759]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O14561[Dtype(Result)-1759]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F325_5310();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) (ti4_2 + (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)) % loc2));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F324_5303(ti4_2);
			F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc3 = F3253_38403(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			ti4_2 = *(EIF_INTEGER_32 *)(Result + O14562[Dtype(Result)-1759]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc3;
			RTAR(tr1,loc3);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_abbreviated_month_names */
EIF_REFERENCE F3253_38386 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc2);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1759,2086,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1759, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1760_17296(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 12L));
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O14562[Dtype(Result)-1759]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O14561[Dtype(Result)-1759]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F325_5324();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_2 + loc1) - ((EIF_INTEGER_32) 1L));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F324_5303(ti4_2);
			F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc2 = F3253_38403(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			ti4_2 = *(EIF_INTEGER_32 *)(Result + O14562[Dtype(Result)-1759]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc2;
			RTAR(tr1,loc2);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_value_decimal_separator */
EIF_REFERENCE F3253_38387 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->decimal_point);
	F2085_21151(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_value_group_separator */
EIF_REFERENCE F3253_38388 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->thousands_sep);
	F2085_21151(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_value_grouping */
EIF_REFERENCE F3253_38389 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->grouping);
	Result = F3253_38401(Current, tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_symbol */
EIF_REFERENCE F3253_38390 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F325_5354();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F324_5303(ti4_1);
		F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F3253_38403(Current, tr2);
	{
		/* INLINED CODE (STRING_32.remove_head) */
		(void) RTCW(Result);
		if ((EIF_BOOLEAN) (((EIF_INTEGER_32) 1L) > *(EIF_INTEGER_32 *)(Result+ _LNGOFF_1_1_0_2_))) {
			*(EIF_INTEGER_32 *)(Result+ _LNGOFF_1_1_0_2_) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
			F2080_20949(Result);
		} else {
			F2087_21245(Result, (EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(Result+ _LNGOFF_1_1_0_2_) - ((EIF_INTEGER_32) 1L)));
		}
		/* END INLINED CODE */
	}
	;
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_symbol_location */
EIF_INTEGER_32 F3253_38391 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F325_5354();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(919, 0x00).id, 919, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F324_5303(ti4_1);
		F920_12990(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	loc1 = F3253_38403(Current, tr2);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(loc1);
		ti4_1 = *(EIF_INTEGER_32 *)(loc1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		{
			/* INLINED CODE (STRING_32.item) */
			tw1 = (EIF_CHARACTER_32)  0;
			(void) RTCW(loc1);
			tr1 = *(EIF_REFERENCE *)(loc1);
			tw1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tw1 = tw1;
		tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '-';
		tb1 = tw1 == tw2;
		if (tb1) {
			RTLE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			{
				/* INLINED CODE (STRING_32.item) */
				tw1 = (EIF_CHARACTER_32)  0;
				(void) RTCW(loc1);
				tr1 = *(EIF_REFERENCE *)(loc1);
				tw1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) - ((EIF_INTEGER_32) 1L))))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tw1 = tw1;
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '+';
			tb1 = tw1 == tw2;
			if (tb1) {
				Result = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			} else {
				{
					/* INLINED CODE (STRING_32.item) */
					tw1 = (EIF_CHARACTER_32)  0;
					(void) RTCW(loc1);
					tr1 = *(EIF_REFERENCE *)(loc1);
					tw1 = 
						/* INLINED CODE (SPECIAL.item) */
						*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) - ((EIF_INTEGER_32) 1L))))
						/* END INLINED CODE */;
					/* END INLINED CODE */
				}
				tw1 = tw1;
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
				tb1 = tw1 == tw2;
				if (tb1) {
					RTLE;
					return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					RTLE;
					return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
				}
			}
		}
	} else {
		RTLE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_decimal_separator */
EIF_REFERENCE F3253_38392 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_decimal_point);
	F2085_21151(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_numbers_after_decimal_separator */
EIF_INTEGER_32 F3253_38393 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_NATURAL_32 tu4_1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tc1 = (EIF_CHARACTER_8) (((struct lconv *)tp1)->frac_digits);
	tu4_1 = (EIF_NATURAL_32) tc1;
	Result = (EIF_INTEGER_32) tu4_1;
	if ((EIF_BOOLEAN)(Result == ((EIF_INTEGER_32) 255L))) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	}
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_group_separator */
EIF_REFERENCE F3253_38394 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_thousands_sep);
	F2085_21151(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_positive_sign */
EIF_REFERENCE F3253_38395 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->positive_sign);
	F2085_21151(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_negative_sign */
EIF_REFERENCE F3253_38396 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->negative_sign);
	F2085_21151(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_grouping */
EIF_REFERENCE F3253_38397 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_grouping);
	Result = F3253_38401(Current, tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_code_page */
EIF_REFERENCE F3253_38398 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(1058, 0x00).id, 1058, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tp1 = inline_F324_5305();
	F1059_15101(RTCW(loc1), tp1);
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	Result = F3253_38403(Current, tr1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_int_currency_symbol */
EIF_REFERENCE F3253_38399 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->int_curr_symbol);
	F2085_21151(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_int_currency_numbers_after_decimal_separator */
EIF_INTEGER_32 F3253_38400 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_NATURAL_32 tu4_1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tc1 = (EIF_CHARACTER_8) (((struct lconv *)tp1)->int_frac_digits);
	tu4_1 = (EIF_NATURAL_32) tc1;
	Result = (EIF_INTEGER_32) tu4_1;
	if ((EIF_BOOLEAN)(Result == ((EIF_INTEGER_32) 255L))) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	}
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.pointer_to_array */
EIF_REFERENCE F3253_38401 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_NATURAL_32 tu4_1;
	EIF_CHARACTER_32 tw1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,Result);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
	F2085_21151(RTCW(loc1), arg1);
	{
		static EIF_TYPE_INDEX typarr0[] = {1760,2269,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1760, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	F1761_17296(RTCW(Result), ((EIF_INTEGER_32) 0L), ((EIF_INTEGER_32) 1L), ti4_1);
	loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN) (loc2 > ti4_1)) break;
		{
			/* INLINED CODE (STRING_32.item) */
			tw1 = (EIF_CHARACTER_32)  0;
			(void) RTCW(loc1);
			tr1 = *(EIF_REFERENCE *)(loc1);
			tw1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc2 - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tw1 = tw1;
		tu4_1 = (EIF_NATURAL_32) tw1;
		loc3 = (EIF_INTEGER_32) tu4_1;
		if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 255L))) {
			loc2 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		} else {
			{
				/* INLINED CODE (ARRAY.put) */
				(void) RTCW(Result);
				tr1 = *(EIF_REFERENCE *)(Result);
				/* INLINED CODE (SPECIAL.put) */
				*((EIF_INTEGER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc2 - *(EIF_INTEGER_32 *)(Result+ _LNGOFF_1_1_0_1_)))) = loc3;
				/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			;
		}
		loc2++;
	}
	if ((EIF_BOOLEAN)(loc3 != ((EIF_INTEGER_32) 255L))) {
		F1761_17322(RTCW(Result), ((EIF_INTEGER_32) 0L), loc2);
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.c_is_solaris */
EIF_BOOLEAN F3253_38402 (EIF_REFERENCE Current)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F3253_38402 ());
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.utf8_pointer_to_string */
EIF_REFERENCE F3253_38403 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(7);
	RTLR(0,loc1);
	RTLR(1,arg1);
	RTLR(2,tr1);
	RTLR(3,Current);
	RTLR(4,tr2);
	RTLR(5,tr3);
	RTLR(6,Result);
	RTLIU(7);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(1058, 0x00).id, 1058, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tp1 = *(EIF_POINTER *)(RTCW(arg1)+ _PTROFF_0_1_0_1_0_0_);
	F1059_15101(RTCW(loc1), tp1);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_0_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		{
			/* INLINED CODE (C_STRING.string) */
			tr1 = (EIF_REFERENCE)  0;
			(void) RTCW(loc1);
			tp1 = F1059_15119(loc1);
			ti4_1 = (EIF_INTEGER_32) strlen((char*) tp1);
			tr1 = F1059_15109(loc1, ((EIF_INTEGER_32) 1L), ti4_1);
			/* END INLINED CODE */
		}
		tr1 = tr1;
		{
			/* INLINED CODE (UNICODE_CONVERSION.utf8_to_utf32) */
			tr2 = (EIF_REFERENCE)  0;
			tr3 = RTLNS(eif_new_type(246, 0x00).id, 246, _OBJSIZ_0_0_0_0_0_0_0_0_);
			tr2 = F247_4294(RTCW(tr3), tr1);
			/* END INLINED CODE */
		}
		Result = tr2;
	} else {
		Result = RTLNS(eif_new_type(2086, 0x00).id, 2086, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2078_20851(RTCW(Result));
		RTLE;
		return (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.guess_proper_locale */
EIF_REFERENCE F3253_38404 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc8 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_32 tw1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(11);
	RTLR(0,arg1);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLR(3,loc5);
	RTLR(4,loc4);
	RTLR(5,loc8);
	RTLR(6,loc7);
	RTLR(7,Current);
	RTLR(8,loc6);
	RTLR(9,tr2);
	RTLR(10,Result);
	RTLIU(11);
	
	RTGC;
	tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '_';
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_CHARACTER_32)) R17239[Dtype(RTCW(arg1))-2081])(arg1, tw1);
	if (tb1) {
		loc1 = RTLNS(eif_new_type(1058, 0x00).id, 1058, _OBJSIZ_1_0_0_1_0_0_0_0_);
		F1059_15097(RTCW(loc1), arg1);
		ti4_1 = inline_F324_5309();
		{
			/* INLINED CODE (C_STRING.item) */
			tp1 = (EIF_POINTER)  0;
			(void) RTCW(loc1);
			tr1 = *(EIF_REFERENCE *)(loc1);
			tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
			/* END INLINED CODE */
		}
		tp1 = tp1;
		loc2 = inline_F324_5308(ti4_1, tp1);
		if ((EIF_BOOLEAN)(loc2 == loc3)) {
			loc5 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17280[Dtype(RTCW(arg1))-2081])(arg1);
			loc1 = RTLNS(eif_new_type(1058, 0x00).id, 1058, _OBJSIZ_1_0_0_1_0_0_0_0_);
			tr1 = RTMS_EX_H("",0,0);
			F1059_15097(RTCW(loc1), tr1);
			ti4_1 = inline_F324_5309();
			{
				/* INLINED CODE (C_STRING.item) */
				tp1 = (EIF_POINTER)  0;
				(void) RTCW(loc1);
				tr1 = *(EIF_REFERENCE *)(loc1);
				tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
				/* END INLINED CODE */
			}
			tp1 = tp1;
			loc2 = inline_F324_5308(ti4_1, tp1);
			if ((EIF_BOOLEAN)(loc2 != loc3)) {
				loc1 = RTLNS(eif_new_type(1058, 0x00).id, 1058, _OBJSIZ_1_0_0_1_0_0_0_0_);
				F1059_15101(RTCW(loc1), loc2);
				{
					/* INLINED CODE (C_STRING.string) */
					tr1 = (EIF_REFERENCE)  0;
					(void) RTCW(loc1);
					tp1 = F1059_15119(loc1);
					ti4_1 = (EIF_INTEGER_32) strlen((char*) tp1);
					tr1 = F1059_15109(loc1, ((EIF_INTEGER_32) 1L), ti4_1);
					/* END INLINED CODE */
				}
				loc4 = tr1;
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17280[Dtype(RTCW(loc4))-2081])(loc4);
				tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R17263[Dtype(RTCW(tr1))-2081])(tr1, loc5);
				if (tb1) {
					loc8 = (EIF_REFERENCE) loc4;
				}
			}
			if ((EIF_BOOLEAN)(loc8 == NULL)) {
				loc7 = F3253_38368(Current);
				{
					/* INLINED CODE (LINKED_LIST.start) */
					(void) RTCW(loc7);
					if ((EIF_BOOLEAN)(*(EIF_REFERENCE *)(loc7) != NULL)) {
						tr1 = *(EIF_REFERENCE *)(loc7);
						RTAR(loc7, tr1);
						*(EIF_REFERENCE *)(loc7 + _REFACS_1_) = (EIF_REFERENCE) tr1;
						*(EIF_BOOLEAN *)(loc7 + O14334[Dtype(loc7)-1697]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
					} else {
						*(EIF_BOOLEAN *)(loc7 + O14334[Dtype(loc7)-1697]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
					}
					*(EIF_BOOLEAN *)(loc7 + O14333[Dtype(loc7)-1697]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
					/* END INLINED CODE */
				}
				;
				for (;;) {
					tb1 = '\01';
					tb2 = *(EIF_BOOLEAN *)(RTCW(loc7) + O14334[Dtype(loc7)-1697]);
					if (!tb2) {
						tb1 = (EIF_BOOLEAN)(loc8 != NULL);
					}
					if (tb1) break;
					tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R13915[Dtype(RTCW(loc7))-1484])(loc7);
					loc6 = *(EIF_REFERENCE *)(RTCW(tr1) + _REFACS_1_);
					tb2 = F2085_21179(RTCW(loc6));
					if (tb2) {
						loc4 = F2078_20904(RTCW(loc6));
						tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17280[Dtype(RTCW(loc4))-2081])(loc4);
						tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R17263[Dtype(RTCW(tr1))-2081])(tr1, loc5);
						if (tb2) {
							loc8 = (EIF_REFERENCE) loc4;
						}
					}
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R13892[Dtype(RTCW(loc7))-1462])(loc7);
				}
			}
		}
	}
	if ((EIF_BOOLEAN)(loc8 == NULL)) {
		tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17235[Dtype(RTCW(arg1))-2081])(arg1);
		if (tb2) {
			tr1 = F2078_20904(RTCW(arg1));
			RTLE;
			return (EIF_REFERENCE) tr1;
		} else {
			tr1 = RTLNS(eif_new_type(246, 0x00).id, 246, _OBJSIZ_0_0_0_0_0_0_0_0_);
			{
				/* INLINED CODE (UTF_CONVERTER.utf_32_string_to_utf_8_string_8) */
				tr2 = (EIF_REFERENCE)  0;
				(void) RTCW(tr1);
				tr2 = RTLNS(eif_new_type(2082, 0x00).id, 2082, _OBJSIZ_1_1_0_3_0_0_0_0_);
				ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17258[Dtype(RTCW(arg1))-2081])(arg1);
				F2081_20981(RTCW(tr2), ti4_1);
				F247_4281(tr1, arg1, tr2);
				/* END INLINED CODE */
			}
			Result = tr2;
		}
	} else {
		RTLE;
		return (EIF_REFERENCE) loc8;
	}
	RTLE;
	return Result;
}

void EIF_Minit2256 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
