//===----------------------------------------------------------------------===//
// Copyright © 2026 Apple Inc. and the container project authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

/// System-defined keys for resource labels.
public struct ResourceLabelKeys {
    /// Indicates a owner of a resource managed by a plugin.
    public static let plugin = "com.apple.container.plugin"

    /// Indicates a resource with a reserved or dedicated purpose.
    public static let role = "com.apple.container.resource.role"
}

/// System-defined values for resource the resource role label.
public struct ResourceRoleValues {
    /// Indicates a container that can build images.
    public static let builder = "builder"

    /// Indicates a system-created resource that cannot be deleted by the user.
    public static let builtin = "builtin"
}
