/**
 * tests/t30018/test_case.h
 *
 * Copyright (c) 2021-2025 Bartek Kryza <bkryza@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

TEST_CASE("t30018")
{
    using namespace clanguml::test;
    using namespace std::string_literals;

    auto [config, db, diagram, model] =
        CHECK_PACKAGE_MODEL("t30018", "t30018_package");

    CHECK_PACKAGE_DIAGRAM(*config, diagram, *model, [](const auto &src) {
        REQUIRE(IsNamespacePackage(src, "context"s, "F"s));
        REQUIRE(IsNamespacePackage(src, "context"s, "E"s));
        REQUIRE(IsNamespacePackage(src, "context"s, "B"s));
        REQUIRE(IsNamespacePackage(src, "context"s, "D"s));

        REQUIRE(!IsNamespacePackage(src, "context"s, "A"s));
        REQUIRE(!IsNamespacePackage(src, "context"s, "X"s));
        REQUIRE(!IsNamespacePackage(src, "context"s, "C"s));
        REQUIRE(!IsNamespacePackage(src, "context"s, "Y"s));

        REQUIRE(HasDependencyLink(src, {"context"s, "F"s}, {"context", "E"}, "",
            fmt::format("https://github.com/bkryza/clang-uml/blob/{}/tests/"
                        "t30018/t30018.cc#L40",
                clanguml::util::get_git_commit()),
            ""));
    });
}