# t20021 - Loop statements sequence diagram test case
## Config
```yaml
diagrams:
  t20021_sequence:
    type: sequence
    glob:
      - t20021.cc
    include:
      namespaces:
        - clanguml::t20021
    using_namespace: clanguml::t20021
    from:
      - function: "clanguml::t20021::tmain()"
```
## Source code
File `tests/t20021/t20021.cc`
```cpp
#include <vector>

namespace clanguml {
namespace t20021 {
struct A {
    int a1() { return 0; }
    int a2() { return 1; }
    int a3() { return 2; }
};

struct B {
    void log() { }

    int b1() const { return 3; }
    int b2() const { return 4; }
};

struct C {
    int c1() { return 1; }
    int c2() { return 2; }
    int c3() { return 3; }
    int c4() { return c5(); }
    int c5() { return 5; }

    std::vector<int> &contents() { return contents_; }

    std::vector<int> contents_;
};

int tmain()
{
    A a;
    std::vector<B> b;
    C c;

    int i = 10;
    while (i -= c.c4()) {
        int j = a.a3();
        do {
            for (int l = a.a2(); l > c.c1(); l -= c.c2())
                a.a1();
        } while (j -= c.c3());
    }

    int result = 0;
    for (const auto &bi : b) {
        result += bi.b2();
    }

    for (const auto &ci : c.contents()) {
        result += ci;
    }

    return b.front().b2() + result;
}
}
}
```
## Generated PlantUML diagrams
![t20021_sequence](./t20021_sequence.svg "Loop statements sequence diagram test case")
## Generated Mermaid diagrams
![t20021_sequence](./t20021_sequence_mermaid.svg "Loop statements sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20021_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20021::tmain()",
      "id": "13461048163044463326",
      "name": "tmain",
      "namespace": "clanguml::t20021",
      "source_location": {
        "column": 5,
        "file": "t20021.cc",
        "line": 30,
        "translation_unit": "t20021.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "c4()",
          "full_name": "clanguml::t20021::C::c4()",
          "id": "999423020978569411",
          "name": "c4",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 9,
            "file": "t20021.cc",
            "line": 22,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c5()",
          "full_name": "clanguml::t20021::C::c5()",
          "id": "10605765713438469028",
          "name": "c5",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 9,
            "file": "t20021.cc",
            "line": 23,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c1()",
          "full_name": "clanguml::t20021::C::c1()",
          "id": "17150117920578586424",
          "name": "c1",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 9,
            "file": "t20021.cc",
            "line": 19,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c2()",
          "full_name": "clanguml::t20021::C::c2()",
          "id": "13661547835268008141",
          "name": "c2",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 9,
            "file": "t20021.cc",
            "line": 20,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c3()",
          "full_name": "clanguml::t20021::C::c3()",
          "id": "10423142025974403121",
          "name": "c3",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 9,
            "file": "t20021.cc",
            "line": 21,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        },
        {
          "display_name": "contents()",
          "full_name": "clanguml::t20021::C::contents()",
          "id": "6515241731085583713",
          "name": "contents",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 23,
            "file": "t20021.cc",
            "line": 25,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "C",
      "full_name": "clanguml::t20021::C",
      "id": "3609024002074859509",
      "name": "C",
      "namespace": "clanguml::t20021",
      "source_location": {
        "column": 8,
        "file": "t20021.cc",
        "line": 18,
        "translation_unit": "t20021.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a3()",
          "full_name": "clanguml::t20021::A::a3()",
          "id": "14943641868999129521",
          "name": "a3",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 9,
            "file": "t20021.cc",
            "line": 8,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a2()",
          "full_name": "clanguml::t20021::A::a2()",
          "id": "9114358382067320148",
          "name": "a2",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 9,
            "file": "t20021.cc",
            "line": 7,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a1()",
          "full_name": "clanguml::t20021::A::a1()",
          "id": "13275908397574487940",
          "name": "a1",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 9,
            "file": "t20021.cc",
            "line": 6,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20021::A",
      "id": "10243868858636085846",
      "name": "A",
      "namespace": "clanguml::t20021",
      "source_location": {
        "column": 8,
        "file": "t20021.cc",
        "line": 5,
        "translation_unit": "t20021.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b2() const",
          "full_name": "clanguml::t20021::B::b2() const",
          "id": "12488327994212504617",
          "name": "b2",
          "namespace": "clanguml::t20021",
          "source_location": {
            "column": 9,
            "file": "t20021.cc",
            "line": 15,
            "translation_unit": "t20021.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20021::B",
      "id": "14797568643547163151",
      "name": "B",
      "namespace": "clanguml::t20021",
      "source_location": {
        "column": 8,
        "file": "t20021.cc",
        "line": 11,
        "translation_unit": "t20021.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "13461048163044463326",
        "location": "clanguml::t20021::tmain()"
      },
      "messages": [
        {
          "activity_id": "13461048163044463326",
          "messages": [
            {
              "from": {
                "activity_id": "13461048163044463326",
                "participant_id": "13461048163044463326"
              },
              "name": "c4()",
              "return_type": "int",
              "scope": "condition",
              "source_location": {
                "column": 17,
                "file": "t20021.cc",
                "line": 37,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "999423020978569411",
                "participant_id": "3609024002074859509"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "999423020978569411",
                "participant_id": "3609024002074859509"
              },
              "name": "c5()",
              "return_type": "int",
              "scope": "normal",
              "source_location": {
                "column": 23,
                "file": "t20021.cc",
                "line": 22,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "10605765713438469028",
                "participant_id": "3609024002074859509"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "10605765713438469028",
                "participant_id": "3609024002074859509"
              },
              "name": "",
              "return_type": "int",
              "scope": "normal",
              "source_location": {
                "column": 16,
                "file": "t20021.cc",
                "line": 23,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "999423020978569411",
                "participant_id": "3609024002074859509"
              },
              "type": "return"
            },
            {
              "from": {
                "activity_id": "999423020978569411",
                "participant_id": "3609024002074859509"
              },
              "name": "",
              "return_type": "int",
              "scope": "normal",
              "source_location": {
                "column": 16,
                "file": "t20021.cc",
                "line": 22,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "13461048163044463326",
                "participant_id": "13461048163044463326"
              },
              "type": "return"
            },
            {
              "from": {
                "activity_id": "13461048163044463326",
                "participant_id": "13461048163044463326"
              },
              "name": "a3()",
              "return_type": "int",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20021.cc",
                "line": 38,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "14943641868999129521",
                "participant_id": "10243868858636085846"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "14943641868999129521",
                "participant_id": "10243868858636085846"
              },
              "name": "",
              "return_type": "int",
              "scope": "normal",
              "source_location": {
                "column": 16,
                "file": "t20021.cc",
                "line": 8,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "13461048163044463326",
                "participant_id": "13461048163044463326"
              },
              "type": "return"
            },
            {
              "activity_id": "13461048163044463326",
              "messages": [
                {
                  "activity_id": "13461048163044463326",
                  "messages": [
                    {
                      "from": {
                        "activity_id": "13461048163044463326",
                        "participant_id": "13461048163044463326"
                      },
                      "name": "a2()",
                      "return_type": "int",
                      "scope": "condition",
                      "source_location": {
                        "column": 26,
                        "file": "t20021.cc",
                        "line": 40,
                        "translation_unit": "t20021.cc"
                      },
                      "to": {
                        "activity_id": "9114358382067320148",
                        "participant_id": "10243868858636085846"
                      },
                      "type": "message"
                    },
                    {
                      "from": {
                        "activity_id": "9114358382067320148",
                        "participant_id": "10243868858636085846"
                      },
                      "name": "",
                      "return_type": "int",
                      "scope": "normal",
                      "source_location": {
                        "column": 16,
                        "file": "t20021.cc",
                        "line": 7,
                        "translation_unit": "t20021.cc"
                      },
                      "to": {
                        "activity_id": "13461048163044463326",
                        "participant_id": "13461048163044463326"
                      },
                      "type": "return"
                    },
                    {
                      "from": {
                        "activity_id": "13461048163044463326",
                        "participant_id": "13461048163044463326"
                      },
                      "name": "c1()",
                      "return_type": "int",
                      "scope": "condition",
                      "source_location": {
                        "column": 38,
                        "file": "t20021.cc",
                        "line": 40,
                        "translation_unit": "t20021.cc"
                      },
                      "to": {
                        "activity_id": "17150117920578586424",
                        "participant_id": "3609024002074859509"
                      },
                      "type": "message"
                    },
                    {
                      "from": {
                        "activity_id": "17150117920578586424",
                        "participant_id": "3609024002074859509"
                      },
                      "name": "",
                      "return_type": "int",
                      "scope": "normal",
                      "source_location": {
                        "column": 16,
                        "file": "t20021.cc",
                        "line": 19,
                        "translation_unit": "t20021.cc"
                      },
                      "to": {
                        "activity_id": "13461048163044463326",
                        "participant_id": "13461048163044463326"
                      },
                      "type": "return"
                    },
                    {
                      "from": {
                        "activity_id": "13461048163044463326",
                        "participant_id": "13461048163044463326"
                      },
                      "name": "c2()",
                      "return_type": "int",
                      "scope": "condition",
                      "source_location": {
                        "column": 51,
                        "file": "t20021.cc",
                        "line": 40,
                        "translation_unit": "t20021.cc"
                      },
                      "to": {
                        "activity_id": "13661547835268008141",
                        "participant_id": "3609024002074859509"
                      },
                      "type": "message"
                    },
                    {
                      "from": {
                        "activity_id": "13661547835268008141",
                        "participant_id": "3609024002074859509"
                      },
                      "name": "",
                      "return_type": "int",
                      "scope": "normal",
                      "source_location": {
                        "column": 16,
                        "file": "t20021.cc",
                        "line": 20,
                        "translation_unit": "t20021.cc"
                      },
                      "to": {
                        "activity_id": "13461048163044463326",
                        "participant_id": "13461048163044463326"
                      },
                      "type": "return"
                    },
                    {
                      "from": {
                        "activity_id": "13461048163044463326",
                        "participant_id": "13461048163044463326"
                      },
                      "name": "a1()",
                      "return_type": "int",
                      "scope": "normal",
                      "source_location": {
                        "column": 17,
                        "file": "t20021.cc",
                        "line": 41,
                        "translation_unit": "t20021.cc"
                      },
                      "to": {
                        "activity_id": "13275908397574487940",
                        "participant_id": "10243868858636085846"
                      },
                      "type": "message"
                    },
                    {
                      "from": {
                        "activity_id": "13275908397574487940",
                        "participant_id": "10243868858636085846"
                      },
                      "name": "",
                      "return_type": "int",
                      "scope": "normal",
                      "source_location": {
                        "column": 16,
                        "file": "t20021.cc",
                        "line": 6,
                        "translation_unit": "t20021.cc"
                      },
                      "to": {
                        "activity_id": "13461048163044463326",
                        "participant_id": "13461048163044463326"
                      },
                      "type": "return"
                    }
                  ],
                  "name": "for",
                  "type": "loop"
                },
                {
                  "from": {
                    "activity_id": "13461048163044463326",
                    "participant_id": "13461048163044463326"
                  },
                  "name": "c3()",
                  "return_type": "int",
                  "scope": "condition",
                  "source_location": {
                    "column": 23,
                    "file": "t20021.cc",
                    "line": 42,
                    "translation_unit": "t20021.cc"
                  },
                  "to": {
                    "activity_id": "10423142025974403121",
                    "participant_id": "3609024002074859509"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "10423142025974403121",
                    "participant_id": "3609024002074859509"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 16,
                    "file": "t20021.cc",
                    "line": 21,
                    "translation_unit": "t20021.cc"
                  },
                  "to": {
                    "activity_id": "13461048163044463326",
                    "participant_id": "13461048163044463326"
                  },
                  "type": "return"
                }
              ],
              "name": "do",
              "type": "loop"
            }
          ],
          "name": "while",
          "type": "loop"
        },
        {
          "activity_id": "13461048163044463326",
          "messages": [
            {
              "from": {
                "activity_id": "13461048163044463326",
                "participant_id": "13461048163044463326"
              },
              "name": "b2() const",
              "return_type": "int",
              "scope": "normal",
              "source_location": {
                "column": 19,
                "file": "t20021.cc",
                "line": 47,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "12488327994212504617",
                "participant_id": "14797568643547163151"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "12488327994212504617",
                "participant_id": "14797568643547163151"
              },
              "name": "",
              "return_type": "int",
              "scope": "normal",
              "source_location": {
                "column": 22,
                "file": "t20021.cc",
                "line": 15,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "13461048163044463326",
                "participant_id": "13461048163044463326"
              },
              "type": "return"
            }
          ],
          "name": "for",
          "type": "loop"
        },
        {
          "activity_id": "13461048163044463326",
          "messages": [
            {
              "from": {
                "activity_id": "13461048163044463326",
                "participant_id": "13461048163044463326"
              },
              "name": "contents()",
              "return_type": "std::vector<int> &",
              "scope": "condition",
              "source_location": {
                "column": 27,
                "file": "t20021.cc",
                "line": 50,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "6515241731085583713",
                "participant_id": "3609024002074859509"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "6515241731085583713",
                "participant_id": "3609024002074859509"
              },
              "name": "",
              "return_type": "std::vector<int> &",
              "scope": "normal",
              "source_location": {
                "column": 36,
                "file": "t20021.cc",
                "line": 25,
                "translation_unit": "t20021.cc"
              },
              "to": {
                "activity_id": "13461048163044463326",
                "participant_id": "13461048163044463326"
              },
              "type": "return"
            }
          ],
          "name": "for",
          "type": "loop"
        },
        {
          "from": {
            "activity_id": "13461048163044463326",
            "participant_id": "13461048163044463326"
          },
          "name": "b2() const",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20021.cc",
            "line": 54,
            "translation_unit": "t20021.cc"
          },
          "to": {
            "activity_id": "12488327994212504617",
            "participant_id": "14797568643547163151"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "12488327994212504617",
            "participant_id": "14797568643547163151"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 22,
            "file": "t20021.cc",
            "line": 15,
            "translation_unit": "t20021.cc"
          },
          "to": {
            "activity_id": "13461048163044463326",
            "participant_id": "13461048163044463326"
          },
          "type": "return"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20021"
}
```
## Generated GraphML models
