<!-- This file is autogenerated! Do not modify it -->

# Voyager

[:material-play-circle: Run this example](https://numbat.dev/?q=%23+How+many+photons+are+received+per+bit+transmitted+from+Voyager+1%3F%0A%23%0A%23+This+calculation+is+adapted+from+a+Physics+Stack+Exchange+answer+%5B1%5D.%0A%23%0A%23+%5B1%5D+https%3A%2F%2Fphysics.stackexchange.com%2Fa%2F816710%0A%0A%23+Voyager+radio+transmission%3A%0Alet+datarate+%3D+160+bps%0Alet+f+%3D+8.3+GHz%0Alet+P_transmit+%3D+23+W%0A%0Alet+%CF%89+%3D+2%CF%80+f%0Alet+%CE%BB+%3D+c+%2F+f%0A%0A%40aliases%28photon%29%0Aunit+photons%0A%0Alet+energy_per_photon+%3D+%E2%84%8F+%CF%89+%2F+photon%0A%0Alet+photon_rate+%3D+P_transmit+%2F+energy_per_photon+-%3E+photons%2Fs%0A%0Aprint%28%22Voyager+sends+data+at+a+rate+of+%7Bdatarate%7D+with+%7BP_transmit%7D.%22%29%0Aprint%28%22At+a+frequency+of+%7Bf%7D%2C+this+amounts+to+%7Bphoton_rate%3A.0e%7D.%22%29%0A%0A%23+Voyager+dish+antenna%3A%0Alet+d_voyager+%3D+3.7+m%0A%0A%23+Voyagers+distance+to+Earth%3A%0Alet+R+%3D+23.5+billion+kilometers++%23+as+of+2024%0A%0A%23+Diameter+of+receiver+dish%3A%0Alet+d_receiver+%3D+70+m%0A%0Alet+irradiance+%3D+P_transmit+%2F+%284%CF%80+R%C2%B2%29%0Alet+P_received%3A+Power+%3D+irradiance+%C3%97+%28%CF%80+d_voyager+%2F+%CE%BB%29%C2%B2+%C3%97+%28%CF%80+d_receiver%C2%B2+%2F+4%29%0A%0Aprint%28%22A+%7Bd_receiver%7D+dish+on+Earth+will+receive+%7BP_received+-%3E+aW%3A.1f%7D+of+power.%22%29%0A%0Alet+photon_rate_receiver+%3D+P_received+%2F+energy_per_photon+-%3E+photons%2Fs%0Alet+photons_per_bit+%3D+photon_rate_receiver+%2F+datarate+-%3E+photons%2Fbit%0A%0Aprint%28%29%0Aprint%28%22This+corresponds+to+%7Bphoton_rate_receiver%7D.%22%29%0Aprint%28%22Which+means+%7Bphotons_per_bit%3A.0%7D.%22%29%0A){ .md-button .md-button--primary }

```numbat
# How many photons are received per bit transmitted from Voyager 1?
#
# This calculation is adapted from a Physics Stack Exchange answer [1].
#
# [1] https://physics.stackexchange.com/a/816710

# Voyager radio transmission:
let datarate = 160 bps
let f = 8.3 GHz
let P_transmit = 23 W

let ω = 2π f
let λ = c / f

@aliases(photon)
unit photons

let energy_per_photon = ℏ ω / photon

let photon_rate = P_transmit / energy_per_photon -> photons/s

print("Voyager sends data at a rate of {datarate} with {P_transmit}.")
print("At a frequency of {f}, this amounts to {photon_rate:.0e}.")

# Voyager dish antenna:
let d_voyager = 3.7 m

# Voyagers distance to Earth:
let R = 23.5 billion kilometers  # as of 2024

# Diameter of receiver dish:
let d_receiver = 70 m

let irradiance = P_transmit / (4π R²)
let P_received: Power = irradiance × (π d_voyager / λ)² × (π d_receiver² / 4)

print("A {d_receiver} dish on Earth will receive {P_received -> aW:.1f} of power.")

let photon_rate_receiver = P_received / energy_per_photon -> photons/s
let photons_per_bit = photon_rate_receiver / datarate -> photons/bit

print()
print("This corresponds to {photon_rate_receiver}.")
print("Which means {photons_per_bit:.0}.")
```
