<!-- @generated by usage-cli from usage spec -->
# `mise prepare`

- **Usage**: `mise prepare [FLAGS] [PROVIDER]`
- **Aliases**: `prep`
- **Source code**: [`src/cli/prepare.rs`](https://github.com/jdx/mise/blob/main/src/cli/prepare.rs)

[experimental] Ensure project dependencies are ready

Runs all applicable prepare steps for the current project.
This checks if dependency lockfiles are newer than installed outputs
(e.g., package-lock.json vs node_modules/) and runs install commands
if needed.

Providers with `auto = true` are automatically invoked before `mise x` and `mise run`
unless skipped with the --no-prepare flag.

## Arguments

### `[PROVIDER]`

Provider to operate on (runs only this provider, or use with --explain)

## Flags

### `--explain`

Show why a provider is fresh or stale (requires a provider argument)

### `-f --force`

Force run all prepare steps even if outputs are fresh

### `-n --dry-run`

Only check if prepare is needed, don't run commands

### `--list`

Show what prepare steps are available

### `--only… <ONLY>`

Run specific prepare rule(s) only

### `--skip… <SKIP>`

Skip specific prepare rule(s)

Examples:

```
mise prepare              # Run all applicable prepare steps
mise prepare npm          # Run only npm prepare
mise prepare npm --explain # Show why npm is fresh or stale
mise prepare --dry-run    # Show what would run without executing
mise prepare --force      # Force run even if outputs are fresh
mise prepare --list       # List available prepare providers
mise prepare --skip npm   # Skip npm prepare
```

Configuration:

```
Configure prepare providers in mise.toml:

```toml
# Built-in npm provider (auto-detects lockfile)
[prepare.npm]
auto = true              # Auto-run before mise x/run

# Custom provider
[prepare.codegen]
auto = true
sources = ["schema/*.graphql"]
outputs = ["src/generated/"]
run = "npm run codegen"

[prepare]
disable = ["npm"]        # Disable specific providers at runtime
```
```
