pub fn instruction_str(opcode: u8) -> &'static str {
    match opcode {
        0x00 => "NOP",
        0x01 => "TCALL 0",
        0x02 => "SET1 d.0",
        0x03 => "BBS d.0, r",
        0x04 => "OR A, d",
        0x05 => "OR A, !a",
        0x06 => "OR A, (X)",
        0x07 => "OR A, [d+X]",
        0x08 => "OR A, #i",
        0x09 => "OR dd, ds",
        0x0A => "OR1 C, m.b",
        0x0B => "ASL d",
        0x0C => "ASL !a",
        0x0D => "PUSH PSW",
        0x0E => "TSET1 !a",
        0x0F => "BRK",
        0x10 => "BPL r",
        0x11 => "TCALL 1",
        0x12 => "CLR1 d.0",
        0x13 => "BBC d.0, r",
        0x14 => "OR A, d+X",
        0x15 => "OR A, !a+X",
        0x16 => "OR A, !a+Y",
        0x17 => "OR A, [d]+Y",
        0x18 => "OR d, #i",
        0x19 => "OR (X), (Y)",
        0x1A => "DECW d",
        0x1B => "ASL d+X",
        0x1C => "ASL A",
        0x1D => "DEC X",
        0x1E => "CMP X, !a",
        0x1F => "JMP [!a+X]",
        0x20 => "CLRP",
        0x21 => "TCALL 2",
        0x22 => "SET1 d.1",
        0x23 => "BBS d.1, r",
        0x24 => "AND A, d",
        0x25 => "AND A, !a",
        0x26 => "AND A, (X)",
        0x27 => "AND A, [d+X]",
        0x28 => "AND A, #i",
        0x29 => "AND dd, ds",
        0x2A => "OR1 C, /m.b",
        0x2B => "ROL d",
        0x2C => "ROL !a",
        0x2D => "PUSH A",
        0x2E => "CBNE d, r",
        0x2F => "BRA r",
        0x30 => "BMI r",
        0x31 => "TCALL 3",
        0x32 => "CLR1 d.1",
        0x33 => "BBC d.1, r",
        0x34 => "AND A, d+X",
        0x35 => "AND A, !a+X",
        0x36 => "AND A, !a+Y",
        0x37 => "AND A, [d]+Y",
        0x38 => "AND d, #i",
        0x39 => "AND (X), (Y)",
        0x3A => "INCW d",
        0x3B => "ROL d+X",
        0x3C => "ROL A",
        0x3D => "INC X",
        0x3E => "CMP X, d",
        0x3F => "CALL !a",
        0x40 => "SETP",
        0x41 => "TCALL 4",
        0x42 => "SET1 d.2",
        0x43 => "BBS d.2, r",
        0x44 => "EOR A, d",
        0x45 => "EOR A, !a",
        0x46 => "EOR A, (X)",
        0x47 => "EOR A, [d+X]",
        0x48 => "EOR A, #i",
        0x49 => "EOR dd, ds",
        0x4A => "AND1 C, m.b",
        0x4B => "LSR d",
        0x4C => "LSR !a",
        0x4D => "PUSH X",
        0x4E => "TCLR !a",
        0x4F => "PCALL u",
        0x50 => "BVC r",
        0x51 => "TCALL 5",
        0x52 => "CLR1 d.2",
        0x53 => "BBC d.2, r",
        0x54 => "EOR A, d+X",
        0x55 => "EOR A, !a+X",
        0x56 => "EOR A, !a+Y",
        0x57 => "EOR A, [d]+Y",
        0x58 => "EOR d, #i",
        0x59 => "EOR (X), (Y)",
        0x5A => "CMPW YA, d",
        0x5B => "LSR d+X",
        0x5C => "LSR A",
        0x5D => "MOV X, A",
        0x5E => "CMP Y, !a",
        0x5F => "JMP !a",
        0x60 => "CLRC",
        0x61 => "TCALL 6",
        0x62 => "SET1 d.3",
        0x63 => "BBS d.3, r",
        0x64 => "CMP A, d",
        0x65 => "CMP A, !a",
        0x66 => "CMP A, (X)",
        0x67 => "CMP A, [d+X]",
        0x68 => "CMP A, #i",
        0x69 => "CMP dd, ds",
        0x6A => "AND1 C, /m.b",
        0x6B => "ROR d",
        0x6C => "ROR !a",
        0x6D => "PUSH Y",
        0x6E => "DBNZ d, r",
        0x6F => "RET",
        0x70 => "BVS r",
        0x71 => "TCALL 7",
        0x72 => "CLR1 d.3",
        0x73 => "BBC d.3, r",
        0x74 => "CMP A, d+X",
        0x75 => "CMP A, !a+X",
        0x76 => "CMP A, !a+Y",
        0x77 => "CMP A, [d]+Y",
        0x78 => "CMP d, #i",
        0x79 => "CMP (X), (Y)",
        0x7A => "ADDW YA, d",
        0x7B => "ROR d+x",
        0x7C => "ROR A",
        0x7D => "MOV A, X",
        0x7E => "CMP Y, d",
        0x7F => "RETI",
        0x80 => "SETC",
        0x81 => "TCALL 8",
        0x82 => "SET1 d.4",
        0x83 => "BBS d.4, r",
        0x84 => "ADC A, d",
        0x85 => "ADC A, !a",
        0x86 => "ADC A, (X)",
        0x87 => "ADC A, [d+X]",
        0x88 => "ADC A, #i",
        0x89 => "ADC dd, ds",
        0x8A => "EOR1 C, m.b",
        0x8B => "DEC d",
        0x8C => "DEC !a",
        0x8D => "MOV Y, #i",
        0x8E => "POP PSW",
        0x8F => "MOV d, #i",
        0x90 => "BCC r",
        0x91 => "TCALL 9",
        0x92 => "CLR1 d.4",
        0x93 => "BBC d.4, r",
        0x94 => "ADC A, d+X",
        0x95 => "ADC A, !a+X",
        0x96 => "ADC A, !a+Y",
        0x97 => "ADC A, [d]+Y",
        0x98 => "ADC d, #i",
        0x99 => "ADC (X), (Y)",
        0x9A => "SUBW YA, d",
        0x9B => "DEC d+X",
        0x9C => "DEC A",
        0x9D => "MOV X, SP",
        0x9E => "DIV YA, X",
        0x9F => "XCN A",
        0xA0 => "EI",
        0xA1 => "TCALL 10",
        0xA2 => "SET1 d.5",
        0xA3 => "BBS d.5, r",
        0xA4 => "SBC A, d",
        0xA5 => "SBC A, !a",
        0xA6 => "SBC A, (X)",
        0xA7 => "SBC A, [d+X]",
        0xA8 => "SBC A, #i",
        0xA9 => "SBC dd, ds",
        0xAA => "MOV1 C, m.b",
        0xAB => "INC d",
        0xAC => "INC !a",
        0xAD => "CMP Y, #i",
        0xAE => "POP A",
        0xAF => "MOV (X)+, A",
        0xB0 => "BCS r",
        0xB1 => "TCALL 11",
        0xB2 => "CLR1 d.5",
        0xB3 => "BBC d.5, r",
        0xB4 => "SBC a, d+X",
        0xB5 => "SBC A, !a+X",
        0xB6 => "SBC A, !a+Y",
        0xB7 => "SBC A, [d]+Y",
        0xB8 => "SBC d, #i",
        0xB9 => "SBC (X), (Y)",
        0xBA => "MOVW YA, d",
        0xBB => "INC d+X",
        0xBC => "INC A",
        0xBD => "MOV SP, X",
        0xBE => "DAS A",
        0xBF => "MOV A, (X)+",
        0xC0 => "DI",
        0xC1 => "TCALL 12",
        0xC2 => "SET1 d.6",
        0xC3 => "BBS d.6, r",
        0xC4 => "MOV d, A",
        0xC5 => "MOV !a, A",
        0xC6 => "MOV (X), A",
        0xC7 => "MOV [d+X], A",
        0xC8 => "CMP X, #i",
        0xC9 => "MOV !a, X",
        0xCA => "MOV1 m.b, C",
        0xCB => "MOV d, Y",
        0xCC => "MOV !a, Y",
        0xCD => "MOV X, #i",
        0xCE => "POP X",
        0xCF => "MUL YA",
        0xD0 => "BNE r",
        0xD1 => "TCALL 13",
        0xD2 => "CLR1 d.6",
        0xD3 => "BBC d.6, r",
        0xD4 => "MOV d+X, A",
        0xD5 => "MOV !a+X, A",
        0xD6 => "MOV !a+Y, A",
        0xD7 => "MOV [d]+Y, A",
        0xD8 => "MOV d, X",
        0xD9 => "MOV d+Y, X",
        0xDA => "MOVW d, YA",
        0xDB => "MOV d+X, Y",
        0xDC => "DEC Y",
        0xDD => "MOV A, Y",
        0xDE => "CBNE d+X, r",
        0xDF => "DAA A",
        0xE0 => "CLRV",
        0xE1 => "TCALL 14",
        0xE2 => "SET1 d.7",
        0xE3 => "BBS d.7, r",
        0xE4 => "MOV A, d",
        0xE5 => "MOV A, !a",
        0xE6 => "MOV A, (X)",
        0xE7 => "MOV A, [d+X]",
        0xE8 => "MOV A, #i",
        0xE9 => "MOV X, !a",
        0xEA => "NOT1 m.b",
        0xEB => "MOV Y, d",
        0xEC => "MOV Y, !a",
        0xED => "NOTC",
        0xEE => "POP Y",
        0xEF => "SLEEP",
        0xF0 => "BEQ r",
        0xF1 => "TCALL 15",
        0xF2 => "CLR1 d.7",
        0xF3 => "BBC d.7, r",
        0xF4 => "MOV A, d+X",
        0xF5 => "MOV A, !a+X",
        0xF6 => "MOV A, !a+Y",
        0xF7 => "MOV A, [d]+Y",
        0xF8 => "MOV X, d",
        0xF9 => "MOV X, d+Y",
        0xFA => "MOV dd, ds",
        0xFB => "MOV Y, d+X",
        0xFC => "INC Y",
        0xFD => "MOV Y, A",
        0xFE => "DBNZ Y, r",
        0xFF => "STOP",
    }
}
