open class Step {
    /// Which profiles (HK_PROFILES) need to be active for the step to run
    profiles: Listing<String>?

    /// Which file patterns to run the step on
    glob: Listing<String>?

    /// If true, the step will run by itself, waiting for previous steps to finish before starting and making later steps wait for it to finish
    exclusive = false

    /// Wait for sibling steps to finish before starting this step.
    depends = new Listing<String>{}

    /// If true, when intending to run the fix command for this step, if any other steps in the same group need to read to the same files, this step will run the check command instead
    /// if it fails, the fix command will be run after
    /// Note that this behavior is only used if multiple steps would be in contention. If all fix steps edit disjoint files, the fix step will be chosen first despite this config.
    check_first = true

    /// fetches a read lock instead of a write lock when running fix/fix_all. Use if the tool has its own locking mechanism or you simply don't care if files may be written to
    /// by multiple steps.
    stomp = true

    /// a shell command to check. Any edits will be ignored.
    check: String?

    /// a shell command that checks and edits files. Edits will be automatically added to the index.
    fix: String?

    /// a shell command to check on all files
    /// if check_all is not set, this will just use the check command and pass all files in the repo as {{files}}
    check_all: String?

    /// a shell command that checks and edits files. Edits will be automatically added to the index.
    fix_all: String?

    /// globs of files to add to git index after running a fix/fix_all step
    /// if not set, all files will be added
    stage: Listing<String>?
}

typealias Hook = Mapping<String, Step>

min_hk_version: String?

`pre-commit`: Hook?
`pre-push`: Hook?
