Like the previous month was the first in 2025 with plenty of news to share, this month is a first as well: I seem to have nothing to write about.

Sure, there were a couple of smaller API improvements, but nothing that would inspire me.
So what did I do all this time? Probably this is the moment where there really is no other way but to talk about GitButler, something I avoided last month just because it doesn't seem to belong into the `gitoxide` newsletter.

## GitButler

[GitButler](https://gitbutler.com) is what I have been working on intensely for the last two months effectively, in a push to help it to unfold its true potential. Thus far it was mostly powered by `git2`, with `gitoxide` sprinkled in there, but the next iteration will be the inverse with `git2` only being used where `gitoxide` is lacking a feature. That way, along with massive architectural changes, it will be able to cope with large repositories and be more compatible with various Git features, too.

I cannot wait to see all this work to finally come to fruition, and of course, to also see myself being pulled to a user interface that truly elevates my workflow and the workflow of other devs just like me who thus far preferred to stay on the command-line.

## Community

### Faster `gix blame`

Christoph Rüßler kept working and managed to greatly improve the `gix blame` performance while increasing its conformance to Git at the same time. This means that now, depending on the sample, `gix blame` *can* be a bit faster than Git, but it typically is still up to 30% slower when commitgraph caches are used. Overall though, the performance is nothing to sneeze at, and it competes quite well except for in pathological cases.
Admittedly, I am quite blown away by the performance and have a feeling that last time I checked, I didn't use the latest version of the `gix` binary.
It's worth noting that rename-tracking still isn't support, but I also see no reason why it shouldn't be eventually, a feature that would make `gix blame` so much more useful in practice.

### `gix blame` with experimental cache

A pretty [slim PR](https://github.com/GitoxideLabs/gitoxide/pull/1852) shows how to use a special cache to greatly speedup blames, from ~300ms down to just ~4ms, a massive 75x speedup that would be very useful for editors and IDEs, or forges, I am sure!
Of course, one first has to build such cache, and probably do so per file, but I am sure there are plenty of use-cases for it when it's driven by dev tooling.

### Gix in Cargo

With `gix status` now available I am planning to integrate it as soon as possible! That didn't happen yet, but… it will, the stack to work off before I can start this is pretty high though so it's unlikely to happen anytime soon.

Cheers
Sebastian

PS: The latest timesheets can be found [here (2025)](https://github.com/Byron/byron/blob/main/timesheets/2025.csv). 