# dprint

[![CI](https://github.com/dprint/dprint/workflows/CI/badge.svg)](https://github.com/dprint/dprint/actions?query=workflow%3ACI)
[![Homebrew](https://img.shields.io/badge/dynamic/json.svg?url=https://formulae.brew.sh/api/formula/dprint.json&query=$.versions.stable&label=homebrew)](https://formulae.brew.sh/formula/dprint)

Monorepo for dprint—a pluggable and configurable code formatting platform.

## Links

- [Overview](https://dprint.dev/overview)
- [Getting Started](https://dprint.dev/install)
- [Playground](https://dprint.dev/playground)

## Plugins

See https://dprint.dev/plugins/

Repos:

- [dprint-plugin-typescript](https://github.com/dprint/dprint-plugin-typescript) - TypeScript/JavaScript code formatter.
- [dprint-plugin-json](https://github.com/dprint/dprint-plugin-json) - JSON/JSONC code formatter.
- [dprint-plugin-markdown](https://github.com/dprint/dprint-plugin-markdown) - Markdown code formatter.
- [dprint-plugin-toml](https://github.com/dprint/dprint-plugin-toml) - TOML code formatter.
- [dprint-plugin-jupyter](https://github.com/dprint/dprint-plugin-jupyter) - Jupyter notebook code block formatter.
- [dprint-plugin-dockerfile](https://github.com/dprint/dprint-plugin-dockerfile) - Dockerfile code formatter.
- [dprint-plugin-biome](https://github.com/dprint/dprint-plugin-biome) - Biome (JS/TS) wrapper plugin.
- [dprint-plugin-prettier](https://github.com/dprint/dprint-plugin-prettier) - Prettier wrapper plugin.
- [dprint-plugin-roslyn](https://github.com/dprint/dprint-plugin-roslyn) - Roslyn (C#/VB) wrapper plugin.
- [dprint-plugin-ruff](https://github.com/dprint/dprint-plugin-ruff) - Ruff (Python) wrapper plugin.
- [dprint-plugin-exec](https://github.com/dprint/dprint-plugin-exec) - Formats code with any CLI executable.
- [Malva](https://github.com/g-plane/malva) - CSS, SCSS, Sass, and Less formatter
- [markup_fmt](https://github.com/g-plane/markup_fmt) - HTML, Vue, Svelte, Astro, Angular, Jinja, Twig, Nunjucks, Vento, Mustache and XML formatter.
- [pretty_graphql](https://github.com/g-plane/pretty_graphql) - GraphQL formatter.
- [pretty_yaml](https://github.com/g-plane/pretty_yaml) - YAML formatter.

## Notes

I do a lot of this development in my spare time. Please consider [sponsoring](https://dprint.dev/sponsor) if you are a commercial company using this.
