# Change-log

## 3.16.1.0 [Artem Pelenitsyn](mailto:a@pelenitsyn.top) November 2025

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.16.1.0.md

## 3.16.0.0 [Artem Pelenitsyn](mailto:a@pelenitsyn.top) July 2025

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.16.0.0.md

## 3.14.2.0 [Mikolaj Konarski](mailto:mikolaj@well-typed.com) April 2025

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.14.2.0.md

## 3.14.1.0 (Hécate [hecate+github@glitchbra.in](mailto:hecate+github@glitchbra.in) November 2024)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.14.1.0.md


## 3.14.0.0 (Hécate [hecate+github@glitchbra.in](mailto:hecate+github@glitchbra.in) September 2024)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.14.0.0.md


## 3.12.1.0 (Artem Pelenitsyn [a.pelenitsyn@gmail.com](mailto:a.pelenitsyn@gmail.com) June 2024)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.12.1.0.md


## 3.10.3.0 (Hécate [hecate+github@glitchbra.in](mailto:hecate+github@glitchbra.in) January 2024)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.10.3.0.md


## 3.10.2.1 (Hécate [hecate+github@glitchbra.in](mailto:hecate+github@glitchbra.in) November 2023)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.10.2.1.md


## 3.10.2.0 (Hécate [hecate+github@glitchbra.in](mailto:hecate+github@glitchbra.in) November 2023)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.10.2.0.md


## 3.10.1.0 (Mikolaj Konarski [mikolaj@well-typed.com](mailto:mikolaj@well-typed.com) March 2023)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.10.1.0.md


## 3.8.1.0 (Mikolaj Konarski [mikolaj@well-typed.com](mailto:mikolaj@well-typed.com) August 2022)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.8.1.0.md


## 3.6.2.0 (Emily Pillmore [emilypi@cohomolo.gy](mailto:emilypi@cohomolo.gy) October 2021)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.6.2.0.md


## 3.6.0.0 (Emily Pillmore [emilypi@cohomolo.gy](mailto:emilypi@cohomolo.gy) August 2021)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.6.0.0.md


## 3.4.1.0 (Emily Pillmore [emilypi@cohomolo.gy](mailto:emilypi@cohomolo.gy) October 2021)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.4.1.0.md


## 3.4.0.0 (Oleg Grenrus [oleg.grenrus@iki.fi](mailto:oleg.grenrus@iki.fi) February 2021)

* See https://github.com/haskell/cabal/blob/master/release-notes/cabal-install-3.4.0.0.md


## 3.2.0.0 (Herbert Valerio Riedel [hvr@gnu.org](mailto:hvr@gnu.org) April 2020)

* `v2-build` (and other `v2-`prefixed commands) now accept the `--benchmark-option(s)` flags, which pass options to benchmark executables (analogous to how `--test-option(s)` works). (\#6209)
* Add solver optimization to skip a version of a package if it does not resolve any conflicts encountered in the last version, controlled by flag '--fine-grained-conflicts'. (\#5918)
* `cabal v2-exec` doesn't fail in clean package (\#6479)
* Show full ABI hash for installed packages in solver log (\#5892)
* Create incoming directory even for empty packages (\#4130)
* Start GHCi with `main-is` module in scope (\#6311)
* Implement `--benchmark-options` for `v2-bench` (\#6224)
* Fix store-dir in ghc env files generated by `cabal install --lib --package-env` (\#6298)
* `cabal v2-run` works with `.lhs` files (\#6134)
* `subdir` in source-repository-package accepts multiple entries (\#5472)


## 3.0.1.0 (Herbert Valerio Riedel [hvr@gnu.org](mailto:hvr@gnu.org) April 2020)

* Create store incoming directory (\#4130)
* `fetchRepoTarball` output is not marked (\#6385)
* Update `setupMinCabalVersionConstraint` for GHC-8.8 (\#6217)
* Implement `cabal install --ignore-project` (\#5919)
* `cabal install executable` solver isn't affected by default environment contents (\#6410)
* Use `lukko` for file locking (\#6345)
* Use `hackage-security-0.6` (\#6388)
* Other dependency upgrades


## 3.0.0.0 (Mikhail Glushenkov [mikhail.glushenkov@gmail.com](mailto:mikhail.glushenkov@gmail.com) August 2019)

* `v2-haddock` fails on `haddock` failures (\#5977)
* `v2-run` works when given `File.lhs` literate file. (\#6134)
* Parse comma-separated lists for extra-prog-path, extra-lib-dirs, extra-framework-dirs, and extra-include-dirs as actual lists. (\#5420)
* `v2-repl` no longer changes directory to a randomized temporary folder when used outside of a project. (\#5544)
* `install-method` and `overwrite-policy` in `.cabal/config` now actually work. (\#5942)
* `v2-install` now reports the error when a package fails to build. (\#5641)
* `v2-install` now has a default when called in a project (\#5978, \#6014, \#6092)
* '--write-ghc-environment-files' now defaults to 'never' (\#4242)
* Fix `sdist`'s output when sent to stdout. (\#5874)
* Allow a list of dependencies to be provided for `repl --build-depends`. (\#5845)
* Legacy commands are now only accessible with the `v1-` prefixes, and the `v2-` commands are the new default. Accordingly, the next version of Cabal will be the start of the 3.x version series. (\#5800)
* New solver flag: '--reject-unconstrained-dependencies'. (\#2568)
* Ported old-style test options to the new-style commands (\#5455).
* Improved error messages for cabal file parse errors. (\#5710)
* Removed support for `.zip` format source distributions (\#5755)
* Add "simple project" initialization option. (\#5707)
* Add '--minimize-conflict-set' flag to try to improve the solver's error message, but with an increase in run time. (\#5647)
* v2-test now succeeds when there are no test suites. (\#5435)
* Add '--lib', '--exe', and '--libandexe' shorthands to init. (\#5759)
* init now generates valid `Main.lhs` files. (\#5577)
* Init improvements: add flag '--application-dir', and when creating a library also create a MyLib.hs module. (\#5740)
* Add support for generating test-suite via cabal init. (\#5761)
* Increase `max-backjumps` default from 2000 to 4000.
* Make v2-install/new-install-specific flags configurable in ~/.cabal/config
* Add --installdir and --install-method=copy flags to v2-install that make it possible to copy the executable instead of symlinking it
* --symlink-bindir no longer controls the symlinking directory of v2-install (installdir controls both symlinking and copying now)
* Default to non-interactive init.
* Add --test-wrapper that allows a prebuild script to set the test environment.
* Add filterTestFlags: filter test-wrapper for Cabal < 3.0.0.
* Cabal now only builds the minimum of a package for `v2-install` (\#5754, \#6091)


## 2.4.1.0 (Mikhail Glushenkov [mikhail.glushenkov@gmail.com](mailto:mikhail.glushenkov@gmail.com) November 2018)

* Add message to alert user to potential package casing errors. (\#5635)
* new-clean no longer deletes dist-newstyle/src with `-s`. (\#5699)
* 'new-install' now warns when failing to symlink an exe (\#5602)
* Extend 'cabal init' support for 'cabal-version' selection (\#5567)
* 'new-sdist' now generates tarballs with file modification times from a date in 2001. Using the Unix epoch caused problems on Windows. (\#5596)
* Register monolithic packages installed into the store due to a build-tool dependency if they also happen to contain a buildable public lib. (\#5379,\#5604)
* Fixed a Windows bug where cabal-install tried to copy files after moving them (\#5631).
* 'cabal v2-repl' now works for indefinite (in the Backpack sense) components. (\#5619)
* Set data dir environment variable for tarballs and remote repos (\#5469)
* Fix monolithic inplace build tool PATH (\#5633)
* 'cabal init' now supports '-w'/'--with-compiler' flag (\#4936, \#5654)
* Fix ambiguous --builddir on new-install (\#5652)
* Allow relative --storedir (\#5662)
* Respect --dry on new-install (\#5671)
* Warn when new-installing zero exes (\#5666)
* Add 'pkg-cabal-sha256' field to plan.json (\#5695)
* New v2-build flag: '--only-configure'. (\#5578)
* Fixed a 'new-install' failure that manifested when it encountered remote source dependencies in a project. (\#5643)
* New 'v2-[build,configure' flag: '--write-ghc-environment-files' to control the generation of .ghc.environment files. (\#5711)


## 2.4.0.0 (Mikhail Glushenkov [mikhail.glushenkov@gmail.com](mailto:mikhail.glushenkov@gmail.com) September 2018)

* Bugfix: "cabal new-build --ghc-option '--bogus' --ghc-option '-O1'" no longer ignores all arguments except the last one (\#5512).
* Add the following option aliases for '-dir'-suffixed options: 'storedir', 'logsdir', 'packagedir', 'sourcedir', 'outputdir' (\#5484).
* 'new-run' now allows the user to run scripts that use a special block to define their requirements (as in the executable stanza) in place of a target. This also allows the use of 'cabal' as an interpreter in a shebang line.
* Add aliases for the "new-" commands that won't change when they lose their prefix or are eventually replaced by a third UI paradigm in the future. (\#5429)
* 'outdated' now accepts '--project-file FILE', which will look for bounds from the new-style freeze file named FILE.freeze. This is only available when `--new-freeze-file` has been passed.
* 'new-repl' now accepts a '--build-depends' flag which accepts the same syntax as is used in .cabal files to add additional dependencies to the environment when developing in the REPL. It is now usable outside of projects. (\#5425, \#5454)
* 'new-build' now treats Haddock errors non-fatally. In addition, it attempts to avoid trying to generate Haddocks when there is nothing to generate them from. (\#5232, \#5459)
* 'new-run', 'new-test', and 'new-bench' now will attempt to resolve ambiguous selectors by filtering out selectors that would be invalid. (\#4679, \#5461)
* 'new-install' now supports installing libraries and local components. (\#5399)
* Drop support for GHC 7.4, since it is out of our support window (and has been for over a year!).
* 'new-update' now works outside of projects. (\#5096)
* Extend `plan.json` with `pkg-src` provenance information. (\#5487)
* Add 'new-sdist' command (\#5389). Creates stable archives based on cabal projects in '.zip' and '.tar.gz' formats.
* Add '--repl-options' flag to 'cabal repl' and 'cabal new-repl' commands. Passes its arguments to the invoked repl, bypassing the new-build's cached configurations. This assures they don't trigger useless rebuilds and are always applied within the repl. (\#4247, \#5287)
* Add 'v1-' prefixes for the commands that will be replaced in the new-build universe, in preparation for it becoming the default. (\#5358)
* 'outdated' accepts '--v1-freeze-file' and '--v2-freeze-file' in the same spirit.
* Completed the 'new-clean' command (\#5357). The functionality is equivalent to old-style clean, but for nix-style builds.
* Ensure that each package selected for a build-depends dependency contains a library (\#5304).
* Support packages from local tarballs in the cabal.project file.
* Default changelog generated by 'cabal init' is now named 'CHANGELOG.md' (\#5441).
* Align output of 'new-build' command phases (\#4040).
* Add support for specifying remote VCS dependencies via new 'source-repository-package' stanzas in 'cabal.project' files (\#5351).


## 2.2.0.0 (Mikhail Glushenkov [mikhail.glushenkov@gmail.com](mailto:mikhail.glushenkov@gmail.com) March 2018)

* '--with-PROG' and '--PROG-options' are applied to all packages and not local packages only (\#5019).
* Completed the 'new-update' command (\#4809), which respects nix-style cabal.project(.local) files and allows to update from multiple repositories when using overlays.
* Completed the 'new-run' command (\#4477). The functionality is the same of the old 'run' command but using nix-style builds. Additionally, it can run executables across packages in a project. Tests and benchmarks are also treated as executables, providing a quick way to pass them arguments.
* Completed the 'new-bench' command (\#3638). Same as above.
* Completed the 'new-exec' command (\#3638). Same as above.
* Added a preliminary 'new-install' command (\#4558, nonlocal exes part) which allows to quickly install executables from Hackage.
* Set symlink-bindir (used by new-install) to .cabal/bin by default on .cabal/config initialization (\#5188).
* 'cabal update' now supports '--index-state' which can be used to roll back the index to an earlier state.
* '--allow-{newer,older}' syntax has been enhanced. Dependency relaxation can be now limited to a specific release of a package, plus there's a new syntax for relaxing only caret-style (i.e. '^>=') dependencies (\#4575, \#4669).
* New config file field: 'cxx-options' to specify which options to be passed to the compiler when compiling C++ sources specified by the 'cxx-sources' field. (\#3700)
* New config file field: 'cxx-sources' to specify C++ files to be compiled separately from C source files. Useful in conjunction with the 'cxx-options' flag to pass different compiler options to C and C++ source files. (\#3700)
* Use [lfxtb] letters to differentiate component kind instead of opaque "c" in dist-dir layout.
* 'cabal configure' now supports '--enable-static', which can be used to build static libraries with GHC via GHC's `-staticlib` flag.
* 'cabal user-config now supports '--augment' which can append additional lines to a new or updated cabal config file.
* Added support for '--enable-tests' and '--enable-benchmarks' to 'cabal fetch' (\#4948).
* Misspelled package-names on CLI will no longer be silently case-corrected (\#4778).
* 'cabal new-configure' now backs up the old 'cabal.project.local' file if it exists (\#4460).
* On macOS, `new-build` will now place dynamic libraries into `store/lib` and aggressively shorten their names in an effort to stay within the load command size limits of macOSs mach-o linker.
* 'new-build' now checks for the existence of executables for build-tools and build-tool-depends dependencies in the solver (\#4884).
* Fixed a spurious warning telling the user to run 'cabal update' when it wasn't necessary (\#4444).
* Packages installed in sandboxes via 'add-source' now have their timestamps updated correctly and so will not be reinstalled unnecessarily if the main install command fails (\#1375).
* Add Windows device path support for copyFile, renameFile. Allows cabal new-build to use temporary store path of up to 32k length (\#3972, \#4914, \#4515).
* When a flag value is specified multiple times on the command line, the last one is now preferred, so e.g. '-f+dev -f-dev' is now equivalent to '-f-dev' (\#4452).
* Removed support for building cabal-install with GHC < 7.10 (\#4870).
* New 'package *' section in 'cabal.project' files that applies options to all packages, not just those local to the project.
* Paths_ autogen modules now compile when `RebindableSyntax` or `OverloadedStrings` is used in `default-extensions`. [stack\#3789](https://github.com/commercialhaskell/stack/issues/3789)
* getDataDir`and other`Paths_autogen`functions now work correctly when compiling a custom`Setup.hs`script using`new-build` (\#5164).


## 2.0.0.1 (Mikhail Glushenkov [mikhail.glushenkov@gmail.com](mailto:mikhail.glushenkov@gmail.com) December 2017)

* Support for GHC's numeric -g debug levels (\#4673).
* Demoted 'scope' field version check to a warning (\#4714).
* Fixed verbosity flags getting removed before being passed to 'printPlan' (\#4724).
* Added a '--store-dir' option that can be used to configure the location of the build global build store (\#4623).
* Turned `allow-{newer,older}` in `cabal.project` files into an accumulating field to match CLI flag semantics (\#4679).
* Improve success message when `cabal upload`ing documentation (\#4777).
* Documentation fixes.


## 2.0.0.0 (Mikhail Glushenkov [mikhail.glushenkov@gmail.com](mailto:mikhail.glushenkov@gmail.com) August 2017)

* See http://coldwa.st/e/blog/2017-09-09-Cabal-2-0.html for more detailed release notes.
* Removed the '--root-cmd' parameter of the 'install' command (\#3356).
* Deprecated 'cabal install --global' (\#3356).
* Changed 'cabal upload' to upload a package candidate by default (\#3419). Same applies to uploading documentation.
* Added a new 'cabal upload' flag '--publish' for publishing a package on Hackage instead of uploading a candidate (\#3419).
* Added optional solver output visualisation support via the tracetree package. Mainly intended for debugging (\#3410).
* Removed the '--check' option from 'cabal upload' (\#1823). It was replaced by package candidates.
* Fixed various behaviour differences between network transports (\#3429).
* The bootstrap script now works correctly when run from a Git clone (\#3439).
* Removed the top-down solver (\#3598).
* The '-v/--verbosity' option no longer affects GHC verbosity (except in the case of '-v0'). Use '--ghc-options=-v' to enable verbose GHC output (\#3540, \#3671).
* Changed the default logfile template from '.../$pkgid.log' to '.../$compiler/\$libname.log' (\#3807).
* Added a new command, 'cabal reconfigure', which re-runs 'configure' with the most recently used flags (\#2214).
* Added the '--index-state' flag for requesting a specific version of the package index (\#3893, \#4115).
* Support for building Backpack packages.  See https://github.com/ezyang/ghc-proposals/blob/backpack/proposals/0000-backpack.rst for more details.
* Support the Nix package manager (\#3651).
* Made the 'template-haskell' package non-upgradable again (\#4185).
* Fixed password echoing on MinTTY (\#4128).
* Added a new solver flag, '--allow-boot-library-installs', that allows any package to be installed or upgraded (\#4209).
* New 'cabal-install' command: 'outdated', for listing outdated version bounds in a .cabal file or a freeze file (\#4207).
* Added qualified constraints for setup dependencies. For example, --constraint="setup.bar == 1.0" constrains all setup dependencies on bar, and --constraint="foo:setup.bar == 1.0" constrains foo's setup dependency on bar (part of \#3502).
* Non-qualified constraints, such as --constraint="bar == 1.0", now only apply to top-level dependencies. They don't constrain setup or build-tool dependencies. The new syntax --constraint="any.bar == 1.0" constrains all uses of bar.
* Added a technical preview version of the 'cabal doctest' command (\#4480).


## 1.24.0.2 (Mikhail Glushenkov [mikhail.glushenkov@gmail.com](mailto:mikhail.glushenkov@gmail.com) December 2016)

* Adapted to the revert of a PVP-noncompliant API change in Cabal 1.24.2.0 (\#4123).
* Bumped the directory upper bound to < 1.4 (\#4158).


## 1.24.0.1 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) October 2016)

* Fixed issue with passing '--enable-profiling' when invoking Setup scripts built with older versions of Cabal (\#3873).
* Fixed various behaviour differences between network transports (\#3429).
* Updated to depend on the latest hackage-security that fixes various issues on Windows.
* Fixed 'new-build' to exit with a non-zero exit code on failure (\#3506).
* Store secure repo index data as 01-index.* (\#3862).
* Added new hackage-security root keys for distribution with cabal-install.
* Fix an issue where 'cabal install' sometimes had to be run twice for packages with build-type: Custom and a custom-setup stanza (\#3723).
* 'cabal sdist' no longer ignores '--builddir' when the package's build-type is Custom (\#3794).


## 1.24.0.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) March 2016)

* If there are multiple remote repos, 'cabal update' now updates them in parallel (\#2503).
* New 'cabal upload' option '-P'/'--password-command' for reading Hackage password from arbitrary program output (\#2506).
* Better warning for 'cabal run' (\#2510).
* 'cabal init' now warns if the chosen package name is already registered in the source package index (\#2436).
* New 'cabal install' option: '--offline' (\#2578).
* Accept 'builddir' field in cabal.config (\#2484)
* Read 'builddir' option from 'CABAL_BUILDDIR' environment variable.
* Remote repos may now be configured to use https URLs. This uses either curl or wget or, on Windows, PowerShell, under the hood (\#2687).
* Install target URLs can now use https e.g. 'cabal install https://example.com/foo-1.0.tar.gz'.
* Automatically use https for cabal upload for the main hackage.haskell.org (other repos will use whatever they are configured to use).
* Support for dependencies of custom Setup.hs scripts (see http://www.well-typed.com/blog/2015/07/cabal-setup-deps/).
* 'cabal' program itself now can be used as an external setup method. This fixes an issue when Cabal version mismatch caused unnecessary reconfigures (\#2633).
* Improved error message for unsatisfiable package constraints (\#2727).
* Fixed a space leak in 'cabal update' (\#2826).
* 'cabal exec' and 'sandbox hc-pkg' now use the configured compiler (\#2859).
* New 'cabal haddock' option: '--for-hackage' (\#2852).
* Added a warning when the solver cannot find a dependency (\#2853).
* New 'cabal upload' option: '--doc': upload documentation to hackage (\#2890).
* Improved error handling for 'sandbox delete-source' (\#2943).
* Solver support for extension and language flavours (\#2873).
* Support for secure repos using hackage-security (\#2983).
* Added a log file message similar to one printed by 'make' when building in another directory (\#2642).
* Added new subcommand 'init' to 'cabal user-config'. This subcommand creates a cabal configuration file in either the default location or as specified by --config-file (\#2553).
* The man page for 'cabal-install' is now automatically generated (\#2877).
* The '--allow-newer' option now works as expected when specified multiple times (\#2588).
* New config file field: 'extra-framework-dirs' (extra locations to find OS X frameworks in). Can be also specified as an argument for 'install' and 'configure' commands (\#3158).
* It's now possible to limit the scope of '--allow-newer' to single packages in the install plan (\#2756).
* Full '--allow-newer' syntax is now supported in the config file (that is, 'allow-newer: base, ghc-prim,  some-package:vector') (\#3171).
* Improved performance of '--reorder-goals' (\#3208).
* Fixed space leaks in modular solver (\#2916, \#2914).
* Made the solver aware of pkg-config constraints (\#3023).
* Added a new command: 'gen-bounds' (\#3223). See http://softwaresimply.blogspot.se/2015/08/cabal-gen-bounds-easy-generation-of.html.
* Tech preview of new nix-style isolated project-based builds. Currently provides the commands (new-)build/repl/configure.


## 1.22.9.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) March 2016)

* Include Cabal-1.22.8.0


## 1.22.8.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) February 2016)

* Only Custom setup scripts should be compiled with '-i -i.'.
* installedCabalVersion: Don't special-case Cabal anymore.
* Bump the HTTP upper bound. See \#3069.


## 1.22.7.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) December 2015)

* Remove GZipUtils tests
* maybeDecompress: bail on all errors at the beginning of the stream with zlib < 0.6
* Correct maybeDecompress


## 1.22.6.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) June 2015)

* A fix for @ezyang's fix for \#2502. (Mikhail Glushenkov)


## 1.22.5.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) June 2015)

* Reduce temporary directory name length, fixes \#2502. (Edward Z. Yang)


## 1.22.4.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) May 2015)

* Force cabal upload to always use digest auth and never basic auth.
* Add dependency-graph information to `printPlan` output
* bootstrap.sh: fixes linker matching to avoid cases where tested linker names appear unexpectedly in compiler output (fixes \#2542)


## 1.22.3.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) April 2015)

* Fix bash completion for sandbox subcommands - Fixes \#2513 (Mikhail Glushenkov)
* filterConfigureFlags: filter more flags (Mikhail Glushenkov)


## 1.22.2.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) March 2015)

* Don't pass '--{en,dis}able-profiling' to old setup exes.
* -Wall police
* Allow filepath 1.4


## 1.22.0.0 (Johan Tibell [johan.tibell@gmail.com](mailto:johan.tibell@gmail.com) January 2015)

* New command: user-config (\#2159).
* Implement 'cabal repl --only' (\#2016).
* Fix an issue when 'cabal repl' was doing unnecessary compilation (\#1715).
* Prompt the user to specify source directory in 'cabal init' (\#1989).
* Remove the self-upgrade check (\#2090).
* Don't redownload already downloaded packages when bootstrapping (\#2133).
* Support sandboxes in 'bootstrap.sh' (\#2137).
* Install profiling and shared libs by default in 'bootstrap.sh' (\#2009).


## 1.20.2.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) February 2016)

* Only Custom setup scripts should be compiled with '-i -i.'.
* installedCabalVersion: Don't special-case Cabal anymore.


## 1.20.1.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) May 2015)

* Force cabal upload to always use digest auth and never basic auth.
* bootstrap.sh: install network-uri before HTTP


## 1.20.0.5 (Johan Tibell [johan.tibell@gmail.com](mailto:johan.tibell@gmail.com) December 2014)

* Support random 1.1.
* Fix bootstrap script after network package split.
* Support network-2.6 in test suite.


## 1.20.0.3 (Johan Tibell [johan.tibell@gmail.com](mailto:johan.tibell@gmail.com) June 2014)

* Don't attempt to rename dist if it is already named correctly
* Treat all flags of a package as interdependent.
* Allow template-haskell to be upgradable again


## 1.20.0.2 (Johan Tibell [johan.tibell@gmail.com](mailto:johan.tibell@gmail.com) May 2014)

* Increase max-backjumps to 2000.
* Fix solver bug which led to missed install plans.
* Fix streaming test output.
* Tweak solver heuristics to avoid reinstalls.


## 1.20.0.1 (Johan Tibell [johan.tibell@gmail.com](mailto:johan.tibell@gmail.com) May 2014)

* Fix cabal repl search path bug on Windows
* Include OS and arch in cabal-install user agent
* Revert --constraint flag behavior in configure to 1.18 behavior


## 1.20.0.0 (Johan Tibell [johan.tibell@gmail.com](mailto:johan.tibell@gmail.com) April 2014)

* Build only selected executables
* Add -j flag to build/test/bench/run
* Improve install log file
* Don't symlink executables when in a sandbox
* Add --package-db flag to 'list' and 'info'
* Make upload more efficient
* Add --require-sandbox option
* Add experimental Cabal file format command
* Add haddock section to config file
* Add --main-is flag to init


## 1.18.2.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) February 2016)

* Only Custom setup scripts should be compiled with '-i -i.'.
* installedCabalVersion: Don't special-case Cabal anymore.


## 1.18.1.0 (Ryan Thomas [ryan@ryant.org](mailto:ryan@ryant.org) May 2015)

* Force cabal upload to always use digest auth and never basic auth.
* Merge pull request \#2367 from juhp/patch-2
* Fix bootstrap.sh by bumping HTTP to 4000.2.16.1


## 1.18.0.7 (Johan Tibell [johan.tibell@gmail.com](mailto:johan.tibell@gmail.com) December 2014)

* Support random 1.1.
* Fix bootstrap script after network package split.
* Support network-2.6 in test suite.


## 1.18.0.5 (Johan Tibell [johan.tibell@gmail.com](mailto:johan.tibell@gmail.com) July 2014)

* Make solver flag resolution more conservative.


## 1.18.0.4 (Johan Tibell [johan.tibell@gmail.com](mailto:johan.tibell@gmail.com) May 2014)

* Increase max-backjumps to 2000.
* Fix solver bug which led to missed install plans.
* Tweak solver heuristics to avoid reinstalls.


## 0.14.0 (Andres Loeh [andres@well-typed.com](mailto:andres@well-typed.com) April 2012)

* Works with ghc-7.4
* Completely new modular dependency solver (default in most cases)
* Some tweaks to old topdown dependency solver
* Install plans are now checked for reinstalls that break packages
* Flags --constraint and --preference work for nonexisting packages
* New constraint forms for source and installed packages
* New constraint form for package-specific use flags
* New constraint form for package-specific stanza flags
* Test suite dependencies are pulled in on demand
* No longer install packages on --enable-tests when tests fail
* New "cabal bench" command
* Various "cabal init" tweaks


## 0.10.0 (Duncan Coutts [duncan@community.haskell.org](mailto:duncan@community.haskell.org) February 2011)

* New package targets: local dirs, local and remote tarballs
* Initial support for a "world" package target
* Partial fix for situation where user packages mask global ones
* Removed cabal upgrade, new --upgrade-dependencies flag
* New cabal install --only-dependencies flag
* New cabal fetch --no-dependencies and --dry-run flags
* Improved output for cabal info
* Simpler and faster bash command line completion
* Fix for broken proxies that decompress wrongly
* Fix for cabal unpack to preserve executable permissions
* Adjusted the output for the -v verbosity level in a few places


## 0.8.2 (Duncan Coutts [duncan@community.haskell.org](mailto:duncan@community.haskell.org) March 2010)

* Fix for cabal update on Windows
* On windows switch to per-user installs (rather than global)
* Handle intra-package dependencies in dependency planning
* Minor tweaks to cabal init feature
* Fix various -Wall warnings
* Fix for cabal sdist --snapshot


## 0.8.0 (Duncan Coutts [duncan@haskell.org](mailto:duncan@haskell.org) Dec 2009)

* Works with ghc-6.12
* New "cabal init" command for making initial project .cabal file
* New feature to maintain an index of haddock documentation


## 0.6.4 (Duncan Coutts [duncan@haskell.org](mailto:duncan@haskell.org) Nov 2009)

* Improve the algorithm for selecting the base package version
* Hackage errors now reported by "cabal upload [--check]"
* Improved format of messages from "cabal check"
* Config file can now be selected by an env var
* Updated tar reading/writing code
* Improve instructions in the README and bootstrap output
* Fix bootstrap.sh on Solaris 9
* Fix bootstrap for systems where network uses parsec 3
* Fix building with ghc-6.6


## 0.6.2 (Duncan Coutts [duncan@haskell.org](mailto:duncan@haskell.org) Feb 2009)

* The upgrade command has been disabled in this release
* The configure and install commands now have consistent behaviour
* Reduce the tendency to re-install already existing packages
* The --constraint= flag now works for the install command
* New --preference= flag for soft constraints / version preferences
* Improved bootstrap.sh script, smarter and better error checking
* New cabal info command to display detailed info on packages
* New cabal unpack command to download and untar a package
* HTTP-4000 package required, should fix bugs with http proxies
* Now works with authenticated proxies.
* On Windows can now override the proxy setting using an env var
* Fix compatibility with config files generated by older versions
* Warn if the hackage package list is very old
* More helpful --help output, mention config file and examples
* Better documentation in ~/.cabal/config file
* Improved command line interface for logging and build reporting
* Minor improvements to some messages


## 0.6.0 (Duncan Coutts [duncan@haskell.org](mailto:duncan@haskell.org) Oct 2008)

* Constraint solver can now cope with base 3 and base 4
* Allow use of package version preferences from hackage index
* More detailed output from cabal install --dry-run -v
* Improved bootstrap.sh


## 0.5.2 (Duncan Coutts [duncan@haskell.org](mailto:duncan@haskell.org) Aug 2008)

* Support building haddock documentation
* Self-reinstall now works on Windows
* Allow adding symlinks to executables into a separate bindir
* New self-documenting config file
* New install --reinstall flag
* More helpful status messages in a couple places
* Upload failures now report full text error message from the server
* Support for local package repositories
* New build logging and reporting
* New command to upload build reports to (a compatible) server
* Allow tilde in hackage server URIs
* Internal code improvements
* Many other minor improvements and bug fixes


## 0.5.1 (Duncan Coutts [duncan@haskell.org](mailto:duncan@haskell.org) June 2008)

* Restore minimal hugs support in dependency resolver
* Fix for disabled http proxies on Windows
* Revert to global installs on Windows by default


## 0.5.0 (Duncan Coutts [duncan@haskell.org](mailto:duncan@haskell.org) June 2008)

* New package dependency resolver, solving diamond dep problem
* Integrate cabal-setup functionality
* Integrate cabal-upload functionality
* New cabal update and check commands
* Improved behavior for install and upgrade commands
* Full Windows support
* New command line handling
* Bash command line completion
* Allow case insensitive package names on command line
* New --dry-run flag for install, upgrade and fetch commands
* New --root-cmd flag to allow installing as root
* New --cabal-lib-version flag to select different Cabal lib versions
* Support for HTTP proxies
* Improved cabal list output
* Build other non-dependent packages even when some fail
* Report a summary of all build failures at the end
* Partial support for hugs
* Partial implementation of build reporting and logging
* More consistent logging and verbosity
* Significant internal code restructuring


## 0.4 (Duncan Coutts [duncan@haskell.org](mailto:duncan@haskell.org) Oct 2007)

* Renamed executable from 'cabal-install' to 'cabal'
* Partial Windows compatibility
* Do per-user installs by default
* cabal install now installs the package in the current directory
* Allow multiple remote servers
* Use zlib lib and internal tar code and rather than external tar
* Reorganised configuration files
* Significant code restructuring
* Cope with packages with conditional dependencies


## 0.3 and older versions (by Lemmih, Paolo Martini and others 2006-2007)

* Switch from smart-server, dumb-client model to the reverse
* New .tar.gz based index format
* New remote and local package archive format
