/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.core.Running;
import com.google.caliper.model.Measurement;
import com.google.caliper.worker.AllocationRecorder;
import com.google.caliper.worker.AllocationStats;
import com.google.caliper.worker.instrument.WorkerInstrument;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import javax.inject.Inject;

final class MicrobenchmarkAllocationWorkerInstrument
extends WorkerInstrument {
    private static final int WARMUP_REPS = 10;
    private static final int MAX_REPS = 100;
    private static final int DETERMINISTIC_BENCHMARK_THRESHOLD = 2;
    private static final int DETERMINISTIC_MEASUREMENT_COUNT = 5;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Random random;
    private final AllocationRecorder recorder;

    @Inject
    MicrobenchmarkAllocationWorkerInstrument(@Running.Benchmark Object benchmark, @Running.BenchmarkMethod Method method, AllocationRecorder recorder, Random random) {
        super(benchmark, method);
        this.random = random;
        this.recorder = recorder;
    }

    public void bootstrap() throws Exception {
        this.measureAllocations(this.benchmark, this.benchmarkMethod, 10);
        this.verifyBenchmarkIsDeterministic();
    }

    private void verifyBenchmarkIsDeterministic() throws Exception {
        ArrayList<AllocationStats> history = new ArrayList<AllocationStats>();
        AllocationStats baseline = null;
        int matchingSequenceLength = 1;
        for (int i = 0; i < 5; ++i) {
            AllocationStats stats = this.measureAllocations(this.benchmark, this.benchmarkMethod, 0);
            history.add(stats);
            if (stats.equals(baseline)) {
                if (++matchingSequenceLength != 2) continue;
                return;
            }
            matchingSequenceLength = 1;
            baseline = stats;
        }
        StringBuilder builder = new StringBuilder(100);
        AllocationStats previous = null;
        for (AllocationStats allocationStats : history) {
            if (previous == null) {
                builder.append(LINE_SEPARATOR).append("  ").append(allocationStats);
            } else {
                AllocationStats.Delta delta = allocationStats.delta(previous);
                builder.append(LINE_SEPARATOR).append("  ").append(delta);
            }
            previous = allocationStats;
        }
        throw new IllegalStateException(String.format("Your benchmark appears to have non-deterministic allocation behavior. During the warm up process there was no consecutive sequence of %d runs with identical allocations. The allocation history is:%s", 2, builder));
    }

    public void dryRun() throws Exception {
        this.benchmarkMethod.invoke(this.benchmark, 1);
    }

    public Iterable<Measurement> measure() throws Exception {
        AllocationStats baseline = this.measureAllocations(this.benchmark, this.benchmarkMethod, 0);
        int measurementReps = this.random.nextInt(100) + 1;
        AllocationStats measurement = this.measureAllocations(this.benchmark, this.benchmarkMethod, measurementReps);
        return measurement.minus(baseline).toMeasurements();
    }

    private AllocationStats measureAllocations(Object benchmark, Method method, int reps) throws Exception {
        Object[] args = new Object[]{reps};
        this.recorder.startRecording();
        method.invoke(benchmark, args);
        return this.recorder.stopRecording(reps);
    }
}

