/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.bridge;

import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.model.InstrumentType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;

public final class ExperimentSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final InstrumentType instrumentType;
    private final ImmutableMap<String, String> workerInstrumentOptions;
    private final BenchmarkSpec benchmarkSpec;
    private final ImmutableList<String> methodParameterClasses;

    public ExperimentSpec(int id, InstrumentType instrumentType, ImmutableMap<String, String> workerInstrumentOptions, BenchmarkSpec benchmarkSpec, Iterable<String> methodParameterClasses) {
        this.id = id;
        this.instrumentType = instrumentType;
        this.workerInstrumentOptions = workerInstrumentOptions;
        this.benchmarkSpec = benchmarkSpec;
        this.methodParameterClasses = ImmutableList.copyOf(methodParameterClasses);
    }

    public int id() {
        return this.id;
    }

    public InstrumentType instrumentType() {
        return this.instrumentType;
    }

    public ImmutableMap<String, String> workerInstrumentOptions() {
        return this.workerInstrumentOptions;
    }

    public BenchmarkSpec benchmarkSpec() {
        return this.benchmarkSpec;
    }

    public ImmutableList<String> methodParameterClasses() {
        return this.methodParameterClasses;
    }
}

