/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.refaster.AutoValue_UMemberReference;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import org.jspecify.annotations.Nullable;

@AutoValue
abstract class UMemberReference
extends UExpression
implements MemberReferenceTree {
    UMemberReference() {
    }

    public static UMemberReference create(MemberReferenceTree.ReferenceMode mode, UExpression qualifierExpression, CharSequence name, @Nullable Iterable<? extends UExpression> typeArguments) {
        return new AutoValue_UMemberReference(mode, qualifierExpression, StringName.of(name), (ImmutableList<UExpression>)(typeArguments == null ? null : ImmutableList.copyOf(typeArguments)));
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.MEMBER_REFERENCE;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitMemberReference(this, data);
    }

    @Override
    public Choice<Unifier> visitMemberReference(MemberReferenceTree node, Unifier unifier) {
        return Choice.condition(this.getMode() == node.getMode(), unifier).thenChoose(Unifier.unifications(this.getQualifierExpression(), node.getQualifierExpression())).thenChoose(Unifier.unifications(this.getName(), node.getName())).thenChoose(Unifier.unifications(this.getTypeArguments(), node.getTypeArguments()));
    }

    @Override
    public JCTree.JCMemberReference inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().Reference(this.getMode(), this.getName().inline(inliner), (JCTree.JCExpression)this.getQualifierExpression().inline(inliner), this.getTypeArguments() == null ? null : inliner.inlineList(this.getTypeArguments()));
    }

    @Override
    public abstract MemberReferenceTree.ReferenceMode getMode();

    @Override
    public abstract UExpression getQualifierExpression();

    @Override
    public abstract StringName getName();

    public abstract @Nullable ImmutableList<UExpression> getTypeArguments();
}

