/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.AbstractPerfAsmProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.util.Deduplicator;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.IntervalMap;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.TreeMultiset;
import org.openjdk.jmh.util.Utils;

public class DTraceAsmProfiler
extends AbstractPerfAsmProfiler {
    private final long sampleFrequency;
    private volatile String pid;
    private volatile Process dtraceProcess;
    private OptionSpec<Long> optFrequency;

    public DTraceAsmProfiler(String initLine) throws ProfilerException {
        super(initLine, "sampled_pc");
        Collection<String> messages = Utils.tryWith("sudo", "-n", "dtrace", "-V");
        if (!messages.isEmpty()) {
            throw new ProfilerException(messages.toString());
        }
        try {
            this.sampleFrequency = (Long)this.set.valueOf(this.optFrequency);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
        super.beforeTrial(params);
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        if (pid == 0L) {
            throw new IllegalStateException("DTrace needs the forked VM PID, but it is not initialized");
        }
        long dtracePid = Utils.getPid(this.dtraceProcess);
        if (dtracePid == 0L) {
            throw new IllegalStateException("Cannot determine dtrace process PID");
        }
        Collection<String> messages = Utils.tryWith("sudo", "-n", "kill", "-TERM", Long.toString(dtracePid));
        if (!messages.isEmpty()) {
            throw new IllegalStateException(messages.toString());
        }
        try {
            int errcode = this.dtraceProcess.waitFor();
            if (errcode != 0) {
                throw new IllegalStateException("Non-zero error code from dtrace: " + errcode);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while waiting for profiler to stop");
        }
        this.pid = String.valueOf(pid);
        return super.afterTrial(br, pid, stdOut, stdErr);
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        this.dtraceProcess = Utils.runAsync("sudo", "-n", "dtrace", "-n", "profile-" + this.sampleFrequency + " /arg1/ { printf(\"%d 0x%lx %d\", pid, arg1, timestamp); ufunc(arg1)}", "-o", this.perfBinData.getAbsolutePath());
        return Collections.emptyList();
    }

    @Override
    public String getDescription() {
        return "DTrace profile provider + PrintAssembly Profiler";
    }

    @Override
    protected void addMyOptions(OptionParser parser) {
        this.optFrequency = parser.accepts("frequency", "Sampling frequency. This is synonymous to profile-#").withRequiredArg().ofType(Long.class).describedAs("freq").defaultsTo((Object)1001L, (Object[])new Long[0]);
    }

    @Override
    protected void parseEvents() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AbstractPerfAsmProfiler.PerfEvents readEvents(double skipMs, double lenMs) {
        long start = (long)skipMs;
        long end = (long)(skipMs + lenMs);
        try (FileReader fr = new FileReader(this.perfBinData.file());){
            AbstractPerfAsmProfiler.PerfEvents perfEvents;
            try (BufferedReader reader = new BufferedReader(fr);){
                String line;
                Deduplicator<AbstractPerfAsmProfiler.MethodDesc> dedup = new Deduplicator<AbstractPerfAsmProfiler.MethodDesc>();
                HashMultimap<AbstractPerfAsmProfiler.MethodDesc, Long> methods = new HashMultimap<AbstractPerfAsmProfiler.MethodDesc, Long>();
                TreeMultiset<Long> events = new TreeMultiset<Long>();
                long dtraceTimestampBase = 0L;
                while ((line = reader.readLine()) != null) {
                    Object sampledPid;
                    if (!line.contains(":profile")) continue;
                    line = line.trim();
                    String[] splits = (line = line.substring(line.indexOf(":profile"))).split(" ", 5);
                    if (splits.length < 2 || !((String)(sampledPid = splits[1])).equals(this.pid) || splits.length < 4) continue;
                    long timestamp = Long.parseLong(splits[3]);
                    if (dtraceTimestampBase == 0L) {
                        dtraceTimestampBase = timestamp;
                        continue;
                    }
                    long elapsed = timestamp - dtraceTimestampBase;
                    long elapsedMs = TimeUnit.NANOSECONDS.toMillis(elapsed);
                    if (elapsedMs < start || elapsedMs > end) continue;
                    long address = Long.decode(splits[2]);
                    events.add(address);
                    String methodLine = splits[4];
                    if (methodLine.startsWith("0x")) continue;
                    String symbol = "[unknown]";
                    String[] methodSplit = methodLine.split("`");
                    String library = methodSplit[0];
                    if ("".equals(library)) {
                        library = "[unknown]";
                    }
                    if (methodSplit.length == 2) {
                        symbol = methodSplit[1];
                    }
                    methods.put(dedup.dedup(AbstractPerfAsmProfiler.MethodDesc.nativeMethod(symbol, library)), address);
                }
                IntervalMap<AbstractPerfAsmProfiler.MethodDesc> methodMap = new IntervalMap<AbstractPerfAsmProfiler.MethodDesc>();
                for (AbstractPerfAsmProfiler.MethodDesc md : methods.keys()) {
                    Collection longs = methods.get(md);
                    methodMap.add(md, (Long)Utils.min(longs), (Long)Utils.max(longs));
                }
                TreeMap<String, Multiset<Long>> allEvents = new TreeMap<String, Multiset<Long>>();
                assert (this.requestedEventNames.size() == 1);
                allEvents.put((String)this.requestedEventNames.get(0), events);
                perfEvents = new AbstractPerfAsmProfiler.PerfEvents(this.requestedEventNames, allEvents, methodMap);
            }
            return perfEvents;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String perfBinaryExtension() {
        return ".txt";
    }
}

