/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker.trial;

import com.google.caliper.bridge.LogMessage;
import com.google.caliper.bridge.LogMessageVisitor;
import com.google.caliper.bridge.ShouldContinueMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.runner.instrument.MeasurementCollectingVisitor;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.worker.FailureLogMessageVisitor;
import com.google.caliper.runner.worker.Worker;
import com.google.caliper.runner.worker.WorkerException;
import com.google.caliper.runner.worker.WorkerProcessor;
import com.google.caliper.runner.worker.trial.TrialFailureException;
import com.google.caliper.runner.worker.trial.TrialResult;
import com.google.caliper.runner.worker.trial.TrialResultFactory;
import com.google.caliper.runner.worker.trial.VmDataCollectingVisitor;
import com.google.caliper.util.ShortDuration;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;
import javax.inject.Inject;

final class TrialProcessor
extends WorkerProcessor<TrialResult> {
    private final CaliperOptions options;
    private final TrialResultFactory trialFactory;
    private final VmDataCollectingVisitor dataCollectingVisitor;
    private final MeasurementCollectingVisitor measurementCollectingVisitor;

    @Inject
    TrialProcessor(MeasurementCollectingVisitor measurementCollectingVisitor, CaliperOptions options, TrialResultFactory trialFactory, VmDataCollectingVisitor dataCollectingVisitor) {
        this.options = options;
        this.trialFactory = trialFactory;
        this.measurementCollectingVisitor = measurementCollectingVisitor;
        this.dataCollectingVisitor = dataCollectingVisitor;
    }

    @Override
    public ShortDuration timeLimit() {
        return this.options.timeLimit();
    }

    @Override
    public boolean handleMessage(LogMessage message, Worker worker) throws IOException {
        message.accept((LogMessageVisitor)FailureLogMessageVisitor.INSTANCE);
        message.accept((LogMessageVisitor)this.measurementCollectingVisitor);
        message.accept((LogMessageVisitor)this.dataCollectingVisitor);
        boolean doneCollecting = this.measurementCollectingVisitor.isDoneCollecting();
        if (message instanceof StopMeasurementLogMessage) {
            worker.sendMessage((Serializable)new ShouldContinueMessage(!doneCollecting, this.measurementCollectingVisitor.isWarmupComplete()));
            if (doneCollecting) {
                worker.closeWriter();
            }
        }
        return doneCollecting;
    }

    @Override
    public String getTimeoutErrorMessage(Worker worker) {
        String string = String.valueOf(super.getTimeoutErrorMessage(worker));
        String string2 = String.valueOf(String.format(" The limit (%s) may be adjusted using the --time-limit flag.", this.timeLimit()));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    @Override
    public WorkerException newWorkerException(String message, @Nullable Throwable cause) {
        return new TrialFailureException(message, cause);
    }

    @Override
    public TrialResult getResult() {
        return this.trialFactory.newTrialResult(this.dataCollectingVisitor, this.measurementCollectingVisitor);
    }
}

