/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.jobs.Job;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Flt;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;

public final class FltSeq
extends NativeSeq {
    private final float[] values;

    private FltSeq(float[] values) {
        super(values.length, (Type)AtomType.FLOAT);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException, QueryException {
        int size = in.readNum();
        float[] values = new float[size];
        for (int s = 0; s < size; ++s) {
            values[s] = Flt.parse(in.readToken(), null);
        }
        return FltSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        float[] fArray = this.values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double v = fArray[i];
            out.writeToken(Token.token(v));
        }
    }

    @Override
    public Flt itemAt(long index) {
        return Flt.get(this.values[(int)index]);
    }

    @Override
    public Value reverse(Job job) {
        int sz = (int)this.size;
        float[] tmp = new float[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return FltSeq.get(tmp);
    }

    public float[] toJava() {
        return this.values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof FltSeq) {
            FltSeq seq = (FltSeq)obj;
            if (!Arrays.equals(this.values, seq.values)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    public static Value get(float[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Flt.get(values[0]) : new FltSeq(values));
    }
}

