/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.util.InputInfo;

public final class DBDelete
extends DBUpdate {
    private final ArrayList<IOFile> paths = new ArrayList(1);
    private int size;

    public DBDelete(Data data, IOFile path, InputInfo info) {
        super(UpdateType.DBDELETE, data, info);
        this.size = path.isDir() ? path.descendants().size() : 1;
        this.paths.add(path);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void apply() {
        for (IOFile path : this.paths) {
            path.delete();
        }
    }

    @Override
    public void merge(Update update) {
        this.paths.addAll(((DBDelete)update).paths);
        this.size += update.size();
    }

    @Override
    public int size() {
        return this.size;
    }
}

