/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.in.ArrayInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.convert.ConvertFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.B64Lazy;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;

abstract class ArchiveFn
extends StandardFunc {
    ArchiveFn() {
    }

    final byte[] encode(byte[] value, String encoding, boolean enforce, QueryContext qc) throws QueryException {
        if (encoding == "UTF-8" && !enforce) {
            return value;
        }
        try {
            boolean validate = qc.context.options.get(MainOptions.CHECKSTRINGS);
            return ConvertFn.toString(new ArrayInput(value), encoding, validate);
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ENCODE2_X.get(this.info, ex);
        }
    }

    final HashSet<String> toEntries(Expr expr, QueryContext qc) throws QueryException {
        Item item;
        LinkedHashSet<String> entries = new LinkedHashSet<String>();
        Iter names = expr.iter(qc);
        while ((item = qc.next(names)) != null) {
            entries.add(this.toString(item, qc));
        }
        return entries.isEmpty() ? null : entries;
    }

    final Bin toArchive(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        if (item instanceof Bin) {
            Bin bin = (Bin)item;
            return bin;
        }
        if (item.type.isStringOrUntyped()) {
            return new B64Lazy(new IOFile(this.toPath(item, qc)), QueryError.FILE_IO_ERROR_X);
        }
        throw QueryError.STRBIN_X_X.get(this.info, item.seqType(), item);
    }

    final Object toInput(Expr expr, QueryContext qc, boolean direct) throws QueryException, IOException {
        Item archive = expr.atomItem(qc, this.info);
        if (archive instanceof Bin) {
            return archive;
        }
        if (!archive.type.isStringOrUntyped()) {
            throw QueryError.STRBIN_X_X.get(this.info, archive.seqType(), archive);
        }
        IO io = this.toIO(archive, qc);
        return direct && ArchiveFn.localZip(io) ? io : new B64Lazy(io, QueryError.FILE_IO_ERROR_X);
    }

    static boolean localZip(IO io) throws IOException {
        if (io instanceof IOFile) {
            if (io.hasSuffix(".zip")) {
                return true;
            }
            try (InputStream is = io.inputStream();){
                if (is.read() == 80 && is.read() == 75) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }
}

