/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.dictionary;

import java.io.IOException;
import net.reduls.igo.util.FileMappedInputStream;

public final class CharCategory {
    private final Category[] categorys;
    private final int[] char2id;
    private final int[] eqlMasks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharCategory(String string) throws IOException {
        this.categorys = this.readCategorys(string);
        FileMappedInputStream fileMappedInputStream = new FileMappedInputStream(string + "/code2category");
        try {
            this.char2id = fileMappedInputStream.getIntArray(fileMappedInputStream.size() / 4 / 2);
            this.eqlMasks = fileMappedInputStream.getIntArray(fileMappedInputStream.size() / 4 / 2);
        }
        finally {
            fileMappedInputStream.close();
        }
    }

    public Category category(char c) {
        return this.categorys[this.char2id[c]];
    }

    public boolean isCompatible(char c, char c2) {
        return (this.eqlMasks[c] & this.eqlMasks[c2]) != 0;
    }

    private Category[] readCategorys(String string) throws IOException {
        int[] nArray = FileMappedInputStream.getIntArray(string + "/char.category");
        int n = nArray.length / 4;
        Category[] categoryArray = new Category[n];
        for (int i = 0; i < n; ++i) {
            categoryArray[i] = new Category(nArray[i * 4], nArray[i * 4 + 1], nArray[i * 4 + 2] == 1, nArray[i * 4 + 3] == 1);
        }
        return categoryArray;
    }

    public static class Category {
        public final int id;
        public final int length;
        public final boolean invoke;
        public final boolean group;

        public Category(int n, int n2, boolean bl, boolean bl2) {
            this.id = n;
            this.length = n2;
            this.invoke = bl;
            this.group = bl2;
        }
    }
}

