/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public final class FileMappedInputStream {
    private final FileChannel cnl;
    private int cur = 0;

    public FileMappedInputStream(String string) throws IOException {
        this.cnl = new FileInputStream(string).getChannel();
    }

    public int getInt() throws IOException {
        return this.map(4).getInt();
    }

    public int[] getIntArray(int n) throws IOException {
        int[] nArray = new int[n];
        this.map(n * 4).asIntBuffer().get(nArray);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getIntArray(String string) throws IOException {
        FileMappedInputStream fileMappedInputStream = new FileMappedInputStream(string);
        try {
            int[] nArray = fileMappedInputStream.getIntArray(fileMappedInputStream.size() / 4);
            return nArray;
        }
        finally {
            fileMappedInputStream.close();
        }
    }

    public short[] getShortArray(int n) throws IOException {
        short[] sArray = new short[n];
        this.map(n * 2).asShortBuffer().get(sArray);
        return sArray;
    }

    public char[] getCharArray(int n) throws IOException {
        char[] cArray = new char[n];
        this.map(n * 2).asCharBuffer().get(cArray);
        return cArray;
    }

    public String getString(int n) throws IOException {
        return this.map(n * 2).asCharBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String string) throws IOException {
        FileMappedInputStream fileMappedInputStream = new FileMappedInputStream(string);
        try {
            String string2 = fileMappedInputStream.getString(fileMappedInputStream.size() / 2);
            return string2;
        }
        finally {
            fileMappedInputStream.close();
        }
    }

    public int size() throws IOException {
        return (int)this.cnl.size();
    }

    public void close() {
        try {
            this.cnl.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ByteBuffer map(int n) throws IOException {
        this.cur += n;
        return this.cnl.map(FileChannel.MapMode.READ_ONLY, this.cur - n, n).order(ByteOrder.nativeOrder());
    }
}

