/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.EnumMap;
import org.basex.io.in.DataInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;

public enum ListType implements Type
{
    NMTOKENS("NMTOKENS", AtomType.NMTOKEN),
    ENTITIES("ENTITIES", AtomType.ENTITY),
    IDREFS("IDREFS", AtomType.IDREF);

    private final AtomType type;
    private final QNm name;
    private EnumMap<Occ, SeqType> seqTypes;

    private ListType(String name, AtomType type) {
        this.name = new QNm(name, QueryText.XS_URI);
        this.type = type;
    }

    public final QNm qname() {
        return this.name;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isUntyped() {
        return false;
    }

    @Override
    public final boolean isNumberOrUntyped() {
        return false;
    }

    @Override
    public final boolean isStringOrUntyped() {
        return false;
    }

    @Override
    public final boolean isSortable() {
        return false;
    }

    @Override
    public final Value cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
        byte[][] values = Token.split(Token.normalize(item.string(info)), 32);
        if (values.length == 0) {
            throw QueryError.FUNCCAST_X_X_X.get(info, item.type, this, item);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (byte[] value : values) {
            vb.add(this.type.cast(Str.get(value), qc, info));
        }
        return vb.value(this.type);
    }

    @Override
    public final Value cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
        return this.cast(Str.get(value, qc, info), qc, info);
    }

    @Override
    public Item read(DataInput in, QueryContext qc) {
        throw Util.notExpected();
    }

    @Override
    public SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    @Override
    public final boolean eq(Type tp) {
        return this == tp;
    }

    @Override
    public final boolean instanceOf(Type tp) {
        ChoiceItemType cit;
        return this == tp || (tp instanceof ChoiceItemType ? (cit = (ChoiceItemType)tp).hasInstance(this) : tp == AtomType.ITEM);
    }

    @Override
    public final Type union(Type tp) {
        return this == tp ? tp : (tp instanceof ChoiceItemType ? tp.union(this) : AtomType.ITEM);
    }

    @Override
    public final Type intersect(Type tp) {
        return tp instanceof ChoiceItemType ? tp.intersect(this) : (this.instanceOf(tp) ? this : (tp.instanceOf(this) ? tp : null));
    }

    @Override
    public final AtomType atomic() {
        return this.type;
    }

    @Override
    public final Type.ID id() {
        return null;
    }

    @Override
    public final boolean nsSensitive() {
        return false;
    }

    @Override
    public final String toString() {
        return Strings.concat(NSGlobal.prefix(this.name.uri()), Character.valueOf(':'), this.name.string());
    }

    public static ListType find(QNm qname) {
        for (ListType lt : ListType.values()) {
            if (!lt.name.eq(qname)) continue;
            return lt;
        }
        return null;
    }
}

