/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.LinkedList;
import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.func.Function;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.list.StringList;

public final class FuncItem
extends FItem
implements Scope {
    public final Expr expr;
    private final Var[] params;
    private final AnnList anns;
    private final int stackSize;
    private final InputInfo info;
    private final QNm name;
    private final QueryFocus focus;
    private final boolean simple;

    public FuncItem(InputInfo info, Expr expr, Var[] params, AnnList anns, FuncType type, int stackSize, QNm name) {
        this(info, expr, params, anns, type, stackSize, name, null);
    }

    public FuncItem(InputInfo info, Expr expr, Var[] params, AnnList anns, FuncType type, int stackSize, QNm name, QueryFocus focus) {
        super(type);
        this.info = info;
        this.expr = expr;
        this.params = params;
        this.anns = anns;
        this.stackSize = stackSize;
        this.name = name;
        this.focus = focus;
        this.simple = !expr.has(Flag.CTX);
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm paramName(int ps) {
        return this.params[ps].name;
    }

    @Override
    public String funcIdentity() {
        QNm qnm = this.funcName();
        TokenBuilder tb = new TokenBuilder();
        tb.add(qnm != null ? (Object)qnm.prefixId() : "fn").add(35).addInt(this.arity());
        if (this.focus != null || qnm == null) {
            tb.add(45).addInt(this.hashCode());
        }
        return tb.toString();
    }

    @Override
    public AnnList annotations() {
        return this.anns;
    }

    @Override
    public void refineType(Expr exp) {
        Type tp = this.funcType().intersect(exp.seqType().type);
        if (tp != null) {
            this.type = tp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value invokeInternal(QueryContext qc, InputInfo ii, Value[] args) throws QueryException {
        int arity = this.arity();
        for (int a = 0; a < arity; ++a) {
            qc.set(this.params[a], args[a]);
        }
        if (this.simple) {
            return this.expr.value(qc);
        }
        QueryFocus qf = qc.focus;
        qc.focus = this.focus != null ? this.focus : new QueryFocus();
        try {
            Value value = this.expr.value(qc);
            return value;
        }
        finally {
            qc.focus = qf;
        }
    }

    @Override
    public int stackFrameSize() {
        return this.stackSize;
    }

    @Override
    boolean updating() {
        return this.anns.contains(Annotation.UPDATING) || this.expr.has(Flag.UPD);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.funcItem(this);
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Var param : this.params) {
            if (visitor.declared(param)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public boolean compiled() {
        return true;
    }

    @Override
    public Object toJava() {
        return this;
    }

    @Override
    public Expr inline(Expr[] exprs, CompileContext cc) throws QueryException {
        if (!cc.inlineable(this.anns, this.expr) || this.expr.has(Flag.CTX)) {
            return null;
        }
        cc.info("inline %", this);
        LinkedList<Clause> clauses = new LinkedList<Clause>();
        IntObjectMap<Var> vm = new IntObjectMap<Var>();
        int arity = this.arity();
        for (int a = 0; a < arity; ++a) {
            clauses.add(new Let(cc.copy(this.params[a], vm), exprs[a]).optimize(cc));
        }
        Expr rtrn = this.expr.copy(cc, vm).optimize(cc);
        return clauses.isEmpty() ? rtrn : new GFLWOR(this.info, clauses, rtrn).optimize(cc);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOMIZE_X.get(this.info, this);
    }

    @Override
    public Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOMIZE_X.get(this.info, this);
    }

    @Override
    public byte[] string(InputInfo ii) throws QueryException {
        throw QueryError.FIATOMIZE_X.get(this.info, this);
    }

    @Override
    public boolean deepEqual(Item item, DeepEqual deep) {
        if (this == item) {
            return true;
        }
        if (item instanceof FuncItem) {
            FuncItem func = (FuncItem)item;
            int a = this.arity();
            if (a == func.arity()) {
                while (--a >= 0 && this.params[a].seqType().eq(func.params[a].seqType())) {
                }
                return a == -1 && this.expr.equals(func.expr);
            }
        }
        return false;
    }

    @Override
    public boolean vacuousBody() {
        SeqType st = this.expr.seqType();
        return st != null && st.zero() && !this.expr.has(Flag.UPD);
    }

    public Object fold(Expr input, boolean array, boolean left, CompileContext cc) throws QueryException {
        if (this.arity() == 2 && !input.has(Flag.NDT)) {
            Var actionVar = this.params[left ? 1 : 0];
            Var resultVar = this.params[left ? 0 : 1];
            Predicate<Expr> result = ex -> {
                if (!(ex instanceof VarRef)) return false;
                VarRef vr = (VarRef)ex;
                if (!vr.var.equals(resultVar)) return false;
                return true;
            };
            if (!array && input.seqType().oneOrMore() && this.expr instanceof Value) {
                return this.expr;
            }
            if (result.test(this.expr)) {
                return "";
            }
            Expr expr = this.expr;
            if (expr instanceof If) {
                If iff = (If)expr;
                Expr cond = iff.cond;
                Expr thn = iff.exprs[0];
                Expr els = iff.exprs[1];
                if (!cond.uses(actionVar) && !cond.has(Flag.NDT)) {
                    Expr cnd = cond;
                    Expr action = null;
                    if (result.test(thn)) {
                        action = els;
                    } else if (result.test(els)) {
                        cnd = cc.function(Function.NOT, this.info, cond);
                        action = thn;
                    } else if (cond instanceof CmpG) {
                        CmpG cmp = (CmpG)cond;
                        Expr op1 = cmp.arg(0);
                        Expr op2 = cmp.arg(1);
                        SeqType st1 = op1.seqType();
                        SeqType st2 = op2.seqType();
                        if (result.test(op1) && op2 instanceof Item && op2.equals(thn) && cmp.opG() == CmpG.OpG.EQ && st1.eq(st2) && (st1.instanceOf(Types.DECIMAL_O) || st1.instanceOf(Types.STRING_O))) {
                            action = els;
                        }
                    }
                    if (action != null) {
                        return new FuncItem[]{new FuncItem(this.info, cnd, this.params, this.anns, this.funcType(), this.stackSize, null, this.focus), new FuncItem(this.info, action, this.params, this.anns, this.funcType(), this.stackSize, null, this.focus)};
                    }
                }
            }
        }
        return null;
    }

    public FuncItem refine(SeqType[] argTypes, CompileContext cc) throws QueryException {
        int nargs = argTypes.length;
        int arity = this.arity();
        if (nargs >= arity) {
            FuncType oldType = this.funcType();
            SeqType[] oldArgTypes = oldType.argTypes;
            SeqType[] newArgTypes = new SeqType[arity];
            for (int a = 0; a < arity; ++a) {
                SeqType at = argTypes[a];
                SeqType oat = oldArgTypes[a];
                newArgTypes[a] = at.instanceOf(oat) ? at : oat;
            }
            FuncType newType = FuncType.get(oldType.declType, newArgTypes);
            FuncItem fitem = newType.eq(oldType) ? this : (FuncItem)this.coerceTo(newType, cc.qc, cc, this.info);
            Var[] vars = fitem.params;
            for (int a = 0; a < arity; ++a) {
                SeqType vt = vars[a].declType;
                if (vt == null || !argTypes[a].instanceOf(vt)) continue;
                vars[a].declType = null;
            }
            return fitem;
        }
        return this;
    }

    @Override
    public InputInfo info() {
        return this.info;
    }

    @Override
    public String description() {
        return "function item";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name == null ? null : this.name.prefixId()), new Object[]{this.params, this.expr});
    }

    @Override
    public String toErrorString() {
        QueryString qs = new QueryString();
        if (this.name != null) {
            qs.concat(this.name.prefixId(), "#", this.arity());
        } else {
            StringList list = new StringList(this.arity());
            for (Var param : this.params) {
                list.add(param.toErrorString());
            }
            qs.token(this.anns).token("fn").params(list.finish());
            qs.token("as").token(this.funcType().declType).brace(this.expr);
        }
        return qs.toString();
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.anns);
        if (this.name != null) {
            qs.concat("(: ", this.name.prefixId(), "#", this.arity(), " :)");
        }
        qs.token("fn").params(this.params).token("as").token(this.funcType().declType).brace(this.expr);
    }
}

