/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.XQFunction;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public abstract class FItem
extends Item
implements XQFunction {
    protected FItem(Type type) {
        super(type);
    }

    @Override
    public final int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        throw QueryError.FIATOMIZE_X.get(this.info(ii), this);
    }

    @Override
    public final boolean atomicEqual(Item item) {
        return false;
    }

    @Override
    public final FuncType funcType() {
        return this.type.funcType();
    }

    public abstract String funcIdentity();

    @Override
    public Item materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        throw QueryError.BASEX_FUNCTION_X.get(this.info(ii), this);
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        throw QueryError.BASEX_FUNCTION_X.get(this.info(ii), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FItem coerceTo(FuncType ft, QueryContext qc, CompileContext cc, InputInfo ii) throws QueryException {
        int a;
        InputInfo info = this.info(ii);
        SeqType[] argTypes = ft.argTypes;
        int nargs = argTypes.length;
        int arity = this.arity();
        if (nargs < arity) {
            throw QueryError.arityError(this, arity, nargs, false, info);
        }
        if (this.type.eq(ft)) {
            return this;
        }
        VarScope vs = new VarScope();
        Var[] vars = new Var[nargs];
        Expr[] args = new Expr[arity];
        for (a = 0; a < arity; ++a) {
            vars[a] = vs.addNew(this.paramName(a), argTypes[a], qc, info);
            args[a] = new VarRef(info, vars[a]).optimize(cc);
        }
        for (a = arity; a < nargs; ++a) {
            vars[a] = vs.addNew(QNm.EMPTY, argTypes[a], qc, info);
        }
        try {
            if (cc != null) {
                cc.pushScope(vs);
            }
            Expr body = new DynFuncCall(info, this.updating(), false, (Expr)this, args);
            if (cc != null) {
                body = body.optimize(cc);
            }
            SeqType dt = ft.declType;
            FuncType tp = this.funcType();
            if (!tp.declType.instanceOf(dt)) {
                body = new TypeCheck(info, body, dt);
                if (cc != null) {
                    body = body.optimize(cc);
                }
            }
            SeqType bt = body.seqType();
            tp = cc != null && !bt.eq(dt) && bt.instanceOf(dt) ? FuncType.get(bt, argTypes) : ft;
            body.markTailCalls(null);
            FuncItem funcItem = new FuncItem(info, body, vars, this.annotations(), tp, vs.stackSize(), this.funcName());
            return funcItem;
        }
        finally {
            if (cc != null) {
                cc.removeScope();
            }
        }
    }

    abstract boolean updating();

    @Override
    public final boolean equals(Object obj) {
        try {
            FItem fitem;
            return obj instanceof FItem && this.deepEqual(fitem = (FItem)obj, null);
        }
        catch (QueryException ex) {
            Util.debug(ex);
            return false;
        }
    }
}

