/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.map.MapCompilation;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.MapType;
import org.basex.util.InputInfo;

public final class MapRemove
extends StandardFunc {
    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        XQMap map = this.toMap(this.arg(0), qc);
        Iter keys = this.arg(1).atomIter(qc, this.info);
        while ((item = qc.next(keys)) != null) {
            map = map.remove(this.toAtomItem(item, qc));
        }
        return map;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr map = this.arg(0);
        Expr key = this.arg(1);
        if (map == XQMap.empty()) {
            return map;
        }
        MapType type = null;
        MapCompilation mc = MapCompilation.get(map).key(key);
        if (mc.key != null) {
            boolean extensible = mc.record.isExtensible();
            if (mc.field == null && !extensible) {
                return map;
            }
            if (mc.key == MapCompilation.EXTENDED && extensible || mc.field == null || mc.field.isOptional()) {
                type = mc.record;
            }
        }
        if (type == null && mc.mapType != null) {
            if (mc.keyMismatch) {
                return map;
            }
            type = MapType.get(mc.mapType.keyType(), mc.mapType.valueType());
        }
        if (type != null) {
            this.exprType.assign(type);
        }
        return this;
    }
}

