/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.csv;

import java.util.Arrays;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntSet;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public class CsvW3ArraysOptions
extends Options {
    public static final StringOption FIELD_DELIMITER = new StringOption("field-delimiter", ",");
    public static final StringOption ROW_DELIMITER = new StringOption("row-delimiter", "\n");
    public static final StringOption QUOTE_CHARACTER = new StringOption("quote-character", "\"");
    public static final BooleanOption TRIM_WHITESPACE = new BooleanOption("trim-whitespace", false);

    public CsvParserOptions finish(InputInfo ii, CsvOptions.CsvFormat format) throws QueryException {
        IntSet delim = new IntSet();
        for (StringOption opt : Arrays.asList(FIELD_DELIMITER, ROW_DELIMITER, QUOTE_CHARACTER)) {
            String val = this.get(opt);
            if (val.codePointCount(0, val.length()) != 1) {
                throw QueryError.CSV_SINGLECHAR_X_X.get(ii, opt.name(), val);
            }
            int cp = val.codePointAt(0);
            if (delim.add(cp)) continue;
            throw QueryError.CSV_DELIMITER_X.get(ii, val);
        }
        CsvParserOptions copts = new CsvParserOptions();
        copts.set(CsvOptions.FORMAT, format);
        copts.set(CsvOptions.FIELD_DELIMITER, this.get(FIELD_DELIMITER));
        copts.set(CsvOptions.ROW_DELIMITER, this.get(ROW_DELIMITER));
        copts.set(CsvOptions.QUOTE_CHARACTER, this.get(QUOTE_CHARACTER));
        copts.set(CsvOptions.TRIM_WHITESPACE, this.get(TRIM_WHITESPACE));
        copts.set(CsvOptions.STRICT_QUOTING, true);
        return copts;
    }
}

