/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.parse.CommandParser;
import org.basex.http.HTTPConnection;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTSession;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;

final class RESTCommands
extends RESTCmd {
    private RESTCommands(RESTSession session) {
        super(session);
    }

    @Override
    protected void run0() throws IOException {
        HTTPConnection conn = this.session.conn;
        conn.sopts().set(SerializerOptions.METHOD, (Enum)SerialMethod.TEXT);
        conn.initResponse();
        ServletOutputStream os = conn.response.getOutputStream();
        for (Command cmd : this.session) {
            this.run(cmd, (OutputStream)os);
        }
    }

    static RESTCommands get(RESTSession session, String input, boolean single) throws BaseXException {
        try {
            CommandParser cp = CommandParser.get((String)input, (Context)session.conn.context);
            if (single) {
                session.add(cp.parseSingle());
            } else {
                for (Command cmd : cp.parse()) {
                    session.add(cmd);
                }
            }
            return new RESTCommands(session);
        }
        catch (QueryException ex) {
            throw new BaseXException((Exception)((Object)ex));
        }
    }
}

