/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.xml;

import de.bottlecaps.markup.BlitzException;
import de.bottlecaps.markup.blitz.Errors;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlGrammarInput {
    private static final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
    private static final DocumentBuilder docBuilder;
    private static final Set<String> elements;
    private final Document doc;
    private String indent;

    private XmlGrammarInput(InputSource xml) {
        try {
            this.doc = docBuilder.parse(xml);
        }
        catch (Exception e) {
            throw new BlitzException("Failed to parse XML gramamr input", e);
        }
    }

    public XmlGrammarInput(InputStream xml) {
        this(new InputSource(xml));
    }

    public XmlGrammarInput(String xml) {
        this(new InputSource(new StringReader(xml)));
    }

    public String toIxml() {
        NodeList elementsByTagName = this.doc.getElementsByTagName("*");
        int l = elementsByTagName.getLength();
        for (int i2 = 0; i2 < l; ++i2) {
            Element element = (Element)elementsByTagName.item(i2);
            if (element.getNamespaceURI() != null) {
                throw new BlitzException("Unsupported element: Q{" + element.getNamespaceURI() + "}" + element.getLocalName());
            }
            if (!elements.contains(element.getLocalName())) {
                throw new BlitzException("Unsupported element: " + element.getLocalName());
            }
            NodeList childNodes = element.getChildNodes();
            if ("comment".equals(element.getLocalName())) continue;
            int m = childNodes.getLength();
            block4: for (int j = 0; j < m; ++j) {
                Node childNode = childNodes.item(j);
                switch (childNode.getNodeType()) {
                    case 1: 
                    case 7: 
                    case 8: {
                        continue block4;
                    }
                    default: {
                        String textContent = childNode.getTextContent();
                        if (textContent.isBlank()) continue block4;
                        throw new BlitzException("Unsupported content in element " + element.getLocalName() + ": " + textContent);
                    }
                }
            }
        }
        int maxLength = 1 + Arrays.stream(XmlGrammarInput.childElements(this.doc.getDocumentElement())).mapToInt(e -> e.getAttribute("name").length()).max().orElseThrow(() -> new BlitzException("No rules found in ixml grammar"));
        this.indent = IntStream.range(0, maxLength).mapToObj(i -> " ").collect(Collectors.joining());
        return this.process(this.doc.getDocumentElement());
    }

    private String process(Element element) {
        ArrayList<String> strings = new ArrayList<String>();
        char repetition = '+';
        String charsetPrefix = "";
        switch (element.getLocalName()) {
            case "ixml": {
                for (Element child : XmlGrammarInput.childElements(element)) {
                    strings.add(this.process(child));
                }
                return String.join((CharSequence)"\n", strings);
            }
            case "rule": {
                String lhs = element.getAttribute("mark") + element.getAttribute("name");
                for (Element child : XmlGrammarInput.childElements(element)) {
                    strings.add(this.process(child));
                }
                return this.indent.substring(lhs.length()) + lhs + ": " + String.join((CharSequence)(";\n" + this.indent + "  "), strings) + ".";
            }
            case "alt": {
                for (Element child : XmlGrammarInput.childElements(element)) {
                    strings.add(this.process(child));
                }
                return String.join((CharSequence)", ", strings);
            }
            case "alts": {
                for (Element child : XmlGrammarInput.childElements(element)) {
                    strings.add(this.process(child));
                }
                return "(" + String.join((CharSequence)", ", strings) + ")";
            }
            case "nonterminal": {
                return element.getAttribute("mark") + element.getAttribute("name");
            }
            case "literal": {
                if (!element.getAttribute("hex").isEmpty()) {
                    if (!element.getAttribute("hex").matches("^[0-9A-Fa-f]+$")) {
                        Errors.S06.thro(element.getAttribute("hex"));
                    }
                    return "#" + element.getAttribute("hex");
                }
                return element.getAttribute("tmark") + "'" + element.getAttribute("string").replace("'", "''") + "'";
            }
            case "option": {
                return this.process(XmlGrammarInput.singletonChildElement(element)) + "?";
            }
            case "repeat0": {
                repetition = '*';
            }
            case "repeat1": {
                Element[] childElements = XmlGrammarInput.childElements(element);
                if (childElements.length == 1) {
                    return this.process(childElements[0]) + repetition;
                }
                if (childElements.length == 2) {
                    return this.process(childElements[0]) + repetition + repetition + this.process(childElements[1]);
                }
                throw XmlGrammarInput.invalidChildElementsException(element, childElements);
            }
            case "sep": {
                return this.process(XmlGrammarInput.singletonChildElement(element));
            }
            case "exclusion": {
                charsetPrefix = "~";
            }
            case "inclusion": {
                for (Element child : XmlGrammarInput.childElements(element)) {
                    strings.add(this.process(child));
                }
                return element.getAttribute("tmark") + charsetPrefix + "[" + String.join((CharSequence)"; ", strings) + "]";
            }
            case "member": {
                if (!element.getAttribute("hex").isEmpty()) {
                    if (!element.getAttribute("hex").matches("^[0-9A-Fa-f]+$")) {
                        Errors.S06.thro(element.getAttribute("hex"));
                    }
                    return "#" + element.getAttribute("hex");
                }
                String code = element.getAttribute("code");
                if (!code.isEmpty()) {
                    return code;
                }
                String from = element.getAttribute("from");
                String to = element.getAttribute("to");
                if (!from.isEmpty() && !to.isEmpty()) {
                    if (from.startsWith("#") && !from.matches("^[0-9A-Fa-f]+$")) {
                        Errors.S06.thro(from.substring(1));
                    }
                    if (to.startsWith("#") && !to.matches("^[0-9A-Fa-f]+$")) {
                        Errors.S06.thro(to.substring(1));
                    }
                    return (String)(from.startsWith("#") ? from : "'" + from.replace("'", "''") + "'") + "-" + (String)(to.startsWith("#") ? to : "'" + to.replace("'", "''") + "'");
                }
                return "'" + element.getAttribute("string").replace("'", "''") + "'";
            }
            case "insertion": {
                if (!element.getAttribute("hex").isEmpty()) {
                    if (!element.getAttribute("hex").matches("^[0-9A-Fa-f]+$")) {
                        Errors.S06.thro(element.getAttribute("hex"));
                    }
                    return "+#" + element.getAttribute("hex");
                }
                return "+'" + element.getAttribute("string").replace("'", "''") + "'";
            }
        }
        throw new BlitzException("Unsupported element: " + element.getLocalName());
    }

    public static Element singletonChildElement(Element element) {
        Element[] childElements = XmlGrammarInput.childElements(element);
        if (childElements.length != 1) {
            throw XmlGrammarInput.invalidChildElementsException(element, childElements);
        }
        return childElements[0];
    }

    public static BlitzException invalidChildElementsException(Element element, Element[] childElements) {
        return new BlitzException("Invalid child elements of " + element.getLocalName() + ": " + Arrays.stream(childElements).map(Node::getLocalName).collect(Collectors.joining(", ")));
    }

    public static Element[] childElements(Element element) {
        NodeList childNodes = element.getChildNodes();
        ArrayList<Element> childElements = new ArrayList<Element>();
        int l = childNodes.getLength();
        for (int i = 0; i < l; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || "comment".equals(childNode.getLocalName())) continue;
            childElements.add((Element)childNode);
        }
        return (Element[])childElements.toArray(Element[]::new);
    }

    static {
        try {
            dbFactory.setValidating(false);
            dbFactory.setNamespaceAware(true);
            dbFactory.setFeature("http://xml.org/sax/features/validation", false);
            dbFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        elements = Set.of("alt", "alts", "comment", "exclusion", "inclusion", "insertion", "ixml", "literal", "member", "nonterminal", "option", "repeat0", "repeat1", "rule", "sep");
    }
}

