/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.sql.JDBCConnections;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.AtomType;

abstract class SqlFn
extends StandardFunc {
    SqlFn() {
    }

    final PreparedStatement prepared(QueryContext qc) throws QueryException {
        return (PreparedStatement)this.conn(qc, 2, false);
    }

    final Connection connection(QueryContext qc) throws QueryException {
        return (Connection)this.conn(qc, 1, false);
    }

    final AutoCloseable get(QueryContext qc, boolean close) throws QueryException {
        return this.conn(qc, 0, close);
    }

    static JDBCConnections jdbc(QueryContext qc) {
        return qc.resources.index(JDBCConnections.class);
    }

    private AutoCloseable conn(QueryContext qc, int mode, boolean close) throws QueryException {
        JDBCConnections conns = SqlFn.jdbc(qc);
        Uri id = (Uri)this.checkType(this.arg(0), AtomType.ANY_URI, qc);
        AutoCloseable ac = conns.get(id);
        switch (mode) {
            case 1: {
                if (ac instanceof Connection) break;
                throw QueryError.SQL_ID1_X.get(this.info, id);
            }
            case 2: {
                if (ac instanceof PreparedStatement) break;
                throw QueryError.SQL_ID2_X.get(this.info, id);
            }
            default: {
                if (ac != null) break;
                throw QueryError.SQL_ID1_X.get(this.info, id);
            }
        }
        if (close) {
            conns.remove(id);
        }
        return ac;
    }
}

