// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include <vector>

#include "base/android/jni_array.h"
#include "base/check.h"
#include "testing/android/native_test/native_test_util.h"

// Must come after all headers that specialize FromJniType() / ToJniType().
#include "testing/android/native_test/native_main_runner_jni/MainRunner_jni.h"

extern int main(int argc, char** argv);

namespace testing {
namespace android {

static int32_t JNI_MainRunner_RunMain(
    JNIEnv* env,
    const base::android::JavaRef<jobjectArray>& command_line) {
  // Guards against process being reused.
  // In most cases, running main again will cause problems (static variables,
  // singletons, lazy instances won't be in the same state as a clean run).
  static bool alreadyRun = false;
  CHECK(!alreadyRun);
  alreadyRun = true;

  std::vector<std::string> cpp_command_line;
  base::android::AppendJavaStringArrayToStringVector(env, command_line,
                                                     &cpp_command_line);

  std::vector<char*> argv;
  int argc = ArgsToArgv(cpp_command_line, &argv);
  return main(argc, &argv[0]);
}

}  // namespace android
}  // namespace testing

DEFINE_JNI(MainRunner)
