// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_3_2_autogen.cpp:
//   Defines the GLES 3.2 entry points.

#include "libGLESv2/entry_points_gles_3_2_autogen.h"

#include "common/entry_points_enum_autogen.h"
#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/capture_gles_3_2_autogen.h"
#include "libANGLE/context_private_call.inl.h"
#include "libANGLE/context_private_call_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationES32.h"
#include "libGLESv2/global_state.h"

using namespace gl;

extern "C" {
void GL_APIENTRY GL_BlendBarrier()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBlendBarrier, "context = %d", CID(context)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendBarrier(context, angle::EntryPoint::GLBlendBarrier);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLBlendBarrier);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->blendBarrier();
        }
        ANGLE_CAPTURE_GL(BlendBarrier, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendBarrier);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendEquationSeparatei(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBlendEquationSeparatei,
                            "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s", CID(context),
                            buf, GLenumToString(GLESEnum::BlendEquationModeEXT, modeRGB),
                            GLenumToString(GLESEnum::BlendEquationModeEXT, modeAlpha)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendEquationSeparatei(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendEquationSeparatei, buf, modeRGB, modeAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLBlendEquationSeparatei);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendEquationSeparatei(context->getMutablePrivateState(),
                                                 context->getMutablePrivateStateCache(), buf,
                                                 modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE_GL(BlendEquationSeparatei, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendEquationSeparatei);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendEquationi(GLuint buf, GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBlendEquationi, "context = %d, buf = %u, mode = %s",
                            CID(context), buf,
                            GLenumToString(GLESEnum::BlendEquationModeEXT, mode)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendEquationi(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendEquationi, buf, mode);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLBlendEquationi);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendEquationi(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), buf, mode);
        }
        ANGLE_CAPTURE_GL(BlendEquationi, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendEquationi);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_BlendFuncSeparatei(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLBlendFuncSeparatei,
              "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
              CID(context), buf, GLenumToString(GLESEnum::BlendingFactor, srcRGB),
              GLenumToString(GLESEnum::BlendingFactor, dstRGB),
              GLenumToString(GLESEnum::BlendingFactor, srcAlpha),
              GLenumToString(GLESEnum::BlendingFactor, dstAlpha)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendFuncSeparatei(context->getPrivateState(),
                                                         context->getMutableErrorSetForValidation(),
                                                         angle::EntryPoint::GLBlendFuncSeparatei,
                                                         buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLBlendFuncSeparatei);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendFuncSeparatei(context->getMutablePrivateState(),
                                             context->getMutablePrivateStateCache(), buf, srcRGB,
                                             dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE_GL(BlendFuncSeparatei, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                         dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendFuncSeparatei);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendFunci(GLuint buf, GLenum src, GLenum dst)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBlendFunci, "context = %d, buf = %u, src = %s, dst = %s",
                            CID(context), buf, GLenumToString(GLESEnum::BlendingFactor, src),
                            GLenumToString(GLESEnum::BlendingFactor, dst)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendFunci(context->getPrivateState(),
                                                 context->getMutableErrorSetForValidation(),
                                                 angle::EntryPoint::GLBlendFunci, buf, src, dst);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLBlendFunci);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendFunci(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), buf, src, dst);
        }
        ANGLE_CAPTURE_GL(BlendFunci, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendFunci);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLColorMaski,
                            "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s",
                            CID(context), index, GLbooleanToString(r), GLbooleanToString(g),
                            GLbooleanToString(b), GLbooleanToString(a)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateColorMaski(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLColorMaski, index, r, g, b, a);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLColorMaski);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateColorMaski(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), index, r, g, b, a);
        }
        ANGLE_CAPTURE_GL(ColorMaski, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLColorMaski);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_CopyImageSubData(GLuint srcName,
                                     GLenum srcTarget,
                                     GLint srcLevel,
                                     GLint srcX,
                                     GLint srcY,
                                     GLint srcZ,
                                     GLuint dstName,
                                     GLenum dstTarget,
                                     GLint dstLevel,
                                     GLint dstX,
                                     GLint dstY,
                                     GLint dstZ,
                                     GLsizei srcWidth,
                                     GLsizei srcHeight,
                                     GLsizei srcDepth)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLCopyImageSubData,
              "context = %d, srcName = %u, srcTarget = %s, srcLevel = %d, srcX = %d, srcY = %d, "
              "srcZ = %d, dstName = %u, dstTarget = %s, dstLevel = %d, dstX = %d, dstY = %d, dstZ "
              "= %d, srcWidth = %d, srcHeight = %d, srcDepth = %d",
              CID(context), srcName, GLenumToString(GLESEnum::CopyImageSubDataTarget, srcTarget),
              srcLevel, srcX, srcY, srcZ, dstName,
              GLenumToString(GLESEnum::CopyImageSubDataTarget, dstTarget), dstLevel, dstX, dstY,
              dstZ, srcWidth, srcHeight, srcDepth));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopyImageSubData(
                    context, angle::EntryPoint::GLCopyImageSubData, srcName, srcTarget, srcLevel,
                    srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                    srcHeight, srcDepth);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLCopyImageSubData);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE_GL(CopyImageSubData, isCallValid, context, srcName, srcTarget, srcLevel, srcX,
                         srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                         srcHeight, srcDepth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopyImageSubData);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DebugMessageCallback(GLDEBUGPROC callback, const void *userParam)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDebugMessageCallback,
                            "context = %d, callback = 0x%016" PRIxPTR ", userParam = 0x%016" PRIxPTR
                            "",
                            CID(context), (uintptr_t)callback, (uintptr_t)userParam));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDebugMessageCallback(
                    context, angle::EntryPoint::GLDebugMessageCallback, callback, userParam);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLDebugMessageCallback);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->debugMessageCallback(callback, userParam);
        }
        ANGLE_CAPTURE_GL(DebugMessageCallback, isCallValid, context, callback, userParam);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDebugMessageCallback);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DebugMessageControl(GLenum source,
                                        GLenum type,
                                        GLenum severity,
                                        GLsizei count,
                                        const GLuint *ids,
                                        GLboolean enabled)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLDebugMessageControl,
        "context = %d, source = %s, type = %s, severity = %s, count = %d, ids = 0x%016" PRIxPTR
        ", enabled = %s",
        CID(context), GLenumToString(GLESEnum::DebugSource, source),
        GLenumToString(GLESEnum::DebugType, type),
        GLenumToString(GLESEnum::DebugSeverity, severity), count, (uintptr_t)ids,
        GLbooleanToString(enabled)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateDebugMessageControl(context, angle::EntryPoint::GLDebugMessageControl,
                                                source, type, severity, count, ids, enabled);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLDebugMessageControl);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
        ANGLE_CAPTURE_GL(DebugMessageControl, isCallValid, context, source, type, severity, count,
                         ids, enabled);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDebugMessageControl);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DebugMessageInsert(GLenum source,
                                       GLenum type,
                                       GLuint id,
                                       GLenum severity,
                                       GLsizei length,
                                       const GLchar *buf)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDebugMessageInsert,
                            "context = %d, source = %s, type = %s, id = %u, severity = %s, length "
                            "= %d, buf = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::DebugSource, source),
                            GLenumToString(GLESEnum::DebugType, type), id,
                            GLenumToString(GLESEnum::DebugSeverity, severity), length,
                            (uintptr_t)buf));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateDebugMessageInsert(context, angle::EntryPoint::GLDebugMessageInsert,
                                               source, type, id, severity, length, buf);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLDebugMessageInsert);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
        ANGLE_CAPTURE_GL(DebugMessageInsert, isCallValid, context, source, type, id, severity,
                         length, buf);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDebugMessageInsert);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Disablei(GLenum target, GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDisablei, "context = %d, target = %s, index = %u",
                            CID(context), GLenumToString(GLESEnum::EnableCap, target), index));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDisablei(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLDisablei, target, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLDisablei);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateDisablei(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), target, index);
        }
        ANGLE_CAPTURE_GL(Disablei, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDisablei);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsBaseVertex(GLenum mode,
                                           GLsizei count,
                                           GLenum type,
                                           const void *indices,
                                           GLint basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLDrawElementsBaseVertex,
              "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
              ", basevertex = %d",
              CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
              GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, basevertex));

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsBaseVertex(
                    context, angle::EntryPoint::GLDrawElementsBaseVertex, modePacked, count,
                    typePacked, indices, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLDrawElementsBaseVertex);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE_GL(DrawElementsBaseVertex, isCallValid, context, modePacked, count,
                         typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawElementsBaseVertex);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertex(GLenum mode,
                                                    GLsizei count,
                                                    GLenum type,
                                                    const void *indices,
                                                    GLsizei instancecount,
                                                    GLint basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLDrawElementsInstancedBaseVertex,
              "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
              ", instancecount = %d, basevertex = %d",
              CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
              GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, instancecount,
              basevertex));

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsInstancedBaseVertex(
                    context, angle::EntryPoint::GLDrawElementsInstancedBaseVertex, modePacked,
                    count, typePacked, indices, instancecount, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context,
                                       angle::EntryPoint::GLDrawElementsInstancedBaseVertex);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedBaseVertex, isCallValid, context, modePacked, count,
                         typePacked, indices, instancecount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsInstancedBaseVertex);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawRangeElementsBaseVertex(GLenum mode,
                                                GLuint start,
                                                GLuint end,
                                                GLsizei count,
                                                GLenum type,
                                                const void *indices,
                                                GLint basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDrawRangeElementsBaseVertex,
                            "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, "
                            "indices = 0x%016" PRIxPTR ", basevertex = %d",
                            CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), start, end,
                            count, GLenumToString(GLESEnum::DrawElementsType, type),
                            (uintptr_t)indices, basevertex));

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawRangeElementsBaseVertex(
                    context, angle::EntryPoint::GLDrawRangeElementsBaseVertex, modePacked, start,
                    end, count, typePacked, indices, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLDrawRangeElementsBaseVertex);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE_GL(DrawRangeElementsBaseVertex, isCallValid, context, modePacked, start, end,
                         count, typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawRangeElementsBaseVertex);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Enablei(GLenum target, GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLEnablei, "context = %d, target = %s, index = %u",
                            CID(context), GLenumToString(GLESEnum::EnableCap, target), index));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEnablei(context->getPrivateState(),
                                              context->getMutableErrorSetForValidation(),
                                              angle::EntryPoint::GLEnablei, target, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLEnablei);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateEnablei(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), target, index);
        }
        ANGLE_CAPTURE_GL(Enablei, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLEnablei);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferTexture(GLenum target,
                                       GLenum attachment,
                                       GLuint texture,
                                       GLint level)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLFramebufferTexture,
                            "context = %d, target = %s, attachment = %s, texture = %u, level = %d",
                            CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
                            GLenumToString(GLESEnum::FramebufferAttachment, attachment), texture,
                            level));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateFramebufferTexture(context, angle::EntryPoint::GLFramebufferTexture,
                                               target, attachment, texturePacked, level);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLFramebufferTexture);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE_GL(FramebufferTexture, isCallValid, context, target, attachment,
                         texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLFramebufferTexture);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLuint GL_APIENTRY GL_GetDebugMessageLog(GLuint count,
                                         GLsizei bufSize,
                                         GLenum *sources,
                                         GLenum *types,
                                         GLuint *ids,
                                         GLenum *severities,
                                         GLsizei *lengths,
                                         GLchar *messageLog)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetDebugMessageLog,
              "context = %d, count = %u, bufSize = %d, sources = 0x%016" PRIxPTR
              ", types = 0x%016" PRIxPTR ", ids = 0x%016" PRIxPTR ", severities = 0x%016" PRIxPTR
              ", lengths = 0x%016" PRIxPTR ", messageLog = 0x%016" PRIxPTR "",
              CID(context), count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
              (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog));

    GLuint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetDebugMessageLog(
                    context, angle::EntryPoint::GLGetDebugMessageLog, count, bufSize, sources,
                    types, ids, severities, lengths, messageLog);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetDebugMessageLog);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getDebugMessageLog(count, bufSize, sources, types, ids,
                                                      severities, lengths, messageLog);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLog, GLuint>();
        }
        ANGLE_CAPTURE_GL(GetDebugMessageLog, isCallValid, context, count, bufSize, sources, types,
                         ids, severities, lengths, messageLog, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetDebugMessageLog);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLog, GLuint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLenum GL_APIENTRY GL_GetGraphicsResetStatus()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetGraphicsResetStatus, "context = %d", CID(context)));

    GLenum returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetGraphicsResetStatus(
                    context, angle::EntryPoint::GLGetGraphicsResetStatus);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetGraphicsResetStatus);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatus, GLenum>();
        }
        ANGLE_CAPTURE_GL(GetGraphicsResetStatus, isCallValid, context, returnValue);
    }
    else
    {

        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatus, GLenum>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY
GL_GetObjectLabel(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetObjectLabel,
              "context = %d, identifier = %s, name = %u, bufSize = %d, length = 0x%016" PRIxPTR
              ", label = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::ObjectIdentifier, identifier), name, bufSize,
              (uintptr_t)length, (uintptr_t)label));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetObjectLabel(context, angle::EntryPoint::GLGetObjectLabel,
                                                     identifier, name, bufSize, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetObjectLabel);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
        ANGLE_CAPTURE_GL(GetObjectLabel, isCallValid, context, identifier, name, bufSize, length,
                         label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetObjectLabel);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetObjectPtrLabel(const void *ptr,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetObjectPtrLabel,
                            "context = %d, ptr = 0x%016" PRIxPTR
                            ", bufSize = %d, length = 0x%016" PRIxPTR ", label = 0x%016" PRIxPTR "",
                            CID(context), (uintptr_t)ptr, bufSize, (uintptr_t)length,
                            (uintptr_t)label));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetObjectPtrLabel(
                    context, angle::EntryPoint::GLGetObjectPtrLabel, ptr, bufSize, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetObjectPtrLabel);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
        ANGLE_CAPTURE_GL(GetObjectPtrLabel, isCallValid, context, ptr, bufSize, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetObjectPtrLabel);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPointerv(GLenum pname, void **params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetPointerv,
                            "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
                            GLenumToString(GLESEnum::GetPointervPName, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() < ES_2_0 ||
                             context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetPointerv(context, angle::EntryPoint::GLGetPointerv, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES1Or32(context, angle::EntryPoint::GLGetPointerv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE_GL(GetPointerv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetPointerv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetSamplerParameterIiv,
                            "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), sampler,
                            GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterIiv(
                    context, angle::EntryPoint::GLGetSamplerParameterIiv, samplerPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetSamplerParameterIiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterIiv, isCallValid, context, samplerPacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetSamplerParameterIiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetSamplerParameterIuiv,
                            "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), sampler,
                            GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterIuiv(
                    context, angle::EntryPoint::GLGetSamplerParameterIuiv, samplerPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetSamplerParameterIuiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterIuiv, isCallValid, context, samplerPacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSamplerParameterIuiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterIiv(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetTexParameterIiv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::GetTextureParameter, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterIiv(
                    context, angle::EntryPoint::GLGetTexParameterIiv, targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetTexParameterIiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterIiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexParameterIiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterIuiv(GLenum target, GLenum pname, GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetTexParameterIuiv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::GetTextureParameter, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterIuiv(
                    context, angle::EntryPoint::GLGetTexParameterIuiv, targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetTexParameterIuiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterIuiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexParameterIuiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetnUniformfv(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetnUniformfv,
              "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
              CID(context), program, location, bufSize, (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetnUniformfv(context, angle::EntryPoint::GLGetnUniformfv,
                                                    programPacked, locationPacked, bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetnUniformfv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformfv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformfv, isCallValid, context, programPacked, locationPacked,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetnUniformfv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetnUniformiv(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetnUniformiv,
              "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
              CID(context), program, location, bufSize, (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetnUniformiv(context, angle::EntryPoint::GLGetnUniformiv,
                                                    programPacked, locationPacked, bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetnUniformiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformiv, isCallValid, context, programPacked, locationPacked,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetnUniformiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetnUniformuiv(GLuint program, GLint location, GLsizei bufSize, GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetnUniformuiv,
              "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
              CID(context), program, location, bufSize, (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetnUniformuiv(context, angle::EntryPoint::GLGetnUniformuiv,
                                           programPacked, locationPacked, bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLGetnUniformuiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformuiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformuiv, isCallValid, context, programPacked, locationPacked,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetnUniformuiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsEnabledi(GLenum target, GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLIsEnabledi, "context = %d, target = %s, index = %u",
                            CID(context), GLenumToString(GLESEnum::EnableCap, target), index));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsEnabledi(context->getPrivateState(),
                                                 context->getMutableErrorSetForValidation(),
                                                 angle::EntryPoint::GLIsEnabledi, target, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLIsEnabledi);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue =
                ContextPrivateIsEnabledi(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabledi, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsEnabledi, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsEnabledi);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabledi, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_MinSampleShading(GLfloat value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLMinSampleShading, "context = %d, value = %f", CID(context), value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMinSampleShading(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLMinSampleShading, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLMinSampleShading);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateMinSampleShading(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), value);
        }
        ANGLE_CAPTURE_GL(MinSampleShading, isCallValid, context, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMinSampleShading);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ObjectLabel(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLObjectLabel,
              "context = %d, identifier = %s, name = %u, length = %d, label = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::ObjectIdentifier, identifier), name, length,
              (uintptr_t)label));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateObjectLabel(context, angle::EntryPoint::GLObjectLabel,
                                                  identifier, name, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLObjectLabel);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->objectLabel(identifier, name, length, label);
        }
        ANGLE_CAPTURE_GL(ObjectLabel, isCallValid, context, identifier, name, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLObjectLabel);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ObjectPtrLabel(const void *ptr, GLsizei length, const GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLObjectPtrLabel,
                            "context = %d, ptr = 0x%016" PRIxPTR
                            ", length = %d, label = 0x%016" PRIxPTR "",
                            CID(context), (uintptr_t)ptr, length, (uintptr_t)label));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateObjectPtrLabel(context, angle::EntryPoint::GLObjectPtrLabel,
                                                     ptr, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLObjectPtrLabel);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->objectPtrLabel(ptr, length, label);
        }
        ANGLE_CAPTURE_GL(ObjectPtrLabel, isCallValid, context, ptr, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLObjectPtrLabel);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PatchParameteri(GLenum pname, GLint value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLPatchParameteri, "context = %d, pname = %s, value = %d",
                            CID(context), GLenumToString(GLESEnum::PatchParameterName, pname),
                            value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePatchParameteri(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPatchParameteri, pname, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLPatchParameteri);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePatchParameteri(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), pname, value);
        }
        ANGLE_CAPTURE_GL(PatchParameteri, isCallValid, context, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPatchParameteri);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PopDebugGroup()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLPopDebugGroup, "context = %d", CID(context)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePopDebugGroup(context, angle::EntryPoint::GLPopDebugGroup);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLPopDebugGroup);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->popDebugGroup();
        }
        ANGLE_CAPTURE_GL(PopDebugGroup, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPopDebugGroup);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PrimitiveBoundingBox(GLfloat minX,
                                         GLfloat minY,
                                         GLfloat minZ,
                                         GLfloat minW,
                                         GLfloat maxX,
                                         GLfloat maxY,
                                         GLfloat maxZ,
                                         GLfloat maxW)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLPrimitiveBoundingBox,
                            "context = %d, minX = %f, minY = %f, minZ = %f, minW = %f, maxX = %f, "
                            "maxY = %f, maxZ = %f, maxW = %f",
                            CID(context), minX, minY, minZ, minW, maxX, maxY, maxZ, maxW));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePrimitiveBoundingBox(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPrimitiveBoundingBox, minX, minY, minZ, minW, maxX, maxY,
                    maxZ, maxW);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLPrimitiveBoundingBox);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePrimitiveBoundingBox(context->getMutablePrivateState(),
                                               context->getMutablePrivateStateCache(), minX, minY,
                                               minZ, minW, maxX, maxY, maxZ, maxW);
        }
        ANGLE_CAPTURE_GL(PrimitiveBoundingBox, isCallValid, context, minX, minY, minZ, minW, maxX,
                         maxY, maxZ, maxW);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPrimitiveBoundingBox);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PushDebugGroup(GLenum source, GLuint id, GLsizei length, const GLchar *message)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLPushDebugGroup,
              "context = %d, source = %s, id = %u, length = %d, message = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::DebugSource, source), id, length,
              (uintptr_t)message));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePushDebugGroup(context, angle::EntryPoint::GLPushDebugGroup,
                                                     source, id, length, message);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLPushDebugGroup);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->pushDebugGroup(source, id, length, message);
        }
        ANGLE_CAPTURE_GL(PushDebugGroup, isCallValid, context, source, id, length, message);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPushDebugGroup);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ReadnPixels(GLint x,
                                GLint y,
                                GLsizei width,
                                GLsizei height,
                                GLenum format,
                                GLenum type,
                                GLsizei bufSize,
                                void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLReadnPixels,
                            "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, "
                            "type = %s, bufSize = %d, data = 0x%016" PRIxPTR "",
                            CID(context), x, y, width, height,
                            GLenumToString(GLESEnum::PixelFormat, format),
                            GLenumToString(GLESEnum::PixelType, type), bufSize, (uintptr_t)data));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateReadnPixels(context, angle::EntryPoint::GLReadnPixels, x, y,
                                                  width, height, format, type, bufSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLReadnPixels);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
        ANGLE_CAPTURE_GL(ReadnPixels, isCallValid, context, x, y, width, height, format, type,
                         bufSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLReadnPixels);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLSamplerParameterIiv,
                            "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "",
                            CID(context), sampler,
                            GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)param));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSamplerParameterIiv(
                    context, angle::EntryPoint::GLSamplerParameterIiv, samplerPacked, pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLSamplerParameterIiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterIiv, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLSamplerParameterIiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLSamplerParameterIuiv,
                            "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "",
                            CID(context), sampler,
                            GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)param));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateSamplerParameterIuiv(context, angle::EntryPoint::GLSamplerParameterIuiv,
                                                 samplerPacked, pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLSamplerParameterIuiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterIuiv, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLSamplerParameterIuiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexBuffer(GLenum target, GLenum internalformat, GLuint buffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLTexBuffer,
                            "context = %d, target = %s, internalformat = %s, buffer = %u",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::SizedInternalFormat, internalformat), buffer));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        BufferID bufferPacked    = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexBuffer(context, angle::EntryPoint::GLTexBuffer,
                                                targetPacked, internalformat, bufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLTexBuffer);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texBuffer(targetPacked, internalformat, bufferPacked);
        }
        ANGLE_CAPTURE_GL(TexBuffer, isCallValid, context, targetPacked, internalformat,
                         bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexBuffer);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexBufferRange(GLenum target,
                                   GLenum internalformat,
                                   GLuint buffer,
                                   GLintptr offset,
                                   GLsizeiptr size)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLTexBufferRange,
        "context = %d, target = %s, internalformat = %s, buffer = %u, offset = %llu, size = %llu",
        CID(context), GLenumToString(GLESEnum::TextureTarget, target),
        GLenumToString(GLESEnum::SizedInternalFormat, internalformat), buffer,
        static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        BufferID bufferPacked    = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexBufferRange(context, angle::EntryPoint::GLTexBufferRange,
                                                     targetPacked, internalformat, bufferPacked,
                                                     offset, size);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLTexBufferRange);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texBufferRange(targetPacked, internalformat, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE_GL(TexBufferRange, isCallValid, context, targetPacked, internalformat,
                         bufferPacked, offset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexBufferRange);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterIiv(GLenum target, GLenum pname, const GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLTexParameterIiv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::TextureParameterName, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterIiv(context, angle::EntryPoint::GLTexParameterIiv,
                                                      targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLTexParameterIiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterIiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameterIiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterIuiv(GLenum target, GLenum pname, const GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLTexParameterIuiv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::TextureParameterName, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterIuiv(
                    context, angle::EntryPoint::GLTexParameterIuiv, targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLTexParameterIuiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterIuiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameterIuiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorage3DMultisample(GLenum target,
                                            GLsizei samples,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLboolean fixedsamplelocations)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLTexStorage3DMultisample,
                            "context = %d, target = %s, samples = %d, internalformat = %s, width = "
                            "%d, height = %d, depth = %d, fixedsamplelocations = %s",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target), samples,
                            GLenumToString(GLESEnum::SizedInternalFormat, internalformat), width,
                            height, depth, GLbooleanToString(fixedsamplelocations)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_2))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorage3DMultisample(
                    context, angle::EntryPoint::GLTexStorage3DMultisample, targetPacked, samples,
                    internalformat, width, height, depth, fixedsamplelocations);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES32(context, angle::EntryPoint::GLTexStorage3DMultisample);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorage3DMultisample(targetPacked, samples, internalformat, width, height,
                                             depth, fixedsamplelocations);
        }
        ANGLE_CAPTURE_GL(TexStorage3DMultisample, isCallValid, context, targetPacked, samples,
                         internalformat, width, height, depth, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorage3DMultisample);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

}  // extern "C"
