// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_3_2_autogen.cpp:
//   Capture functions for the OpenGL ES 3.2 entry points.

#include "libANGLE/capture/capture_gles_3_2_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationES32.h"

using namespace angle;

namespace gl
{
CallCapture CaptureBlendBarrier(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLBlendBarrier, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationSeparatei(const State &glState,
                                          bool isCallValid,
                                          GLuint buf,
                                          GLenum modeRGB,
                                          GLenum modeAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("modeRGB", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum,
                             modeRGB);
    paramBuffer.addEnumParam("modeAlpha", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum,
                             modeAlpha);

    return CallCapture(angle::EntryPoint::GLBlendEquationSeparatei, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationi(const State &glState, bool isCallValid, GLuint buf, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("mode", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLBlendEquationi, std::move(paramBuffer));
}

CallCapture CaptureBlendFuncSeparatei(const State &glState,
                                      bool isCallValid,
                                      GLuint buf,
                                      GLenum srcRGB,
                                      GLenum dstRGB,
                                      GLenum srcAlpha,
                                      GLenum dstAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("srcRGB", GLESEnum::BlendingFactor, ParamType::TGLenum, srcRGB);
    paramBuffer.addEnumParam("dstRGB", GLESEnum::BlendingFactor, ParamType::TGLenum, dstRGB);
    paramBuffer.addEnumParam("srcAlpha", GLESEnum::BlendingFactor, ParamType::TGLenum, srcAlpha);
    paramBuffer.addEnumParam("dstAlpha", GLESEnum::BlendingFactor, ParamType::TGLenum, dstAlpha);

    return CallCapture(angle::EntryPoint::GLBlendFuncSeparatei, std::move(paramBuffer));
}

CallCapture CaptureBlendFunci(const State &glState,
                              bool isCallValid,
                              GLuint buf,
                              GLenum src,
                              GLenum dst)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("src", GLESEnum::BlendingFactor, ParamType::TGLenum, src);
    paramBuffer.addEnumParam("dst", GLESEnum::BlendingFactor, ParamType::TGLenum, dst);

    return CallCapture(angle::EntryPoint::GLBlendFunci, std::move(paramBuffer));
}

CallCapture CaptureColorMaski(const State &glState,
                              bool isCallValid,
                              GLuint index,
                              GLboolean r,
                              GLboolean g,
                              GLboolean b,
                              GLboolean a)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("r", ParamType::TGLboolean, r);
    paramBuffer.addValueParam("g", ParamType::TGLboolean, g);
    paramBuffer.addValueParam("b", ParamType::TGLboolean, b);
    paramBuffer.addValueParam("a", ParamType::TGLboolean, a);

    return CallCapture(angle::EntryPoint::GLColorMaski, std::move(paramBuffer));
}

CallCapture CaptureCopyImageSubData(const State &glState,
                                    bool isCallValid,
                                    GLuint srcName,
                                    GLenum srcTarget,
                                    GLint srcLevel,
                                    GLint srcX,
                                    GLint srcY,
                                    GLint srcZ,
                                    GLuint dstName,
                                    GLenum dstTarget,
                                    GLint dstLevel,
                                    GLint dstX,
                                    GLint dstY,
                                    GLint dstZ,
                                    GLsizei srcWidth,
                                    GLsizei srcHeight,
                                    GLsizei srcDepth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcName", ParamType::TGLuint, srcName);
    paramBuffer.addEnumParam("srcTarget", GLESEnum::CopyImageSubDataTarget, ParamType::TGLenum,
                             srcTarget);
    paramBuffer.addValueParam("srcLevel", ParamType::TGLint, srcLevel);
    paramBuffer.addValueParam("srcX", ParamType::TGLint, srcX);
    paramBuffer.addValueParam("srcY", ParamType::TGLint, srcY);
    paramBuffer.addValueParam("srcZ", ParamType::TGLint, srcZ);
    paramBuffer.addValueParam("dstName", ParamType::TGLuint, dstName);
    paramBuffer.addEnumParam("dstTarget", GLESEnum::CopyImageSubDataTarget, ParamType::TGLenum,
                             dstTarget);
    paramBuffer.addValueParam("dstLevel", ParamType::TGLint, dstLevel);
    paramBuffer.addValueParam("dstX", ParamType::TGLint, dstX);
    paramBuffer.addValueParam("dstY", ParamType::TGLint, dstY);
    paramBuffer.addValueParam("dstZ", ParamType::TGLint, dstZ);
    paramBuffer.addValueParam("srcWidth", ParamType::TGLsizei, srcWidth);
    paramBuffer.addValueParam("srcHeight", ParamType::TGLsizei, srcHeight);
    paramBuffer.addValueParam("srcDepth", ParamType::TGLsizei, srcDepth);

    return CallCapture(angle::EntryPoint::GLCopyImageSubData, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageCallback(const State &glState,
                                        bool isCallValid,
                                        GLDEBUGPROC callback,
                                        const void *userParam)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("callback", ParamType::TGLDEBUGPROC, callback);

    ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, userParam, &userParamParam.value);
        CaptureDebugMessageCallback_userParam(glState, callback, userParam, &userParamParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &userParamParam.value);
    }
    paramBuffer.addParam(std::move(userParamParam));

    return CallCapture(angle::EntryPoint::GLDebugMessageCallback, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageControl(const State &glState,
                                       bool isCallValid,
                                       GLenum source,
                                       GLenum type,
                                       GLenum severity,
                                       GLsizei count,
                                       const GLuint *ids,
                                       GLboolean enabled)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLESEnum::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLESEnum::DebugType, ParamType::TGLenum, type);
    paramBuffer.addEnumParam("severity", GLESEnum::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, ids, &idsParam.value);
        CaptureDebugMessageControl_ids(glState, source, type, severity, count, ids, enabled,
                                       &idsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &idsParam.value);
    }
    paramBuffer.addParam(std::move(idsParam));

    paramBuffer.addValueParam("enabled", ParamType::TGLboolean, enabled);

    return CallCapture(angle::EntryPoint::GLDebugMessageControl, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageInsert(const State &glState,
                                      bool isCallValid,
                                      GLenum source,
                                      GLenum type,
                                      GLuint id,
                                      GLenum severity,
                                      GLsizei length,
                                      const GLchar *buf)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLESEnum::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLESEnum::DebugType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addEnumParam("severity", GLESEnum::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture bufParam("buf", ParamType::TGLcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointer, buf, &bufParam.value);
        CaptureDebugMessageInsert_buf(glState, source, type, id, severity, length, buf, &bufParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &bufParam.value);
    }
    paramBuffer.addParam(std::move(bufParam));

    return CallCapture(angle::EntryPoint::GLDebugMessageInsert, std::move(paramBuffer));
}

CallCapture CaptureDisablei(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLDisablei, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsBaseVertex(const State &glState,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          GLsizei count,
                                          DrawElementsType typePacked,
                                          const void *indices,
                                          GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsBaseVertex_indices(glState, modePacked, count, typePacked, indices,
                                              basevertex, &indicesParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
    }
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(angle::EntryPoint::GLDrawElementsBaseVertex, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertex(const State &glState,
                                                   bool isCallValid,
                                                   PrimitiveMode modePacked,
                                                   GLsizei count,
                                                   DrawElementsType typePacked,
                                                   const void *indices,
                                                   GLsizei instancecount,
                                                   GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseVertex_indices(glState, modePacked, count, typePacked,
                                                       indices, instancecount, basevertex,
                                                       &indicesParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
    }
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedBaseVertex,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawRangeElementsBaseVertex(const State &glState,
                                               bool isCallValid,
                                               PrimitiveMode modePacked,
                                               GLuint start,
                                               GLuint end,
                                               GLsizei count,
                                               DrawElementsType typePacked,
                                               const void *indices,
                                               GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLuint, start);
    paramBuffer.addValueParam("end", ParamType::TGLuint, end);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawRangeElementsBaseVertex_indices(glState, modePacked, start, end, count,
                                                   typePacked, indices, basevertex, &indicesParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
    }
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(angle::EntryPoint::GLDrawRangeElementsBaseVertex, std::move(paramBuffer));
}

CallCapture CaptureEnablei(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLEnablei, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture(const State &glState,
                                      bool isCallValid,
                                      GLenum target,
                                      GLenum attachment,
                                      TextureID texturePacked,
                                      GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(angle::EntryPoint::GLFramebufferTexture, std::move(paramBuffer));
}

CallCapture CaptureGetDebugMessageLog(const State &glState,
                                      bool isCallValid,
                                      GLuint count,
                                      GLsizei bufSize,
                                      GLenum *sources,
                                      GLenum *types,
                                      GLuint *ids,
                                      GLenum *severities,
                                      GLsizei *lengths,
                                      GLchar *messageLog,
                                      GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture sourcesParam("sources", ParamType::TGLenumPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumPointer, sources, &sourcesParam.value);
        CaptureGetDebugMessageLog_sources(glState, count, bufSize, sources, types, ids, severities,
                                          lengths, messageLog, &sourcesParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &sourcesParam.value);
    }
    paramBuffer.addParam(std::move(sourcesParam));

    ParamCapture typesParam("types", ParamType::TGLenumPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumPointer, types, &typesParam.value);
        CaptureGetDebugMessageLog_types(glState, count, bufSize, sources, types, ids, severities,
                                        lengths, messageLog, &typesParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &typesParam.value);
    }
    paramBuffer.addParam(std::move(typesParam));

    ParamCapture idsParam("ids", ParamType::TGLuintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
        CaptureGetDebugMessageLog_ids(glState, count, bufSize, sources, types, ids, severities,
                                      lengths, messageLog, &idsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr), &idsParam.value);
    }
    paramBuffer.addParam(std::move(idsParam));

    ParamCapture severitiesParam("severities", ParamType::TGLenumPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumPointer, severities, &severitiesParam.value);
        CaptureGetDebugMessageLog_severities(glState, count, bufSize, sources, types, ids,
                                             severities, lengths, messageLog, &severitiesParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &severitiesParam.value);
    }
    paramBuffer.addParam(std::move(severitiesParam));

    ParamCapture lengthsParam("lengths", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, lengths, &lengthsParam.value);
        CaptureGetDebugMessageLog_lengths(glState, count, bufSize, sources, types, ids, severities,
                                          lengths, messageLog, &lengthsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthsParam.value);
    }
    paramBuffer.addParam(std::move(lengthsParam));

    ParamCapture messageLogParam("messageLog", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, messageLog, &messageLogParam.value);
        CaptureGetDebugMessageLog_messageLog(glState, count, bufSize, sources, types, ids,
                                             severities, lengths, messageLog, &messageLogParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &messageLogParam.value);
    }
    paramBuffer.addParam(std::move(messageLogParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetDebugMessageLog, std::move(paramBuffer));
}

CallCapture CaptureGetGraphicsResetStatus(const State &glState,
                                          bool isCallValid,
                                          GLenum returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetGraphicsResetStatus, std::move(paramBuffer));
}

CallCapture CaptureGetObjectLabel(const State &glState,
                                  bool isCallValid,
                                  GLenum identifier,
                                  GLuint name,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLESEnum::ObjectIdentifier, ParamType::TGLenum,
                             identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetObjectLabel_length(glState, identifier, name, bufSize, length, label,
                                     &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture labelParam("label", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
        CaptureGetObjectLabel_label(glState, identifier, name, bufSize, length, label, &labelParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &labelParam.value);
    }
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(angle::EntryPoint::GLGetObjectLabel, std::move(paramBuffer));
}

CallCapture CaptureGetObjectPtrLabel(const State &glState,
                                     bool isCallValid,
                                     const void *ptr,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *label)
{
    ParamBuffer paramBuffer;

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureGetObjectPtrLabel_ptr(glState, ptr, bufSize, length, label, &ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
    }
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetObjectPtrLabel_length(glState, ptr, bufSize, length, label, &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture labelParam("label", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
        CaptureGetObjectPtrLabel_label(glState, ptr, bufSize, length, label, &labelParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &labelParam.value);
    }
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(angle::EntryPoint::GLGetObjectPtrLabel, std::move(paramBuffer));
}

CallCapture CaptureGetPointerv(const State &glState, bool isCallValid, GLenum pname, void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::GetPointervPName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetPointerv_params(glState, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetPointerv, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIiv(const State &glState,
                                          bool isCallValid,
                                          SamplerID samplerPacked,
                                          GLenum pname,
                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIiv_params(glState, samplerPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuiv(const State &glState,
                                           bool isCallValid,
                                           SamplerID samplerPacked,
                                           GLenum pname,
                                           GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIuiv_params(glState, samplerPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIiv(const State &glState,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLenum pname,
                                      GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIiv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetTexParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuiv(const State &glState,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIuiv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetTexParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfv(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLsizei bufSize,
                                 GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetnUniformfv_params(glState, programPacked, locationPacked, bufSize, params,
                                    &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetnUniformfv, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformiv(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLsizei bufSize,
                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetnUniformiv_params(glState, programPacked, locationPacked, bufSize, params,
                                    &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetnUniformiv, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformuiv(const State &glState,
                                  bool isCallValid,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLsizei bufSize,
                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetnUniformuiv_params(glState, programPacked, locationPacked, bufSize, params,
                                     &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetnUniformuiv, std::move(paramBuffer));
}

CallCapture CaptureIsEnabledi(const State &glState,
                              bool isCallValid,
                              GLenum target,
                              GLuint index,
                              GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsEnabledi, std::move(paramBuffer));
}

CallCapture CaptureMinSampleShading(const State &glState, bool isCallValid, GLfloat value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);

    return CallCapture(angle::EntryPoint::GLMinSampleShading, std::move(paramBuffer));
}

CallCapture CaptureObjectLabel(const State &glState,
                               bool isCallValid,
                               GLenum identifier,
                               GLuint name,
                               GLsizei length,
                               const GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLESEnum::ObjectIdentifier, ParamType::TGLenum,
                             identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
        CaptureObjectLabel_label(glState, identifier, name, length, label, &labelParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &labelParam.value);
    }
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(angle::EntryPoint::GLObjectLabel, std::move(paramBuffer));
}

CallCapture CaptureObjectPtrLabel(const State &glState,
                                  bool isCallValid,
                                  const void *ptr,
                                  GLsizei length,
                                  const GLchar *label)
{
    ParamBuffer paramBuffer;

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureObjectPtrLabel_ptr(glState, ptr, length, label, &ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
    }
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
        CaptureObjectPtrLabel_label(glState, ptr, length, label, &labelParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &labelParam.value);
    }
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(angle::EntryPoint::GLObjectPtrLabel, std::move(paramBuffer));
}

CallCapture CapturePatchParameteri(const State &glState,
                                   bool isCallValid,
                                   GLenum pname,
                                   GLint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::PatchParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLint, value);

    return CallCapture(angle::EntryPoint::GLPatchParameteri, std::move(paramBuffer));
}

CallCapture CapturePopDebugGroup(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPopDebugGroup, std::move(paramBuffer));
}

CallCapture CapturePrimitiveBoundingBox(const State &glState,
                                        bool isCallValid,
                                        GLfloat minX,
                                        GLfloat minY,
                                        GLfloat minZ,
                                        GLfloat minW,
                                        GLfloat maxX,
                                        GLfloat maxY,
                                        GLfloat maxZ,
                                        GLfloat maxW)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("minX", ParamType::TGLfloat, minX);
    paramBuffer.addValueParam("minY", ParamType::TGLfloat, minY);
    paramBuffer.addValueParam("minZ", ParamType::TGLfloat, minZ);
    paramBuffer.addValueParam("minW", ParamType::TGLfloat, minW);
    paramBuffer.addValueParam("maxX", ParamType::TGLfloat, maxX);
    paramBuffer.addValueParam("maxY", ParamType::TGLfloat, maxY);
    paramBuffer.addValueParam("maxZ", ParamType::TGLfloat, maxZ);
    paramBuffer.addValueParam("maxW", ParamType::TGLfloat, maxW);

    return CallCapture(angle::EntryPoint::GLPrimitiveBoundingBox, std::move(paramBuffer));
}

CallCapture CapturePushDebugGroup(const State &glState,
                                  bool isCallValid,
                                  GLenum source,
                                  GLuint id,
                                  GLsizei length,
                                  const GLchar *message)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLESEnum::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture messageParam("message", ParamType::TGLcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointer, message, &messageParam.value);
        CapturePushDebugGroup_message(glState, source, id, length, message, &messageParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &messageParam.value);
    }
    paramBuffer.addParam(std::move(messageParam));

    return CallCapture(angle::EntryPoint::GLPushDebugGroup, std::move(paramBuffer));
}

CallCapture CaptureReadnPixels(const State &glState,
                               bool isCallValid,
                               GLint x,
                               GLint y,
                               GLsizei width,
                               GLsizei height,
                               GLenum format,
                               GLenum type,
                               GLsizei bufSize,
                               void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture dataParam("data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
        CaptureReadnPixels_data(glState, x, y, width, height, format, type, bufSize, data,
                                &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLReadnPixels, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIiv(const State &glState,
                                       bool isCallValid,
                                       SamplerID samplerPacked,
                                       GLenum pname,
                                       const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIiv_param(glState, samplerPacked, pname, param, &paramParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
    }
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(angle::EntryPoint::GLSamplerParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuiv(const State &glState,
                                        bool isCallValid,
                                        SamplerID samplerPacked,
                                        GLenum pname,
                                        const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIuiv_param(glState, samplerPacked, pname, param, &paramParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramParam.value);
    }
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(angle::EntryPoint::GLSamplerParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureTexBuffer(const State &glState,
                             bool isCallValid,
                             TextureType targetPacked,
                             GLenum internalformat,
                             BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(angle::EntryPoint::GLTexBuffer, std::move(paramBuffer));
}

CallCapture CaptureTexBufferRange(const State &glState,
                                  bool isCallValid,
                                  TextureType targetPacked,
                                  GLenum internalformat,
                                  BufferID bufferPacked,
                                  GLintptr offset,
                                  GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(angle::EntryPoint::GLTexBufferRange, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIiv(const State &glState,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLenum pname,
                                   const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIiv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLTexParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuiv(const State &glState,
                                    bool isCallValid,
                                    TextureType targetPacked,
                                    GLenum pname,
                                    const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIuiv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLTexParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DMultisample(const State &glState,
                                           bool isCallValid,
                                           TextureType targetPacked,
                                           GLsizei samples,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(angle::EntryPoint::GLTexStorage3DMultisample, std::move(paramBuffer));
}

}  // namespace gl
