// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from cl.xml and cl_angle_ext.xml.
//
// Copyright 2025 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_cl_autogen.cpp:
//   Capture functions for the OpenCL  entry points.

#include "libANGLE/capture/capture_cl_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationCL_autogen.h"

using namespace angle;

namespace cl
{

// CL 1.0
CallCapture CaptureGetPlatformIDs(bool isCallValid,
                                  cl_uint num_entries,
                                  cl_platform_id *platforms,
                                  cl_uint *num_platforms,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("num_entries", ParamType::Tcl_uint, num_entries);

    ParamCapture platformsParam("platforms", ParamType::Tcl_platform_idPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_platform_idPointer, platforms, &platformsParam.value);
        CaptureGetPlatformIDs_platforms(num_entries, platforms, num_platforms, &platformsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_platform_idPointer, static_cast<cl_platform_id *>(nullptr),
                       &platformsParam.value);
    }
    paramBuffer.addParam(std::move(platformsParam));

    ParamCapture num_platformsParam("num_platforms", ParamType::Tcl_uintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_uintPointer, num_platforms, &num_platformsParam.value);
        CaptureGetPlatformIDs_num_platforms(num_entries, platforms, num_platforms,
                                            &num_platformsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_platformsParam.value);
    }
    paramBuffer.addParam(std::move(num_platformsParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetPlatformIDs, std::move(paramBuffer));
}

CallCapture CaptureGetPlatformInfo(bool isCallValid,
                                   cl_platform_id platform,
                                   PlatformInfo param_namePacked,
                                   size_t param_value_size,
                                   void *param_value,
                                   size_t *param_value_size_ret,
                                   cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);
    paramBuffer.addValueParam("param_namePacked", ParamType::TPlatformInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetPlatformInfo_param_value(platform, param_namePacked, param_value_size,
                                           param_value, param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetPlatformInfo_param_value_size_ret(platform, param_namePacked, param_value_size,
                                                    param_value, param_value_size_ret,
                                                    &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetPlatformInfo, std::move(paramBuffer));
}

CallCapture CaptureGetDeviceIDs(bool isCallValid,
                                cl_platform_id platform,
                                DeviceType device_typePacked,
                                cl_uint num_entries,
                                cl_device_id *devices,
                                cl_uint *num_devices,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);
    paramBuffer.addValueParam("device_typePacked", ParamType::TDeviceType, device_typePacked);
    paramBuffer.addValueParam("num_entries", ParamType::Tcl_uint, num_entries);

    ParamCapture devicesParam("devices", ParamType::Tcl_device_idPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_device_idPointer, devices, &devicesParam.value);
        CaptureGetDeviceIDs_devices(platform, device_typePacked, num_entries, devices, num_devices,
                                    &devicesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_device_idPointer, static_cast<cl_device_id *>(nullptr),
                       &devicesParam.value);
    }
    paramBuffer.addParam(std::move(devicesParam));

    ParamCapture num_devicesParam("num_devices", ParamType::Tcl_uintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_uintPointer, num_devices, &num_devicesParam.value);
        CaptureGetDeviceIDs_num_devices(platform, device_typePacked, num_entries, devices,
                                        num_devices, &num_devicesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_devicesParam.value);
    }
    paramBuffer.addParam(std::move(num_devicesParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetDeviceIDs, std::move(paramBuffer));
}

CallCapture CaptureGetDeviceInfo(bool isCallValid,
                                 cl_device_id device,
                                 DeviceInfo param_namePacked,
                                 size_t param_value_size,
                                 void *param_value,
                                 size_t *param_value_size_ret,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("param_namePacked", ParamType::TDeviceInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetDeviceInfo_param_value(device, param_namePacked, param_value_size, param_value,
                                         param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetDeviceInfo_param_value_size_ret(device, param_namePacked, param_value_size,
                                                  param_value, param_value_size_ret,
                                                  &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetDeviceInfo, std::move(paramBuffer));
}

CallCapture CaptureCreateContext(bool isCallValid,
                                 const cl_context_properties *properties,
                                 cl_uint num_devices,
                                 const cl_device_id *devices,
                                 void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                               const void *private_info,
                                                               size_t cb,
                                                               void *user_data),
                                 void *user_data,
                                 cl_int *errcode_ret,
                                 cl_context returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture propertiesParam("properties", ParamType::Tcl_context_propertiesConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_context_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateContext_properties(properties, num_devices, devices, pfn_notify, user_data,
                                        errcode_ret, &propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_context_propertiesConstPointer,
                       static_cast<const cl_context_properties *>(nullptr), &propertiesParam.value);
    }
    paramBuffer.addParam(std::move(propertiesParam));

    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    ParamCapture devicesParam("devices", ParamType::Tcl_device_idConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer, devices, &devicesParam.value);
        CaptureCreateContext_devices(properties, num_devices, devices, pfn_notify, user_data,
                                     errcode_ret, &devicesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &devicesParam.value);
    }
    paramBuffer.addParam(std::move(devicesParam));

    ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_context_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_context_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureCreateContext_pfn_notify(properties, num_devices, devices, pfn_notify, user_data,
                                        errcode_ret, &pfn_notifyParam);
    }
    else
    {
        InitParamValue(
            ParamType::Tcl_context_func_type,
            static_cast<void(CL_CALLBACK *)(const char *errinfo, const void *private_info,
                                            size_t cb, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
    }
    paramBuffer.addParam(std::move(pfn_notifyParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureCreateContext_user_data(properties, num_devices, devices, pfn_notify, user_data,
                                       errcode_ret, &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateContext_errcode_ret(properties, num_devices, devices, pfn_notify, user_data,
                                         errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_context);
    InitParamValue(ParamType::Tcl_context, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateContext, std::move(paramBuffer));
}

CallCapture CaptureCreateContextFromType(bool isCallValid,
                                         const cl_context_properties *properties,
                                         DeviceType device_typePacked,
                                         void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                       const void *private_info,
                                                                       size_t cb,
                                                                       void *user_data),
                                         void *user_data,
                                         cl_int *errcode_ret,
                                         cl_context returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture propertiesParam("properties", ParamType::Tcl_context_propertiesConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_context_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateContextFromType_properties(properties, device_typePacked, pfn_notify,
                                                user_data, errcode_ret, &propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_context_propertiesConstPointer,
                       static_cast<const cl_context_properties *>(nullptr), &propertiesParam.value);
    }
    paramBuffer.addParam(std::move(propertiesParam));

    paramBuffer.addValueParam("device_typePacked", ParamType::TDeviceType, device_typePacked);

    ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_context_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_context_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureCreateContextFromType_pfn_notify(properties, device_typePacked, pfn_notify,
                                                user_data, errcode_ret, &pfn_notifyParam);
    }
    else
    {
        InitParamValue(
            ParamType::Tcl_context_func_type,
            static_cast<void(CL_CALLBACK *)(const char *errinfo, const void *private_info,
                                            size_t cb, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
    }
    paramBuffer.addParam(std::move(pfn_notifyParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureCreateContextFromType_user_data(properties, device_typePacked, pfn_notify, user_data,
                                               errcode_ret, &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateContextFromType_errcode_ret(properties, device_typePacked, pfn_notify,
                                                 user_data, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_context);
    InitParamValue(ParamType::Tcl_context, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateContextFromType, std::move(paramBuffer));
}

CallCapture CaptureRetainContext(bool isCallValid, cl_context context, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainContext, std::move(paramBuffer));
}

CallCapture CaptureReleaseContext(bool isCallValid, cl_context context, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseContext, std::move(paramBuffer));
}

CallCapture CaptureGetContextInfo(bool isCallValid,
                                  cl_context context,
                                  ContextInfo param_namePacked,
                                  size_t param_value_size,
                                  void *param_value,
                                  size_t *param_value_size_ret,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("param_namePacked", ParamType::TContextInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetContextInfo_param_value(context, param_namePacked, param_value_size, param_value,
                                          param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetContextInfo_param_value_size_ret(context, param_namePacked, param_value_size,
                                                   param_value, param_value_size_ret,
                                                   &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetContextInfo, std::move(paramBuffer));
}

CallCapture CaptureRetainCommandQueue(bool isCallValid,
                                      cl_command_queue command_queue,
                                      cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainCommandQueue, std::move(paramBuffer));
}

CallCapture CaptureReleaseCommandQueue(bool isCallValid,
                                       cl_command_queue command_queue,
                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseCommandQueue, std::move(paramBuffer));
}

CallCapture CaptureGetCommandQueueInfo(bool isCallValid,
                                       cl_command_queue command_queue,
                                       CommandQueueInfo param_namePacked,
                                       size_t param_value_size,
                                       void *param_value,
                                       size_t *param_value_size_ret,
                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("param_namePacked", ParamType::TCommandQueueInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetCommandQueueInfo_param_value(command_queue, param_namePacked, param_value_size,
                                               param_value, param_value_size_ret,
                                               &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetCommandQueueInfo_param_value_size_ret(
            command_queue, param_namePacked, param_value_size, param_value, param_value_size_ret,
            &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetCommandQueueInfo, std::move(paramBuffer));
}

CallCapture CaptureCreateBuffer(bool isCallValid,
                                cl_context context,
                                MemFlags flagsPacked,
                                size_t size,
                                void *host_ptr,
                                cl_int *errcode_ret,
                                cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);

    ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateBuffer_host_ptr(context, flagsPacked, size, host_ptr, errcode_ret,
                                     &host_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
    }
    paramBuffer.addParam(std::move(host_ptrParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateBuffer_errcode_ret(context, flagsPacked, size, host_ptr, errcode_ret,
                                        &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateBuffer, std::move(paramBuffer));
}

CallCapture CaptureRetainMemObject(bool isCallValid, cl_mem memobj, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainMemObject, std::move(paramBuffer));
}

CallCapture CaptureReleaseMemObject(bool isCallValid, cl_mem memobj, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseMemObject, std::move(paramBuffer));
}

CallCapture CaptureGetSupportedImageFormats(bool isCallValid,
                                            cl_context context,
                                            MemFlags flagsPacked,
                                            MemObjectType image_typePacked,
                                            cl_uint num_entries,
                                            cl_image_format *image_formats,
                                            cl_uint *num_image_formats,
                                            cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("image_typePacked", ParamType::TMemObjectType, image_typePacked);
    paramBuffer.addValueParam("num_entries", ParamType::Tcl_uint, num_entries);

    ParamCapture image_formatsParam("image_formats", ParamType::Tcl_image_formatPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_image_formatPointer, image_formats,
                       &image_formatsParam.value);
        CaptureGetSupportedImageFormats_image_formats(context, flagsPacked, image_typePacked,
                                                      num_entries, image_formats, num_image_formats,
                                                      &image_formatsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_image_formatPointer, static_cast<cl_image_format *>(nullptr),
                       &image_formatsParam.value);
    }
    paramBuffer.addParam(std::move(image_formatsParam));

    ParamCapture num_image_formatsParam("num_image_formats", ParamType::Tcl_uintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_uintPointer, num_image_formats,
                       &num_image_formatsParam.value);
        CaptureGetSupportedImageFormats_num_image_formats(
            context, flagsPacked, image_typePacked, num_entries, image_formats, num_image_formats,
            &num_image_formatsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_image_formatsParam.value);
    }
    paramBuffer.addParam(std::move(num_image_formatsParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetSupportedImageFormats, std::move(paramBuffer));
}

CallCapture CaptureGetMemObjectInfo(bool isCallValid,
                                    cl_mem memobj,
                                    MemInfo param_namePacked,
                                    size_t param_value_size,
                                    void *param_value,
                                    size_t *param_value_size_ret,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);
    paramBuffer.addValueParam("param_namePacked", ParamType::TMemInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetMemObjectInfo_param_value(memobj, param_namePacked, param_value_size, param_value,
                                            param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetMemObjectInfo_param_value_size_ret(memobj, param_namePacked, param_value_size,
                                                     param_value, param_value_size_ret,
                                                     &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetMemObjectInfo, std::move(paramBuffer));
}

CallCapture CaptureGetImageInfo(bool isCallValid,
                                cl_mem image,
                                ImageInfo param_namePacked,
                                size_t param_value_size,
                                void *param_value,
                                size_t *param_value_size_ret,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);
    paramBuffer.addValueParam("param_namePacked", ParamType::TImageInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetImageInfo_param_value(image, param_namePacked, param_value_size, param_value,
                                        param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetImageInfo_param_value_size_ret(image, param_namePacked, param_value_size,
                                                 param_value, param_value_size_ret,
                                                 &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetImageInfo, std::move(paramBuffer));
}

CallCapture CaptureRetainSampler(bool isCallValid, cl_sampler sampler, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::Tcl_sampler, sampler);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainSampler, std::move(paramBuffer));
}

CallCapture CaptureReleaseSampler(bool isCallValid, cl_sampler sampler, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::Tcl_sampler, sampler);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseSampler, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerInfo(bool isCallValid,
                                  cl_sampler sampler,
                                  SamplerInfo param_namePacked,
                                  size_t param_value_size,
                                  void *param_value,
                                  size_t *param_value_size_ret,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::Tcl_sampler, sampler);
    paramBuffer.addValueParam("param_namePacked", ParamType::TSamplerInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetSamplerInfo_param_value(sampler, param_namePacked, param_value_size, param_value,
                                          param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetSamplerInfo_param_value_size_ret(sampler, param_namePacked, param_value_size,
                                                   param_value, param_value_size_ret,
                                                   &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetSamplerInfo, std::move(paramBuffer));
}

CallCapture CaptureCreateProgramWithSource(bool isCallValid,
                                           cl_context context,
                                           cl_uint count,
                                           const char **strings,
                                           const size_t *lengths,
                                           cl_int *errcode_ret,
                                           cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("count", ParamType::Tcl_uint, count);

    ParamCapture stringsParam("strings", ParamType::TcharConstPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointerPointer, strings, &stringsParam.value);
        CaptureCreateProgramWithSource_strings(context, count, strings, lengths, errcode_ret,
                                               &stringsParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointerPointer, static_cast<const char **>(nullptr),
                       &stringsParam.value);
    }
    paramBuffer.addParam(std::move(stringsParam));

    ParamCapture lengthsParam("lengths", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, lengths, &lengthsParam.value);
        CaptureCreateProgramWithSource_lengths(context, count, strings, lengths, errcode_ret,
                                               &lengthsParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &lengthsParam.value);
    }
    paramBuffer.addParam(std::move(lengthsParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateProgramWithSource_errcode_ret(context, count, strings, lengths, errcode_ret,
                                                   &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateProgramWithSource, std::move(paramBuffer));
}

CallCapture CaptureCreateProgramWithBinary(bool isCallValid,
                                           cl_context context,
                                           cl_uint num_devices,
                                           const cl_device_id *device_list,
                                           const size_t *lengths,
                                           const unsigned char **binaries,
                                           cl_int *binary_status,
                                           cl_int *errcode_ret,
                                           cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureCreateProgramWithBinary_device_list(context, num_devices, device_list, lengths,
                                                   binaries, binary_status, errcode_ret,
                                                   &device_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
    }
    paramBuffer.addParam(std::move(device_listParam));

    ParamCapture lengthsParam("lengths", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, lengths, &lengthsParam.value);
        CaptureCreateProgramWithBinary_lengths(context, num_devices, device_list, lengths, binaries,
                                               binary_status, errcode_ret, &lengthsParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &lengthsParam.value);
    }
    paramBuffer.addParam(std::move(lengthsParam));

    ParamCapture binariesParam("binaries", ParamType::TcharUnsignedConstPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharUnsignedConstPointerPointer, binaries, &binariesParam.value);
        CaptureCreateProgramWithBinary_binaries(context, num_devices, device_list, lengths,
                                                binaries, binary_status, errcode_ret,
                                                &binariesParam);
    }
    else
    {
        InitParamValue(ParamType::TcharUnsignedConstPointerPointer,
                       static_cast<const unsigned char **>(nullptr), &binariesParam.value);
    }
    paramBuffer.addParam(std::move(binariesParam));

    ParamCapture binary_statusParam("binary_status", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, binary_status, &binary_statusParam.value);
        CaptureCreateProgramWithBinary_binary_status(context, num_devices, device_list, lengths,
                                                     binaries, binary_status, errcode_ret,
                                                     &binary_statusParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &binary_statusParam.value);
    }
    paramBuffer.addParam(std::move(binary_statusParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateProgramWithBinary_errcode_ret(context, num_devices, device_list, lengths,
                                                   binaries, binary_status, errcode_ret,
                                                   &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateProgramWithBinary, std::move(paramBuffer));
}

CallCapture CaptureRetainProgram(bool isCallValid, cl_program program, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainProgram, std::move(paramBuffer));
}

CallCapture CaptureReleaseProgram(bool isCallValid, cl_program program, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseProgram, std::move(paramBuffer));
}

CallCapture CaptureBuildProgram(bool isCallValid,
                                cl_program program,
                                cl_uint num_devices,
                                const cl_device_id *device_list,
                                const char *options,
                                void(CL_CALLBACK *pfn_notify)(cl_program program, void *user_data),
                                void *user_data,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureBuildProgram_device_list(program, num_devices, device_list, options, pfn_notify,
                                        user_data, &device_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
    }
    paramBuffer.addParam(std::move(device_listParam));

    ParamCapture optionsParam("options", ParamType::TcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointer, options, &optionsParam.value);
        CaptureBuildProgram_options(program, num_devices, device_list, options, pfn_notify,
                                    user_data, &optionsParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &optionsParam.value);
    }
    paramBuffer.addParam(std::move(optionsParam));

    ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_program_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureBuildProgram_pfn_notify(program, num_devices, device_list, options, pfn_notify,
                                       user_data, &pfn_notifyParam);
    }
    else
    {
        InitParamValue(
            ParamType::Tcl_program_func_type,
            static_cast<void(CL_CALLBACK *)(cl_program program, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
    }
    paramBuffer.addParam(std::move(pfn_notifyParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureBuildProgram_user_data(program, num_devices, device_list, options, pfn_notify,
                                      user_data, &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLBuildProgram, std::move(paramBuffer));
}

CallCapture CaptureGetProgramInfo(bool isCallValid,
                                  cl_program program,
                                  ProgramInfo param_namePacked,
                                  size_t param_value_size,
                                  void *param_value,
                                  size_t *param_value_size_ret,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("param_namePacked", ParamType::TProgramInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetProgramInfo_param_value(program, param_namePacked, param_value_size, param_value,
                                          param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetProgramInfo_param_value_size_ret(program, param_namePacked, param_value_size,
                                                   param_value, param_value_size_ret,
                                                   &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetProgramInfo, std::move(paramBuffer));
}

CallCapture CaptureGetProgramBuildInfo(bool isCallValid,
                                       cl_program program,
                                       cl_device_id device,
                                       ProgramBuildInfo param_namePacked,
                                       size_t param_value_size,
                                       void *param_value,
                                       size_t *param_value_size_ret,
                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("param_namePacked", ParamType::TProgramBuildInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetProgramBuildInfo_param_value(program, device, param_namePacked, param_value_size,
                                               param_value, param_value_size_ret,
                                               &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetProgramBuildInfo_param_value_size_ret(
            program, device, param_namePacked, param_value_size, param_value, param_value_size_ret,
            &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetProgramBuildInfo, std::move(paramBuffer));
}

CallCapture CaptureCreateKernel(bool isCallValid,
                                cl_program program,
                                const char *kernel_name,
                                cl_int *errcode_ret,
                                cl_kernel returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);

    ParamCapture kernel_nameParam("kernel_name", ParamType::TcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointer, kernel_name, &kernel_nameParam.value);
        CaptureCreateKernel_kernel_name(program, kernel_name, errcode_ret, &kernel_nameParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &kernel_nameParam.value);
    }
    paramBuffer.addParam(std::move(kernel_nameParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateKernel_errcode_ret(program, kernel_name, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_kernel);
    InitParamValue(ParamType::Tcl_kernel, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateKernel, std::move(paramBuffer));
}

CallCapture CaptureCreateKernelsInProgram(bool isCallValid,
                                          cl_program program,
                                          cl_uint num_kernels,
                                          cl_kernel *kernels,
                                          cl_uint *num_kernels_ret,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("num_kernels", ParamType::Tcl_uint, num_kernels);

    ParamCapture kernelsParam("kernels", ParamType::Tcl_kernelPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_kernelPointer, kernels, &kernelsParam.value);
        CaptureCreateKernelsInProgram_kernels(program, num_kernels, kernels, num_kernels_ret,
                                              &kernelsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_kernelPointer, static_cast<cl_kernel *>(nullptr),
                       &kernelsParam.value);
    }
    paramBuffer.addParam(std::move(kernelsParam));

    ParamCapture num_kernels_retParam("num_kernels_ret", ParamType::Tcl_uintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_uintPointer, num_kernels_ret, &num_kernels_retParam.value);
        CaptureCreateKernelsInProgram_num_kernels_ret(program, num_kernels, kernels,
                                                      num_kernels_ret, &num_kernels_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_kernels_retParam.value);
    }
    paramBuffer.addParam(std::move(num_kernels_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateKernelsInProgram, std::move(paramBuffer));
}

CallCapture CaptureRetainKernel(bool isCallValid, cl_kernel kernel, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainKernel, std::move(paramBuffer));
}

CallCapture CaptureReleaseKernel(bool isCallValid, cl_kernel kernel, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseKernel, std::move(paramBuffer));
}

CallCapture CaptureSetKernelArg(bool isCallValid,
                                cl_kernel kernel,
                                cl_uint arg_index,
                                size_t arg_size,
                                const void *arg_value,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("arg_index", ParamType::Tcl_uint, arg_index);
    paramBuffer.addValueParam("arg_size", ParamType::Tsize_t, arg_size);

    ParamCapture arg_valueParam("arg_value", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, arg_value, &arg_valueParam.value);
        CaptureSetKernelArg_arg_value(kernel, arg_index, arg_size, arg_value, &arg_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &arg_valueParam.value);
    }
    paramBuffer.addParam(std::move(arg_valueParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetKernelArg, std::move(paramBuffer));
}

CallCapture CaptureGetKernelInfo(bool isCallValid,
                                 cl_kernel kernel,
                                 KernelInfo param_namePacked,
                                 size_t param_value_size,
                                 void *param_value,
                                 size_t *param_value_size_ret,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetKernelInfo_param_value(kernel, param_namePacked, param_value_size, param_value,
                                         param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetKernelInfo_param_value_size_ret(kernel, param_namePacked, param_value_size,
                                                  param_value, param_value_size_ret,
                                                  &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetKernelInfo, std::move(paramBuffer));
}

CallCapture CaptureGetKernelWorkGroupInfo(bool isCallValid,
                                          cl_kernel kernel,
                                          cl_device_id device,
                                          KernelWorkGroupInfo param_namePacked,
                                          size_t param_value_size,
                                          void *param_value,
                                          size_t *param_value_size_ret,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelWorkGroupInfo,
                              param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetKernelWorkGroupInfo_param_value(kernel, device, param_namePacked,
                                                  param_value_size, param_value,
                                                  param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetKernelWorkGroupInfo_param_value_size_ret(
            kernel, device, param_namePacked, param_value_size, param_value, param_value_size_ret,
            &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetKernelWorkGroupInfo, std::move(paramBuffer));
}

CallCapture CaptureWaitForEvents(bool isCallValid,
                                 cl_uint num_events,
                                 const cl_event *event_list,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("num_events", ParamType::Tcl_uint, num_events);

    ParamCapture event_listParam("event_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_list, &event_listParam.value);
        CaptureWaitForEvents_event_list(num_events, event_list, &event_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_listParam.value);
    }
    paramBuffer.addParam(std::move(event_listParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLWaitForEvents, std::move(paramBuffer));
}

CallCapture CaptureGetEventInfo(bool isCallValid,
                                cl_event event,
                                EventInfo param_namePacked,
                                size_t param_value_size,
                                void *param_value,
                                size_t *param_value_size_ret,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);
    paramBuffer.addValueParam("param_namePacked", ParamType::TEventInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetEventInfo_param_value(event, param_namePacked, param_value_size, param_value,
                                        param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetEventInfo_param_value_size_ret(event, param_namePacked, param_value_size,
                                                 param_value, param_value_size_ret,
                                                 &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetEventInfo, std::move(paramBuffer));
}

CallCapture CaptureRetainEvent(bool isCallValid, cl_event event, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainEvent, std::move(paramBuffer));
}

CallCapture CaptureReleaseEvent(bool isCallValid, cl_event event, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseEvent, std::move(paramBuffer));
}

CallCapture CaptureGetEventProfilingInfo(bool isCallValid,
                                         cl_event event,
                                         ProfilingInfo param_namePacked,
                                         size_t param_value_size,
                                         void *param_value,
                                         size_t *param_value_size_ret,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);
    paramBuffer.addValueParam("param_namePacked", ParamType::TProfilingInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetEventProfilingInfo_param_value(event, param_namePacked, param_value_size,
                                                 param_value, param_value_size_ret,
                                                 &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetEventProfilingInfo_param_value_size_ret(event, param_namePacked, param_value_size,
                                                          param_value, param_value_size_ret,
                                                          &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetEventProfilingInfo, std::move(paramBuffer));
}

CallCapture CaptureFlush(bool isCallValid, cl_command_queue command_queue, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLFlush, std::move(paramBuffer));
}

CallCapture CaptureFinish(bool isCallValid, cl_command_queue command_queue, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLFinish, std::move(paramBuffer));
}

CallCapture CaptureEnqueueReadBuffer(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem buffer,
                                     cl_bool blocking_read,
                                     size_t offset,
                                     size_t size,
                                     void *ptr,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_read", ParamType::Tcl_bool, blocking_read);
    paramBuffer.addValueParam("offset", ParamType::Tsize_t, offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);

    ParamCapture ptrParam("ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, ptr, &ptrParam.value);
        CaptureEnqueueReadBuffer_ptr(command_queue, buffer, blocking_read, offset, size, ptr,
                                     num_events_in_wait_list, event_wait_list, event, &ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &ptrParam.value);
    }
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueReadBuffer_event_wait_list(command_queue, buffer, blocking_read, offset, size,
                                                 ptr, num_events_in_wait_list, event_wait_list,
                                                 event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueReadBuffer_event(command_queue, buffer, blocking_read, offset, size, ptr,
                                       num_events_in_wait_list, event_wait_list, event,
                                       &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueReadBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueWriteBuffer(bool isCallValid,
                                      cl_command_queue command_queue,
                                      cl_mem buffer,
                                      cl_bool blocking_write,
                                      size_t offset,
                                      size_t size,
                                      const void *ptr,
                                      cl_uint num_events_in_wait_list,
                                      const cl_event *event_wait_list,
                                      cl_event *event,
                                      cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_write", ParamType::Tcl_bool, blocking_write);
    paramBuffer.addValueParam("offset", ParamType::Tsize_t, offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureEnqueueWriteBuffer_ptr(command_queue, buffer, blocking_write, offset, size, ptr,
                                      num_events_in_wait_list, event_wait_list, event, &ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
    }
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueWriteBuffer_event_wait_list(command_queue, buffer, blocking_write, offset,
                                                  size, ptr, num_events_in_wait_list,
                                                  event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueWriteBuffer_event(command_queue, buffer, blocking_write, offset, size, ptr,
                                        num_events_in_wait_list, event_wait_list, event,
                                        &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueWriteBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyBuffer(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem src_buffer,
                                     cl_mem dst_buffer,
                                     size_t src_offset,
                                     size_t dst_offset,
                                     size_t size,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_buffer", ParamType::Tcl_mem, src_buffer);
    paramBuffer.addValueParam("dst_buffer", ParamType::Tcl_mem, dst_buffer);
    paramBuffer.addValueParam("src_offset", ParamType::Tsize_t, src_offset);
    paramBuffer.addValueParam("dst_offset", ParamType::Tsize_t, dst_offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyBuffer_event_wait_list(command_queue, src_buffer, dst_buffer, src_offset,
                                                 dst_offset, size, num_events_in_wait_list,
                                                 event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyBuffer_event(command_queue, src_buffer, dst_buffer, src_offset,
                                       dst_offset, size, num_events_in_wait_list, event_wait_list,
                                       event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueReadImage(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem image,
                                    cl_bool blocking_read,
                                    const size_t *origin,
                                    const size_t *region,
                                    size_t row_pitch,
                                    size_t slice_pitch,
                                    void *ptr,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);
    paramBuffer.addValueParam("blocking_read", ParamType::Tcl_bool, blocking_read);

    ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, origin, &originParam.value);
        CaptureEnqueueReadImage_origin(command_queue, image, blocking_read, origin, region,
                                       row_pitch, slice_pitch, ptr, num_events_in_wait_list,
                                       event_wait_list, event, &originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &originParam.value);
    }
    paramBuffer.addParam(std::move(originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueReadImage_region(command_queue, image, blocking_read, origin, region,
                                       row_pitch, slice_pitch, ptr, num_events_in_wait_list,
                                       event_wait_list, event, &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    paramBuffer.addValueParam("row_pitch", ParamType::Tsize_t, row_pitch);
    paramBuffer.addValueParam("slice_pitch", ParamType::Tsize_t, slice_pitch);

    ParamCapture ptrParam("ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, ptr, &ptrParam.value);
        CaptureEnqueueReadImage_ptr(command_queue, image, blocking_read, origin, region, row_pitch,
                                    slice_pitch, ptr, num_events_in_wait_list, event_wait_list,
                                    event, &ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &ptrParam.value);
    }
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueReadImage_event_wait_list(
            command_queue, image, blocking_read, origin, region, row_pitch, slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueReadImage_event(command_queue, image, blocking_read, origin, region,
                                      row_pitch, slice_pitch, ptr, num_events_in_wait_list,
                                      event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueReadImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueWriteImage(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem image,
                                     cl_bool blocking_write,
                                     const size_t *origin,
                                     const size_t *region,
                                     size_t input_row_pitch,
                                     size_t input_slice_pitch,
                                     const void *ptr,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);
    paramBuffer.addValueParam("blocking_write", ParamType::Tcl_bool, blocking_write);

    ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, origin, &originParam.value);
        CaptureEnqueueWriteImage_origin(
            command_queue, image, blocking_write, origin, region, input_row_pitch,
            input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, &originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &originParam.value);
    }
    paramBuffer.addParam(std::move(originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueWriteImage_region(
            command_queue, image, blocking_write, origin, region, input_row_pitch,
            input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    paramBuffer.addValueParam("input_row_pitch", ParamType::Tsize_t, input_row_pitch);
    paramBuffer.addValueParam("input_slice_pitch", ParamType::Tsize_t, input_slice_pitch);

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureEnqueueWriteImage_ptr(command_queue, image, blocking_write, origin, region,
                                     input_row_pitch, input_slice_pitch, ptr,
                                     num_events_in_wait_list, event_wait_list, event, &ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
    }
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueWriteImage_event_wait_list(command_queue, image, blocking_write, origin,
                                                 region, input_row_pitch, input_slice_pitch, ptr,
                                                 num_events_in_wait_list, event_wait_list, event,
                                                 &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueWriteImage_event(
            command_queue, image, blocking_write, origin, region, input_row_pitch,
            input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueWriteImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyImage(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem src_image,
                                    cl_mem dst_image,
                                    const size_t *src_origin,
                                    const size_t *dst_origin,
                                    const size_t *region,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_image", ParamType::Tcl_mem, src_image);
    paramBuffer.addValueParam("dst_image", ParamType::Tcl_mem, dst_image);

    ParamCapture src_originParam("src_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, src_origin, &src_originParam.value);
        CaptureEnqueueCopyImage_src_origin(command_queue, src_image, dst_image, src_origin,
                                           dst_origin, region, num_events_in_wait_list,
                                           event_wait_list, event, &src_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &src_originParam.value);
    }
    paramBuffer.addParam(std::move(src_originParam));

    ParamCapture dst_originParam("dst_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, dst_origin, &dst_originParam.value);
        CaptureEnqueueCopyImage_dst_origin(command_queue, src_image, dst_image, src_origin,
                                           dst_origin, region, num_events_in_wait_list,
                                           event_wait_list, event, &dst_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &dst_originParam.value);
    }
    paramBuffer.addParam(std::move(dst_originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueCopyImage_region(command_queue, src_image, dst_image, src_origin, dst_origin,
                                       region, num_events_in_wait_list, event_wait_list, event,
                                       &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyImage_event_wait_list(command_queue, src_image, dst_image, src_origin,
                                                dst_origin, region, num_events_in_wait_list,
                                                event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyImage_event(command_queue, src_image, dst_image, src_origin, dst_origin,
                                      region, num_events_in_wait_list, event_wait_list, event,
                                      &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyImageToBuffer(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem src_image,
                                            cl_mem dst_buffer,
                                            const size_t *src_origin,
                                            const size_t *region,
                                            size_t dst_offset,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_image", ParamType::Tcl_mem, src_image);
    paramBuffer.addValueParam("dst_buffer", ParamType::Tcl_mem, dst_buffer);

    ParamCapture src_originParam("src_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, src_origin, &src_originParam.value);
        CaptureEnqueueCopyImageToBuffer_src_origin(command_queue, src_image, dst_buffer, src_origin,
                                                   region, dst_offset, num_events_in_wait_list,
                                                   event_wait_list, event, &src_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &src_originParam.value);
    }
    paramBuffer.addParam(std::move(src_originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueCopyImageToBuffer_region(command_queue, src_image, dst_buffer, src_origin,
                                               region, dst_offset, num_events_in_wait_list,
                                               event_wait_list, event, &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    paramBuffer.addValueParam("dst_offset", ParamType::Tsize_t, dst_offset);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyImageToBuffer_event_wait_list(
            command_queue, src_image, dst_buffer, src_origin, region, dst_offset,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyImageToBuffer_event(command_queue, src_image, dst_buffer, src_origin,
                                              region, dst_offset, num_events_in_wait_list,
                                              event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyImageToBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyBufferToImage(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem src_buffer,
                                            cl_mem dst_image,
                                            size_t src_offset,
                                            const size_t *dst_origin,
                                            const size_t *region,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_buffer", ParamType::Tcl_mem, src_buffer);
    paramBuffer.addValueParam("dst_image", ParamType::Tcl_mem, dst_image);
    paramBuffer.addValueParam("src_offset", ParamType::Tsize_t, src_offset);

    ParamCapture dst_originParam("dst_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, dst_origin, &dst_originParam.value);
        CaptureEnqueueCopyBufferToImage_dst_origin(command_queue, src_buffer, dst_image, src_offset,
                                                   dst_origin, region, num_events_in_wait_list,
                                                   event_wait_list, event, &dst_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &dst_originParam.value);
    }
    paramBuffer.addParam(std::move(dst_originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueCopyBufferToImage_region(command_queue, src_buffer, dst_image, src_offset,
                                               dst_origin, region, num_events_in_wait_list,
                                               event_wait_list, event, &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyBufferToImage_event_wait_list(
            command_queue, src_buffer, dst_image, src_offset, dst_origin, region,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyBufferToImage_event(command_queue, src_buffer, dst_image, src_offset,
                                              dst_origin, region, num_events_in_wait_list,
                                              event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyBufferToImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMapBuffer(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem buffer,
                                    cl_bool blocking_map,
                                    MapFlags map_flagsPacked,
                                    size_t offset,
                                    size_t size,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int *errcode_ret,
                                    void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_map", ParamType::Tcl_bool, blocking_map);
    paramBuffer.addValueParam("map_flagsPacked", ParamType::TMapFlags, map_flagsPacked);
    paramBuffer.addValueParam("offset", ParamType::Tsize_t, offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueMapBuffer_event_wait_list(
            command_queue, buffer, blocking_map, map_flagsPacked, offset, size,
            num_events_in_wait_list, event_wait_list, event, errcode_ret, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMapBuffer_event(command_queue, buffer, blocking_map, map_flagsPacked, offset,
                                      size, num_events_in_wait_list, event_wait_list, event,
                                      errcode_ret, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureEnqueueMapBuffer_errcode_ret(command_queue, buffer, blocking_map, map_flagsPacked,
                                            offset, size, num_events_in_wait_list, event_wait_list,
                                            event, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMapBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMapImage(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_mem image,
                                   cl_bool blocking_map,
                                   MapFlags map_flagsPacked,
                                   const size_t *origin,
                                   const size_t *region,
                                   size_t *image_row_pitch,
                                   size_t *image_slice_pitch,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   cl_int *errcode_ret,
                                   void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);
    paramBuffer.addValueParam("blocking_map", ParamType::Tcl_bool, blocking_map);
    paramBuffer.addValueParam("map_flagsPacked", ParamType::TMapFlags, map_flagsPacked);

    ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, origin, &originParam.value);
        CaptureEnqueueMapImage_origin(command_queue, image, blocking_map, map_flagsPacked, origin,
                                      region, image_row_pitch, image_slice_pitch,
                                      num_events_in_wait_list, event_wait_list, event, errcode_ret,
                                      &originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &originParam.value);
    }
    paramBuffer.addParam(std::move(originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueMapImage_region(command_queue, image, blocking_map, map_flagsPacked, origin,
                                      region, image_row_pitch, image_slice_pitch,
                                      num_events_in_wait_list, event_wait_list, event, errcode_ret,
                                      &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    ParamCapture image_row_pitchParam("image_row_pitch", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, image_row_pitch, &image_row_pitchParam.value);
        CaptureEnqueueMapImage_image_row_pitch(command_queue, image, blocking_map, map_flagsPacked,
                                               origin, region, image_row_pitch, image_slice_pitch,
                                               num_events_in_wait_list, event_wait_list, event,
                                               errcode_ret, &image_row_pitchParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &image_row_pitchParam.value);
    }
    paramBuffer.addParam(std::move(image_row_pitchParam));

    ParamCapture image_slice_pitchParam("image_slice_pitch", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, image_slice_pitch, &image_slice_pitchParam.value);
        CaptureEnqueueMapImage_image_slice_pitch(
            command_queue, image, blocking_map, map_flagsPacked, origin, region, image_row_pitch,
            image_slice_pitch, num_events_in_wait_list, event_wait_list, event, errcode_ret,
            &image_slice_pitchParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &image_slice_pitchParam.value);
    }
    paramBuffer.addParam(std::move(image_slice_pitchParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueMapImage_event_wait_list(command_queue, image, blocking_map, map_flagsPacked,
                                               origin, region, image_row_pitch, image_slice_pitch,
                                               num_events_in_wait_list, event_wait_list, event,
                                               errcode_ret, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMapImage_event(command_queue, image, blocking_map, map_flagsPacked, origin,
                                     region, image_row_pitch, image_slice_pitch,
                                     num_events_in_wait_list, event_wait_list, event, errcode_ret,
                                     &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureEnqueueMapImage_errcode_ret(command_queue, image, blocking_map, map_flagsPacked,
                                           origin, region, image_row_pitch, image_slice_pitch,
                                           num_events_in_wait_list, event_wait_list, event,
                                           errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMapImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueUnmapMemObject(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem memobj,
                                         void *mapped_ptr,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);

    ParamCapture mapped_ptrParam("mapped_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, mapped_ptr, &mapped_ptrParam.value);
        CaptureEnqueueUnmapMemObject_mapped_ptr(command_queue, memobj, mapped_ptr,
                                                num_events_in_wait_list, event_wait_list, event,
                                                &mapped_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &mapped_ptrParam.value);
    }
    paramBuffer.addParam(std::move(mapped_ptrParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueUnmapMemObject_event_wait_list(command_queue, memobj, mapped_ptr,
                                                     num_events_in_wait_list, event_wait_list,
                                                     event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueUnmapMemObject_event(command_queue, memobj, mapped_ptr,
                                           num_events_in_wait_list, event_wait_list, event,
                                           &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueUnmapMemObject, std::move(paramBuffer));
}

CallCapture CaptureEnqueueNDRangeKernel(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_kernel kernel,
                                        cl_uint work_dim,
                                        const size_t *global_work_offset,
                                        const size_t *global_work_size,
                                        const size_t *local_work_size,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("work_dim", ParamType::Tcl_uint, work_dim);

    ParamCapture global_work_offsetParam("global_work_offset", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, global_work_offset,
                       &global_work_offsetParam.value);
        CaptureEnqueueNDRangeKernel_global_work_offset(
            command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size,
            num_events_in_wait_list, event_wait_list, event, &global_work_offsetParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &global_work_offsetParam.value);
    }
    paramBuffer.addParam(std::move(global_work_offsetParam));

    ParamCapture global_work_sizeParam("global_work_size", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, global_work_size,
                       &global_work_sizeParam.value);
        CaptureEnqueueNDRangeKernel_global_work_size(
            command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size,
            num_events_in_wait_list, event_wait_list, event, &global_work_sizeParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &global_work_sizeParam.value);
    }
    paramBuffer.addParam(std::move(global_work_sizeParam));

    ParamCapture local_work_sizeParam("local_work_size", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, local_work_size,
                       &local_work_sizeParam.value);
        CaptureEnqueueNDRangeKernel_local_work_size(
            command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size,
            num_events_in_wait_list, event_wait_list, event, &local_work_sizeParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &local_work_sizeParam.value);
    }
    paramBuffer.addParam(std::move(local_work_sizeParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueNDRangeKernel_event_wait_list(
            command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueNDRangeKernel_event(
            command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size,
            num_events_in_wait_list, event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueNDRangeKernel, std::move(paramBuffer));
}

CallCapture CaptureEnqueueNativeKernel(bool isCallValid,
                                       cl_command_queue command_queue,
                                       void(CL_CALLBACK *user_func)(void *),
                                       void *args,
                                       size_t cb_args,
                                       cl_uint num_mem_objects,
                                       const cl_mem *mem_list,
                                       const void **args_mem_loc,
                                       cl_uint num_events_in_wait_list,
                                       const cl_event *event_wait_list,
                                       cl_event *event,
                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture user_funcParam("user_func", ParamType::Tcl_void_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_void_func_type, user_func, &user_funcParam.value);
        CaptureEnqueueNativeKernel_user_func(
            command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc,
            num_events_in_wait_list, event_wait_list, event, &user_funcParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_void_func_type,
                       static_cast<void(CL_CALLBACK *)(void *)>(nullptr), &user_funcParam.value);
    }
    paramBuffer.addParam(std::move(user_funcParam));

    ParamCapture argsParam("args", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, args, &argsParam.value);
        CaptureEnqueueNativeKernel_args(command_queue, user_func, args, cb_args, num_mem_objects,
                                        mem_list, args_mem_loc, num_events_in_wait_list,
                                        event_wait_list, event, &argsParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &argsParam.value);
    }
    paramBuffer.addParam(std::move(argsParam));

    paramBuffer.addValueParam("cb_args", ParamType::Tsize_t, cb_args);
    paramBuffer.addValueParam("num_mem_objects", ParamType::Tcl_uint, num_mem_objects);

    ParamCapture mem_listParam("mem_list", ParamType::Tcl_memConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_memConstPointer, mem_list, &mem_listParam.value);
        CaptureEnqueueNativeKernel_mem_list(
            command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc,
            num_events_in_wait_list, event_wait_list, event, &mem_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_memConstPointer, static_cast<const cl_mem *>(nullptr),
                       &mem_listParam.value);
    }
    paramBuffer.addParam(std::move(mem_listParam));

    ParamCapture args_mem_locParam("args_mem_loc", ParamType::TvoidConstPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointerPointer, args_mem_loc, &args_mem_locParam.value);
        CaptureEnqueueNativeKernel_args_mem_loc(
            command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc,
            num_events_in_wait_list, event_wait_list, event, &args_mem_locParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointerPointer, static_cast<const void **>(nullptr),
                       &args_mem_locParam.value);
    }
    paramBuffer.addParam(std::move(args_mem_locParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueNativeKernel_event_wait_list(
            command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueNativeKernel_event(command_queue, user_func, args, cb_args, num_mem_objects,
                                         mem_list, args_mem_loc, num_events_in_wait_list,
                                         event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueNativeKernel, std::move(paramBuffer));
}

CallCapture CaptureSetCommandQueueProperty(bool isCallValid,
                                           cl_command_queue command_queue,
                                           CommandQueueProperties propertiesPacked,
                                           cl_bool enable,
                                           cl_command_queue_properties *old_properties,
                                           cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("propertiesPacked", ParamType::TCommandQueueProperties,
                              propertiesPacked);
    paramBuffer.addValueParam("enable", ParamType::Tcl_bool, enable);

    ParamCapture old_propertiesParam("old_properties",
                                     ParamType::Tcl_command_queue_propertiesPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_command_queue_propertiesPointer, old_properties,
                       &old_propertiesParam.value);
        CaptureSetCommandQueueProperty_old_properties(command_queue, propertiesPacked, enable,
                                                      old_properties, &old_propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_command_queue_propertiesPointer,
                       static_cast<cl_command_queue_properties *>(nullptr),
                       &old_propertiesParam.value);
    }
    paramBuffer.addParam(std::move(old_propertiesParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetCommandQueueProperty, std::move(paramBuffer));
}

CallCapture CaptureCreateImage2D(bool isCallValid,
                                 cl_context context,
                                 MemFlags flagsPacked,
                                 const cl_image_format *image_format,
                                 size_t image_width,
                                 size_t image_height,
                                 size_t image_row_pitch,
                                 void *host_ptr,
                                 cl_int *errcode_ret,
                                 cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);

    ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_image_formatConstPointer, image_format,
                       &image_formatParam.value);
        CaptureCreateImage2D_image_format(context, flagsPacked, image_format, image_width,
                                          image_height, image_row_pitch, host_ptr, errcode_ret,
                                          &image_formatParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_image_formatConstPointer,
                       static_cast<const cl_image_format *>(nullptr), &image_formatParam.value);
    }
    paramBuffer.addParam(std::move(image_formatParam));

    paramBuffer.addValueParam("image_width", ParamType::Tsize_t, image_width);
    paramBuffer.addValueParam("image_height", ParamType::Tsize_t, image_height);
    paramBuffer.addValueParam("image_row_pitch", ParamType::Tsize_t, image_row_pitch);

    ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateImage2D_host_ptr(context, flagsPacked, image_format, image_width, image_height,
                                      image_row_pitch, host_ptr, errcode_ret, &host_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
    }
    paramBuffer.addParam(std::move(host_ptrParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateImage2D_errcode_ret(context, flagsPacked, image_format, image_width,
                                         image_height, image_row_pitch, host_ptr, errcode_ret,
                                         &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateImage2D, std::move(paramBuffer));
}

CallCapture CaptureCreateImage3D(bool isCallValid,
                                 cl_context context,
                                 MemFlags flagsPacked,
                                 const cl_image_format *image_format,
                                 size_t image_width,
                                 size_t image_height,
                                 size_t image_depth,
                                 size_t image_row_pitch,
                                 size_t image_slice_pitch,
                                 void *host_ptr,
                                 cl_int *errcode_ret,
                                 cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);

    ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_image_formatConstPointer, image_format,
                       &image_formatParam.value);
        CaptureCreateImage3D_image_format(
            context, flagsPacked, image_format, image_width, image_height, image_depth,
            image_row_pitch, image_slice_pitch, host_ptr, errcode_ret, &image_formatParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_image_formatConstPointer,
                       static_cast<const cl_image_format *>(nullptr), &image_formatParam.value);
    }
    paramBuffer.addParam(std::move(image_formatParam));

    paramBuffer.addValueParam("image_width", ParamType::Tsize_t, image_width);
    paramBuffer.addValueParam("image_height", ParamType::Tsize_t, image_height);
    paramBuffer.addValueParam("image_depth", ParamType::Tsize_t, image_depth);
    paramBuffer.addValueParam("image_row_pitch", ParamType::Tsize_t, image_row_pitch);
    paramBuffer.addValueParam("image_slice_pitch", ParamType::Tsize_t, image_slice_pitch);

    ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateImage3D_host_ptr(context, flagsPacked, image_format, image_width, image_height,
                                      image_depth, image_row_pitch, image_slice_pitch, host_ptr,
                                      errcode_ret, &host_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
    }
    paramBuffer.addParam(std::move(host_ptrParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateImage3D_errcode_ret(
            context, flagsPacked, image_format, image_width, image_height, image_depth,
            image_row_pitch, image_slice_pitch, host_ptr, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateImage3D, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMarker(bool isCallValid,
                                 cl_command_queue command_queue,
                                 cl_event *event,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMarker_event(command_queue, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMarker, std::move(paramBuffer));
}

CallCapture CaptureEnqueueWaitForEvents(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_uint num_events,
                                        const cl_event *event_list,
                                        cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_events", ParamType::Tcl_uint, num_events);

    ParamCapture event_listParam("event_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_list, &event_listParam.value);
        CaptureEnqueueWaitForEvents_event_list(command_queue, num_events, event_list,
                                               &event_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_listParam.value);
    }
    paramBuffer.addParam(std::move(event_listParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueWaitForEvents, std::move(paramBuffer));
}

CallCapture CaptureEnqueueBarrier(bool isCallValid,
                                  cl_command_queue command_queue,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueBarrier, std::move(paramBuffer));
}

CallCapture CaptureUnloadCompiler(bool isCallValid, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLUnloadCompiler, std::move(paramBuffer));
}

CallCapture CaptureGetExtensionFunctionAddress(bool isCallValid,
                                               const char *func_name,
                                               void *returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture func_nameParam("func_name", ParamType::TcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointer, func_name, &func_nameParam.value);
        CaptureGetExtensionFunctionAddress_func_name(func_name, &func_nameParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &func_nameParam.value);
    }
    paramBuffer.addParam(std::move(func_nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetExtensionFunctionAddress, std::move(paramBuffer));
}

CallCapture CaptureCreateCommandQueue(bool isCallValid,
                                      cl_context context,
                                      cl_device_id device,
                                      CommandQueueProperties propertiesPacked,
                                      cl_int *errcode_ret,
                                      cl_command_queue returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("propertiesPacked", ParamType::TCommandQueueProperties,
                              propertiesPacked);

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateCommandQueue_errcode_ret(context, device, propertiesPacked, errcode_ret,
                                              &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_command_queue);
    InitParamValue(ParamType::Tcl_command_queue, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateCommandQueue, std::move(paramBuffer));
}

CallCapture CaptureCreateSampler(bool isCallValid,
                                 cl_context context,
                                 cl_bool normalized_coords,
                                 AddressingMode addressing_modePacked,
                                 FilterMode filter_modePacked,
                                 cl_int *errcode_ret,
                                 cl_sampler returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("normalized_coords", ParamType::Tcl_bool, normalized_coords);
    paramBuffer.addValueParam("addressing_modePacked", ParamType::TAddressingMode,
                              addressing_modePacked);
    paramBuffer.addValueParam("filter_modePacked", ParamType::TFilterMode, filter_modePacked);

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateSampler_errcode_ret(context, normalized_coords, addressing_modePacked,
                                         filter_modePacked, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_sampler);
    InitParamValue(ParamType::Tcl_sampler, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateSampler, std::move(paramBuffer));
}

CallCapture CaptureEnqueueTask(bool isCallValid,
                               cl_command_queue command_queue,
                               cl_kernel kernel,
                               cl_uint num_events_in_wait_list,
                               const cl_event *event_wait_list,
                               cl_event *event,
                               cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueTask_event_wait_list(command_queue, kernel, num_events_in_wait_list,
                                           event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueTask_event(command_queue, kernel, num_events_in_wait_list, event_wait_list,
                                 event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueTask, std::move(paramBuffer));
}

// CL 1.1
CallCapture CaptureCreateSubBuffer(bool isCallValid,
                                   cl_mem buffer,
                                   MemFlags flagsPacked,
                                   cl_buffer_create_type buffer_create_type,
                                   const void *buffer_create_info,
                                   cl_int *errcode_ret,
                                   cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("buffer_create_type", ParamType::Tcl_buffer_create_type,
                              buffer_create_type);

    ParamCapture buffer_create_infoParam("buffer_create_info", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, buffer_create_info,
                       &buffer_create_infoParam.value);
        CaptureCreateSubBuffer_buffer_create_info(buffer, flagsPacked, buffer_create_type,
                                                  buffer_create_info, errcode_ret,
                                                  &buffer_create_infoParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &buffer_create_infoParam.value);
    }
    paramBuffer.addParam(std::move(buffer_create_infoParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateSubBuffer_errcode_ret(buffer, flagsPacked, buffer_create_type,
                                           buffer_create_info, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateSubBuffer, std::move(paramBuffer));
}

CallCapture CaptureSetMemObjectDestructorCallback(bool isCallValid,
                                                  cl_mem memobj,
                                                  void(CL_CALLBACK *pfn_notify)(cl_mem memobj,
                                                                                void *user_data),
                                                  void *user_data,
                                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);

    ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_mem_destructor_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_mem_destructor_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureSetMemObjectDestructorCallback_pfn_notify(memobj, pfn_notify, user_data,
                                                         &pfn_notifyParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_mem_destructor_func_type,
                       static_cast<void(CL_CALLBACK *)(cl_mem memobj, void *user_data)>(nullptr),
                       &pfn_notifyParam.value);
    }
    paramBuffer.addParam(std::move(pfn_notifyParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureSetMemObjectDestructorCallback_user_data(memobj, pfn_notify, user_data,
                                                        &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetMemObjectDestructorCallback, std::move(paramBuffer));
}

CallCapture CaptureCreateUserEvent(bool isCallValid,
                                   cl_context context,
                                   cl_int *errcode_ret,
                                   cl_event returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateUserEvent_errcode_ret(context, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_event);
    InitParamValue(ParamType::Tcl_event, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateUserEvent, std::move(paramBuffer));
}

CallCapture CaptureSetUserEventStatus(bool isCallValid,
                                      cl_event event,
                                      cl_int execution_status,
                                      cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);
    paramBuffer.addValueParam("execution_status", ParamType::Tcl_int, execution_status);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetUserEventStatus, std::move(paramBuffer));
}

CallCapture CaptureSetEventCallback(bool isCallValid,
                                    cl_event event,
                                    cl_int command_exec_callback_type,
                                    void(CL_CALLBACK *pfn_notify)(cl_event event,
                                                                  cl_int event_command_status,
                                                                  void *user_data),
                                    void *user_data,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);
    paramBuffer.addValueParam("command_exec_callback_type", ParamType::Tcl_int,
                              command_exec_callback_type);

    ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_callback_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_callback_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureSetEventCallback_pfn_notify(event, command_exec_callback_type, pfn_notify, user_data,
                                           &pfn_notifyParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_callback_func_type,
                       static_cast<void(CL_CALLBACK *)(cl_event event, cl_int event_command_status,
                                                       void *user_data)>(nullptr),
                       &pfn_notifyParam.value);
    }
    paramBuffer.addParam(std::move(pfn_notifyParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureSetEventCallback_user_data(event, command_exec_callback_type, pfn_notify, user_data,
                                          &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetEventCallback, std::move(paramBuffer));
}

CallCapture CaptureEnqueueReadBufferRect(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem buffer,
                                         cl_bool blocking_read,
                                         const size_t *buffer_origin,
                                         const size_t *host_origin,
                                         const size_t *region,
                                         size_t buffer_row_pitch,
                                         size_t buffer_slice_pitch,
                                         size_t host_row_pitch,
                                         size_t host_slice_pitch,
                                         void *ptr,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_read", ParamType::Tcl_bool, blocking_read);

    ParamCapture buffer_originParam("buffer_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, buffer_origin, &buffer_originParam.value);
        CaptureEnqueueReadBufferRect_buffer_origin(
            command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &buffer_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &buffer_originParam.value);
    }
    paramBuffer.addParam(std::move(buffer_originParam));

    ParamCapture host_originParam("host_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, host_origin, &host_originParam.value);
        CaptureEnqueueReadBufferRect_host_origin(
            command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &host_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &host_originParam.value);
    }
    paramBuffer.addParam(std::move(host_originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueReadBufferRect_region(
            command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    paramBuffer.addValueParam("buffer_row_pitch", ParamType::Tsize_t, buffer_row_pitch);
    paramBuffer.addValueParam("buffer_slice_pitch", ParamType::Tsize_t, buffer_slice_pitch);
    paramBuffer.addValueParam("host_row_pitch", ParamType::Tsize_t, host_row_pitch);
    paramBuffer.addValueParam("host_slice_pitch", ParamType::Tsize_t, host_slice_pitch);

    ParamCapture ptrParam("ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, ptr, &ptrParam.value);
        CaptureEnqueueReadBufferRect_ptr(
            command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &ptrParam.value);
    }
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueReadBufferRect_event_wait_list(
            command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueReadBufferRect_event(
            command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueReadBufferRect, std::move(paramBuffer));
}

CallCapture CaptureEnqueueWriteBufferRect(bool isCallValid,
                                          cl_command_queue command_queue,
                                          cl_mem buffer,
                                          cl_bool blocking_write,
                                          const size_t *buffer_origin,
                                          const size_t *host_origin,
                                          const size_t *region,
                                          size_t buffer_row_pitch,
                                          size_t buffer_slice_pitch,
                                          size_t host_row_pitch,
                                          size_t host_slice_pitch,
                                          const void *ptr,
                                          cl_uint num_events_in_wait_list,
                                          const cl_event *event_wait_list,
                                          cl_event *event,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_write", ParamType::Tcl_bool, blocking_write);

    ParamCapture buffer_originParam("buffer_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, buffer_origin, &buffer_originParam.value);
        CaptureEnqueueWriteBufferRect_buffer_origin(
            command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &buffer_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &buffer_originParam.value);
    }
    paramBuffer.addParam(std::move(buffer_originParam));

    ParamCapture host_originParam("host_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, host_origin, &host_originParam.value);
        CaptureEnqueueWriteBufferRect_host_origin(
            command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &host_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &host_originParam.value);
    }
    paramBuffer.addParam(std::move(host_originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueWriteBufferRect_region(
            command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    paramBuffer.addValueParam("buffer_row_pitch", ParamType::Tsize_t, buffer_row_pitch);
    paramBuffer.addValueParam("buffer_slice_pitch", ParamType::Tsize_t, buffer_slice_pitch);
    paramBuffer.addValueParam("host_row_pitch", ParamType::Tsize_t, host_row_pitch);
    paramBuffer.addValueParam("host_slice_pitch", ParamType::Tsize_t, host_slice_pitch);

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureEnqueueWriteBufferRect_ptr(
            command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
    }
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueWriteBufferRect_event_wait_list(
            command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueWriteBufferRect_event(
            command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueWriteBufferRect, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyBufferRect(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem src_buffer,
                                         cl_mem dst_buffer,
                                         const size_t *src_origin,
                                         const size_t *dst_origin,
                                         const size_t *region,
                                         size_t src_row_pitch,
                                         size_t src_slice_pitch,
                                         size_t dst_row_pitch,
                                         size_t dst_slice_pitch,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_buffer", ParamType::Tcl_mem, src_buffer);
    paramBuffer.addValueParam("dst_buffer", ParamType::Tcl_mem, dst_buffer);

    ParamCapture src_originParam("src_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, src_origin, &src_originParam.value);
        CaptureEnqueueCopyBufferRect_src_origin(
            command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch,
            src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
            event_wait_list, event, &src_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &src_originParam.value);
    }
    paramBuffer.addParam(std::move(src_originParam));

    ParamCapture dst_originParam("dst_origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, dst_origin, &dst_originParam.value);
        CaptureEnqueueCopyBufferRect_dst_origin(
            command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch,
            src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
            event_wait_list, event, &dst_originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &dst_originParam.value);
    }
    paramBuffer.addParam(std::move(dst_originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueCopyBufferRect_region(command_queue, src_buffer, dst_buffer, src_origin,
                                            dst_origin, region, src_row_pitch, src_slice_pitch,
                                            dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
                                            event_wait_list, event, &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    paramBuffer.addValueParam("src_row_pitch", ParamType::Tsize_t, src_row_pitch);
    paramBuffer.addValueParam("src_slice_pitch", ParamType::Tsize_t, src_slice_pitch);
    paramBuffer.addValueParam("dst_row_pitch", ParamType::Tsize_t, dst_row_pitch);
    paramBuffer.addValueParam("dst_slice_pitch", ParamType::Tsize_t, dst_slice_pitch);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyBufferRect_event_wait_list(
            command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch,
            src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
            event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyBufferRect_event(command_queue, src_buffer, dst_buffer, src_origin,
                                           dst_origin, region, src_row_pitch, src_slice_pitch,
                                           dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
                                           event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyBufferRect, std::move(paramBuffer));
}

// CL 1.2
CallCapture CaptureCreateSubDevices(bool isCallValid,
                                    cl_device_id in_device,
                                    const cl_device_partition_property *properties,
                                    cl_uint num_devices,
                                    cl_device_id *out_devices,
                                    cl_uint *num_devices_ret,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("in_device", ParamType::Tcl_device_id, in_device);

    ParamCapture propertiesParam("properties",
                                 ParamType::Tcl_device_partition_propertyConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_device_partition_propertyConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateSubDevices_properties(in_device, properties, num_devices, out_devices,
                                           num_devices_ret, &propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_device_partition_propertyConstPointer,
                       static_cast<const cl_device_partition_property *>(nullptr),
                       &propertiesParam.value);
    }
    paramBuffer.addParam(std::move(propertiesParam));

    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    ParamCapture out_devicesParam("out_devices", ParamType::Tcl_device_idPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_device_idPointer, out_devices, &out_devicesParam.value);
        CaptureCreateSubDevices_out_devices(in_device, properties, num_devices, out_devices,
                                            num_devices_ret, &out_devicesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_device_idPointer, static_cast<cl_device_id *>(nullptr),
                       &out_devicesParam.value);
    }
    paramBuffer.addParam(std::move(out_devicesParam));

    ParamCapture num_devices_retParam("num_devices_ret", ParamType::Tcl_uintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_uintPointer, num_devices_ret, &num_devices_retParam.value);
        CaptureCreateSubDevices_num_devices_ret(in_device, properties, num_devices, out_devices,
                                                num_devices_ret, &num_devices_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_devices_retParam.value);
    }
    paramBuffer.addParam(std::move(num_devices_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateSubDevices, std::move(paramBuffer));
}

CallCapture CaptureRetainDevice(bool isCallValid, cl_device_id device, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainDevice, std::move(paramBuffer));
}

CallCapture CaptureReleaseDevice(bool isCallValid, cl_device_id device, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseDevice, std::move(paramBuffer));
}

CallCapture CaptureCreateImage(bool isCallValid,
                               cl_context context,
                               MemFlags flagsPacked,
                               const cl_image_format *image_format,
                               const cl_image_desc *image_desc,
                               void *host_ptr,
                               cl_int *errcode_ret,
                               cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);

    ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_image_formatConstPointer, image_format,
                       &image_formatParam.value);
        CaptureCreateImage_image_format(context, flagsPacked, image_format, image_desc, host_ptr,
                                        errcode_ret, &image_formatParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_image_formatConstPointer,
                       static_cast<const cl_image_format *>(nullptr), &image_formatParam.value);
    }
    paramBuffer.addParam(std::move(image_formatParam));

    ParamCapture image_descParam("image_desc", ParamType::Tcl_image_descConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_image_descConstPointer, image_desc, &image_descParam.value);
        CaptureCreateImage_image_desc(context, flagsPacked, image_format, image_desc, host_ptr,
                                      errcode_ret, &image_descParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_image_descConstPointer,
                       static_cast<const cl_image_desc *>(nullptr), &image_descParam.value);
    }
    paramBuffer.addParam(std::move(image_descParam));

    ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateImage_host_ptr(context, flagsPacked, image_format, image_desc, host_ptr,
                                    errcode_ret, &host_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
    }
    paramBuffer.addParam(std::move(host_ptrParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateImage_errcode_ret(context, flagsPacked, image_format, image_desc, host_ptr,
                                       errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateImage, std::move(paramBuffer));
}

CallCapture CaptureCreateProgramWithBuiltInKernels(bool isCallValid,
                                                   cl_context context,
                                                   cl_uint num_devices,
                                                   const cl_device_id *device_list,
                                                   const char *kernel_names,
                                                   cl_int *errcode_ret,
                                                   cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureCreateProgramWithBuiltInKernels_device_list(
            context, num_devices, device_list, kernel_names, errcode_ret, &device_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
    }
    paramBuffer.addParam(std::move(device_listParam));

    ParamCapture kernel_namesParam("kernel_names", ParamType::TcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointer, kernel_names, &kernel_namesParam.value);
        CaptureCreateProgramWithBuiltInKernels_kernel_names(
            context, num_devices, device_list, kernel_names, errcode_ret, &kernel_namesParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &kernel_namesParam.value);
    }
    paramBuffer.addParam(std::move(kernel_namesParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateProgramWithBuiltInKernels_errcode_ret(
            context, num_devices, device_list, kernel_names, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateProgramWithBuiltInKernels,
                       std::move(paramBuffer));
}

CallCapture CaptureCompileProgram(bool isCallValid,
                                  cl_program program,
                                  cl_uint num_devices,
                                  const cl_device_id *device_list,
                                  const char *options,
                                  cl_uint num_input_headers,
                                  const cl_program *input_headers,
                                  const char **header_include_names,
                                  void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                void *user_data),
                                  void *user_data,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureCompileProgram_device_list(program, num_devices, device_list, options,
                                          num_input_headers, input_headers, header_include_names,
                                          pfn_notify, user_data, &device_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
    }
    paramBuffer.addParam(std::move(device_listParam));

    ParamCapture optionsParam("options", ParamType::TcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointer, options, &optionsParam.value);
        CaptureCompileProgram_options(program, num_devices, device_list, options, num_input_headers,
                                      input_headers, header_include_names, pfn_notify, user_data,
                                      &optionsParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &optionsParam.value);
    }
    paramBuffer.addParam(std::move(optionsParam));

    paramBuffer.addValueParam("num_input_headers", ParamType::Tcl_uint, num_input_headers);

    ParamCapture input_headersParam("input_headers", ParamType::Tcl_programConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_programConstPointer, input_headers,
                       &input_headersParam.value);
        CaptureCompileProgram_input_headers(program, num_devices, device_list, options,
                                            num_input_headers, input_headers, header_include_names,
                                            pfn_notify, user_data, &input_headersParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_programConstPointer, static_cast<const cl_program *>(nullptr),
                       &input_headersParam.value);
    }
    paramBuffer.addParam(std::move(input_headersParam));

    ParamCapture header_include_namesParam("header_include_names",
                                           ParamType::TcharConstPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointerPointer, header_include_names,
                       &header_include_namesParam.value);
        CaptureCompileProgram_header_include_names(
            program, num_devices, device_list, options, num_input_headers, input_headers,
            header_include_names, pfn_notify, user_data, &header_include_namesParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointerPointer, static_cast<const char **>(nullptr),
                       &header_include_namesParam.value);
    }
    paramBuffer.addParam(std::move(header_include_namesParam));

    ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_program_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureCompileProgram_pfn_notify(program, num_devices, device_list, options,
                                         num_input_headers, input_headers, header_include_names,
                                         pfn_notify, user_data, &pfn_notifyParam);
    }
    else
    {
        InitParamValue(
            ParamType::Tcl_program_func_type,
            static_cast<void(CL_CALLBACK *)(cl_program program, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
    }
    paramBuffer.addParam(std::move(pfn_notifyParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureCompileProgram_user_data(program, num_devices, device_list, options,
                                        num_input_headers, input_headers, header_include_names,
                                        pfn_notify, user_data, &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCompileProgram, std::move(paramBuffer));
}

CallCapture CaptureLinkProgram(bool isCallValid,
                               cl_context context,
                               cl_uint num_devices,
                               const cl_device_id *device_list,
                               const char *options,
                               cl_uint num_input_programs,
                               const cl_program *input_programs,
                               void(CL_CALLBACK *pfn_notify)(cl_program program, void *user_data),
                               void *user_data,
                               cl_int *errcode_ret,
                               cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureLinkProgram_device_list(context, num_devices, device_list, options,
                                       num_input_programs, input_programs, pfn_notify, user_data,
                                       errcode_ret, &device_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
    }
    paramBuffer.addParam(std::move(device_listParam));

    ParamCapture optionsParam("options", ParamType::TcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointer, options, &optionsParam.value);
        CaptureLinkProgram_options(context, num_devices, device_list, options, num_input_programs,
                                   input_programs, pfn_notify, user_data, errcode_ret,
                                   &optionsParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &optionsParam.value);
    }
    paramBuffer.addParam(std::move(optionsParam));

    paramBuffer.addValueParam("num_input_programs", ParamType::Tcl_uint, num_input_programs);

    ParamCapture input_programsParam("input_programs", ParamType::Tcl_programConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_programConstPointer, input_programs,
                       &input_programsParam.value);
        CaptureLinkProgram_input_programs(context, num_devices, device_list, options,
                                          num_input_programs, input_programs, pfn_notify, user_data,
                                          errcode_ret, &input_programsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_programConstPointer, static_cast<const cl_program *>(nullptr),
                       &input_programsParam.value);
    }
    paramBuffer.addParam(std::move(input_programsParam));

    ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_program_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureLinkProgram_pfn_notify(context, num_devices, device_list, options,
                                      num_input_programs, input_programs, pfn_notify, user_data,
                                      errcode_ret, &pfn_notifyParam);
    }
    else
    {
        InitParamValue(
            ParamType::Tcl_program_func_type,
            static_cast<void(CL_CALLBACK *)(cl_program program, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
    }
    paramBuffer.addParam(std::move(pfn_notifyParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureLinkProgram_user_data(context, num_devices, device_list, options, num_input_programs,
                                     input_programs, pfn_notify, user_data, errcode_ret,
                                     &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureLinkProgram_errcode_ret(context, num_devices, device_list, options,
                                       num_input_programs, input_programs, pfn_notify, user_data,
                                       errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLLinkProgram, std::move(paramBuffer));
}

CallCapture CaptureUnloadPlatformCompiler(bool isCallValid,
                                          cl_platform_id platform,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLUnloadPlatformCompiler, std::move(paramBuffer));
}

CallCapture CaptureGetKernelArgInfo(bool isCallValid,
                                    cl_kernel kernel,
                                    cl_uint arg_index,
                                    KernelArgInfo param_namePacked,
                                    size_t param_value_size,
                                    void *param_value,
                                    size_t *param_value_size_ret,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("arg_index", ParamType::Tcl_uint, arg_index);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelArgInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetKernelArgInfo_param_value(kernel, arg_index, param_namePacked, param_value_size,
                                            param_value, param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetKernelArgInfo_param_value_size_ret(
            kernel, arg_index, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetKernelArgInfo, std::move(paramBuffer));
}

CallCapture CaptureEnqueueFillBuffer(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem buffer,
                                     const void *pattern,
                                     size_t pattern_size,
                                     size_t offset,
                                     size_t size,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);

    ParamCapture patternParam("pattern", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, pattern, &patternParam.value);
        CaptureEnqueueFillBuffer_pattern(command_queue, buffer, pattern, pattern_size, offset, size,
                                         num_events_in_wait_list, event_wait_list, event,
                                         &patternParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &patternParam.value);
    }
    paramBuffer.addParam(std::move(patternParam));

    paramBuffer.addValueParam("pattern_size", ParamType::Tsize_t, pattern_size);
    paramBuffer.addValueParam("offset", ParamType::Tsize_t, offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueFillBuffer_event_wait_list(command_queue, buffer, pattern, pattern_size,
                                                 offset, size, num_events_in_wait_list,
                                                 event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueFillBuffer_event(command_queue, buffer, pattern, pattern_size, offset, size,
                                       num_events_in_wait_list, event_wait_list, event,
                                       &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueFillBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueFillImage(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem image,
                                    const void *fill_color,
                                    const size_t *origin,
                                    const size_t *region,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);

    ParamCapture fill_colorParam("fill_color", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, fill_color, &fill_colorParam.value);
        CaptureEnqueueFillImage_fill_color(command_queue, image, fill_color, origin, region,
                                           num_events_in_wait_list, event_wait_list, event,
                                           &fill_colorParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &fill_colorParam.value);
    }
    paramBuffer.addParam(std::move(fill_colorParam));

    ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, origin, &originParam.value);
        CaptureEnqueueFillImage_origin(command_queue, image, fill_color, origin, region,
                                       num_events_in_wait_list, event_wait_list, event,
                                       &originParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &originParam.value);
    }
    paramBuffer.addParam(std::move(originParam));

    ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueFillImage_region(command_queue, image, fill_color, origin, region,
                                       num_events_in_wait_list, event_wait_list, event,
                                       &regionParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
    }
    paramBuffer.addParam(std::move(regionParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueFillImage_event_wait_list(command_queue, image, fill_color, origin, region,
                                                num_events_in_wait_list, event_wait_list, event,
                                                &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueFillImage_event(command_queue, image, fill_color, origin, region,
                                      num_events_in_wait_list, event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueFillImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMigrateMemObjects(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_uint num_mem_objects,
                                            const cl_mem *mem_objects,
                                            MemMigrationFlags flagsPacked,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_mem_objects", ParamType::Tcl_uint, num_mem_objects);

    ParamCapture mem_objectsParam("mem_objects", ParamType::Tcl_memConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_memConstPointer, mem_objects, &mem_objectsParam.value);
        CaptureEnqueueMigrateMemObjects_mem_objects(command_queue, num_mem_objects, mem_objects,
                                                    flagsPacked, num_events_in_wait_list,
                                                    event_wait_list, event, &mem_objectsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_memConstPointer, static_cast<const cl_mem *>(nullptr),
                       &mem_objectsParam.value);
    }
    paramBuffer.addParam(std::move(mem_objectsParam));

    paramBuffer.addValueParam("flagsPacked", ParamType::TMemMigrationFlags, flagsPacked);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueMigrateMemObjects_event_wait_list(
            command_queue, num_mem_objects, mem_objects, flagsPacked, num_events_in_wait_list,
            event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMigrateMemObjects_event(command_queue, num_mem_objects, mem_objects,
                                              flagsPacked, num_events_in_wait_list, event_wait_list,
                                              event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMigrateMemObjects, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMarkerWithWaitList(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueMarkerWithWaitList_event_wait_list(
            command_queue, num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMarkerWithWaitList_event(command_queue, num_events_in_wait_list,
                                               event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMarkerWithWaitList, std::move(paramBuffer));
}

CallCapture CaptureEnqueueBarrierWithWaitList(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueBarrierWithWaitList_event_wait_list(
            command_queue, num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueBarrierWithWaitList_event(command_queue, num_events_in_wait_list,
                                                event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueBarrierWithWaitList, std::move(paramBuffer));
}

CallCapture CaptureGetExtensionFunctionAddressForPlatform(bool isCallValid,
                                                          cl_platform_id platform,
                                                          const char *func_name,
                                                          void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);

    ParamCapture func_nameParam("func_name", ParamType::TcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointer, func_name, &func_nameParam.value);
        CaptureGetExtensionFunctionAddressForPlatform_func_name(platform, func_name,
                                                                &func_nameParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &func_nameParam.value);
    }
    paramBuffer.addParam(std::move(func_nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetExtensionFunctionAddressForPlatform,
                       std::move(paramBuffer));
}

// CL 2.0
CallCapture CaptureCreateCommandQueueWithProperties(bool isCallValid,
                                                    cl_context context,
                                                    cl_device_id device,
                                                    const cl_queue_properties *properties,
                                                    cl_int *errcode_ret,
                                                    cl_command_queue returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    ParamCapture propertiesParam("properties", ParamType::Tcl_queue_propertiesConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_queue_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateCommandQueueWithProperties_properties(context, device, properties, errcode_ret,
                                                           &propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_queue_propertiesConstPointer,
                       static_cast<const cl_queue_properties *>(nullptr), &propertiesParam.value);
    }
    paramBuffer.addParam(std::move(propertiesParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateCommandQueueWithProperties_errcode_ret(context, device, properties,
                                                            errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_command_queue);
    InitParamValue(ParamType::Tcl_command_queue, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateCommandQueueWithProperties,
                       std::move(paramBuffer));
}

CallCapture CaptureCreatePipe(bool isCallValid,
                              cl_context context,
                              MemFlags flagsPacked,
                              cl_uint pipe_packet_size,
                              cl_uint pipe_max_packets,
                              const cl_pipe_properties *properties,
                              cl_int *errcode_ret,
                              cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("pipe_packet_size", ParamType::Tcl_uint, pipe_packet_size);
    paramBuffer.addValueParam("pipe_max_packets", ParamType::Tcl_uint, pipe_max_packets);

    ParamCapture propertiesParam("properties", ParamType::Tcl_pipe_propertiesConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_pipe_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreatePipe_properties(context, flagsPacked, pipe_packet_size, pipe_max_packets,
                                     properties, errcode_ret, &propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_pipe_propertiesConstPointer,
                       static_cast<const cl_pipe_properties *>(nullptr), &propertiesParam.value);
    }
    paramBuffer.addParam(std::move(propertiesParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreatePipe_errcode_ret(context, flagsPacked, pipe_packet_size, pipe_max_packets,
                                      properties, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreatePipe, std::move(paramBuffer));
}

CallCapture CaptureGetPipeInfo(bool isCallValid,
                               cl_mem pipe,
                               PipeInfo param_namePacked,
                               size_t param_value_size,
                               void *param_value,
                               size_t *param_value_size_ret,
                               cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipe", ParamType::Tcl_mem, pipe);
    paramBuffer.addValueParam("param_namePacked", ParamType::TPipeInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetPipeInfo_param_value(pipe, param_namePacked, param_value_size, param_value,
                                       param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetPipeInfo_param_value_size_ret(pipe, param_namePacked, param_value_size,
                                                param_value, param_value_size_ret,
                                                &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetPipeInfo, std::move(paramBuffer));
}

CallCapture CaptureSVMAlloc(bool isCallValid,
                            cl_context context,
                            SVM_MemFlags flagsPacked,
                            size_t size,
                            cl_uint alignment,
                            void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TSVM_MemFlags, flagsPacked);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("alignment", ParamType::Tcl_uint, alignment);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSVMAlloc, std::move(paramBuffer));
}

CallCapture CaptureSVMFree(bool isCallValid, cl_context context, void *svm_pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture svm_pointerParam("svm_pointer", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, svm_pointer, &svm_pointerParam.value);
        CaptureSVMFree_svm_pointer(context, svm_pointer, &svm_pointerParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &svm_pointerParam.value);
    }
    paramBuffer.addParam(std::move(svm_pointerParam));

    return CallCapture(angle::EntryPoint::CLSVMFree, std::move(paramBuffer));
}

CallCapture CaptureCreateSamplerWithProperties(bool isCallValid,
                                               cl_context context,
                                               const cl_sampler_properties *sampler_properties,
                                               cl_int *errcode_ret,
                                               cl_sampler returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture sampler_propertiesParam("sampler_properties",
                                         ParamType::Tcl_sampler_propertiesConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_sampler_propertiesConstPointer, sampler_properties,
                       &sampler_propertiesParam.value);
        CaptureCreateSamplerWithProperties_sampler_properties(
            context, sampler_properties, errcode_ret, &sampler_propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_sampler_propertiesConstPointer,
                       static_cast<const cl_sampler_properties *>(nullptr),
                       &sampler_propertiesParam.value);
    }
    paramBuffer.addParam(std::move(sampler_propertiesParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateSamplerWithProperties_errcode_ret(context, sampler_properties, errcode_ret,
                                                       &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_sampler);
    InitParamValue(ParamType::Tcl_sampler, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateSamplerWithProperties, std::move(paramBuffer));
}

CallCapture CaptureSetKernelArgSVMPointer(bool isCallValid,
                                          cl_kernel kernel,
                                          cl_uint arg_index,
                                          const void *arg_value,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("arg_index", ParamType::Tcl_uint, arg_index);

    ParamCapture arg_valueParam("arg_value", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, arg_value, &arg_valueParam.value);
        CaptureSetKernelArgSVMPointer_arg_value(kernel, arg_index, arg_value, &arg_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &arg_valueParam.value);
    }
    paramBuffer.addParam(std::move(arg_valueParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetKernelArgSVMPointer, std::move(paramBuffer));
}

CallCapture CaptureSetKernelExecInfo(bool isCallValid,
                                     cl_kernel kernel,
                                     KernelExecInfo param_namePacked,
                                     size_t param_value_size,
                                     const void *param_value,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelExecInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, param_value, &param_valueParam.value);
        CaptureSetKernelExecInfo_param_value(kernel, param_namePacked, param_value_size,
                                             param_value, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetKernelExecInfo, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMFree(bool isCallValid,
                                  cl_command_queue command_queue,
                                  cl_uint num_svm_pointers,
                                  void *svm_pointers[],
                                  void(CL_CALLBACK *pfn_free_func)(cl_command_queue queue,
                                                                   cl_uint num_svm_pointers,
                                                                   void *svm_pointers[],
                                                                   void *user_data),
                                  void *user_data,
                                  cl_uint num_events_in_wait_list,
                                  const cl_event *event_wait_list,
                                  cl_event *event,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_svm_pointers", ParamType::Tcl_uint, num_svm_pointers);

    ParamCapture svm_pointersParam("svm_pointers", ParamType::TvoidPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointerPointer, svm_pointers, &svm_pointersParam.value);
        CaptureEnqueueSVMFree_svm_pointers(command_queue, num_svm_pointers, svm_pointers,
                                           pfn_free_func, user_data, num_events_in_wait_list,
                                           event_wait_list, event, &svm_pointersParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &svm_pointersParam.value);
    }
    paramBuffer.addParam(std::move(svm_pointersParam));

    ParamCapture pfn_free_funcParam("pfn_free_func", ParamType::Tcl_svm_free_callback_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_svm_free_callback_func_type, pfn_free_func,
                       &pfn_free_funcParam.value);
        CaptureEnqueueSVMFree_pfn_free_func(command_queue, num_svm_pointers, svm_pointers,
                                            pfn_free_func, user_data, num_events_in_wait_list,
                                            event_wait_list, event, &pfn_free_funcParam);
    }
    else
    {
        InitParamValue(
            ParamType::Tcl_svm_free_callback_func_type,
            static_cast<void(CL_CALLBACK *)(cl_command_queue queue, cl_uint num_svm_pointers,
                                            void *svm_pointers[], void *user_data)>(nullptr),
            &pfn_free_funcParam.value);
    }
    paramBuffer.addParam(std::move(pfn_free_funcParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureEnqueueSVMFree_user_data(command_queue, num_svm_pointers, svm_pointers,
                                        pfn_free_func, user_data, num_events_in_wait_list,
                                        event_wait_list, event, &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMFree_event_wait_list(command_queue, num_svm_pointers, svm_pointers,
                                              pfn_free_func, user_data, num_events_in_wait_list,
                                              event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMFree_event(command_queue, num_svm_pointers, svm_pointers, pfn_free_func,
                                    user_data, num_events_in_wait_list, event_wait_list, event,
                                    &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMFree, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMMemcpy(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_bool blocking_copy,
                                    void *dst_ptr,
                                    const void *src_ptr,
                                    size_t size,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("blocking_copy", ParamType::Tcl_bool, blocking_copy);

    ParamCapture dst_ptrParam("dst_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, dst_ptr, &dst_ptrParam.value);
        CaptureEnqueueSVMMemcpy_dst_ptr(command_queue, blocking_copy, dst_ptr, src_ptr, size,
                                        num_events_in_wait_list, event_wait_list, event,
                                        &dst_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dst_ptrParam.value);
    }
    paramBuffer.addParam(std::move(dst_ptrParam));

    ParamCapture src_ptrParam("src_ptr", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, src_ptr, &src_ptrParam.value);
        CaptureEnqueueSVMMemcpy_src_ptr(command_queue, blocking_copy, dst_ptr, src_ptr, size,
                                        num_events_in_wait_list, event_wait_list, event,
                                        &src_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &src_ptrParam.value);
    }
    paramBuffer.addParam(std::move(src_ptrParam));

    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMMemcpy_event_wait_list(command_queue, blocking_copy, dst_ptr, src_ptr,
                                                size, num_events_in_wait_list, event_wait_list,
                                                event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMMemcpy_event(command_queue, blocking_copy, dst_ptr, src_ptr, size,
                                      num_events_in_wait_list, event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMMemcpy, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMMemFill(bool isCallValid,
                                     cl_command_queue command_queue,
                                     void *svm_ptr,
                                     const void *pattern,
                                     size_t pattern_size,
                                     size_t size,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture svm_ptrParam("svm_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, svm_ptr, &svm_ptrParam.value);
        CaptureEnqueueSVMMemFill_svm_ptr(command_queue, svm_ptr, pattern, pattern_size, size,
                                         num_events_in_wait_list, event_wait_list, event,
                                         &svm_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &svm_ptrParam.value);
    }
    paramBuffer.addParam(std::move(svm_ptrParam));

    ParamCapture patternParam("pattern", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, pattern, &patternParam.value);
        CaptureEnqueueSVMMemFill_pattern(command_queue, svm_ptr, pattern, pattern_size, size,
                                         num_events_in_wait_list, event_wait_list, event,
                                         &patternParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &patternParam.value);
    }
    paramBuffer.addParam(std::move(patternParam));

    paramBuffer.addValueParam("pattern_size", ParamType::Tsize_t, pattern_size);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMMemFill_event_wait_list(command_queue, svm_ptr, pattern, pattern_size,
                                                 size, num_events_in_wait_list, event_wait_list,
                                                 event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMMemFill_event(command_queue, svm_ptr, pattern, pattern_size, size,
                                       num_events_in_wait_list, event_wait_list, event,
                                       &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMMemFill, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMMap(bool isCallValid,
                                 cl_command_queue command_queue,
                                 cl_bool blocking_map,
                                 MapFlags flagsPacked,
                                 void *svm_ptr,
                                 size_t size,
                                 cl_uint num_events_in_wait_list,
                                 const cl_event *event_wait_list,
                                 cl_event *event,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("blocking_map", ParamType::Tcl_bool, blocking_map);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMapFlags, flagsPacked);

    ParamCapture svm_ptrParam("svm_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, svm_ptr, &svm_ptrParam.value);
        CaptureEnqueueSVMMap_svm_ptr(command_queue, blocking_map, flagsPacked, svm_ptr, size,
                                     num_events_in_wait_list, event_wait_list, event,
                                     &svm_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &svm_ptrParam.value);
    }
    paramBuffer.addParam(std::move(svm_ptrParam));

    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMMap_event_wait_list(command_queue, blocking_map, flagsPacked, svm_ptr,
                                             size, num_events_in_wait_list, event_wait_list, event,
                                             &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMMap_event(command_queue, blocking_map, flagsPacked, svm_ptr, size,
                                   num_events_in_wait_list, event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMMap, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMUnmap(bool isCallValid,
                                   cl_command_queue command_queue,
                                   void *svm_ptr,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture svm_ptrParam("svm_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, svm_ptr, &svm_ptrParam.value);
        CaptureEnqueueSVMUnmap_svm_ptr(command_queue, svm_ptr, num_events_in_wait_list,
                                       event_wait_list, event, &svm_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &svm_ptrParam.value);
    }
    paramBuffer.addParam(std::move(svm_ptrParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMUnmap_event_wait_list(command_queue, svm_ptr, num_events_in_wait_list,
                                               event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMUnmap_event(command_queue, svm_ptr, num_events_in_wait_list,
                                     event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMUnmap, std::move(paramBuffer));
}

// CL 2.1
CallCapture CaptureSetDefaultDeviceCommandQueue(bool isCallValid,
                                                cl_context context,
                                                cl_device_id device,
                                                cl_command_queue command_queue,
                                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetDefaultDeviceCommandQueue, std::move(paramBuffer));
}

CallCapture CaptureGetDeviceAndHostTimer(bool isCallValid,
                                         cl_device_id device,
                                         cl_ulong *device_timestamp,
                                         cl_ulong *host_timestamp,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    ParamCapture device_timestampParam("device_timestamp", ParamType::Tcl_ulongPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_ulongPointer, device_timestamp, &device_timestampParam.value);
        CaptureGetDeviceAndHostTimer_device_timestamp(device, device_timestamp, host_timestamp,
                                                      &device_timestampParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_ulongPointer, static_cast<cl_ulong *>(nullptr),
                       &device_timestampParam.value);
    }
    paramBuffer.addParam(std::move(device_timestampParam));

    ParamCapture host_timestampParam("host_timestamp", ParamType::Tcl_ulongPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_ulongPointer, host_timestamp, &host_timestampParam.value);
        CaptureGetDeviceAndHostTimer_host_timestamp(device, device_timestamp, host_timestamp,
                                                    &host_timestampParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_ulongPointer, static_cast<cl_ulong *>(nullptr),
                       &host_timestampParam.value);
    }
    paramBuffer.addParam(std::move(host_timestampParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetDeviceAndHostTimer, std::move(paramBuffer));
}

CallCapture CaptureGetHostTimer(bool isCallValid,
                                cl_device_id device,
                                cl_ulong *host_timestamp,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    ParamCapture host_timestampParam("host_timestamp", ParamType::Tcl_ulongPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_ulongPointer, host_timestamp, &host_timestampParam.value);
        CaptureGetHostTimer_host_timestamp(device, host_timestamp, &host_timestampParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_ulongPointer, static_cast<cl_ulong *>(nullptr),
                       &host_timestampParam.value);
    }
    paramBuffer.addParam(std::move(host_timestampParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetHostTimer, std::move(paramBuffer));
}

CallCapture CaptureCreateProgramWithIL(bool isCallValid,
                                       cl_context context,
                                       const void *il,
                                       size_t length,
                                       cl_int *errcode_ret,
                                       cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture ilParam("il", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, il, &ilParam.value);
        CaptureCreateProgramWithIL_il(context, il, length, errcode_ret, &ilParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ilParam.value);
    }
    paramBuffer.addParam(std::move(ilParam));

    paramBuffer.addValueParam("length", ParamType::Tsize_t, length);

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateProgramWithIL_errcode_ret(context, il, length, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateProgramWithIL, std::move(paramBuffer));
}

CallCapture CaptureCloneKernel(bool isCallValid,
                               cl_kernel source_kernel,
                               cl_int *errcode_ret,
                               cl_kernel returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("source_kernel", ParamType::Tcl_kernel, source_kernel);

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCloneKernel_errcode_ret(source_kernel, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_kernel);
    InitParamValue(ParamType::Tcl_kernel, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCloneKernel, std::move(paramBuffer));
}

CallCapture CaptureGetKernelSubGroupInfo(bool isCallValid,
                                         cl_kernel kernel,
                                         cl_device_id device,
                                         KernelSubGroupInfo param_namePacked,
                                         size_t input_value_size,
                                         const void *input_value,
                                         size_t param_value_size,
                                         void *param_value,
                                         size_t *param_value_size_ret,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelSubGroupInfo, param_namePacked);
    paramBuffer.addValueParam("input_value_size", ParamType::Tsize_t, input_value_size);

    ParamCapture input_valueParam("input_value", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, input_value, &input_valueParam.value);
        CaptureGetKernelSubGroupInfo_input_value(kernel, device, param_namePacked, input_value_size,
                                                 input_value, param_value_size, param_value,
                                                 param_value_size_ret, &input_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &input_valueParam.value);
    }
    paramBuffer.addParam(std::move(input_valueParam));

    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetKernelSubGroupInfo_param_value(kernel, device, param_namePacked, input_value_size,
                                                 input_value, param_value_size, param_value,
                                                 param_value_size_ret, &param_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
    }
    paramBuffer.addParam(std::move(param_valueParam));

    ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetKernelSubGroupInfo_param_value_size_ret(
            kernel, device, param_namePacked, input_value_size, input_value, param_value_size,
            param_value, param_value_size_ret, &param_value_size_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
    }
    paramBuffer.addParam(std::move(param_value_size_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetKernelSubGroupInfo, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMMigrateMem(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_uint num_svm_pointers,
                                        const void **svm_pointers,
                                        const size_t *sizes,
                                        MemMigrationFlags flagsPacked,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_svm_pointers", ParamType::Tcl_uint, num_svm_pointers);

    ParamCapture svm_pointersParam("svm_pointers", ParamType::TvoidConstPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointerPointer, svm_pointers, &svm_pointersParam.value);
        CaptureEnqueueSVMMigrateMem_svm_pointers(command_queue, num_svm_pointers, svm_pointers,
                                                 sizes, flagsPacked, num_events_in_wait_list,
                                                 event_wait_list, event, &svm_pointersParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointerPointer, static_cast<const void **>(nullptr),
                       &svm_pointersParam.value);
    }
    paramBuffer.addParam(std::move(svm_pointersParam));

    ParamCapture sizesParam("sizes", ParamType::Tsize_tConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tsize_tConstPointer, sizes, &sizesParam.value);
        CaptureEnqueueSVMMigrateMem_sizes(command_queue, num_svm_pointers, svm_pointers, sizes,
                                          flagsPacked, num_events_in_wait_list, event_wait_list,
                                          event, &sizesParam);
    }
    else
    {
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &sizesParam.value);
    }
    paramBuffer.addParam(std::move(sizesParam));

    paramBuffer.addValueParam("flagsPacked", ParamType::TMemMigrationFlags, flagsPacked);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMMigrateMem_event_wait_list(command_queue, num_svm_pointers, svm_pointers,
                                                    sizes, flagsPacked, num_events_in_wait_list,
                                                    event_wait_list, event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMMigrateMem_event(command_queue, num_svm_pointers, svm_pointers, sizes,
                                          flagsPacked, num_events_in_wait_list, event_wait_list,
                                          event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMMigrateMem, std::move(paramBuffer));
}

// CL 2.2
CallCapture CaptureSetProgramReleaseCallback(bool isCallValid,
                                             cl_program program,
                                             void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                           void *user_data),
                                             void *user_data,
                                             cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);

    ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_program_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureSetProgramReleaseCallback_pfn_notify(program, pfn_notify, user_data,
                                                    &pfn_notifyParam);
    }
    else
    {
        InitParamValue(
            ParamType::Tcl_program_func_type,
            static_cast<void(CL_CALLBACK *)(cl_program program, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
    }
    paramBuffer.addParam(std::move(pfn_notifyParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureSetProgramReleaseCallback_user_data(program, pfn_notify, user_data, &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetProgramReleaseCallback, std::move(paramBuffer));
}

CallCapture CaptureSetProgramSpecializationConstant(bool isCallValid,
                                                    cl_program program,
                                                    cl_uint spec_id,
                                                    size_t spec_size,
                                                    const void *spec_value,
                                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("spec_id", ParamType::Tcl_uint, spec_id);
    paramBuffer.addValueParam("spec_size", ParamType::Tsize_t, spec_size);

    ParamCapture spec_valueParam("spec_value", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, spec_value, &spec_valueParam.value);
        CaptureSetProgramSpecializationConstant_spec_value(program, spec_id, spec_size, spec_value,
                                                           &spec_valueParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &spec_valueParam.value);
    }
    paramBuffer.addParam(std::move(spec_valueParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetProgramSpecializationConstant,
                       std::move(paramBuffer));
}

// CL 3.0
CallCapture CaptureSetContextDestructorCallback(bool isCallValid,
                                                cl_context context,
                                                void(CL_CALLBACK *pfn_notify)(cl_context context,
                                                                              void *user_data),
                                                void *user_data,
                                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_context_destructor_func_type);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_context_destructor_func_type, pfn_notify,
                       &pfn_notifyParam.value);
        CaptureSetContextDestructorCallback_pfn_notify(context, pfn_notify, user_data,
                                                       &pfn_notifyParam);
    }
    else
    {
        InitParamValue(
            ParamType::Tcl_context_destructor_func_type,
            static_cast<void(CL_CALLBACK *)(cl_context context, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
    }
    paramBuffer.addParam(std::move(pfn_notifyParam));

    ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureSetContextDestructorCallback_user_data(context, pfn_notify, user_data,
                                                      &user_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
    }
    paramBuffer.addParam(std::move(user_dataParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetContextDestructorCallback, std::move(paramBuffer));
}

CallCapture CaptureCreateBufferWithProperties(bool isCallValid,
                                              cl_context context,
                                              const cl_mem_properties *properties,
                                              MemFlags flagsPacked,
                                              size_t size,
                                              void *host_ptr,
                                              cl_int *errcode_ret,
                                              cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture propertiesParam("properties", ParamType::Tcl_mem_propertiesConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_mem_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateBufferWithProperties_properties(context, properties, flagsPacked, size,
                                                     host_ptr, errcode_ret, &propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_mem_propertiesConstPointer,
                       static_cast<const cl_mem_properties *>(nullptr), &propertiesParam.value);
    }
    paramBuffer.addParam(std::move(propertiesParam));

    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);

    ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateBufferWithProperties_host_ptr(context, properties, flagsPacked, size, host_ptr,
                                                   errcode_ret, &host_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
    }
    paramBuffer.addParam(std::move(host_ptrParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateBufferWithProperties_errcode_ret(context, properties, flagsPacked, size,
                                                      host_ptr, errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateBufferWithProperties, std::move(paramBuffer));
}

CallCapture CaptureCreateImageWithProperties(bool isCallValid,
                                             cl_context context,
                                             const cl_mem_properties *properties,
                                             MemFlags flagsPacked,
                                             const cl_image_format *image_format,
                                             const cl_image_desc *image_desc,
                                             void *host_ptr,
                                             cl_int *errcode_ret,
                                             cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture propertiesParam("properties", ParamType::Tcl_mem_propertiesConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_mem_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateImageWithProperties_properties(context, properties, flagsPacked, image_format,
                                                    image_desc, host_ptr, errcode_ret,
                                                    &propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_mem_propertiesConstPointer,
                       static_cast<const cl_mem_properties *>(nullptr), &propertiesParam.value);
    }
    paramBuffer.addParam(std::move(propertiesParam));

    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);

    ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_image_formatConstPointer, image_format,
                       &image_formatParam.value);
        CaptureCreateImageWithProperties_image_format(context, properties, flagsPacked,
                                                      image_format, image_desc, host_ptr,
                                                      errcode_ret, &image_formatParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_image_formatConstPointer,
                       static_cast<const cl_image_format *>(nullptr), &image_formatParam.value);
    }
    paramBuffer.addParam(std::move(image_formatParam));

    ParamCapture image_descParam("image_desc", ParamType::Tcl_image_descConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_image_descConstPointer, image_desc, &image_descParam.value);
        CaptureCreateImageWithProperties_image_desc(context, properties, flagsPacked, image_format,
                                                    image_desc, host_ptr, errcode_ret,
                                                    &image_descParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_image_descConstPointer,
                       static_cast<const cl_image_desc *>(nullptr), &image_descParam.value);
    }
    paramBuffer.addParam(std::move(image_descParam));

    ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateImageWithProperties_host_ptr(context, properties, flagsPacked, image_format,
                                                  image_desc, host_ptr, errcode_ret,
                                                  &host_ptrParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
    }
    paramBuffer.addParam(std::move(host_ptrParam));

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateImageWithProperties_errcode_ret(context, properties, flagsPacked, image_format,
                                                     image_desc, host_ptr, errcode_ret,
                                                     &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateImageWithProperties, std::move(paramBuffer));
}

// cl_arm_import_memory
CallCapture CaptureImportMemoryARM(bool isCallValid,
                                   cl_context context,
                                   MemFlags flagsPacked,
                                   const cl_import_properties_arm *properties,
                                   void *memory,
                                   size_t size,
                                   cl_int *errcode_ret,
                                   cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);

    ParamCapture propertiesParam("properties", ParamType::Tcl_import_properties_armConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_import_properties_armConstPointer, properties,
                       &propertiesParam.value);
        CaptureImportMemoryARM_properties(context, flagsPacked, properties, memory, size,
                                          errcode_ret, &propertiesParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_import_properties_armConstPointer,
                       static_cast<const cl_import_properties_arm *>(nullptr),
                       &propertiesParam.value);
    }
    paramBuffer.addParam(std::move(propertiesParam));

    ParamCapture memoryParam("memory", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, memory, &memoryParam.value);
        CaptureImportMemoryARM_memory(context, flagsPacked, properties, memory, size, errcode_ret,
                                      &memoryParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &memoryParam.value);
    }
    paramBuffer.addParam(std::move(memoryParam));

    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);

    ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureImportMemoryARM_errcode_ret(context, flagsPacked, properties, memory, size,
                                           errcode_ret, &errcode_retParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
    }
    paramBuffer.addParam(std::move(errcode_retParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLImportMemoryARM, std::move(paramBuffer));
}

// cl_khr_external_memory
CallCapture CaptureEnqueueAcquireExternalMemObjectsKHR(bool isCallValid,
                                                       cl_command_queue command_queue,
                                                       cl_uint num_mem_objects,
                                                       const cl_mem *mem_objects,
                                                       cl_uint num_events_in_wait_list,
                                                       const cl_event *event_wait_list,
                                                       cl_event *event,
                                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_mem_objects", ParamType::Tcl_uint, num_mem_objects);

    ParamCapture mem_objectsParam("mem_objects", ParamType::Tcl_memConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_memConstPointer, mem_objects, &mem_objectsParam.value);
        CaptureEnqueueAcquireExternalMemObjectsKHR_mem_objects(
            command_queue, num_mem_objects, mem_objects, num_events_in_wait_list, event_wait_list,
            event, &mem_objectsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_memConstPointer, static_cast<const cl_mem *>(nullptr),
                       &mem_objectsParam.value);
    }
    paramBuffer.addParam(std::move(mem_objectsParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueAcquireExternalMemObjectsKHR_event_wait_list(
            command_queue, num_mem_objects, mem_objects, num_events_in_wait_list, event_wait_list,
            event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueAcquireExternalMemObjectsKHR_event(command_queue, num_mem_objects,
                                                         mem_objects, num_events_in_wait_list,
                                                         event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueAcquireExternalMemObjectsKHR,
                       std::move(paramBuffer));
}

CallCapture CaptureEnqueueReleaseExternalMemObjectsKHR(bool isCallValid,
                                                       cl_command_queue command_queue,
                                                       cl_uint num_mem_objects,
                                                       const cl_mem *mem_objects,
                                                       cl_uint num_events_in_wait_list,
                                                       const cl_event *event_wait_list,
                                                       cl_event *event,
                                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_mem_objects", ParamType::Tcl_uint, num_mem_objects);

    ParamCapture mem_objectsParam("mem_objects", ParamType::Tcl_memConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_memConstPointer, mem_objects, &mem_objectsParam.value);
        CaptureEnqueueReleaseExternalMemObjectsKHR_mem_objects(
            command_queue, num_mem_objects, mem_objects, num_events_in_wait_list, event_wait_list,
            event, &mem_objectsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_memConstPointer, static_cast<const cl_mem *>(nullptr),
                       &mem_objectsParam.value);
    }
    paramBuffer.addParam(std::move(mem_objectsParam));

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueReleaseExternalMemObjectsKHR_event_wait_list(
            command_queue, num_mem_objects, mem_objects, num_events_in_wait_list, event_wait_list,
            event, &event_wait_listParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
    }
    paramBuffer.addParam(std::move(event_wait_listParam));

    ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueReleaseExternalMemObjectsKHR_event(command_queue, num_mem_objects,
                                                         mem_objects, num_events_in_wait_list,
                                                         event_wait_list, event, &eventParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
    }
    paramBuffer.addParam(std::move(eventParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueReleaseExternalMemObjectsKHR,
                       std::move(paramBuffer));
}

// cl_khr_icd
CallCapture CaptureIcdGetPlatformIDsKHR(bool isCallValid,
                                        cl_uint num_entries,
                                        cl_platform_id *platforms,
                                        cl_uint *num_platforms,
                                        cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("num_entries", ParamType::Tcl_uint, num_entries);

    ParamCapture platformsParam("platforms", ParamType::Tcl_platform_idPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_platform_idPointer, platforms, &platformsParam.value);
        CaptureIcdGetPlatformIDsKHR_platforms(num_entries, platforms, num_platforms,
                                              &platformsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_platform_idPointer, static_cast<cl_platform_id *>(nullptr),
                       &platformsParam.value);
    }
    paramBuffer.addParam(std::move(platformsParam));

    ParamCapture num_platformsParam("num_platforms", ParamType::Tcl_uintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::Tcl_uintPointer, num_platforms, &num_platformsParam.value);
        CaptureIcdGetPlatformIDsKHR_num_platforms(num_entries, platforms, num_platforms,
                                                  &num_platformsParam);
    }
    else
    {
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_platformsParam.value);
    }
    paramBuffer.addParam(std::move(num_platformsParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLIcdGetPlatformIDsKHR, std::move(paramBuffer));
}

CallCapture CaptureIcdGetFunctionAddressForPlatformKHR(bool isCallValid,
                                                       cl_platform_id platform,
                                                       const char *func_name,
                                                       void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);

    ParamCapture func_nameParam("func_name", ParamType::TcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TcharConstPointer, func_name, &func_nameParam.value);
        CaptureIcdGetFunctionAddressForPlatformKHR_func_name(platform, func_name, &func_nameParam);
    }
    else
    {
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &func_nameParam.value);
    }
    paramBuffer.addParam(std::move(func_nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLIcdGetFunctionAddressForPlatformKHR,
                       std::move(paramBuffer));
}

CallCapture CaptureIcdSetPlatformDispatchDataKHR(bool isCallValid,
                                                 cl_platform_id platform,
                                                 void *dispatch_data,
                                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);

    ParamCapture dispatch_dataParam("dispatch_data", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, dispatch_data, &dispatch_dataParam.value);
        CaptureIcdSetPlatformDispatchDataKHR_dispatch_data(platform, dispatch_data,
                                                           &dispatch_dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &dispatch_dataParam.value);
    }
    paramBuffer.addParam(std::move(dispatch_dataParam));

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLIcdSetPlatformDispatchDataKHR, std::move(paramBuffer));
}

}  // namespace cl
