/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.animation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.animation.AnimationExtension;
import org.openstreetmap.josm.tools.ImageProvider;

public class BirthdayExtension
extends JPanel
implements AnimationExtension,
MouseListener,
MouseMotionListener {
    private static final int SIZE = 40;
    private final Image myImage;
    private double w;
    private double h;
    private double Mx;
    private double My;
    private int originX;
    private int originY;
    private boolean isClicked;
    private boolean isHappyBirthday;
    private int giftNumber = 1;
    private final ArrayList<Gift> giftList = new ArrayList();
    private long startTime;
    private long lastSpawnTime;
    Player player = new Player();

    BirthdayExtension() {
        this.myImage = new ImageProvider("presets/shop/present").setMaxSize(new Dimension(40, 40)).get().getImage();
        this.player.setRadius(11.0);
        this.lastSpawnTime = System.currentTimeMillis();
    }

    void spawnGifts() {
        int maxGifts = 30;
        if (this.giftList.size() < 30) {
            this.lastSpawnTime = System.currentTimeMillis();
            Gift gift = new Gift();
            this.giftList.add(gift);
            gift.myImage = this.getImage();
            gift.setRadius(32.0);
            double x = (this.w - (double)this.originX) / 2.0;
            double y = (this.h - (double)this.originY) / 2.0;
            if (this.giftList.size() > 1) {
                double radius = this.w / 2.0;
                double angle = Math.PI * 2 * Math.random();
                gift.setPosition(x += Math.cos(angle) * radius, y += Math.sin(angle) * radius);
            } else {
                gift.setPosition(x, y);
            }
        }
    }

    private void gameLogic() {
        if (this.giftList.isEmpty() && !this.isHappyBirthday || System.currentTimeMillis() - this.lastSpawnTime > 5000L && !this.isHappyBirthday) {
            this.spawnGifts();
            this.lastSpawnTime = System.currentTimeMillis();
        }
        this.player.update();
        for (Gift gift : this.giftList) {
            gift.update();
        }
        int index = 0;
        for (Gift gift : this.giftList) {
            if (gift.circle.overlaps(this.player.circle) && this.isClicked) {
                this.startTime = System.currentTimeMillis();
                this.giftList.remove(index);
                break;
            }
            ++index;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.isClicked = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isClicked = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.Mx = e.getXOnScreen() - this.originX;
        this.My = e.getYOnScreen() - this.originY;
        this.player.setPosition(this.Mx, this.My);
        this.huntGift();
    }

    @Override
    public final void adjustForSize(int w, int h, int x, int y) {
        this.w = w;
        this.h = h;
        this.originX = x;
        this.originY = y;
    }

    @Override
    public void paint(Graphics g) {
        this.gameLogic();
        for (Gift gift : this.giftList) {
            gift.render(g);
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.giftList.isEmpty()) {
            if (System.currentTimeMillis() - this.startTime <= 5000L) {
                int fontSize = 20;
                g2d.setFont(new Font("Arial", 1, fontSize));
                g2d.setColor(Color.RED);
                String text = "Happy Birthday JOSM! ";
                FontMetrics fm = g2d.getFontMetrics();
                int textWidth = fm.stringWidth(text);
                int x = 0;
                int y = 20;
                int i = 0;
                while ((double)i < this.w / (double)textWidth + 1.0) {
                    g2d.drawString(text, x, y);
                    g2d.drawString(text, x, (int)this.h - y);
                    x += textWidth;
                    ++i;
                }
                this.isHappyBirthday = true;
            } else {
                ++this.giftNumber;
                for (int i = 0; i < this.giftNumber; ++i) {
                    this.spawnGifts();
                }
                this.startTime = System.currentTimeMillis();
                this.isHappyBirthday = false;
            }
        }
    }

    @Override
    public void animate() {
    }

    private void huntGift() {
        for (Gift gift : this.giftList) {
            double giftSpeed;
            double dx = gift.circle.x - this.player.circle.x;
            double dy = gift.circle.y - this.player.circle.y;
            double len = Math.sqrt(dx * dx + dy * dy);
            if ((dx < -100.0 || dx > 100.0) && (dy < -100.0 || dy > 100.0)) {
                dx = 0.0;
                dy = 0.0;
            } else if (len > 0.0 && dx != 0.0 && dy != 0.0) {
                dx /= len;
                dy /= len;
            }
            if (dx != 0.0 && dy != 0.0 && gift.circle.x == 0.0 && gift.circle.y == 0.0) {
                giftSpeed = 5.0;
                dy += 5.0;
            } else if (dx != 0.0 && dy != 0.0 && gift.circle.x >= this.w - 40.0 && gift.circle.y == 0.0) {
                giftSpeed = 5.0;
                dy += 5.0;
            } else if (dx != 0.0 && dy != 0.0 && gift.circle.x == 0.0 && gift.circle.y >= this.h - 40.0) {
                giftSpeed = 5.0;
                dx += 5.0;
            } else if (dx != 0.0 && dy != 0.0 && gift.circle.x >= this.w - 40.0 && gift.circle.y >= this.h - 40.0) {
                giftSpeed = 5.0;
                dx -= 5.0;
            } else {
                giftSpeed = 3.0;
            }
            gift.circle.x += dx * giftSpeed;
            gift.circle.y += dy * giftSpeed;
        }
    }

    private Image getImage() {
        return this.myImage;
    }

    private final class Player {
        Circle circle = new Circle();

        private Player() {
        }

        void setPosition(double x, double y) {
            this.circle.setPosition(x, y);
        }

        void setRadius(double radius) {
            this.circle.setRadius(radius);
        }

        void update() {
            this.setPosition(BirthdayExtension.this.Mx, BirthdayExtension.this.My);
        }
    }

    private final class Gift {
        Image myImage;
        Circle circle;
        int offsX;
        int offsY;

        private Gift() {
            this.myImage = BirthdayExtension.this.getImage();
            this.circle = new Circle();
            this.offsX = 4;
            this.offsY = 4;
        }

        void setPosition(double x, double y) {
            this.circle.setPosition(x, y);
        }

        void setRadius(double radius) {
            this.circle.setRadius(radius);
        }

        void update() {
            this.circle.x += (double)this.offsX;
            this.circle.y += (double)this.offsY;
            if (this.circle.x <= 0.0) {
                this.offsX *= -1;
                this.circle.x = 0.0;
                if (this.circle.y == 0.0) {
                    this.offsY *= -1;
                }
            } else if (this.circle.x >= BirthdayExtension.this.w - 40.0) {
                this.offsX *= -1;
                this.circle.x = BirthdayExtension.this.w - 40.0;
            }
            if (this.circle.y <= 0.0) {
                this.offsY *= -1;
                this.circle.y = 0.0;
            } else if (this.circle.y >= BirthdayExtension.this.h - 40.0) {
                this.offsY *= -1;
                this.circle.y = BirthdayExtension.this.h - 40.0;
            }
        }

        void render(Graphics g) {
            double x = this.circle.x;
            double y = this.circle.y;
            g.drawImage(this.myImage, (int)x, (int)y, null);
        }
    }

    private static final class Circle {
        double x;
        double y;
        double radius = 1.0;

        private Circle() {
        }

        void setPosition(double x, double y) {
            this.x = x;
            this.y = y;
        }

        void setRadius(double radius) {
            this.radius = radius;
        }

        boolean overlaps(Circle other) {
            double dx = this.x - other.x;
            double dy = this.y - other.y;
            double dr = this.radius + other.radius;
            return dx * dx + dy * dy < dr * dr;
        }
    }
}

